/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.FeatureResolver;
import com.ibm.ws.st.core.internal.FeatureResolverFeature;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.RequiredFeatureMap;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.FeatureList;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public class ImportFeatureResolver
extends FeatureResolver {
    private static final int SEARCH_LIMIT = 7500;
    private static Map<String, APIInfo> runtimeAPIMap = new HashMap<String, APIInfo>();
    private static final String[][] PREFERRED_JAR_FEATURE_MAP = new String[][]{{"com.ibm.ws.javaee.servlet", "servlet"}, {"com.ibm.ws.javaee.dd.ejb", "ejbLite"}, {"com.ibm.ws.javaee.ejb", "ejbLite"}, {"com.ibm.ws.javaee.jsp", "jsp"}, {"com.ibm.ws.javaee.jaxws", "jaxws"}, {"com.ibm.ws.javaee.jaxrs", "jaxrs"}, {"com.ibm.ws.javaee.persistence", "jpa"}, {"com.ibm.websphere.javaee.servlet", "servlet"}, {"com.ibm.websphere.javaee.ejb", "ejbLite"}, {"com.ibm.websphere.javaee.jsp", "jsp"}, {"com.ibm.websphere.javaee.jaxws", "jaxws"}, {"com.ibm.websphere.javaee.jaxrs", "jaxrs"}, {"com.ibm.websphere.javaee.persistence", "jpa"}, {"com.ibm.websphere.javaee.jsonb", "jsonb"}, {"com.ibm.websphere.javaee.jsonp", "jsonp"}, {"com.ibm.websphere.javaee.cdi", "cdi"}};
    private static final Set<String> IGNORE_PKG_SET = new HashSet<String>();

    private static APIInfo getDevAnnotations(WebSphereRuntime wsRuntime, IJavaProject javaProject) throws CoreException {
        IPackageFragment[] pfs;
        if (wsRuntime == null) {
            return null;
        }
        String key = wsRuntime.getRuntime().getId();
        APIInfo info = runtimeAPIMap.get(key);
        if (info != null) {
            return info;
        }
        long time = System.currentTimeMillis();
        ArrayList<String[]> jarMap = new ArrayList<String[]>();
        HashMap<String, String[]> packageMap = new HashMap<String, String[]>(125);
        HashMap<String, String> preferredFeatures = new HashMap<String, String>();
        List features = FeatureList.getFeatures((boolean)false, (WebSphereRuntime)wsRuntime);
        for (String feature : features) {
            Set jars = FeatureList.getFeatureAPIJars((String)feature, (WebSphereRuntime)wsRuntime);
            for (String jar : jars) {
                jarMap.add(new String[]{jar, feature});
            }
        }
        IVMInstall vmInstall = wsRuntime.getVMInstall();
        String jreLocation = vmInstall != null ? vmInstall.getInstallLocation().toString().replace('\\', '/') : null;
        for (IPackageFragment pf : pfs = javaProject.getPackageFragments()) {
            IPath path = pf.getPath();
            if (pf.getKind() != 2) continue;
            String curElementName = pf.getElementName();
            if (path.toString().contains("/dev/")) {
                String preferredFeature;
                ArrayList<String> matchedFeatures = new ArrayList<String>(3);
                for (String[] s : jarMap) {
                    IClassFile[] cfs;
                    if (!path.toPortableString().contains(s[0]) || (cfs = pf.getClassFiles()).length <= 0) continue;
                    String feature = s[1];
                    if (feature.indexOf("-") > 0) {
                        feature = feature.substring(0, feature.indexOf("-"));
                    }
                    matchedFeatures.add(feature);
                    if (!curElementName.startsWith("javax.persistence")) continue;
                    matchedFeatures.add("jpa");
                }
                if (!matchedFeatures.isEmpty()) {
                    packageMap.put(curElementName, matchedFeatures.toArray(new String[matchedFeatures.size()]));
                }
                if ((preferredFeature = ImportFeatureResolver.getFeatureFromPreferredList(pf.getPath())) == null || curElementName == null || curElementName.length() <= 0) continue;
                preferredFeatures.put(curElementName, preferredFeature);
                continue;
            }
            if (!curElementName.startsWith("javax.jws") && !curElementName.startsWith("javax.xml.ws") || jreLocation == null || !path.toString().startsWith(jreLocation)) continue;
            packageMap.put(curElementName, new String[]{"jaxws"});
        }
        info = new APIInfo();
        Set packageSet = packageMap.keySet();
        int size = packageSet.size();
        info.packages = packageSet.toArray(new String[size]);
        Arrays.sort(info.packages);
        info.features = new String[size][];
        for (int i = 0; i < size; ++i) {
            info.features[i] = (String[])packageMap.get(info.packages[i]);
        }
        info.preferredFeatureMap = preferredFeatures;
        info.apiPackageMap = ImportFeatureResolver.getAPIPackageMap(wsRuntime);
        runtimeAPIMap.put(key, info);
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)("# API Packages: " + packageMap.keySet().size() + " - " + key));
            Trace.tracePerf((String)"Package & annotation metadata", (long)time);
        }
        return info;
    }

    private static Map<String, List<String>> getAPIPackageMap(WebSphereRuntime wsRuntime) {
        HashMap<String, List<String>> apiPackageMap = new HashMap<String, List<String>>();
        List featureList = FeatureList.getFeatures((boolean)false, (WebSphereRuntime)wsRuntime);
        for (String feature : featureList) {
            Set packages = FeatureList.getFeatureAPIPackages((String)feature, (WebSphereRuntime)wsRuntime);
            for (String pkg : packages) {
                ArrayList<String> features = (ArrayList<String>)apiPackageMap.get(pkg);
                if (features == null) {
                    features = new ArrayList<String>();
                    apiPackageMap.put(pkg, features);
                }
                if (feature.indexOf("-") > 0) {
                    feature = feature.substring(0, feature.indexOf("-"));
                }
                if (features.contains(feature)) continue;
                features.add(feature);
            }
        }
        return apiPackageMap;
    }

    private static String getFeatureFromPreferredList(IPath path) {
        for (String[] curMap : PREFERRED_JAR_FEATURE_MAP) {
            int index = path.toString().indexOf(curMap[0]);
            if (index <= 0 || !path.toString().matches(".*(" + curMap[0] + "(\\.\\d+)*_(\\d+\\.)*jar)")) continue;
            return curMap[1];
        }
        return null;
    }

    private static int contains(String[] array, String s) {
        int low = 0;
        int mid = 0;
        int high = array.length - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            int result = array[mid].compareTo(s);
            if (result < 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -1;
    }

    private static void checkAndAddFeatures(String pkg, APIInfo info, List<String> features, FeatureSet existingFeatures, FeaturePackages featurePackages, boolean isAcceptMultipleFeatures) {
        int index;
        if (ImportFeatureResolver.ignorePackage(pkg)) {
            return;
        }
        List<String> apiFeatures = info.apiPackageMap.get(pkg);
        if (apiFeatures != null && apiFeatures.size() == 1 && ImportFeatureResolver.isFeatureNeeded(apiFeatures.get(0), pkg, features, existingFeatures, featurePackages)) {
            features.add(apiFeatures.get(0));
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)("Found feature: " + apiFeatures.get(0) + " (" + pkg + ")"));
            }
        }
        if ((index = ImportFeatureResolver.contains(info.packages, pkg)) > 0) {
            String[] featureList = info.features[index];
            String preferredFeature = info.preferredFeatureMap.get(pkg);
            boolean containsPreferredFeature = false;
            for (String feature : featureList) {
                if (!ImportFeatureResolver.isFeatureNeeded(feature, pkg, features, existingFeatures, featurePackages)) {
                    return;
                }
                if (preferredFeature == null || !preferredFeature.equals(feature)) continue;
                containsPreferredFeature = true;
            }
            if (featureList.length == 1) {
                features.add(featureList[0]);
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, (String)("Found feature: " + featureList[0] + " (" + pkg + ")"));
                }
            } else if (isAcceptMultipleFeatures && containsPreferredFeature) {
                features.add(preferredFeature);
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, (String)("Found feature: " + preferredFeature + " (" + pkg + ")"));
                }
            }
        }
    }

    private static boolean isFeatureNeeded(String feature, String pkg, List<String> features, FeatureSet existingFeatures, FeaturePackages featurePackages) {
        if (!features.isEmpty() && features.contains(feature)) {
            return false;
        }
        if (existingFeatures != null && existingFeatures.resolve(feature) != null) {
            return false;
        }
        return featurePackages == null || !featurePackages.containsPackage(pkg);
    }

    private static void processAnnotations(IType type, IAnnotatable annotatable, APIInfo info, List<String> requiredFeatures, FeatureSet existingFeatures, FeaturePackages featurePackages) throws JavaModelException {
        IAnnotation[] ann;
        for (IAnnotation a : ann = annotatable.getAnnotations()) {
            String pkg = a.getElementName();
            int ind = pkg.lastIndexOf(".");
            if (ind <= 0) continue;
            pkg = pkg.substring(0, ind);
            ImportFeatureResolver.checkAndAddFeatures(pkg, info, requiredFeatures, existingFeatures, featurePackages, true);
        }
    }

    private static boolean deltaIncludesJavaChange(IModuleResourceDelta mrd) {
        IModuleResource mr = mrd.getModuleResource();
        if (mr instanceof IModuleFolder) {
            IModuleResourceDelta[] members = mrd.getAffectedChildren();
            if (members != null) {
                for (IModuleResourceDelta mrdChild : members) {
                    if (!ImportFeatureResolver.deltaIncludesJavaChange(mrdChild)) continue;
                    return true;
                }
            }
        } else if (mr instanceof IModuleFile && mrd.getKind() != 3 && mr.getName().endsWith(".class")) {
            return true;
        }
        return false;
    }

    private static boolean deltaIncludesJavaChange(IModuleResourceDelta[] delta) {
        if (delta == null) {
            return false;
        }
        for (IModuleResourceDelta mrd : delta) {
            if (!ImportFeatureResolver.deltaIncludesJavaChange(mrd)) continue;
            return true;
        }
        return false;
    }

    private FeatureResolverFeature[] getFeaturesForModule(WebSphereRuntime wr, IModule[] module, IModuleResourceDelta[] delta, FeatureSet existingFeatures, FeaturePackages featurePackages, IProgressMonitor monitor) {
        if (module == null || module.length == 0) {
            return null;
        }
        try {
            IPackageFragment[] pfs;
            IProject project = module[module.length - 1].getProject();
            if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature")) {
                return null;
            }
            if (delta != null && !ImportFeatureResolver.deltaIncludesJavaChange(delta)) {
                return null;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            APIInfo info = ImportFeatureResolver.getDevAnnotations(wr, javaProject);
            if (info == null) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, (String)"No WAS classpath, skipping import scanning");
                }
                return null;
            }
            long time = System.currentTimeMillis();
            int count = 0;
            ArrayList<String> requiredFeatures = new ArrayList<String>();
            block4: for (IPackageFragment pf : pfs = javaProject.getPackageFragments()) {
                ICompilationUnit[] cus;
                if (pf.getKind() != 1) continue;
                for (ICompilationUnit cu : cus = pf.getCompilationUnits()) {
                    IType[] allTypes;
                    IImportDeclaration[] imps;
                    for (IImportDeclaration im : imps = cu.getImports()) {
                        String pkg = im.getElementName();
                        if (im.isOnDemand()) {
                            pkg = pkg.substring(0, pkg.length() - 2);
                        } else {
                            int ind = pkg.lastIndexOf(".");
                            if (ind > 0) {
                                pkg = pkg.substring(0, ind);
                            }
                        }
                        ImportFeatureResolver.checkAndAddFeatures(pkg, info, requiredFeatures, existingFeatures, featurePackages, true);
                    }
                    for (IType type : allTypes = cu.getAllTypes()) {
                        ++count;
                        try {
                            IMethod[] methods;
                            ImportFeatureResolver.processAnnotations(type, (IAnnotatable)type, info, requiredFeatures, existingFeatures, featurePackages);
                            for (IMethod m : methods = type.getMethods()) {
                                ++count;
                                ImportFeatureResolver.processAnnotations(type, (IAnnotatable)m, info, requiredFeatures, existingFeatures, featurePackages);
                            }
                        }
                        catch (Exception e) {
                            if (!Trace.ENABLED) continue;
                            Trace.logError((String)("Error processing type for annotations: " + type.getFullyQualifiedName()), (Throwable)e);
                        }
                    }
                    if (count > 7500) break block4;
                }
            }
            if (Trace.ENABLED) {
                Trace.tracePerf((String)"Import scanning", (long)time);
            }
            if (requiredFeatures.isEmpty()) {
                return null;
            }
            FeatureResolverFeature[] result = new FeatureResolverFeature[requiredFeatures.size()];
            for (int x = 0; x < result.length; ++x) {
                result[x] = new FeatureResolverFeature((String)requiredFeatures.get(x));
            }
            return result;
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, (String)"Error scanning imports", (Throwable)e);
            }
            return null;
        }
    }

    public void getRequiredFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, List<IModuleResourceDelta[]> deltaList, FeatureSet existingFeatures, RequiredFeatureMap requiredFeatureMap, boolean includeAll, IProgressMonitor monitor) {
        if (moduleList == null || moduleList.isEmpty()) {
            return;
        }
        if (deltaList != null && moduleList.size() != deltaList.size()) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, (String)"The delta list should be either null or have the same size as the module list", null);
            }
            return;
        }
        HashSet<String> featureSet = new HashSet<String>();
        if (existingFeatures != null) {
            FeatureResolverFeature[] featureIterator = existingFeatures.iterator();
            while (featureIterator.hasNext()) {
                featureSet.add((String)featureIterator.next());
            }
        }
        for (FeatureResolverFeature feature : requiredFeatureMap.getFeatures()) {
            featureSet.add(feature.getName());
        }
        FeaturePackages featurePackages = new FeaturePackages(wr, featureSet);
        for (int i = 0; i < moduleList.size(); ++i) {
            IModuleResourceDelta[] delta;
            IModule[] module = moduleList.get(i);
            FeatureResolverFeature[] requiredFeatures = this.getFeaturesForModule(wr, module, delta = deltaList == null ? null : deltaList.get(i), existingFeatures, featurePackages, monitor);
            if (requiredFeatures == null) continue;
            for (FeatureResolverFeature feature : requiredFeatures) {
                FeatureResolver.checkAndAddFeature((RequiredFeatureMap)requiredFeatureMap, (FeatureSet)existingFeatures, (WebSphereRuntime)wr, (FeatureResolverFeature)feature, Collections.singletonList(module), (boolean)includeAll);
            }
        }
    }

    public FeatureResolverFeature[] getContainedFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, IProgressMonitor monitor) {
        if (moduleList == null || moduleList.isEmpty() || wr == null) {
            return null;
        }
        ArrayList<String> containedFeatures = new ArrayList<String>();
        for (IModule[] module : moduleList) {
            if (module == null || module.length == 0) continue;
            try {
                IPackageFragment[] pfs;
                IProject project = module[module.length - 1].getProject();
                if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature")) continue;
                IJavaProject javaProject = JavaCore.create((IProject)project);
                APIInfo info = ImportFeatureResolver.getDevAnnotations(wr, javaProject);
                if (info == null) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)0, (String)"No WAS classpath, skipping scanning");
                    continue;
                }
                long time = System.currentTimeMillis();
                IVMInstall vmInstall = wr.getVMInstall();
                String jreLocation = vmInstall != null ? vmInstall.getInstallLocation().toString().replace('\\', '/') : null;
                for (IPackageFragment pf : pfs = javaProject.getPackageFragments()) {
                    IPath path;
                    if (pf.isDefaultPackage() || pf.getKind() != 2 || (path = pf.getPath()).toString().contains("/dev/") || jreLocation != null && path.toString().startsWith(jreLocation) || !pf.containsJavaResources()) continue;
                    ImportFeatureResolver.checkAndAddFeatures(pf.getElementName(), info, containedFeatures, null, null, false);
                }
                if (Trace.ENABLED) {
                    Trace.tracePerf((String)"Package scanning", (long)time);
                }
                if (!containedFeatures.isEmpty()) continue;
                return null;
            }
            catch (Exception e) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)1, (String)"Error scanning packages", (Throwable)e);
            }
        }
        if (containedFeatures.isEmpty()) {
            return null;
        }
        FeatureResolverFeature[] result = new FeatureResolverFeature[containedFeatures.size()];
        for (int x = 0; x < result.length; ++x) {
            result[x] = new FeatureResolverFeature((String)containedFeatures.get(x));
        }
        return result;
    }

    private static boolean ignorePackage(String pkg) {
        return IGNORE_PKG_SET.contains(pkg);
    }

    static {
        IGNORE_PKG_SET.add("javax.annotation");
        IGNORE_PKG_SET.add("javax.annotation.security");
        IGNORE_PKG_SET.add("javax.annotation.sql");
    }

    static class APIInfo {
        String[] packages;
        String[][] features;
        Map<String, String> preferredFeatureMap;
        Map<String, List<String>> apiPackageMap;

        APIInfo() {
        }
    }

    private static class FeaturePackages {
        private final WebSphereRuntime wsRuntime;
        private final Set<String> features;
        private Set<String> packages;

        public FeaturePackages(WebSphereRuntime wsRuntime, Set<String> features) {
            this.wsRuntime = wsRuntime;
            this.features = features;
        }

        public boolean containsPackage(String pkg) {
            Set<String> packages = this.getPackages();
            return packages.contains(pkg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> getPackages() {
            if (this.packages == null) {
                this.packages = new HashSet<String>();
                if (this.features == null || this.features.isEmpty()) {
                    return this.packages;
                }
                long timestamp = System.currentTimeMillis();
                HashSet<String> allEnabled = new HashSet<String>();
                for (String feature : this.features) {
                    allEnabled.add(feature);
                    allEnabled.addAll(FeatureList.getFeatureChildren((String)feature, (WebSphereRuntime)this.wsRuntime));
                }
                HashSet jars = new HashSet();
                for (String feature : allEnabled) {
                    Set featureJars = FeatureList.getFeatureAPIJars((String)feature, (WebSphereRuntime)this.wsRuntime);
                    jars.addAll(featureJars);
                }
                for (String jar : jars) {
                    IPath path = this.wsRuntime.getRuntimeLocation().append(jar);
                    File file = path.toFile();
                    if (!file.exists()) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, (String)("Jar file from feature list does not exist: " + jar));
                        continue;
                    }
                    ZipInputStream inputStream = null;
                    try {
                        inputStream = new ZipInputStream(new FileInputStream(file));
                        ZipEntry entry = inputStream.getNextEntry();
                        while (entry != null) {
                            if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                                String name = entry.getName();
                                int index = name.lastIndexOf(47);
                                String pkg = name.substring(0, index);
                                pkg = pkg.replace('/', '.');
                                this.packages.add(pkg);
                            }
                            entry = inputStream.getNextEntry();
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, (String)("Exception trying to read jar file: " + path.toOSString()), (Throwable)e);
                    }
                    finally {
                        if (inputStream == null) continue;
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (Trace.ENABLED) {
                    Trace.tracePerf((String)"Existing feature package collection", (long)timestamp);
                }
            }
            return this.packages;
        }
    }
}

