/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.jee.core.internal.DeploymentDescriptorHelper;
import com.ibm.ws.st.jee.core.internal.Messages;
import com.ibm.ws.st.jee.core.internal.Trace;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigurationJEEValidator
extends AbstractValidator {
    private static final String MARKER_TYPE = "com.ibm.ws.st.jee.core.jeeConfigmarker";
    private static final ValidationResult EMPTY_RESULT = new ValidationResult();
    private static final String DOT_SETTINGS_COMPONENT_FILE_NAME = ".settings/org.eclipse.wst.common.component";
    private static final String WAR_TYPE = "war";
    private static final String JST_WEB = "jst.web";
    private static final String XML_FILENAME = "/WEB-INF/ibm-web-ext.xml";
    private static final String XMI_FILENAME = "/WEB-INF/ibm-web-ext.xmi";

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (!(resource instanceof IFile)) {
            return EMPTY_RESULT;
        }
        ValidationResult result = new ValidationResult();
        ArrayList<IResource> dependsOn = new ArrayList<IResource>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        WebSphereServerInfo[] servers = WebSphereUtil.getWebSphereServerInfos();
        URI uri = resource.getLocationURI();
        for (WebSphereServerInfo server : servers) {
            List appElems;
            ConfigurationFile configFile;
            block22: {
                configFile = server.getConfigurationFileFromURI(uri);
                if (configFile == null || monitor.isCanceled()) continue;
                appElems = DOMUtils.getApplicationElements((Document)configFile.getDomDocument());
                try {
                    resource.deleteMarkers(MARKER_TYPE, true, 2);
                }
                catch (CoreException e) {
                    if (!Trace.ENABLED) break block22;
                    Trace.logError("Error removing markers: com.ibm.ws.st.jee.core.jeeConfigmarker", e);
                }
            }
            for (Element appElem : appElems) {
                IModule[] modules;
                if (monitor.isCanceled()) {
                    return result;
                }
                if (!WAR_TYPE.equals(appElem.getAttribute("type"))) continue;
                String appContextRoot = appElem.getAttribute("context-root");
                String appName = configFile.getAppName(appElem);
                IProject project = wsRoot.getProject(appName);
                if (project == null) continue;
                for (IModule module : modules = ServerUtil.getModules((IProject)project)) {
                    IResource dot_Component;
                    if (!JST_WEB.equals(module.getModuleType().getId())) continue;
                    IWebModule webModule = (IWebModule)module.loadAdapter(IWebModule.class, null);
                    IVirtualFolder root = null;
                    if (webModule != null) {
                        String webContextRoot = webModule.getContextRoot();
                        Attr contextRootNode = appElem.getAttributeNode("context-root");
                        if (appContextRoot.isEmpty()) {
                            root = DeploymentDescriptorHelper.getComponentRoot(project);
                            String contextRootInExt = DeploymentDescriptorHelper.getContextRootFromExtXml(root);
                            if (contextRootInExt != null) {
                                if (!this.isContextRootsEqual(contextRootInExt, webContextRoot)) {
                                    this.addMarker(result, resource, this.getXMIMismatchMsg(root, appName, true), appElem);
                                }
                            } else {
                                contextRootInExt = DeploymentDescriptorHelper.getContextRootFromExtXmi(root);
                                if (contextRootInExt != null) {
                                    if (!this.isContextRootsEqual(contextRootInExt, webContextRoot)) {
                                        this.addMarker(result, resource, this.getXMIMismatchMsg(root, appName, false), appElem);
                                    }
                                } else if (!this.isContextRootsEqual(appName, webContextRoot)) {
                                    if (contextRootNode == null) {
                                        this.addMarker(result, resource, webContextRoot, appName, appElem);
                                    } else {
                                        this.addMarker(result, resource, NLS.bind((String)Messages.warningWebContextRootNotMatch, (Object)appName), contextRootNode);
                                    }
                                }
                            }
                        } else if (!this.isContextRootsEqual(appContextRoot, webContextRoot)) {
                            this.addMarker(result, resource, NLS.bind((String)Messages.warningWebContextRootNotMatch, (Object)appName), contextRootNode);
                        }
                    }
                    if ((dot_Component = project.findMember(DOT_SETTINGS_COMPONENT_FILE_NAME)) != null) {
                        dependsOn.add(dot_Component);
                    }
                    if (root == null) continue;
                    dependsOn.add(root.getFile(XML_FILENAME).getUnderlyingResource());
                    dependsOn.add(root.getFile(XMI_FILENAME).getUnderlyingResource());
                }
            }
        }
        if (!dependsOn.isEmpty()) {
            result.setDependsOn(dependsOn.toArray(new IResource[dependsOn.size()]));
        }
        return result;
    }

    private String getXMIMismatchMsg(IVirtualFolder root, String appName, boolean isXML) {
        String fileName = isXML ? XML_FILENAME : XMI_FILENAME;
        IVirtualFile vFile = root.getFile(fileName);
        IFile iFile = vFile.getUnderlyingFile();
        return NLS.bind((String)Messages.warningWebContextRootNotMatchXMI, (Object)appName, (Object)iFile.getFullPath().toPortableString());
    }

    private boolean isContextRootsEqual(String contextRoot1, String contextRoot2) {
        String b;
        if (contextRoot1 == null || contextRoot2 == null) {
            return false;
        }
        String a = contextRoot1.trim();
        if (a.equals(b = contextRoot2.trim())) {
            return true;
        }
        a = this.constructFullContextRoot(a);
        b = this.constructFullContextRoot(b);
        return a.equals(b);
    }

    private String constructFullContextRoot(String s) {
        if (s.isEmpty()) {
            return s;
        }
        String r = s.charAt(0) != '/' ? "/" + s : s;
        if (!r.endsWith("/")) {
            r = r + "/";
        }
        return r;
    }

    private void addMarker(ValidationResult result, IResource resource, String contextRoot, String appName, Node node) {
        result.add(this.createMessage(NLS.bind((String)Messages.warningWebContextRootNotMatchProjectName, (Object[])new String[]{contextRoot, appName}), resource, 1, node));
    }

    private void addMarker(ValidationResult result, IResource resource, String msg, Node node) {
        result.add(this.createMessage(msg, resource, 1, node));
    }

    protected ValidatorMessage createMessage(String text, IResource resource, int level, Node node) {
        DocumentLocation docLocation;
        ValidatorMessage message = ValidatorMessage.create((String)text, (IResource)resource);
        message.setType(MARKER_TYPE);
        message.setAttribute("severity", level);
        if (node != null && (docLocation = DocumentLocation.createDocumentLocation((Node)node)).getLine() != -1) {
            message.setAttribute("lineNumber", docLocation.getLine());
            if (docLocation.getStartOffset() != -1 && docLocation.getEndOffset() != -1) {
                message.setAttribute("charStart", docLocation.getStartOffset());
                message.setAttribute("charEnd", docLocation.getEndOffset());
            }
        }
        return message;
    }
}

