/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.validation;

import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.validation.ValidationManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class DDEValidator
extends AbstractValidator
implements IValidator {
    public static final String GET_FILE = "getFile";
    public static final String COLUMN_NUMBER_ATTRIBUTE = "columnNumber";

    public void validate(IValidationContext context, IReporter reporter) throws ValidationException {
        boolean workbenchValidation = context instanceof WorkbenchContext;
        String[] fileURIs = context.getURIs();
        if (fileURIs != null && fileURIs.length > 0) {
            int filesCount = fileURIs.length;
            for (int i = 0; i < filesCount && !reporter.isCancelled(); ++i) {
                IFile file;
                String fileName = fileURIs[i];
                if (fileName == null || (file = (IFile)context.loadModel(GET_FILE, new Object[]{fileName})) == null || !DDEValidator.shouldValidate(file)) continue;
                ValidationManager activeDesignViewValidationManager = this.getActiveDesignViewValidationManager(file);
                if (activeDesignViewValidationManager != null) {
                    activeDesignViewValidationManager.getMessageManager().exportMessagesToReporter(file, this, reporter, !workbenchValidation);
                    continue;
                }
                this.performFileValidation(file, reporter, workbenchValidation);
            }
        }
    }

    private static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    private CustomizationManager.Customization getCustomization(IFile file) {
        try {
            IContentDescription contentDescription = file.getContentDescription();
            IContentType contentType = contentDescription.getContentType();
            IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor[] editors = editorRegistry.getEditors(file.getName(), contentType);
            for (int i = 0; i < editors.length; ++i) {
                CustomizationManager.Customization customization = CustomizationManager.getInstance().getCustomization(editors[i].getId());
                if (customization == null) continue;
                return customization;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFileValidation(IFile file, IReporter reporter, boolean workbenchValidation) {
        IStructuredModel modelForRead = null;
        boolean validationSuccessfull = false;
        reporter.removeAllMessages((IValidator)this, (Object)file);
        try {
            modelForRead = StructuredModelManager.getModelManager().getModelForRead(file);
            if (modelForRead != null) {
                IDOMDocument document = ((IDOMModel)modelForRead).getDocument();
                CustomizationManager.Customization customization = this.getCustomization(file);
                int validationEnviroment = workbenchValidation ? 1 : 0;
                ValidationManager validationManager = new ValidationManager(customization, (IResource)file, validationEnviroment);
                validationManager.setEditorInput(this.getEditorInput(file));
                validationManager.setDocument((Document)document);
                validationManager.validateDocument();
                validationManager.getMessageManager().exportMessagesToReporter(file, this, reporter, !workbenchValidation);
                validationSuccessfull = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (modelForRead != null) {
                modelForRead.releaseFromRead();
            }
            if (!validationSuccessfull) {
                LocalizedMessage localizedMessage = new LocalizedMessage(1, Messages.ERROR_RESOURCE_CONTENTS_COULD_NOT_BE_VALIDATED);
                localizedMessage.setTargetObject((Object)file);
                reporter.addMessage((IValidator)this, (IMessage)localizedMessage);
            }
        }
    }

    private ValidationManager getActiveDesignViewValidationManager(IFile file) {
        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        for (int i = 0; i < workbenchWindows.length; ++i) {
            IWorkbenchWindow workbenchWindow = workbenchWindows[i];
            IWorkbenchPage[] workbenchPages = workbenchWindow.getPages();
            for (int j = 0; j < workbenchPages.length; ++j) {
                IWorkbenchPage workbenchPage = workbenchPages[j];
                IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
                for (int k = 0; k < editorReferences.length; ++k) {
                    IEditorInput editorInput;
                    Object adapter;
                    DDEMultiPageEditorPart ddeMultiPageEditorPart;
                    IEditorReference editorReference = editorReferences[k];
                    IWorkbenchPart workbenchPart = editorReference.getPart(false);
                    if (!(workbenchPart instanceof DDEMultiPageEditorPart) || !(ddeMultiPageEditorPart = (DDEMultiPageEditorPart)workbenchPart).isDesignPageActiveAndInFocus() || !((adapter = (editorInput = ddeMultiPageEditorPart.getEditorInput()).getAdapter(IFile.class)) instanceof IFile) || !file.equals(adapter)) continue;
                    return ddeMultiPageEditorPart.getValidationManager();
                }
            }
        }
        return null;
    }

    private IEditorInput getEditorInput(IFile file) {
        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        for (int i = 0; i < workbenchWindows.length; ++i) {
            IWorkbenchWindow workbenchWindow = workbenchWindows[i];
            IWorkbenchPage[] workbenchPages = workbenchWindow.getPages();
            for (int j = 0; j < workbenchPages.length; ++j) {
                IWorkbenchPage workbenchPage = workbenchPages[j];
                IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
                for (int k = 0; k < editorReferences.length; ++k) {
                    Object adapter;
                    IEditorInput editorInput;
                    DDEMultiPageEditorPart ddeMultiPageEditorPart;
                    IEditorReference editorReference = editorReferences[k];
                    IWorkbenchPart workbenchPart = editorReference.getPart(false);
                    if (!(workbenchPart instanceof DDEMultiPageEditorPart) || (ddeMultiPageEditorPart = (DDEMultiPageEditorPart)workbenchPart) == null || (editorInput = ddeMultiPageEditorPart.getEditorInput()) == null || !((adapter = editorInput.getAdapter(IFile.class)) instanceof IFile) || !file.equals(adapter)) continue;
                    return editorInput;
                }
            }
        }
        return null;
    }

    public void cleanup(IReporter reporter) {
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult result = new ValidationResult();
        try {
            this.validateFile(resource, state, result.getReporter(monitor));
        }
        catch (ValidationException e) {
            result.setValidationException(e);
        }
        return result;
    }

    protected IStatus validateFile(IResource resource, ValidationState state, IReporter reporter) throws ValidationException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            ValidationManager activeDesignViewValidationManager = this.getActiveDesignViewValidationManager(file);
            if (activeDesignViewValidationManager != null) {
                activeDesignViewValidationManager.getMessageManager().exportMessagesToReporter(file, this, reporter, false);
            } else {
                this.performFileValidation(file, reporter, true);
            }
        }
        if (reporter.isCancelled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

