/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.viewers;

import com.ibm.xwt.dde.DDEPlugin;
import com.ibm.xwt.dde.customization.ICustomIconObject;
import com.ibm.xwt.dde.customization.ValidationMessage;
import com.ibm.xwt.dde.internal.actions.AddElementAction;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import com.ibm.xwt.dde.internal.data.AtomicDetailItem;
import com.ibm.xwt.dde.internal.data.DetailItem;
import com.ibm.xwt.dde.internal.data.SimpleDetailItem;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.validation.DetailItemValidation;
import com.ibm.xwt.dde.internal.validation.ValidationManager;
import com.ibm.xwt.dde.internal.viewers.DDEViewer;
import java.text.MessageFormat;
import java.util.Stack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TreeNodeToolTip
extends ToolTip {
    private Element treeNodeElement;
    private ValidationManager validationManager;
    private CustomizationManager.Customization customization;
    private DDEViewer ddeViewer;
    private IEditorPart editorPart;
    private TabbedPropertySheetWidgetFactory widgetFactory;

    public TreeNodeToolTip(Control control, Element treeNodeElement, DDEViewer ddeViewer) {
        super(control, 2, true);
        this.treeNodeElement = treeNodeElement;
        this.validationManager = ddeViewer.getValidationManager();
        this.customization = ddeViewer.getCustomization();
        this.editorPart = ddeViewer.getEditorPart();
        this.widgetFactory = ddeViewer.getWidgetFactory();
        this.ddeViewer = ddeViewer;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        DetailItemCustomization detailItemCustomization;
        Composite toolTipMainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 1;
        toolTipMainComposite.setLayout((Layout)gridLayout);
        Composite headerComposite = new Composite(toolTipMainComposite, 0);
        headerComposite.setBackground(this.widgetFactory.getColors().getBackground());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        headerComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.marginRight = 2;
        gridLayout.marginLeft = 2;
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 1;
        gridLayout.horizontalSpacing = 2;
        headerComposite.setLayout((Layout)gridLayout);
        Label headerIconLabel = new Label(headerComposite, 0);
        headerIconLabel.setBackground(this.widgetFactory.getColors().getBackground());
        headerIconLabel.setImage(this.ddeViewer.getTreeLabelProvider().getImage(this.treeNodeElement, true));
        Label headerLabel = new Label(headerComposite, 0);
        headerLabel.setBackground(this.widgetFactory.getColors().getBackground());
        headerLabel.setText(this.ddeViewer.getTreeLabelProvider().getText(this.treeNodeElement));
        headerLabel.setFont(DDEPlugin.getDefault().FONT_DEFAULT_BOLD);
        Composite toolTipContentComposite = new Composite(toolTipMainComposite, 0);
        toolTipContentComposite.setBackground(parent.getDisplay().getSystemColor(29));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginTop = 0;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 3;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 1;
        toolTipContentComposite.setLayout((Layout)gridLayout);
        int treeNodeErrorCount = this.validationManager.getMessageManager().getTreeNodeMessageCount(this.treeNodeElement, 1, false);
        CMElementDeclaration[] treeNodeMissingRequiredChildren = this.validationManager.getMessageManager().getTreeNodeMissingRequiredChildren(this.treeNodeElement);
        if (treeNodeMissingRequiredChildren.length > 0) {
            Label label = new Label(toolTipContentComposite, 0);
            label.setBackground(parent.getDisplay().getSystemColor(29));
            label.setImage(DDEPlugin.getDefault().getImage("icons/error.gif"));
            label = new Label(toolTipContentComposite, 0);
            label.setBackground(parent.getDisplay().getSystemColor(29));
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.horizontalIndent = 3;
            label.setLayoutData((Object)gridData);
            if (treeNodeMissingRequiredChildren.length == 1) {
                label.setText(Messages.SINGLE_REQUIRED_ITEM_MISSING);
            } else {
                label.setText(Messages.MULTIPLE_REQUIRED_ITEMS_MISSING);
            }
            for (int i = 0; i < treeNodeMissingRequiredChildren.length; ++i) {
                ICustomIconObject iconClassObj;
                Object iconClass;
                final CMElementDeclaration cmElementDeclaration = treeNodeMissingRequiredChildren[i];
                String missingTreeNodeLabel = null;
                Image missingTreeNodeIcon = null;
                String namespace = ModelUtil.getNamespaceURI((CMNode)cmElementDeclaration);
                String path = ModelUtil.getNodeFullPath(this.treeNodeElement, (CMNode)cmElementDeclaration);
                DetailItemCustomization detailItemCustomization2 = detailItemCustomization = this.customization != null ? this.customization.getItemCustomization(namespace, path) : null;
                if (detailItemCustomization == null && this.customization != null) {
                    detailItemCustomization = this.customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, path);
                }
                if (detailItemCustomization != null) {
                    missingTreeNodeLabel = detailItemCustomization.getLabel();
                    missingTreeNodeIcon = detailItemCustomization.getIcon();
                    if (missingTreeNodeIcon == null && detailItemCustomization.getIconClass() != null) {
                        try {
                            iconClass = detailItemCustomization.getIconClass().newInstance();
                            if (iconClass instanceof ICustomIconObject) {
                                iconClassObj = (ICustomIconObject)iconClass;
                                iconClassObj.getClass().newInstance();
                                missingTreeNodeIcon = iconClassObj.getIcon(cmElementDeclaration, null);
                            }
                        }
                        catch (IllegalAccessException e1) {
                            e1.printStackTrace();
                        }
                        catch (InstantiationException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else if (this.customization.getIconClass() != null) {
                    try {
                        iconClass = detailItemCustomization.getIconClass().newInstance();
                        if (iconClass instanceof ICustomIconObject) {
                            iconClassObj = (ICustomIconObject)iconClass;
                            iconClassObj.getClass().newInstance();
                            missingTreeNodeIcon = iconClassObj.getIcon(cmElementDeclaration, null);
                        }
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                    catch (InstantiationException e1) {
                        e1.printStackTrace();
                    }
                }
                if (missingTreeNodeLabel == null) {
                    missingTreeNodeLabel = cmElementDeclaration.getElementName();
                }
                if (missingTreeNodeIcon == null) {
                    missingTreeNodeIcon = DDEPlugin.getDefault().getImage("icons/parameters.gif");
                }
                label = new Label(toolTipContentComposite, 0);
                label = new Label(toolTipContentComposite, 0);
                label.setBackground(parent.getDisplay().getSystemColor(29));
                label.setImage(missingTreeNodeIcon);
                gridData = new GridData();
                gridData.horizontalIndent = 5;
                label.setLayoutData((Object)gridData);
                label = new Label(toolTipContentComposite, 0);
                label.setBackground(parent.getDisplay().getSystemColor(29));
                label.setText(missingTreeNodeLabel);
                gridData = new GridData();
                gridData.horizontalIndent = 6;
                label.setLayoutData((Object)gridData);
                ImageHyperlink imageHyperlink = this.widgetFactory.createImageHyperlink(toolTipContentComposite, 0);
                imageHyperlink.setBackground(parent.getDisplay().getSystemColor(29));
                imageHyperlink.setText("Add");
                imageHyperlink.setImage(DDEPlugin.getDefault().getImage("icons/quickfix_error.gif"));
                gridData = new GridData();
                gridData.horizontalIndent = 40;
                gridData.horizontalAlignment = 131072;
                imageHyperlink.setLayoutData((Object)gridData);
                imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkActivated(HyperlinkEvent e) {
                        AddElementAction addElementAction = new AddElementAction(TreeNodeToolTip.this.treeNodeElement, cmElementDeclaration, TreeNodeToolTip.this.ddeViewer, TreeNodeToolTip.this.editorPart, TreeNodeToolTip.this.customization);
                        addElementAction.run();
                        TreeNodeToolTip.this.hide();
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }
                });
            }
        }
        DetailItemValidation[] detailItemValidations = new DetailItemValidation[]{};
        detailItemValidations = treeNodeErrorCount > 0 ? this.validationManager.getMessageManager().getTreeNodeDetailItemMessages(this.treeNodeElement, true, false) : this.validationManager.getMessageManager().getTreeNodeDetailItemMessages(this.treeNodeElement, false, true);
        for (int j = 0; j < detailItemValidations.length; ++j) {
            DetailItemValidation detailItemValidation = detailItemValidations[j];
            final DetailItem detailItem = detailItemValidation.getDetailItem();
            final SimpleDetailItem containingSimpleDetailItem = detailItemValidation.getContainingSimpleDetailItem();
            ValidationMessage message = detailItemValidation.getMessage();
            String controlLabel = null;
            detailItemCustomization = detailItem.getDetailItemCustomization();
            if (detailItemCustomization != null) {
                controlLabel = detailItemCustomization.getLabel();
            }
            if (controlLabel == null) {
                controlLabel = detailItem.getName();
            }
            Label label = new Label(toolTipContentComposite, 0);
            label.setBackground(parent.getDisplay().getSystemColor(29));
            switch (message.getMessageType()) {
                case 0: {
                    label.setImage(DDEPlugin.getDefault().getImage("icons/warning_small.gif"));
                    break;
                }
                case 1: {
                    label.setImage(DDEPlugin.getDefault().getImage("icons/error.gif"));
                }
            }
            String hyperLinkLabel = MessageFormat.format(Messages.LABEL_COLON_SPACE, controlLabel, message.getMessage());
            Hyperlink hyperlink = this.widgetFactory.createHyperlink(toolTipContentComposite, hyperLinkLabel, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.horizontalIndent = 2;
            hyperlink.setLayoutData((Object)gridData);
            hyperlink.setBackground(parent.getDisplay().getSystemColor(29));
            hyperlink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent e) {
                    TreeNodeToolTip.this.hide();
                    Stack<Node> nodes = new Stack<Node>();
                    Node parentNode = TreeNodeToolTip.this.treeNodeElement.getParentNode();
                    while (parentNode.getNodeType() == 1) {
                        nodes.push(parentNode);
                        parentNode = parentNode.getParentNode();
                    }
                    while (!nodes.empty()) {
                        TreeNodeToolTip.this.ddeViewer.getTreeViewer().setExpandedState(nodes.pop(), true);
                    }
                    StructuredSelection selection = new StructuredSelection((Object)TreeNodeToolTip.this.treeNodeElement);
                    TreeNodeToolTip.this.ddeViewer.getTreeViewer().setSelection((ISelection)selection);
                    Node node = null;
                    if (detailItem instanceof AtomicDetailItem) {
                        AtomicDetailItem atomicDetailItem = (AtomicDetailItem)detailItem;
                        node = atomicDetailItem.getNode();
                    }
                    selection = node != null ? new StructuredSelection(node) : new StructuredSelection((Object)ModelUtil.getDetailItemLocalPath(containingSimpleDetailItem, detailItem));
                    TreeNodeToolTip.this.ddeViewer.getDetailsViewer().setSelection((ISelection)selection, true);
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }
            });
        }
        Element[] childTreeNodeElements = new Element[]{};
        childTreeNodeElements = treeNodeErrorCount > 0 ? this.validationManager.getMessageManager().getChildTreeNodeElements(this.treeNodeElement, false, false, true, false) : this.validationManager.getMessageManager().getChildTreeNodeElements(this.treeNodeElement, false, false, false, true);
        if (childTreeNodeElements.length > 0) {
            Label label = new Label(toolTipContentComposite, 0);
            label.setBackground(parent.getDisplay().getSystemColor(29));
            if (treeNodeErrorCount > 0) {
                label.setImage(DDEPlugin.getDefault().getImage("icons/error.gif"));
            } else {
                label.setImage(DDEPlugin.getDefault().getImage("icons/warning_small.gif"));
            }
            label = new Label(toolTipContentComposite, 0);
            label.setBackground(parent.getDisplay().getSystemColor(29));
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.horizontalIndent = 3;
            label.setLayoutData((Object)gridData);
            if (childTreeNodeElements.length == 1) {
                label.setText(treeNodeErrorCount > 0 ? Messages.THE_FOLLOWING_ITEM_CONTAIN_ERRORS : Messages.THE_FOLLOWING_ITEM_CONTAIN_WARNINGS);
            } else {
                label.setText(treeNodeErrorCount > 0 ? Messages.THE_FOLLOWING_ITEMS_CONTAIN_ERRORS : Messages.THE_FOLLOWING_ITEMS_CONTAIN_WARNINGS);
            }
            for (int i = 0; i < childTreeNodeElements.length; ++i) {
                final Element childTreeNodeElement = childTreeNodeElements[i];
                Image elementImage = this.ddeViewer.getTreeLabelProvider().getImage(childTreeNodeElement);
                String elementLabel = this.ddeViewer.getTreeLabelProvider().getText(childTreeNodeElement);
                label = new Label(toolTipContentComposite, 0);
                ImageHyperlink imageHyperlink = this.widgetFactory.createImageHyperlink(toolTipContentComposite, 0);
                imageHyperlink.setBackground(parent.getDisplay().getSystemColor(29));
                imageHyperlink.setImage(elementImage);
                imageHyperlink.setText(elementLabel);
                gridData = new GridData();
                gridData.horizontalSpan = 3;
                gridData.horizontalIndent = 5;
                imageHyperlink.setLayoutData((Object)gridData);
                imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkActivated(HyperlinkEvent e) {
                        StructuredSelection selection = new StructuredSelection((Object)childTreeNodeElement);
                        Stack<Node> nodes = new Stack<Node>();
                        Node parentNode = childTreeNodeElement.getParentNode();
                        while (parentNode.getNodeType() == 1) {
                            nodes.push(parentNode);
                            parentNode = parentNode.getParentNode();
                        }
                        while (!nodes.empty()) {
                            TreeNodeToolTip.this.ddeViewer.getTreeViewer().setExpandedState(nodes.pop(), true);
                        }
                        TreeNodeToolTip.this.ddeViewer.getTreeViewer().setSelection((ISelection)selection);
                        TreeNodeToolTip.this.ddeViewer.getTreeViewer().getTree().setFocus();
                        TreeNodeToolTip.this.hide();
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }
                });
            }
        }
        return toolTipContentComposite;
    }

    protected void afterHideToolTip(Event event) {
    }
}

