/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.viewers;

import com.ibm.xwt.dde.DDEPlugin;
import com.ibm.xwt.dde.customization.ICustomIconObject;
import com.ibm.xwt.dde.customization.ValidationMessage;
import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import com.ibm.xwt.dde.internal.actions.AddElementAction;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import com.ibm.xwt.dde.internal.data.AtomicDetailItem;
import com.ibm.xwt.dde.internal.data.AtomicElementDetailItem;
import com.ibm.xwt.dde.internal.data.DetailItem;
import com.ibm.xwt.dde.internal.data.SimpleDetailItem;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.validation.DetailItemValidation;
import com.ibm.xwt.dde.internal.viewers.DDEViewer;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ErrorMessageSummaryPopupDialog
extends PopupDialog {
    private ScrolledComposite dialogScrolledComposite;
    private Composite dialogComposite;
    private DDEViewer ddeViewer;

    public ErrorMessageSummaryPopupDialog(Shell parent, DDEViewer ddeViewer) {
        super(parent, 2064, true, false, false, false, false, null, null);
        this.ddeViewer = ddeViewer;
    }

    public Point getClientAreaActualSize() {
        return this.dialogComposite.computeSize(-1, -1);
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogScrolledComposite = new ScrolledComposite(parent, 0x800300);
        this.dialogScrolledComposite.setExpandHorizontal(true);
        this.dialogScrolledComposite.setExpandVertical(true);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.dialogScrolledComposite.setLayoutData((Object)gridData);
        this.dialogComposite = new Composite((Composite)this.dialogScrolledComposite, 0x800000);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 3;
        gridLayout.verticalSpacing = 0;
        gridLayout.numColumns = 2;
        this.dialogComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        this.dialogComposite.setLayoutData((Object)gridData);
        int errorCount = this.ddeViewer.getValidationManager().getMessageManager().getDocumentMessageCount(1);
        boolean sourceViewContainsErrors = this.ddeViewer.getSourceViewContainsErrors();
        TreeNodeElement[] treeNodeElements = this.obtainSortedTreeNodeElements(errorCount > 0 || sourceViewContainsErrors, errorCount == 0 && !sourceViewContainsErrors);
        for (int i = 0; i < treeNodeElements.length; ++i) {
            final TreeNodeElement currentTreeNodeElement = treeNodeElements[i];
            Label treeNodeImageLabel = new Label(this.dialogComposite, 0);
            treeNodeImageLabel.setImage(currentTreeNodeElement.treeNodeImage);
            Hyperlink hyperlink = this.ddeViewer.getWidgetFactory().createHyperlink(this.dialogComposite, currentTreeNodeElement.treeNodeLabel, 0);
            hyperlink.setFont(DDEPlugin.getDefault().FONT_DEFAULT_BOLD);
            hyperlink.setUnderlined(false);
            hyperlink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent e) {
                    ErrorMessageSummaryPopupDialog.this.close();
                    Stack<Node> nodes = new Stack<Node>();
                    Node parentNode = currentTreeNodeElement.element.getParentNode();
                    while (parentNode.getNodeType() == 1) {
                        nodes.push(parentNode);
                        parentNode = parentNode.getParentNode();
                    }
                    while (!nodes.empty()) {
                        ErrorMessageSummaryPopupDialog.this.ddeViewer.getTreeViewer().setExpandedState(nodes.pop(), true);
                    }
                    StructuredSelection selection = new StructuredSelection((Object)currentTreeNodeElement.element);
                    ErrorMessageSummaryPopupDialog.this.ddeViewer.getTreeViewer().setSelection((ISelection)selection);
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }
            });
            new Label(this.dialogComposite, 0);
            Composite treeNodeContentComposite = new Composite(this.dialogComposite, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginBottom = 5;
            treeNodeContentComposite.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            treeNodeContentComposite.setLayoutData((Object)gridData);
            if (errorCount <= 0 && sourceViewContainsErrors) continue;
            this.createTreeNodeMessageContent(currentTreeNodeElement, treeNodeContentComposite, errorCount > 0, errorCount == 0);
        }
        if (this.ddeViewer.getSourceViewContainsErrors() && errorCount == 0) {
            Label treeNodeImageLabel = new Label(this.dialogComposite, 0);
            treeNodeImageLabel.setImage(DDEPlugin.getDefault().getImage("icons/error.gif"));
            Text text = new Text(this.dialogComposite, 8);
            text.setText(Messages.ERRORS_IN_SOURCE_VIEW);
            new Label(this.dialogComposite, 0);
            ImageHyperlink imageHyperlink = new ImageHyperlink(this.dialogComposite, 0);
            imageHyperlink.setText(Messages.SWITCH_TO_SOURCE_VIEW);
            imageHyperlink.setImage(DDEPlugin.getDefault().getImage("icons/goto.gif"));
            imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent e) {
                    ErrorMessageSummaryPopupDialog.this.close();
                    Node firstSourceViewErrorNode = ErrorMessageSummaryPopupDialog.this.ddeViewer.getFirstSourceViewErrorNode();
                    ((DDEMultiPageEditorPart)ErrorMessageSummaryPopupDialog.this.ddeViewer.getEditorPart()).setEditorActivePage(DDEMultiPageEditorPart.SOURCE_VIEW_PAGE);
                    ((DDEMultiPageEditorPart)ErrorMessageSummaryPopupDialog.this.ddeViewer.getEditorPart()).setSelection(firstSourceViewErrorNode);
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }
            });
        }
        this.dialogScrolledComposite.setContent((Control)this.dialogComposite);
        this.dialogScrolledComposite.setMinSize(this.dialogComposite.computeSize(-1, -1));
        return this.dialogScrolledComposite;
    }

    private void createTreeNodeMessageContent(final TreeNodeElement treeNodeElement, Composite composite, boolean includeErrors, boolean includeWarnings) {
        Composite contentComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 0;
        contentComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        contentComposite.setLayoutData((Object)gridData);
        CMElementDeclaration[] treeNodeMissingRequiredChildren = this.ddeViewer.getValidationManager().getMessageManager().getTreeNodeMissingRequiredChildren(treeNodeElement.element);
        if (treeNodeMissingRequiredChildren.length > 0) {
            Label label = new Label(contentComposite, 0);
            label.setImage(DDEPlugin.getDefault().getImage("icons/error.gif"));
            label = new Label(contentComposite, 0);
            gridData = new GridData();
            gridData.horizontalIndent = 1;
            label.setLayoutData((Object)gridData);
            Text text = new Text(contentComposite, 8);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            text.setLayoutData((Object)gridData);
            if (treeNodeMissingRequiredChildren.length == 1) {
                text.setText(Messages.SINGLE_REQUIRED_ITEM_MISSING);
            } else {
                text.setText(Messages.MULTIPLE_REQUIRED_ITEMS_MISSING);
            }
            for (int i = 0; i < treeNodeMissingRequiredChildren.length; ++i) {
                final CMElementDeclaration cmElementDeclaration = treeNodeMissingRequiredChildren[i];
                String missingTreeNodeLabel = null;
                Image missingTreeNodeIcon = null;
                String namespace = ModelUtil.getNamespaceURI((CMNode)cmElementDeclaration);
                String path = ModelUtil.getNodeFullPath(treeNodeElement.element, (CMNode)cmElementDeclaration);
                CustomizationManager.Customization customization = this.ddeViewer.getCustomization();
                if (customization != null) {
                    ICustomIconObject iconClassObj;
                    Object iconClass;
                    DetailItemCustomization detailItemCustomization = this.ddeViewer.getCustomization().getItemCustomization(namespace, path);
                    if (detailItemCustomization == null) {
                        detailItemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, path);
                    }
                    if (detailItemCustomization != null) {
                        missingTreeNodeLabel = detailItemCustomization.getLabel();
                        missingTreeNodeIcon = detailItemCustomization.getIcon();
                        if (missingTreeNodeIcon == null && detailItemCustomization.getIconClass() != null) {
                            try {
                                iconClass = detailItemCustomization.getIconClass().newInstance();
                                if (iconClass instanceof ICustomIconObject) {
                                    iconClassObj = (ICustomIconObject)iconClass;
                                    iconClassObj.getClass().newInstance();
                                    missingTreeNodeIcon = iconClassObj.getIcon(cmElementDeclaration, null);
                                }
                            }
                            catch (IllegalAccessException e1) {
                                e1.printStackTrace();
                            }
                            catch (InstantiationException e1) {
                                e1.printStackTrace();
                            }
                        }
                    } else if (customization.getIconClass() != null) {
                        try {
                            iconClass = detailItemCustomization.getIconClass().newInstance();
                            if (iconClass instanceof ICustomIconObject) {
                                iconClassObj = (ICustomIconObject)iconClass;
                                iconClassObj.getClass().newInstance();
                                missingTreeNodeIcon = iconClassObj.getIcon(cmElementDeclaration, null);
                            }
                        }
                        catch (IllegalAccessException e1) {
                            e1.printStackTrace();
                        }
                        catch (InstantiationException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                if (missingTreeNodeLabel == null) {
                    missingTreeNodeLabel = cmElementDeclaration.getElementName();
                }
                if (missingTreeNodeIcon == null) {
                    missingTreeNodeIcon = DDEPlugin.getDefault().getImage("icons/parameters.gif");
                }
                label = new Label(contentComposite, 0);
                Composite missingItemComposite = new Composite(contentComposite, 0);
                gridLayout = new GridLayout();
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                gridLayout.numColumns = 3;
                gridLayout.horizontalSpacing = 1;
                missingItemComposite.setLayout((Layout)gridLayout);
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                missingItemComposite.setLayoutData((Object)gridData);
                label = new Label(missingItemComposite, 0);
                label.setImage(missingTreeNodeIcon);
                gridData = new GridData();
                gridData.horizontalIndent = 5;
                label.setLayoutData((Object)gridData);
                label = new Label(missingItemComposite, 0);
                gridData = new GridData();
                label.setLayoutData((Object)gridData);
                Text missingItemText = new Text(missingItemComposite, 8);
                missingItemText.setText(missingTreeNodeLabel);
                gridData = new GridData();
                missingItemText.setLayoutData((Object)gridData);
                ImageHyperlink imageHyperlink = this.ddeViewer.getWidgetFactory().createImageHyperlink(contentComposite, 0);
                imageHyperlink.setText(Messages.LABEL_ADD);
                imageHyperlink.setImage(DDEPlugin.getDefault().getImage("icons/quickfix_error.gif"));
                gridData = new GridData();
                gridData.horizontalIndent = 50;
                imageHyperlink.setLayoutData((Object)gridData);
                imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkActivated(HyperlinkEvent e) {
                        AddElementAction addElementAction = new AddElementAction(treeNodeElement.element, cmElementDeclaration, ErrorMessageSummaryPopupDialog.this.ddeViewer, ErrorMessageSummaryPopupDialog.this.ddeViewer.getEditorPart(), ErrorMessageSummaryPopupDialog.this.ddeViewer.getCustomization());
                        addElementAction.run();
                        ErrorMessageSummaryPopupDialog.this.close();
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }
                });
            }
        }
        DetailItemValidation[] detailItemValidations = this.ddeViewer.getValidationManager().getMessageManager().getTreeNodeDetailItemMessages(treeNodeElement.element, includeErrors, includeWarnings);
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                DetailItem detailItem_1 = ((DetailItemValidation)arg0).getDetailItem();
                DetailItem detailItem_2 = ((DetailItemValidation)arg1).getDetailItem();
                String name_1 = ErrorMessageSummaryPopupDialog.this.getControlLabel(detailItem_1);
                String name_2 = ErrorMessageSummaryPopupDialog.this.getControlLabel(detailItem_2);
                return Collator.getInstance().compare(name_1, name_2);
            }
        };
        Arrays.sort(detailItemValidations, comparator);
        for (int j = 0; j < detailItemValidations.length; ++j) {
            DetailItemValidation detailItemValidation = detailItemValidations[j];
            ValidationMessage[] customizedMessages = this.ddeViewer.getValidationManager().getMessageManager().getMessages(treeNodeElement.element, includeErrors, includeWarnings);
            final DetailItem detailItem = detailItemValidation.getDetailItem();
            final SimpleDetailItem containingSimpleDetailItem = detailItemValidation.getContainingSimpleDetailItem();
            ValidationMessage message = detailItemValidation.getMessage();
            if (message != null && message.getMessage().equals("") && customizedMessages != null) {
                this.createCustomMessages(message, customizedMessages, detailItem, contentComposite);
                continue;
            }
            String controlLabel = this.getControlLabel(detailItem);
            Label iconLabel = new Label(contentComposite, 0);
            switch (message.getMessageType()) {
                case 1: {
                    iconLabel.setImage(DDEPlugin.getDefault().getImage("icons/error.gif"));
                    break;
                }
                case 0: {
                    iconLabel.setImage(DDEPlugin.getDefault().getImage("icons/warning_small.gif"));
                }
            }
            gridData = new GridData();
            gridData.verticalAlignment = 128;
            iconLabel.setLayoutData((Object)gridData);
            Link link = new Link(contentComposite, 0);
            link.setText(MessageFormat.format(Messages.LABEL_COLON, "<a>" + controlLabel + "</a>"));
            gridData = new GridData();
            gridData.horizontalIndent = 4;
            gridData.verticalAlignment = 128;
            link.setLayoutData((Object)gridData);
            link.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ErrorMessageSummaryPopupDialog.this.close();
                    Stack<Node> nodes = new Stack<Node>();
                    Node parentNode = treeNodeElement.element.getParentNode();
                    while (parentNode.getNodeType() == 1) {
                        nodes.push(parentNode);
                        parentNode = parentNode.getParentNode();
                    }
                    while (!nodes.empty()) {
                        ErrorMessageSummaryPopupDialog.this.ddeViewer.getTreeViewer().setExpandedState(nodes.pop(), true);
                    }
                    StructuredSelection selection = new StructuredSelection((Object)treeNodeElement.element);
                    ErrorMessageSummaryPopupDialog.this.ddeViewer.getTreeViewer().setSelection((ISelection)selection);
                    Node node = null;
                    if (detailItem instanceof AtomicDetailItem) {
                        AtomicDetailItem atomicDetailItem = (AtomicDetailItem)detailItem;
                        node = atomicDetailItem.getNode();
                    }
                    selection = node != null ? new StructuredSelection(node) : new StructuredSelection((Object)ModelUtil.getDetailItemLocalPath(containingSimpleDetailItem, detailItem));
                    ErrorMessageSummaryPopupDialog.this.ddeViewer.getDetailsViewer().setSelection((ISelection)selection, true);
                }
            });
            Text text = new Text(contentComposite, 72);
            text.setText(message.getMessage());
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            text.setLayoutData((Object)gridData);
        }
        ValidationMessage[] treeNodeMessages = this.ddeViewer.getValidationManager().getMessageManager().getTreeNodeMessages(treeNodeElement.element, includeErrors, includeWarnings);
        for (int i = 0; i < treeNodeMessages.length; ++i) {
            ValidationMessage currentValidationMessage = treeNodeMessages[i];
            Label label = new Label(contentComposite, 0);
            if (currentValidationMessage.getMessageType() == 1) {
                label.setImage(DDEPlugin.getDefault().getImage("icons/error.gif"));
            } else if (currentValidationMessage.getMessageType() == 0) {
                label.setImage(DDEPlugin.getDefault().getImage("icons/warning_small.gif"));
            }
            label = new Label(contentComposite, 0);
            gridData = new GridData();
            gridData.horizontalIndent = 1;
            label.setLayoutData((Object)gridData);
            Text text = new Text(contentComposite, 8);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            text.setLayoutData((Object)gridData);
            text.setText(currentValidationMessage.getMessage());
        }
    }

    private void createCustomMessages(ValidationMessage message, ValidationMessage[] customizedMessages, DetailItem detailItem, Composite contentComposite) {
        String controlLabel = this.getControlLabel(detailItem);
        Label iconLabel = new Label(contentComposite, 0);
        switch (message.getMessageType()) {
            case 1: {
                iconLabel.setImage(DDEPlugin.getDefault().getImage("icons/error.gif"));
                break;
            }
            case 0: {
                iconLabel.setImage(DDEPlugin.getDefault().getImage("icons/warning_small.gif"));
            }
        }
        Link link = new Link(contentComposite, 0);
        link.setText("<a>" + controlLabel + "</a>:");
        GridData gridData = new GridData();
        gridData.horizontalIndent = 1;
        if (message.getMessage().equals("") && customizedMessages != null) {
            for (int i = 0; i < customizedMessages.length; ++i) {
                Label label = new Label(contentComposite, 0);
                gridData = new GridData();
                gridData.horizontalIndent = 1;
                label.setLayoutData((Object)gridData);
                Text text = new Text(contentComposite, 8);
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                text.setLayoutData((Object)gridData);
                text.setText(customizedMessages[i].getMessage());
            }
        }
    }

    private TreeNodeElement[] obtainSortedTreeNodeElements(boolean withErrors, boolean withWarnings) {
        Element[] elements = this.ddeViewer.getValidationManager().getMessageManager().getTreeNodeElements(true, withErrors, withWarnings);
        TreeNodeElement[] treeNodeElements = new TreeNodeElement[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            treeNodeElements[i] = new TreeNodeElement(elements[i]);
        }
        Arrays.sort(treeNodeElements, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                TreeNodeElement treeNodeElement0 = (TreeNodeElement)arg0;
                TreeNodeElement treeNodeElement1 = (TreeNodeElement)arg1;
                return treeNodeElement0.treeNodeLabel.compareTo(treeNodeElement1.treeNodeLabel);
            }
        });
        return treeNodeElements;
    }

    private String getControlLabel(DetailItem detailItem) {
        AtomicElementDetailItem atomicElementDetailItem;
        String controlLabel = null;
        DetailItemCustomization detailItemCustomization = detailItem.getDetailItemCustomization();
        if (detailItemCustomization != null) {
            controlLabel = detailItemCustomization.getLabel();
        }
        if (controlLabel == null) {
            controlLabel = detailItem.getName();
        }
        if (detailItem instanceof AtomicElementDetailItem && ModelUtil.isCMNodeRepeatable((atomicElementDetailItem = (AtomicElementDetailItem)detailItem).getCMNode()) && (detailItemCustomization == null || detailItemCustomization != null && !detailItemCustomization.isSingleOccurrence() && detailItemCustomization.getStyle() == 0) && !this.ddeViewer.getCustomization().getHideRepeatableItemNumbers()) {
            MessageFormat messageFormat = new MessageFormat(Messages.ITEM);
            String item = messageFormat.format(new Integer[]{new Integer(ModelUtil.getRepeatableElementIndex((Element)atomicElementDetailItem.getNode()) + 1)});
            controlLabel = controlLabel + " (" + item + ")";
        }
        return controlLabel;
    }

    private class TreeNodeElement {
        String treeNodeLabel;
        Image treeNodeImage;
        Element element;

        public TreeNodeElement(Element element) {
            this.element = element;
            this.treeNodeLabel = ErrorMessageSummaryPopupDialog.this.ddeViewer.getTreeLabelProvider().getText(element);
            this.treeNodeImage = ErrorMessageSummaryPopupDialog.this.ddeViewer.getTreeLabelProvider().getImage(element);
        }
    }
}

