/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.viewers;

import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.validation.ValidationManager;
import com.ibm.xwt.dde.internal.viewers.DDEViewer;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.CMDocumentLoader;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.DOMObserverAdapter;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DDEViewerDelegate
implements IDesignViewer {
    private final int grammarReloadAttempts = 25;
    private final int grammarReloadMillisecondsDelay = 250;
    private DDEViewer ddeViewer;
    private IDocument document;
    private Document domDocument;
    private boolean designViewActive;
    boolean listen;
    INodeNotifier cachedNotifier;
    private IModelStateListener modelStateListener;
    IDocumentListener documentListener;

    public DDEViewerDelegate(Composite parent, CustomizationManager.Customization customization, IEditorPart editorPart) {
        this.ddeViewer = new DDEViewer(parent, customization, editorPart);
        this.ddeViewer.createContents(parent);
        this.listen = true;
    }

    public Control getControl() {
        return this.ddeViewer.getControl();
    }

    public String getTitle() {
        return Messages.LABEL_DESIGN;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.ddeViewer.setSelection(selection, reveal);
    }

    public Document getDocument() {
        return this.domDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocument(IDocument document) {
        this.document = document;
        if (document != null) {
            this.documentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent arg0) {
                }

                public void documentChanged(DocumentEvent arg0) {
                    if (DDEViewerDelegate.this.listen) {
                        DDEViewerDelegate.this.updateFromListener();
                    }
                }
            };
            document.addDocumentListener(this.documentListener);
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            try {
                if (model != null && model instanceof IDOMModel) {
                    this.domDocument = ((IDOMModel)model).getDocument();
                    this.asyncFirstModelLoad(this.domDocument);
                    if (!ModelUtil.isModelPresent(this.domDocument)) {
                        this.ddeViewer.showMissingGrammarMessage();
                    } else {
                        this.ddeViewer.hideMissingGrammarMessage();
                    }
                    this.ddeViewer.setInput(this.domDocument);
                    IStructuredTextUndoManager undoManager = model.getUndoManager();
                    this.ddeViewer.setUndoManager(undoManager);
                    this.modelStateListener = new IModelStateListener(){

                        public void modelAboutToBeChanged(IStructuredModel model) {
                            DDEViewerDelegate.this.listen = false;
                            DDEViewerDelegate.this.cachedNotifier = null;
                        }

                        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
                        }

                        public void modelChanged(IStructuredModel model) {
                            DDEViewerDelegate.this.listen = true;
                            DDEViewerDelegate.this.updateFromListener();
                        }

                        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
                        }

                        public void modelReinitialized(IStructuredModel structuredModel) {
                        }

                        public void modelResourceDeleted(IStructuredModel model) {
                        }

                        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
                        }
                    };
                    model.addModelStateListener(this.modelStateListener);
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
    }

    private void asyncFirstModelLoad(Document domDocument) {
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)domDocument);
        if (modelQuery != null && modelQuery.getCMDocumentManager() != null) {
            Element documentElement;
            CMDocumentManager manager = modelQuery.getCMDocumentManager();
            manager.setPropertyEnabled("asyncLoad", false);
            DOMObserverAdapter domObserverAdapter = null;
            INodeAdapter o = ((INodeNotifier)domDocument).getExistingAdapter(DOMObserverAdapter.class);
            boolean domObserverDisabled = true;
            if (o instanceof DOMObserverAdapter) {
                domObserverAdapter = (DOMObserverAdapter)o;
                domObserverDisabled = domObserverAdapter.disableObserver(true, true);
            }
            CMDocumentLoader loader = new CMDocumentLoader(domDocument, manager);
            if (domObserverDisabled) {
                loader.loadCMDocuments();
            }
            if (!ModelUtil.isModelPresent(domDocument) && (documentElement = domDocument.getDocumentElement()) != null) {
                int attempts;
                String namespace = documentElement.getNamespaceURI();
                if (namespace == null) {
                    namespace = "";
                }
                for (attempts = 0; !domObserverDisabled && domObserverAdapter.isObserverLoading() && attempts < 25; ++attempts) {
                    try {
                        Thread.sleep(250L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                int status = manager.getCMDocumentStatus(namespace);
                for (attempts = 0; status != 3 && status != 4 && attempts < 25 && !ModelUtil.isModelPresent(domDocument); ++attempts) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    status = manager.getCMDocumentStatus(namespace);
                    if (status != 0) continue;
                    loader.loadCMDocuments();
                }
            }
        }
    }

    private void asyncModelLoad(Document domDocument) {
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)domDocument);
        if (modelQuery != null && modelQuery.getCMDocumentManager() != null) {
            Element documentElement;
            CMDocumentManager manager = modelQuery.getCMDocumentManager();
            manager.setPropertyEnabled("asyncLoad", false);
            CMDocumentLoader loader = new CMDocumentLoader(domDocument, manager);
            loader.loadCMDocuments();
            if (!ModelUtil.isModelPresent(domDocument) && (documentElement = domDocument.getDocumentElement()) != null) {
                String namespace = documentElement.getNamespaceURI();
                if (namespace == null) {
                    namespace = "";
                }
                int status = manager.getCMDocumentStatus(namespace);
                for (int attempts = 0; status == 2 && attempts < 25; ++attempts) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    status = manager.getCMDocumentStatus(namespace);
                    if (status != 0) continue;
                    loader.loadCMDocuments();
                }
            }
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.ddeViewer;
    }

    public void activateDesignView() {
        this.designViewActive = true;
        this.ddeViewer.activate();
    }

    public void deActivateDesignView() {
        this.designViewActive = false;
        this.ddeViewer.deActivate();
    }

    public boolean isDesignViewActive() {
        return this.designViewActive;
    }

    public void refresh(boolean forceFrefresh) {
        this.ddeViewer.refresh(forceFrefresh);
    }

    private void updateFromListener() {
        if (!this.ddeViewer.getControl().isDisposed()) {
            this.ddeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!DDEViewerDelegate.this.ddeViewer.getControl().isDisposed()) {
                        if (!DDEViewerDelegate.this.designViewActive && !DDEViewerDelegate.this.ddeViewer.isValidationDirty()) {
                            DDEViewerDelegate.this.ddeViewer.setValidationDirty();
                        }
                        DDEViewerDelegate.this.asyncModelLoad(DDEViewerDelegate.this.domDocument);
                        if (!ModelUtil.isModelPresent(DDEViewerDelegate.this.domDocument)) {
                            DDEViewerDelegate.this.ddeViewer.showMissingGrammarMessage();
                        } else {
                            DDEViewerDelegate.this.ddeViewer.hideMissingGrammarMessage();
                        }
                        DDEViewerDelegate.this.ddeViewer.refresh();
                    }
                }
            });
        }
    }

    public void updateErrorsFromAnnotationModel(IAnnotationModel model) {
        if (!this.ddeViewer.getControl().isDisposed()) {
            this.ddeViewer.updateErrorsFromAnnotationModel(model);
        }
    }

    public ValidationManager getValidationManager() {
        return this.ddeViewer.getValidationManager();
    }

    public void dispose() {
        IDOMModel model;
        if (this.domDocument instanceof IDOMDocument && (model = ((IDOMDocument)this.domDocument).getModel()) != null) {
            model.removeModelStateListener(this.modelStateListener);
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentListener);
        }
        this.ddeViewer.dispose();
        this.document = null;
        this.domDocument = null;
    }

    public Composite getFormHeadComposite() {
        return this.ddeViewer.getFormHead();
    }
}

