/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.validation;

import com.ibm.xwt.dde.internal.messages.Messages;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class DataTypeValidator {
    private final int QName = 0;
    private final int string = 1;
    private final int decimal = 2;
    private final int date = 3;
    private final int dateTime = 4;
    private final int duration = 5;
    private final int gDay = 6;
    private final int gMonth = 7;
    private final int gMonthDay = 8;
    private final int gYear = 9;
    private final int gYearMonth = 10;
    private final int time = 11;
    private final int anyURI = 12;
    private final int base64Binary = 13;
    private final int _boolean = 14;
    private final int _double = 15;
    private final int _float = 16;
    private final int hexBinary = 17;
    private final int NOTATION = 18;
    private final int length = 0;
    private final int minLength = 1;
    private final int maxLength = 2;
    private final int pattern = 3;
    private final int enumeration = 4;
    private final int whiteSpace = 5;
    private final int maxInclusive = 6;
    private final int maxExclusive = 7;
    private final int minInclusive = 8;
    private final int minExclusive = 9;
    private final int fractionDigits = 10;
    private HashMap dataTypesMap = new HashMap();
    private HashMap facetsMap;
    static final DatatypeFactory datatypeFactory;

    public DataTypeValidator() {
        this.dataTypesMap.put("QName", new Integer(0));
        this.dataTypesMap.put("string", new Integer(1));
        this.dataTypesMap.put("decimal", new Integer(2));
        this.dataTypesMap.put("date", new Integer(3));
        this.dataTypesMap.put("dateTime", new Integer(4));
        this.dataTypesMap.put("duration", new Integer(5));
        this.dataTypesMap.put("gDay", new Integer(6));
        this.dataTypesMap.put("gMonth", new Integer(7));
        this.dataTypesMap.put("gMonthDay", new Integer(8));
        this.dataTypesMap.put("gYear", new Integer(9));
        this.dataTypesMap.put("gYearMonth", new Integer(10));
        this.dataTypesMap.put("time", new Integer(11));
        this.dataTypesMap.put("anyURI", new Integer(12));
        this.dataTypesMap.put("base64Binary", new Integer(13));
        this.dataTypesMap.put("boolean", new Integer(14));
        this.dataTypesMap.put("double", new Integer(15));
        this.dataTypesMap.put("float", new Integer(16));
        this.dataTypesMap.put("hexBinary", new Integer(17));
        this.dataTypesMap.put("NOTATION", new Integer(18));
        this.facetsMap = new HashMap();
        this.facetsMap.put("length", new Integer(0));
        this.facetsMap.put("minLength", new Integer(1));
        this.facetsMap.put("maxLength", new Integer(2));
        this.facetsMap.put("pattern", new Integer(3));
        this.facetsMap.put("enumeration", new Integer(4));
        this.facetsMap.put("whiteSpace", new Integer(5));
        this.facetsMap.put("maxInclusive", new Integer(6));
        this.facetsMap.put("maxExclusive", new Integer(7));
        this.facetsMap.put("minInclusive", new Integer(8));
        this.facetsMap.put("minExclusive", new Integer(9));
        this.facetsMap.put("fractionDigits", new Integer(10));
    }

    public String validateXSDTypeDefinition(XSDTypeDefinition xsdTypeDefinition, String value) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdTypeDefinition.getSimpleType();
        if (xsdSimpleTypeDefinition != null) {
            switch (xsdSimpleTypeDefinition.getVariety().getValue()) {
                case 0: {
                    return this.validateAtomicSimpleTypeValue(xsdSimpleTypeDefinition, value);
                }
                case 1: {
                    return this.validateListTypeValue(xsdSimpleTypeDefinition, value);
                }
                case 2: {
                    return this.validateUnionTypeValue(xsdSimpleTypeDefinition, value);
                }
            }
        }
        return null;
    }

    private String validateAtomicSimpleTypeValue(XSDSimpleTypeDefinition xsdSimpleTypeDefinition, String value) {
        String validationMessage = null;
        XSDSimpleTypeDefinition rootXSDSimpleTypeDefinition = xsdSimpleTypeDefinition.getRootType().getSimpleType();
        validationMessage = this.validatePrimitiveTypeValue(rootXSDSimpleTypeDefinition, value);
        if (validationMessage != null) {
            return validationMessage;
        }
        for (XSDFacet xsdFacet : xsdSimpleTypeDefinition.getFacets()) {
            Integer mapValue = (Integer)this.facetsMap.get(xsdFacet.getFacetName());
            if (mapValue == null) continue;
            switch (mapValue) {
                case 0: {
                    XSDLengthFacet xsdLengthFacet = (XSDLengthFacet)xsdFacet;
                    validationMessage = this.validateLengthFacet(xsdLengthFacet.getValue(), value);
                    break;
                }
                case 1: {
                    XSDMinLengthFacet xsdMinLengthFacet = (XSDMinLengthFacet)xsdFacet;
                    validationMessage = this.validateMinLengthFacet(xsdMinLengthFacet, value);
                    break;
                }
                case 2: {
                    XSDMaxLengthFacet xsdMaxLengthFacet = (XSDMaxLengthFacet)xsdFacet;
                    validationMessage = this.validateMaxLengthFacet(xsdMaxLengthFacet, value);
                    break;
                }
                case 3: {
                    XSDPatternFacet xsdPatternFacet = (XSDPatternFacet)xsdFacet;
                    validationMessage = this.validatePatternFacet(xsdPatternFacet, value);
                    break;
                }
                case 4: {
                    XSDEnumerationFacet xsdEnumerationFacet = (XSDEnumerationFacet)xsdFacet;
                    validationMessage = this.validateEnumerationFacet(xsdEnumerationFacet, xsdSimpleTypeDefinition, value);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    XSDMaxInclusiveFacet xsdMaxInclusiveFacet = (XSDMaxInclusiveFacet)xsdFacet;
                    validationMessage = this.validateBoundFacet(true, true, xsdMaxInclusiveFacet.getValue(), xsdSimpleTypeDefinition, value);
                    break;
                }
                case 7: {
                    XSDMaxExclusiveFacet xsdMaxExclusiveFacet = (XSDMaxExclusiveFacet)xsdFacet;
                    validationMessage = this.validateBoundFacet(true, false, xsdMaxExclusiveFacet.getValue(), xsdSimpleTypeDefinition, value);
                    break;
                }
                case 8: {
                    XSDMinInclusiveFacet xsdMinInclusiveFacet = (XSDMinInclusiveFacet)xsdFacet;
                    validationMessage = this.validateBoundFacet(false, true, xsdMinInclusiveFacet.getValue(), xsdSimpleTypeDefinition, value);
                    break;
                }
                case 9: {
                    XSDMinExclusiveFacet xsdMinExclusiveFacet = (XSDMinExclusiveFacet)xsdFacet;
                    validationMessage = this.validateBoundFacet(false, false, xsdMinExclusiveFacet.getValue(), xsdSimpleTypeDefinition, value);
                    break;
                }
                case 10: {
                    XSDFractionDigitsFacet xsdFractionDigitsFacet = (XSDFractionDigitsFacet)xsdFacet;
                    validationMessage = this.validateFractionDigitsFacet(xsdFractionDigitsFacet, value);
                }
            }
            if (validationMessage == null) continue;
            return validationMessage;
        }
        return null;
    }

    private String validateLengthFacet(int facetValue, String value) {
        if (value.length() != facetValue) {
            if (facetValue == 1) {
                return Messages.THE_VALUE_MUST_BE_1_CHARACTER_LONG;
            }
            MessageFormat messageFormat = new MessageFormat(Messages.THE_VALUE_MUST_BE_X_CHARACTERS_LONG);
            return messageFormat.format(new String[]{"" + facetValue});
        }
        return null;
    }

    private String validateMaxLengthFacet(XSDMaxLengthFacet xsdMaxLengthFacet, String value) {
        int facetValue = xsdMaxLengthFacet.getValue();
        if (value.length() > facetValue) {
            if (facetValue == 1) {
                return Messages.THE_VALUE_CANNOT_BE_MORE_THAN_1_CHARACTER_LONG;
            }
            MessageFormat messageFormat = new MessageFormat(Messages.THE_VALUE_CANNOT_BE_MORE_THAN_X_CHARACTERS_LONG);
            return messageFormat.format(new String[]{"" + facetValue});
        }
        return null;
    }

    private String validateMinLengthFacet(XSDMinLengthFacet xsdMinLengthFacet, String value) {
        int facetValue = xsdMinLengthFacet.getValue();
        if (value.length() < facetValue) {
            if (facetValue == 1) {
                return Messages.THE_VALUE_MUST_BE_AT_LEAST_1_CHARACTER_LONG;
            }
            MessageFormat messageFormat = new MessageFormat(Messages.THE_VALUE_MUST_BE_AT_LEAST_X_CHARACTERS_LONG);
            return messageFormat.format(new String[]{"" + facetValue});
        }
        return null;
    }

    private String validatePatternFacet(XSDPatternFacet xsdPatternFacet, String value) {
        for (String pattern : xsdPatternFacet.getValue()) {
            RegularExpression regularExpression = new RegularExpression(pattern, "X");
            if (regularExpression.matches(value)) continue;
            MessageFormat messageFormat = new MessageFormat(Messages.THE_VALUE_MUST_CONFORM_TO_THE_XML_SCHEMA_PATTERN_X);
            return messageFormat.format(new String[]{pattern});
        }
        return null;
    }

    private String validateEnumerationFacet(XSDEnumerationFacet xsdEnumerationFacet, XSDSimpleTypeDefinition xsdSimpleTypeDefinition, String value) {
        for (Object facetObject : xsdEnumerationFacet.getValue()) {
            if (!this.valueMatches(xsdSimpleTypeDefinition, facetObject, value)) continue;
            return null;
        }
        if (xsdEnumerationFacet.getValue().size() == 1) {
            MessageFormat messageFormat = new MessageFormat(Messages.THE_VALUE_MUST_BE_X);
            return messageFormat.format(new String[]{xsdEnumerationFacet.getValue().get(0).toString()});
        }
        return Messages.THE_VALUE_IS_NOT_AMONG_THE_POSSIBLE_OPTIONS;
    }

    private boolean valueMatches(XSDSimpleTypeDefinition xsdSimpleTypeDefinition, Object facetObject, String value) {
        Object valueObject = null;
        try {
            if (facetObject instanceof String) {
                valueObject = value;
            } else if (facetObject instanceof Boolean) {
                valueObject = new Boolean(value);
            } else if (facetObject instanceof Float) {
                valueObject = new Float(value);
            } else if (facetObject instanceof Double) {
                valueObject = new Double(value);
            } else if (facetObject instanceof BigDecimal) {
                valueObject = new BigDecimal(value);
            } else if (facetObject instanceof Duration) {
                try {
                    valueObject = datatypeFactory.newDuration(value);
                }
                catch (Exception exception) {}
            } else if (facetObject instanceof XMLGregorianCalendar) {
                try {
                    valueObject = datatypeFactory.newXMLGregorianCalendar(value);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return facetObject.equals(valueObject);
    }

    private String validateBoundFacet(boolean maxTrueMinFalse, boolean inclusiveTrueExclusiveFalse, Object facetValue, XSDSimpleTypeDefinition xsdSimpleTypeDefinition, String value) {
        int comparisonCoefficient;
        String boundValue = null;
        int n = comparisonCoefficient = maxTrueMinFalse ? 1 : -1;
        if (facetValue instanceof Float) {
            Float facetFloat = (Float)facetValue;
            int comparison = facetFloat.compareTo(new Float(value));
            if (comparison * comparisonCoefficient < 0 || !inclusiveTrueExclusiveFalse && comparison == 0) {
                boundValue = facetFloat.toString();
            }
        } else if (facetValue instanceof Double) {
            Double facetDouble = (Double)facetValue;
            int comparison = facetDouble.compareTo(new Double(value));
            if (comparison * comparisonCoefficient < 0 || !inclusiveTrueExclusiveFalse && comparison == 0) {
                boundValue = facetDouble.toString();
            }
        } else if (facetValue instanceof BigDecimal) {
            BigDecimal facetBigDecimal = (BigDecimal)facetValue;
            int comparison = facetBigDecimal.compareTo(new BigDecimal(value));
            if (comparison * comparisonCoefficient < 0 || !inclusiveTrueExclusiveFalse && comparison == 0) {
                boundValue = facetBigDecimal.toString();
            }
        } else if (facetValue instanceof Duration) {
            try {
                Duration facetXMLDuration = (Duration)facetValue;
                int comparison = facetXMLDuration.compare(datatypeFactory.newDuration(value));
                if (comparison * comparisonCoefficient < 0 || !inclusiveTrueExclusiveFalse && comparison == 0) {
                    boundValue = facetXMLDuration.toString();
                }
            }
            catch (Exception facetXMLDuration) {}
        } else if (facetValue instanceof XMLGregorianCalendar) {
            try {
                XMLGregorianCalendar facetXMLCalendar = (XMLGregorianCalendar)facetValue;
                int comparison = facetXMLCalendar.compare(datatypeFactory.newXMLGregorianCalendar(value));
                if (comparison * comparisonCoefficient < 0 || !inclusiveTrueExclusiveFalse && comparison == 0) {
                    boundValue = facetXMLCalendar.toString();
                }
            }
            catch (Exception facetXMLCalendar) {
                // empty catch block
            }
        }
        if (boundValue != null) {
            MessageFormat messageFormat;
            if (maxTrueMinFalse) {
                if (inclusiveTrueExclusiveFalse) {
                    messageFormat = new MessageFormat(Messages.THE_VALUE_CANNOT_BE_GREATER_THAN_X);
                    return messageFormat.format(new String[]{boundValue});
                }
                messageFormat = new MessageFormat(Messages.THE_VALUE_MUST_BE_SMALLER_THAN_X);
                return messageFormat.format(new String[]{boundValue});
            }
            if (inclusiveTrueExclusiveFalse) {
                messageFormat = new MessageFormat(Messages.THE_VALUE_CANNOT_BE_SMALLER_THAN_X);
                return messageFormat.format(new String[]{boundValue});
            }
            messageFormat = new MessageFormat(Messages.THE_VALUE_MUST_BE_GREATER_THAN_X);
            return messageFormat.format(new String[]{boundValue});
        }
        return null;
    }

    private String validateFractionDigitsFacet(XSDFractionDigitsFacet xsdFractionDigitsFacet, String value) {
        int valueFractionDigits;
        int facetFractionDigits = xsdFractionDigitsFacet.getValue();
        int decimalSeparator = value.indexOf(46);
        if (decimalSeparator != -1 && (valueFractionDigits = value.substring(decimalSeparator + 1).length()) > facetFractionDigits) {
            if (facetFractionDigits == 0) {
                return Messages.THE_VALUE_CANNOT_CONTAIN_FRACTIONAL_DIGITS;
            }
            if (facetFractionDigits == 1) {
                return Messages.THE_VALUE_CANNOT_CONTAIN_MORE_THAN_1_FRACTIONAL_DIGIT;
            }
            MessageFormat messageFormat = new MessageFormat(Messages.THE_VALUE_CANNOT_CONTAIN_MORE_THAN_X_FRACTIONAL_DIGIT);
            return messageFormat.format(new String[]{"" + facetFractionDigits});
        }
        return null;
    }

    private String validatePrimitiveTypeValue(XSDSimpleTypeDefinition xsdSimpleTypeDefinition, String value) {
        Integer mapValue = (Integer)this.dataTypesMap.get(xsdSimpleTypeDefinition.getName());
        if (mapValue != null) {
            switch (mapValue) {
                case 0: {
                    return null;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.validateDecimal(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_decimal;
                }
                case 3: {
                    return this.validateDate(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_date;
                }
                case 4: {
                    return this.validateDateTime(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_dateTime;
                }
                case 5: {
                    return this.validateDuration(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_duration;
                }
                case 6: {
                    return this.validateGDay(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_gDay;
                }
                case 7: {
                    return this.validateGMonth(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_gMonth;
                }
                case 8: {
                    return this.validateGMonthDay(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_gMonthDay;
                }
                case 9: {
                    return this.validateGYear(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_gYear;
                }
                case 10: {
                    return this.validateGYearMonth(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_gYearMonth;
                }
                case 11: {
                    return this.validateTime(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_time;
                }
                case 12: {
                    return null;
                }
                case 13: {
                    return null;
                }
                case 14: {
                    return this.validateBoolean(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_boolean;
                }
                case 15: {
                    return this.validateDouble(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_double;
                }
                case 16: {
                    return this.validateFloat(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_float;
                }
                case 17: {
                    return this.validateHexBinary(value) ? null : Messages.DATA_TYPE_VALIDATION_INVALID_hexBinary;
                }
                case 18: {
                    return null;
                }
            }
        }
        return null;
    }

    private String validateListTypeValue(XSDSimpleTypeDefinition xsdSimpleTypeDefinition, String value) {
        StringTokenizer stringTokenizer = new StringTokenizer(value, " ");
        String[] listValues = new String[stringTokenizer.countTokens()];
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            String validationMessage = this.validateAtomicSimpleTypeValue(xsdSimpleTypeDefinition.getItemTypeDefinition(), token);
            if (validationMessage != null) {
                MessageFormat messageFormat = new MessageFormat(Messages.LIST_ITEM_X);
                return messageFormat.format(new String[]{"" + (i + 1)}) + " " + validationMessage;
            }
            listValues[i++] = token;
        }
        for (XSDFacet xsdFacet : xsdSimpleTypeDefinition.getFacets()) {
            Integer mapValue = (Integer)this.facetsMap.get(xsdFacet.getFacetName());
            if (mapValue == null) continue;
            switch (mapValue) {
                case 0: {
                    XSDLengthFacet xsdLengthFacet = (XSDLengthFacet)xsdFacet;
                    int facetLengthValue = xsdLengthFacet.getValue();
                    if (facetLengthValue == i) break;
                    if (facetLengthValue == 1) {
                        return Messages.THE_LIST_MUST_CONTAIN_1_ITEM;
                    }
                    MessageFormat messageFormat = new MessageFormat(Messages.THE_LIST_MUST_CONTAIN_X_ITEMS);
                    return messageFormat.format(new String[]{"" + facetLengthValue});
                }
                case 1: {
                    XSDMinLengthFacet xsdMinLengthFacet = (XSDMinLengthFacet)xsdFacet;
                    int facetMinLengthValue = xsdMinLengthFacet.getValue();
                    if (facetMinLengthValue <= i) break;
                    if (facetMinLengthValue == 1) {
                        return Messages.THE_LIST_MUST_CONTAIN_AT_LEAST_1_ITEM;
                    }
                    MessageFormat messageFormat = new MessageFormat(Messages.THE_LIST_MUST_CONTAIN_AT_LEAST_X_ITEMS);
                    return messageFormat.format(new String[]{"" + facetMinLengthValue});
                }
                case 2: {
                    XSDMaxLengthFacet xsdMaxLengthFacet = (XSDMaxLengthFacet)xsdFacet;
                    int facetMaxLengthValue = xsdMaxLengthFacet.getValue();
                    if (facetMaxLengthValue >= i) break;
                    if (facetMaxLengthValue == 1) {
                        return Messages.THE_LIST_MUST_CONTAIN_AT_MOST_1_ITEM;
                    }
                    MessageFormat messageFormat = new MessageFormat(Messages.THE_LIST_MUST_CONTAIN_AT_MOST_X_ITEMS);
                    return messageFormat.format(new String[]{"" + facetMaxLengthValue});
                }
                case 4: {
                    XSDEnumerationFacet xsdEnumerationFacet = (XSDEnumerationFacet)xsdFacet;
                    String validationMessage = this.validateListEnumerationFacet(xsdEnumerationFacet, value);
                    if (validationMessage == null) break;
                    return validationMessage;
                }
                case 3: {
                    XSDPatternFacet xsdPatternFacet = (XSDPatternFacet)xsdFacet;
                    String validationMessage = this.validatePatternFacet(xsdPatternFacet, value);
                    if (validationMessage == null) break;
                    return validationMessage;
                }
            }
        }
        return null;
    }

    private String validateListEnumerationFacet(XSDEnumerationFacet xsdEnumerationFacet, String value) {
        StringTokenizer stringTokenizer = new StringTokenizer(value, " ");
        String[] listValues = new String[stringTokenizer.countTokens()];
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            listValues[i++] = stringTokenizer.nextToken();
        }
        for (List facetEnumerationValueList : xsdEnumerationFacet.getValue()) {
            if (facetEnumerationValueList.size() != listValues.length) continue;
            Iterator facetEnumerationValueListIterator = facetEnumerationValueList.iterator();
            i = 0;
            while (facetEnumerationValueListIterator.hasNext()) {
                Object facetObject = facetEnumerationValueListIterator.next();
                if (!this.valueMatches(xsdEnumerationFacet.getSimpleTypeDefinition().getItemTypeDefinition(), facetObject, listValues[i])) break;
                ++i;
            }
            if (facetEnumerationValueList.size() != i) continue;
            return null;
        }
        return Messages.THE_VALUE_IS_NOT_AMONG_THE_POSSIBLE_LISTS;
    }

    private String validateUnionTypeValue(XSDSimpleTypeDefinition xsdSimpleTypeDefinition, String value) {
        EList memberTypeDefinitions = xsdSimpleTypeDefinition.getMemberTypeDefinitions();
        Iterator memberTypeDefinitionsIterator = memberTypeDefinitions.iterator();
        boolean validTypeFound = false;
        String msg = null;
        StringBuffer sb = new StringBuffer(Messages.DATA_TYPE_VALIDATION_INVALID_UNION);
        int i = 0;
        while (!validTypeFound && memberTypeDefinitionsIterator.hasNext()) {
            XSDTypeDefinition memberTypeDefinition = (XSDTypeDefinition)memberTypeDefinitionsIterator.next();
            msg = this.validateXSDTypeDefinition(memberTypeDefinition, value);
            if (msg != null) {
                sb.append("\n");
                sb.append(Messages.bind((String)Messages.VALIDATION_MESSAGE, (Object)(++i), (Object)msg));
            }
            if (msg != null) continue;
            validTypeFound = true;
        }
        if (!validTypeFound) {
            return sb.toString();
        }
        for (XSDFacet xsdFacet : xsdSimpleTypeDefinition.getFacets()) {
            Integer mapValue = (Integer)this.facetsMap.get(xsdFacet.getFacetName());
            if (mapValue == null) continue;
            switch (mapValue) {
                case 4: {
                    XSDEnumerationFacet xsdEnumerationFacet = (XSDEnumerationFacet)xsdFacet;
                    String validationMessage = this.validateEnumerationFacet(xsdEnumerationFacet, xsdSimpleTypeDefinition, value);
                    if (validationMessage == null) break;
                    return validationMessage;
                }
                case 3: {
                    XSDPatternFacet xsdPatternFacet = (XSDPatternFacet)xsdFacet;
                    String validationMessage = this.validatePatternFacet(xsdPatternFacet, value);
                    if (validationMessage == null) break;
                    return validationMessage;
                }
            }
        }
        return null;
    }

    private boolean validateDecimal(String value) {
        if (value.length() > 0) {
            if (value.charAt(0) == '+' || value.charAt(0) == '-') {
                if (value.length() == 1) {
                    return false;
                }
                value = value.substring(1);
            }
            boolean dotPresent = false;
            while (value.length() > 0) {
                char currentChar = value.charAt(0);
                if (currentChar == '.') {
                    if (dotPresent) {
                        return false;
                    }
                    dotPresent = true;
                } else if (!Character.isDigit(currentChar)) {
                    return false;
                }
                value = value.substring(1);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean validateDate(String value) {
        block16: {
            if (value.length() > 0) {
                if (value.charAt(0) == '-') {
                    value = value.substring(1);
                }
                if (value.length() < 10) {
                    return false;
                }
                if (value.charAt(4) != '-' || value.charAt(7) != '-') {
                    return false;
                }
                try {
                    int year = Integer.parseInt(value.substring(0, 4));
                    int month = Integer.parseInt(value.substring(5, 7));
                    int day = Integer.parseInt(value.substring(8, 10));
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setLenient(false);
                    gregorianCalendar.set(1, year);
                    gregorianCalendar.set(2, month - 1);
                    gregorianCalendar.set(5, day);
                    gregorianCalendar.getTime();
                }
                catch (Exception exception) {
                    return false;
                }
                if (value.length() == 11) {
                    if (value.charAt(10) != 'Z') {
                        return false;
                    }
                } else {
                    if (value.length() == 16) {
                        if (value.charAt(10) != '+' && value.charAt(10) != '-' || value.charAt(13) != ':') {
                            return false;
                        }
                        try {
                            int hours = Integer.parseInt(value.substring(11, 13));
                            int minutes = Integer.parseInt(value.substring(14, 16));
                            if (hours > 13 || minutes > 59 || hours < 0 || minutes < 0) {
                                return false;
                            }
                            break block16;
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    if (value.length() != 10) {
                        return false;
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean validateDateTime(String value) {
        block21: {
            if (value.length() > 0) {
                if (value.charAt(0) == '-') {
                    value = value.substring(1);
                }
                if (value.length() < 19) {
                    return false;
                }
                if (value.charAt(4) != '-' || value.charAt(7) != '-' || value.charAt(10) != 'T' || value.charAt(13) != ':' || value.charAt(16) != ':') {
                    return false;
                }
                try {
                    int year = Integer.parseInt(value.substring(0, 4));
                    int month = Integer.parseInt(value.substring(5, 7));
                    int day = Integer.parseInt(value.substring(8, 10));
                    int hours = Integer.parseInt(value.substring(11, 13));
                    int minutes = Integer.parseInt(value.substring(14, 16));
                    int seconds = Integer.parseInt(value.substring(17, 19));
                    if (hours > 24 || minutes > 59 || seconds > 59 || hours < 0 || minutes < 0 || seconds < 0) {
                        return false;
                    }
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setLenient(false);
                    gregorianCalendar.set(1, year);
                    gregorianCalendar.set(2, month - 1);
                    gregorianCalendar.set(5, day);
                    gregorianCalendar.getTime();
                }
                catch (Exception exception) {
                    return false;
                }
                if (value.length() > 19) {
                    if ((value = value.substring(19)).charAt(0) == '.') {
                        value = value.substring(1);
                        boolean secondFractionFound = false;
                        while (value.length() > 0 && Character.isDigit(value.charAt(0))) {
                            secondFractionFound = true;
                            value = value.substring(1);
                        }
                        if (!secondFractionFound) {
                            return false;
                        }
                    }
                    if (value.length() == 1) {
                        if (value.charAt(0) != 'Z') {
                            return false;
                        }
                    } else {
                        if (value.length() == 6) {
                            if (value.charAt(0) != '+' && value.charAt(0) != '-' || value.charAt(3) != ':') {
                                return false;
                            }
                            try {
                                int hours = Integer.parseInt(value.substring(1, 3));
                                int minutes = Integer.parseInt(value.substring(4, 6));
                                if (hours > 13 || minutes > 59 || hours < 0 || minutes < 0) {
                                    return false;
                                }
                                break block21;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        if (value.length() != 0) {
                            return false;
                        }
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean validateDuration(String value) {
        if (value.length() > 1) {
            if (value.charAt(0) != 'P') {
                return false;
            }
            int timeToken = value.indexOf(84);
            String date = null;
            String time = null;
            if (timeToken != -1) {
                date = value.substring(1, timeToken);
                time = value.substring(timeToken + 1, value.length());
            } else {
                date = value.substring(1);
            }
            boolean yearFound = false;
            boolean monthFound = false;
            boolean dayFound = false;
            boolean numberJustParsed = false;
            while (date.length() > 0) {
                char currentChar = date.charAt(0);
                if (Character.isDigit(currentChar)) {
                    numberJustParsed = true;
                } else {
                    if (!numberJustParsed) {
                        return false;
                    }
                    switch (currentChar) {
                        case 'Y': {
                            if (yearFound || monthFound || dayFound) {
                                return false;
                            }
                            yearFound = true;
                            break;
                        }
                        case 'M': {
                            if (monthFound || dayFound) {
                                return false;
                            }
                            monthFound = true;
                            break;
                        }
                        case 'D': {
                            if (dayFound) {
                                return false;
                            }
                            dayFound = true;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    numberJustParsed = false;
                }
                date = date.substring(1);
            }
            if (numberJustParsed) {
                return false;
            }
            if (time != null) {
                boolean hoursFound = false;
                boolean minutesFound = false;
                boolean secondFractionFound = false;
                boolean secondsFound = false;
                while (time.length() > 0) {
                    char currentChar = time.charAt(0);
                    if (Character.isDigit(currentChar)) {
                        numberJustParsed = true;
                    } else {
                        if (!numberJustParsed) {
                            return false;
                        }
                        switch (currentChar) {
                            case 'H': {
                                if (hoursFound || minutesFound || secondFractionFound || secondsFound) {
                                    return false;
                                }
                                hoursFound = true;
                            }
                            case 'M': {
                                if (minutesFound || secondFractionFound || secondsFound) {
                                    return false;
                                }
                                minutesFound = true;
                            }
                            case '.': {
                                if (secondFractionFound || secondsFound) {
                                    return false;
                                }
                                secondFractionFound = true;
                            }
                            case 'S': {
                                if (secondsFound) {
                                    return false;
                                }
                                secondsFound = true;
                            }
                        }
                        numberJustParsed = false;
                    }
                    time = time.substring(1);
                }
            }
            return !numberJustParsed;
        }
        return false;
    }

    private boolean validateGDay(String value) {
        block15: {
            block14: {
                if (value.length() > 4) {
                    if (value.charAt(0) != '-' || value.charAt(1) != '-' || value.charAt(2) != '-') {
                        return false;
                    }
                    try {
                        int day = Integer.parseInt(value.substring(3, 5));
                        if (day > 31 || day < 1) {
                            return false;
                        }
                        break block14;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return false;
            }
            if (value.length() == 6) {
                if (value.charAt(5) != 'Z') {
                    return false;
                }
            } else {
                if (value.length() == 11) {
                    if (value.charAt(5) != '+' && value.charAt(5) != '-' || value.charAt(8) != ':') {
                        return false;
                    }
                    try {
                        int hours = Integer.parseInt(value.substring(6, 8));
                        int minutes = Integer.parseInt(value.substring(9, 11));
                        if (hours > 13 || minutes > 59 || hours < 0 || minutes < 0) {
                            return false;
                        }
                        break block15;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                if (value.length() != 5) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateGMonth(String value) {
        block18: {
            block17: {
                if (value.length() > 3) {
                    if (value.charAt(0) != '-' || value.charAt(1) != '-') {
                        return false;
                    }
                    try {
                        int month = Integer.parseInt(value.substring(2, 4));
                        if (month > 12 || month < 1) {
                            return false;
                        }
                        break block17;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return false;
            }
            value = value.substring(4);
            if (value.length() > 1 && value.charAt(0) == '-') {
                if (value.charAt(1) == '-') {
                    value = value.substring(2);
                } else {
                    return false;
                }
            }
            if (value.length() == 1) {
                if (value.charAt(0) != 'Z') {
                    return false;
                }
            } else {
                if (value.length() == 6) {
                    if (value.charAt(0) != '+' && value.charAt(0) != '-' || value.charAt(3) != ':') {
                        return false;
                    }
                    try {
                        int hours = Integer.parseInt(value.substring(1, 3));
                        int minutes = Integer.parseInt(value.substring(4, 6));
                        if (hours > 13 || minutes > 59 || hours < 0 || minutes < 0) {
                            return false;
                        }
                        break block18;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                if (value.length() != 0) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateGMonthDay(String value) {
        block15: {
            block14: {
                if (value.length() > 5) {
                    if (value.charAt(0) != '-' || value.charAt(1) != '-' || value.charAt(4) != '-') {
                        return false;
                    }
                    try {
                        int month = Integer.parseInt(value.substring(2, 4));
                        int day = Integer.parseInt(value.substring(5, 7));
                        if (month > 12 || month < 1 || day > 31 || day < 1) {
                            return false;
                        }
                        break block14;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return false;
            }
            if (value.length() == 8) {
                if (value.charAt(7) != 'Z') {
                    return false;
                }
            } else {
                if (value.length() == 13) {
                    if (value.charAt(7) != '+' && value.charAt(7) != '-' || value.charAt(10) != ':') {
                        return false;
                    }
                    try {
                        int hours = Integer.parseInt(value.substring(8, 10));
                        int minutes = Integer.parseInt(value.substring(11, 13));
                        if (hours > 13 || minutes > 59 || hours < 0 || minutes < 0) {
                            return false;
                        }
                        break block15;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                if (value.length() != 7) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateGYear(String value) {
        block15: {
            block14: {
                if (value.length() > 3) {
                    if (value.charAt(0) == '-') {
                        value = value.substring(1);
                    }
                    try {
                        int year = Integer.parseInt(value.substring(0, 4));
                        if (year < 0) {
                            return false;
                        }
                        break block14;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return false;
            }
            if (value.length() == 5) {
                if (value.charAt(4) != 'Z') {
                    return false;
                }
            } else {
                if (value.length() == 10) {
                    if (value.charAt(4) != '+' && value.charAt(4) != '-' || value.charAt(7) != ':') {
                        return false;
                    }
                    try {
                        int hours = Integer.parseInt(value.substring(5, 7));
                        int minutes = Integer.parseInt(value.substring(8, 10));
                        if (hours > 13 || minutes > 59 || hours < 0 || minutes < 0) {
                            return false;
                        }
                        break block15;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                if (value.length() != 4) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateGYearMonth(String value) {
        block16: {
            block15: {
                if (value.length() > 6) {
                    if (value.charAt(0) == '-') {
                        value = value.substring(1);
                    }
                    if (value.charAt(4) != '-') {
                        return false;
                    }
                    try {
                        int year = Integer.parseInt(value.substring(0, 4));
                        int month = Integer.parseInt(value.substring(5, 7));
                        if (year < 0 || month > 12 || month < 1) {
                            return false;
                        }
                        break block15;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return false;
            }
            if (value.length() == 8) {
                if (value.charAt(7) != 'Z') {
                    return false;
                }
            } else {
                if (value.length() == 13) {
                    if (value.charAt(7) != '+' && value.charAt(7) != '-' || value.charAt(10) != ':') {
                        return false;
                    }
                    try {
                        int hours = Integer.parseInt(value.substring(8, 10));
                        int minutes = Integer.parseInt(value.substring(11, 13));
                        if (hours > 13 || minutes > 59 || hours < 0 || minutes < 0) {
                            return false;
                        }
                        break block16;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                if (value.length() != 7) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateTime(String value) {
        block20: {
            if (value.length() > 0) {
                int minutes;
                int hours;
                if (value.length() < 8) {
                    return false;
                }
                if (value.charAt(2) != ':' || value.charAt(5) != ':') {
                    return false;
                }
                try {
                    hours = Integer.parseInt(value.substring(0, 2));
                    minutes = Integer.parseInt(value.substring(3, 5));
                    int seconds = Integer.parseInt(value.substring(6, 8));
                    if (hours > 24 || minutes > 59 || seconds > 59 || hours < 0 || minutes < 0 || seconds < 0) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
                if (value.length() > 8) {
                    if ((value = value.substring(8)).charAt(0) == '.') {
                        value = value.substring(1);
                        boolean secondFractionFound = false;
                        while (value.length() > 0 && Character.isDigit(value.charAt(0))) {
                            secondFractionFound = true;
                            value = value.substring(1);
                        }
                        if (!secondFractionFound) {
                            return false;
                        }
                    }
                    if (value.length() == 1) {
                        if (value.charAt(0) != 'Z') {
                            return false;
                        }
                    } else {
                        if (value.length() == 6) {
                            if (value.charAt(0) != '+' && value.charAt(0) != '-' || value.charAt(3) != ':') {
                                return false;
                            }
                            try {
                                hours = Integer.parseInt(value.substring(1, 3));
                                minutes = Integer.parseInt(value.substring(4, 6));
                                if (hours > 13 || minutes > 59 || hours < 0 || minutes < 0) {
                                    return false;
                                }
                                break block20;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        if (value.length() != 0) {
                            return false;
                        }
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean validateDouble(String value) {
        if (value.length() > 0) {
            if (!("INF".equals(value) || "-INF".equals(value) || "NaN".equals(value))) {
                try {
                    Double.parseDouble(value);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean validateFloat(String value) {
        if (value.length() > 0) {
            if (!("INF".equals(value) || "-INF".equals(value) || "NaN".equals(value))) {
                try {
                    Float.parseFloat(value);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean validateHexBinary(String value) {
        if (value.length() % 2 == 0) {
            for (int i = 0; i < value.length(); ++i) {
                char currentChar = value.charAt(i);
                if (currentChar == 'a' || currentChar == 'b' || currentChar == 'c' || currentChar == 'd' || currentChar == 'e' || currentChar == 'f' || Character.isDigit(currentChar)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean validateBoolean(String value) {
        return "true".equals(value) || "1".equals(value) || "false".equals(value) || "0".equals(value);
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException exception) {
            throw new RuntimeException(exception);
        }
    }
}

