/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.util;

import com.ibm.xwt.dde.DDEPlugin;
import com.ibm.xwt.dde.customization.ICustomCanCreateObject;
import com.ibm.xwt.dde.customization.ICustomCanDeleteObject;
import com.ibm.xwt.dde.customization.ICustomDefaultValueObject;
import com.ibm.xwt.dde.customization.ICustomIconObject;
import com.ibm.xwt.dde.customization.ICustomLabelObject;
import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import com.ibm.xwt.dde.internal.actions.AddElementAction;
import com.ibm.xwt.dde.internal.actions.DeleteElementAction;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import com.ibm.xwt.dde.internal.data.AtomicAttributeDetailItem;
import com.ibm.xwt.dde.internal.data.AtomicDetailItem;
import com.ibm.xwt.dde.internal.data.DetailItem;
import com.ibm.xwt.dde.internal.data.RepeatableAtomicDetailItemSet;
import com.ibm.xwt.dde.internal.data.SimpleDetailItem;
import com.ibm.xwt.dde.internal.viewers.DDEViewer;
import com.ibm.xwt.dde.internal.viewers.DetailsContentProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ModelUtil {
    public static final int SEQUENCE = 1;
    public static final int ALL = 2;
    public static final int CHOICE = 4;
    public static final int OPTIONAL = 8;
    public static final int REPEATABLE = 16;
    static final String EXT_XSD = "http://www.ibm.com/xmlns/dde/schema/annotation/ext";
    static final String SCHEMA_XSD = "http://www.w3.org/2001/XMLSchema";

    public static boolean isAtomicCMElementDeclaration(CustomizationManager.Customization customization, Element parentElement, CMElementDeclaration cmElementDeclaration) {
        CMGroup cmGroup;
        CMNamedNodeMap cmNamedNodeMap = cmElementDeclaration.getAttributes();
        for (int i = 0; i < cmNamedNodeMap.getLength(); ++i) {
            CMAttributeDeclaration cmAttributeDelcaration = (CMAttributeDeclaration)cmNamedNodeMap.item(i);
            String attributeNamespace = ModelUtil.getNamespaceURI((CMNode)cmAttributeDelcaration);
            String path = ModelUtil.getNodeFullPath(parentElement, cmElementDeclaration, (CMNode)cmAttributeDelcaration);
            DetailItemCustomization detailItemCustomization = null;
            if (customization != null && (detailItemCustomization = customization.getItemCustomization(attributeNamespace, path)) == null) {
                detailItemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, path);
            }
            if (detailItemCustomization != null && (detailItemCustomization == null || detailItemCustomization.isHidden())) continue;
            return false;
        }
        CMContent cmContent = cmElementDeclaration.getContent();
        if (cmContent == null) {
            return true;
        }
        return cmContent.getNodeType() == 7 && (cmGroup = (CMGroup)cmContent).getChildNodes().getLength() == 0;
    }

    public static boolean isAtomicCMElementDeclaration(CustomizationManager.Customization customization, Element grandParentElement, CMElementDeclaration parentCMElementDeclaration, CMElementDeclaration cmElementDeclaration) {
        CMGroup cmGroup;
        CMNamedNodeMap cmNamedNodeMap = cmElementDeclaration.getAttributes();
        for (int i = 0; i < cmNamedNodeMap.getLength(); ++i) {
            CMAttributeDeclaration cmAttributeDelcaration = (CMAttributeDeclaration)cmNamedNodeMap.item(i);
            String attributeNamespace = ModelUtil.getNamespaceURI((CMNode)cmAttributeDelcaration);
            String path = ModelUtil.getNodeFullPath(grandParentElement, parentCMElementDeclaration, (CMNode)cmAttributeDelcaration);
            DetailItemCustomization detailItemCustomization = null;
            if (customization != null && (detailItemCustomization = customization.getItemCustomization(attributeNamespace, path)) == null) {
                detailItemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, path);
            }
            if (detailItemCustomization != null && (detailItemCustomization == null || detailItemCustomization.isHidden())) continue;
            return false;
        }
        CMContent cmContent = cmElementDeclaration.getContent();
        if (cmContent == null) {
            return true;
        }
        return cmContent.getNodeType() == 7 && (cmGroup = (CMGroup)cmContent).getChildNodes().getLength() == 0;
    }

    public static boolean isSimpleCMElementDeclaration(CustomizationManager.Customization customization, Element parentElement, CMElementDeclaration cmElementDeclaration) {
        IsSimpleCMElementDeclarationVisitor visitor = new IsSimpleCMElementDeclarationVisitor(customization, parentElement, cmElementDeclaration);
        visitor.visitCMNode((CMNode)cmElementDeclaration.getContent());
        return visitor.getResult();
    }

    public static boolean isCMNodeRepeatable(CMNode node) {
        if (node instanceof CMContent) {
            CMContent content = (CMContent)node;
            return content.getMaxOccur() > 1 || content.getMaxOccur() == -1;
        }
        return false;
    }

    public static int getGroupTypesInBetween(CMElementDeclaration ancestorCMElementDeclaration, CMElementDeclaration childCMElementDeclaration) {
        CMContent cmContent = ancestorCMElementDeclaration.getContent();
        if (cmContent != null && cmContent.getNodeType() == 7) {
            CMGroup cmGroup = (CMGroup)cmContent;
            return ModelUtil.recursiveGetGroupTypesInBetween(cmGroup, (CMNode)childCMElementDeclaration);
        }
        return 0;
    }

    private static int recursiveGetGroupTypesInBetween(CMGroup cmGroup, CMNode cmNode) {
        CMNodeList cmGroupChildren = cmGroup.getChildNodes();
        if (cmGroupChildren != null) {
            for (int i = 0; i < cmGroupChildren.getLength(); ++i) {
                CMGroup childCMGroup;
                int result;
                CMNode cmGroupChild = cmGroupChildren.item(i);
                if (cmGroupChild.equals(cmNode)) {
                    return ModelUtil.getGroupDescription(cmGroup);
                }
                if (cmGroupChild.getNodeType() != 7 || (result = ModelUtil.recursiveGetGroupTypesInBetween(childCMGroup = (CMGroup)cmGroupChild, cmNode)) <= 0) continue;
                return result | ModelUtil.getGroupDescription(cmGroup);
            }
        }
        return 0;
    }

    private static int getGroupDescription(CMGroup cmGroup) {
        int result = 0;
        switch (cmGroup.getOperator()) {
            case 1: {
                result |= 1;
                break;
            }
            case 3: {
                result |= 2;
                break;
            }
            case 2: {
                result |= 4;
            }
        }
        if (cmGroup.getMinOccur() == 0) {
            result |= 8;
        }
        if (cmGroup.getMaxOccur() == -1 || cmGroup.getMaxOccur() > 1) {
            result |= 0x10;
        }
        return result;
    }

    public static Element[] getInstancesOfElement(Element parentElement, CMElementDeclaration cmElementDeclaration) {
        ArrayList<Element> result = new ArrayList<Element>();
        String nodeName = DOMNamespaceHelper.computeName((CMNode)cmElementDeclaration, (Node)parentElement, null);
        String namespaceURI = null;
        CMDocument cmDocument = (CMDocument)cmElementDeclaration.getProperty("CMDocument");
        if (cmDocument != null) {
            namespaceURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
        }
        for (Node node = parentElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNodeName().equals(nodeName) || namespaceURI != null && ModelUtil.getNodeNamespace(node) != null && !namespaceURI.equals(ModelUtil.getNodeNamespace(node))) continue;
            result.add((Element)node);
        }
        return result.toArray(new Element[result.size()]);
    }

    public static Element obtainOrCreateElement(Element parentElement, CMElementDeclaration cmElementDeclaration, CustomizationManager.Customization customization) {
        Element[] instance = ModelUtil.getInstancesOfElement(parentElement, cmElementDeclaration);
        if (instance.length > 0) {
            return instance[0];
        }
        NodeList childNodes = parentElement.getChildNodes();
        boolean parentNodeFormatRequired = childNodes == null || childNodes.getLength() == 0 || childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3 && childNodes.item(0).getNodeValue().trim().length() == 0;
        Element element = null;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)parentElement.getOwnerDocument());
        boolean append = false;
        Node refChild = parentElement.getLastChild();
        if (modelQuery.canInsert(parentElement, (CMNode)cmElementDeclaration, parentElement.getChildNodes().getLength(), 2)) {
            append = true;
        } else {
            for (int i = parentElement.getChildNodes().getLength(); !modelQuery.canInsert(parentElement, (CMNode)cmElementDeclaration, i - 1, 2) && i > 0; --i) {
                refChild = refChild.getPreviousSibling();
            }
            if (refChild == null) {
                refChild = parentElement.getFirstChild();
            }
        }
        IDOMModel model = ((IDOMNode)parentElement).getModel();
        model.aboutToChangeModel();
        String namespaceURI = null;
        CMDocument cmDocument = (CMDocument)cmElementDeclaration.getProperty("CMDocument");
        if (cmDocument != null) {
            namespaceURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
        }
        element = namespaceURI != null ? parentElement.getOwnerDocument().createElementNS(namespaceURI, DOMNamespaceHelper.computeName((CMNode)cmElementDeclaration, (Node)parentElement, null)) : parentElement.getOwnerDocument().createElement(cmElementDeclaration.getElementName());
        Text textNode = parentElement.getOwnerDocument().createTextNode(System.getProperty("line.separator"));
        if (append) {
            parentElement.appendChild(element);
            parentElement.appendChild(textNode);
        } else {
            parentElement.insertBefore(element, refChild);
            parentElement.insertBefore(textNode, refChild);
        }
        if (parentNodeFormatRequired) {
            ModelUtil.formatXMLNode(parentElement);
        } else {
            ModelUtil.formatXMLNode(element);
        }
        model.changedModel();
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatXMLNode(Node node) {
        DocumentRewriteSession rewriteSession = null;
        if (node instanceof IDOMNode) {
            rewriteSession = ((IDocumentExtension4)((IDOMNode)node).getModel().getStructuredDocument()).startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        }
        FormatProcessorXML formatProcessor = new FormatProcessorXML();
        try {
            formatProcessor.formatNode(node);
        }
        catch (Exception exception) {
        }
        finally {
            if (node instanceof IDOMNode && rewriteSession != null) {
                ((IDocumentExtension4)((IDOMNode)node).getModel().getStructuredDocument()).stopRewriteSession(rewriteSession);
            }
        }
    }

    public static Element recursivelyCompressEmptyElementTags(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            Element currentElement = (Element)node;
            node = ModelUtil.recursivelyCompressEmptyElementTags(currentElement);
        }
        return ModelUtil.compressEmptyElementTag(element);
    }

    public static Element compressEmptyElementTag(Element element) {
        NodeList childNodes;
        ITextRegionList regions;
        ITextRegion lastRegion;
        IStructuredDocumentRegion endTagStructuredDocumentRegion;
        IDOMElement newElement = (IDOMElement)element;
        IStructuredDocumentRegion startTagStructuredDocumentRegion = newElement.getFirstStructuredDocumentRegion();
        if (startTagStructuredDocumentRegion != (endTagStructuredDocumentRegion = newElement.getLastStructuredDocumentRegion()) && startTagStructuredDocumentRegion != null && (lastRegion = (regions = startTagStructuredDocumentRegion.getRegions()).get(regions.size() - 1)).getType() != "XML_EMPTY_TAG_CLOSE" && ((childNodes = newElement.getChildNodes()) == null || childNodes.getLength() == 0 || childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3 && childNodes.item(0).getNodeValue().trim().length() == 0)) {
            IDOMModel structuredModel = newElement.getModel();
            IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
            int startTagStartOffset = newElement.getStartOffset();
            int offset = endTagStructuredDocumentRegion.getStart();
            int length = endTagStructuredDocumentRegion.getLength();
            structuredDocument.replaceText((Object)structuredDocument, offset, length, "");
            newElement = (IDOMElement)structuredModel.getIndexedRegion(startTagStartOffset);
            offset = startTagStructuredDocumentRegion.getStart() + lastRegion.getStart();
            structuredDocument.replaceText((Object)structuredDocument, offset, 0, "/");
            newElement = (IDOMElement)structuredModel.getIndexedRegion(startTagStartOffset);
        }
        return newElement;
    }

    public static boolean elementMustAppearInTree(CustomizationManager.Customization customization, Element parentElement, CMElementDeclaration parentCMElementDeclaration, CMElementDeclaration childCMElementDeclaration) {
        boolean isSimple;
        boolean singleOccurrence = false;
        if (customization != null) {
            String path = ModelUtil.getNodeFullPath(parentElement, (CMNode)childCMElementDeclaration);
            String elementNamespace = ModelUtil.getNamespaceURI((CMNode)childCMElementDeclaration);
            DetailItemCustomization detailItemCustomization = customization.getItemCustomization(elementNamespace, path);
            if (detailItemCustomization == null) {
                detailItemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)childCMElementDeclaration, path);
            }
            if (detailItemCustomization != null) {
                if (detailItemCustomization.isHidden()) {
                    return false;
                }
                int style = detailItemCustomization.getStyle();
                if (style == 5) {
                    return true;
                }
                if (style == 4 || style == 2 || style == 1) {
                    return false;
                }
                singleOccurrence = detailItemCustomization.isSingleOccurrence();
            }
        }
        Object object = null;
        object = childCMElementDeclaration.getProperty("SubstitutionGroupValue");
        if (object != null && !"".equals(object)) {
            return true;
        }
        if ((ModelUtil.getGroupTypesInBetween(parentCMElementDeclaration, childCMElementDeclaration) & 0x14) != 0 && !singleOccurrence) {
            return true;
        }
        return !ModelUtil.isAtomicCMElementDeclaration(customization, parentElement, childCMElementDeclaration) && (!(isSimple = ModelUtil.isSimpleCMElementDeclaration(customization, parentElement, childCMElementDeclaration)) || isSimple && ModelUtil.isCMNodeRepeatable((CMNode)childCMElementDeclaration) && !singleOccurrence);
    }

    public static String getNamespaceURI(CMNode cmNode) {
        CMDocument cmDocument = (CMDocument)cmNode.getProperty("CMDocument");
        if (cmDocument != null) {
            return (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
        }
        return null;
    }

    public static String getElementFullPath(Element element) {
        String path = element.getLocalName();
        for (Node parentNode = element.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            if (parentNode.getNodeType() != 1) continue;
            Element parentElement = (Element)parentNode;
            path = parentElement.getLocalName() + '/' + path;
        }
        return '/' + path;
    }

    public static String getNodeFullPath(Element parentElement, CMNode cmNode) {
        String name = "";
        if (cmNode.getNodeType() == 2) {
            name = '@' + ((CMAttributeDeclaration)cmNode).getAttrName();
        } else if (cmNode.getNodeType() == 5) {
            name = '/' + ((CMElementDeclaration)cmNode).getElementName();
        }
        return ModelUtil.getElementFullPath(parentElement) + name;
    }

    public static String getNodeFullPath(Element grandParentElement, CMElementDeclaration parentCMElementDeclaration, CMNode cmNode) {
        String name = "";
        if (cmNode.getNodeType() == 2) {
            name = '@' + ((CMAttributeDeclaration)cmNode).getAttrName();
        } else if (cmNode.getNodeType() == 5) {
            name = '/' + ((CMElementDeclaration)cmNode).getElementName();
        }
        return ModelUtil.getElementFullPath(grandParentElement) + '/' + parentCMElementDeclaration.getElementName() + name;
    }

    public static String formatMultiLineTextForEditing(String text) {
        StringTokenizer stringTokenizer = new StringTokenizer(text, "\n", true);
        String result = "";
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token == null || token.length() <= 0) continue;
            if (token.charAt(0) == '\n' && !"".equals(result)) {
                result = result + "\r\n";
                continue;
            }
            result = result + token.trim();
        }
        return result.trim();
    }

    public static String formatToolTip(String toolTip) {
        StringTokenizer stringTokenizer = new StringTokenizer(toolTip, "\n", false);
        String result = "";
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken().trim();
            result = result + token + ' ';
        }
        return result;
    }

    public static String getModelNamespaceURI(Document document) {
        Vector vector;
        Object firstElement;
        Object object;
        CMDocument cmDocument;
        String modelNamespaceURI = null;
        Element documentElement = document.getDocumentElement();
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        CMNode cmNode = modelQuery.getCMNode((Node)documentElement);
        if (cmNode != null && (cmDocument = (CMDocument)cmNode.getProperty("CMDocument")) != null && (object = cmDocument.getProperty("http://org.eclipse.wst/cm/properties/namespaceInfo")) instanceof Vector && (firstElement = (vector = (Vector)object).firstElement()) instanceof NamespaceInfo) {
            NamespaceInfo namespaceInfo = (NamespaceInfo)firstElement;
            modelNamespaceURI = namespaceInfo.uri != null ? namespaceInfo.uri : "";
        }
        return modelNamespaceURI;
    }

    public static boolean isModelPresent(Document document) {
        Element documentElement = document.getDocumentElement();
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        try {
            CMNode cmNode = modelQuery.getCMNode((Node)documentElement);
            if (cmNode != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isRootElement(Element element) {
        return element == element.getOwnerDocument().getDocumentElement();
    }

    public static String processLabelDistinguishers(Element element, String label) {
        String result = "";
        boolean processToken = false;
        StringTokenizer stringTokenizer = new StringTokenizer(label, "$", true);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if ("$".equals(token)) {
                processToken = !processToken;
                continue;
            }
            if (processToken) {
                Element currentElement = null;
                String attributeName = null;
                if (".".equals(token)) {
                    currentElement = element;
                } else {
                    if (token.charAt(0) == '/') {
                        currentElement = element.getOwnerDocument().getDocumentElement();
                        token = token.substring(currentElement.getNodeName().length() + 1);
                    } else {
                        currentElement = element;
                    }
                    StringTokenizer segmentStringTokenizer = new StringTokenizer(token, "/");
                    while (segmentStringTokenizer.hasMoreTokens()) {
                        NodeList nodeList;
                        String segmentToken = segmentStringTokenizer.nextToken();
                        int index = segmentToken.indexOf(64);
                        if (index != -1) {
                            attributeName = segmentToken.substring(index + 1);
                            segmentToken = segmentToken.substring(0, index);
                        }
                        if ((nodeList = currentElement.getElementsByTagNameNS(ModelUtil.getNodeNamespace(currentElement), segmentToken)).getLength() == 0) {
                            nodeList = currentElement.getElementsByTagName(segmentToken);
                        }
                        if (nodeList.getLength() <= 0) continue;
                        currentElement = (Element)nodeList.item(0);
                    }
                }
                if (attributeName != null) {
                    String attributeValue = currentElement.getAttribute(attributeName);
                    if (attributeValue == null) continue;
                    result = result + attributeValue.trim();
                    continue;
                }
                for (Node node = currentElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                    String text;
                    if (node.getNodeType() != 3 || (text = node.getNodeValue()) == null) continue;
                    result = result + text.trim();
                }
                continue;
            }
            result = result + token;
        }
        return result;
    }

    public static CMGroup getContainingGroup(CMElementDeclaration ancestorCMElementDeclaration, CMElementDeclaration cmElementDeclaration) {
        CMContent cmContent = ancestorCMElementDeclaration.getContent();
        if (cmContent.getNodeType() == 7) {
            Stack<Object> cmGroupStack = new Stack<Object>();
            cmGroupStack.push((CMGroup)cmContent);
            while (!cmGroupStack.isEmpty()) {
                CMGroup currentGroup = (CMGroup)cmGroupStack.pop();
                CMNodeList cmNodeList = currentGroup.getChildNodes();
                for (int i = 0; i < cmNodeList.getLength(); ++i) {
                    CMNode cmNode = cmNodeList.item(i);
                    if (cmNode.getNodeType() == 5) {
                        CMElementDeclaration potentialCMElementDeclaration = (CMElementDeclaration)cmNode;
                        if (!potentialCMElementDeclaration.equals(cmElementDeclaration)) continue;
                        return currentGroup;
                    }
                    if (cmNode.getNodeType() != 7) continue;
                    cmGroupStack.push(cmNode);
                }
            }
        }
        return null;
    }

    public static boolean canInsertConsideringDuplication(ModelQuery modelQuery, Element element, CMElementDeclaration cmElementDeclaration, CustomizationManager.Customization customization, IEditorPart editorPart) {
        if (customization != null) {
            DetailItemCustomization detailItemCustomization = customization.getItemCustomization(ModelUtil.getNamespaceURI((CMNode)cmElementDeclaration), ModelUtil.getNodeFullPath(element, (CMNode)cmElementDeclaration));
            if (detailItemCustomization == null) {
                detailItemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, ModelUtil.getElementFullPath(element));
            }
            if (detailItemCustomization != null) {
                boolean canCreate = detailItemCustomization.isCanCreate();
                if (!canCreate) {
                    return false;
                }
                Class canCreateClass = detailItemCustomization.getCanCreateClass();
                if (canCreateClass != null) {
                    try {
                        Object object = canCreateClass.newInstance();
                        if (object instanceof ICustomCanCreateObject) {
                            ICustomCanCreateObject customCanCreateObject = (ICustomCanCreateObject)object;
                            return customCanCreateObject.canCreate(element, editorPart);
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return true;
    }

    public static boolean insertActionsAvailable(Element element, CMElementDeclaration cmElementDeclaration, ModelQuery modelQuery, CustomizationManager.Customization customization, IEditorPart editorPart) {
        ArrayList modelQueryInsertActions = new ArrayList();
        modelQuery.getInsertActions(element, cmElementDeclaration, -1, 2, 2, modelQueryInsertActions);
        for (ModelQueryAction modelQueryAction : modelQueryInsertActions) {
            CMElementDeclaration availableCMElementDeclaration;
            CMNode cmNode = modelQueryAction.getCMNode();
            if (!(cmNode instanceof CMElementDeclaration) || !ModelUtil.canInsertConsideringDuplication(modelQuery, element, availableCMElementDeclaration = (CMElementDeclaration)cmNode, customization, editorPart) || !ModelUtil.elementMustAppearInTree(customization, element, cmElementDeclaration, availableCMElementDeclaration)) continue;
            return true;
        }
        return false;
    }

    public static List getInsertActions(Element element, CustomizationManager.Customization customization, DDEViewer ddeViewer, IEditorPart editorPart) {
        boolean detectSchemaLabel = false;
        boolean globalDetectSchemaLabel = false;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(element);
        String path = ModelUtil.getElementFullPath(element);
        ArrayList<AddElementAction> actions = new ArrayList<AddElementAction>();
        ArrayList modelQueryInsertActions = new ArrayList();
        ArrayList<CMNode> availableContent = new ArrayList<CMNode>();
        modelQuery.getInsertActions(element, cmElementDeclaration, -1, 2, 2, modelQueryInsertActions);
        for (ModelQueryAction modelQueryAction : modelQueryInsertActions) {
            CMNode cmNode = modelQueryAction.getCMNode();
            availableContent.add(cmNode);
        }
        for (Object e : availableContent) {
            CMElementDeclaration availableCMElementDeclaration;
            if (!(e instanceof CMElementDeclaration) || !ModelUtil.canInsertConsideringDuplication(modelQuery, element, availableCMElementDeclaration = (CMElementDeclaration)e, customization, editorPart) || !ModelUtil.elementMustAppearInTree(customization, element, cmElementDeclaration, availableCMElementDeclaration)) continue;
            AddElementAction action = new AddElementAction(element, availableCMElementDeclaration, ddeViewer, editorPart, customization);
            DetailItemCustomization detailItemCustomization = null;
            if (customization != null) {
                ImageDescriptor imageDescriptor;
                globalDetectSchemaLabel = customization.getGlobalDetectSchemaLabel();
                detailItemCustomization = customization.getItemCustomization(ModelUtil.getNamespaceURI((CMNode)availableCMElementDeclaration), path + '/' + availableCMElementDeclaration.getElementName());
                if (detailItemCustomization == null) {
                    detailItemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, ModelUtil.getElementFullPath(element));
                }
                String label = null;
                if (detailItemCustomization != null) {
                    Image image;
                    label = detailItemCustomization.getCreationLabel();
                    detectSchemaLabel = detailItemCustomization.getDetectSchemaLabel();
                    if (label == null) {
                        label = detailItemCustomization.getLabel();
                    }
                    if (label != null) {
                        action.setText(label);
                    }
                    if ((image = detailItemCustomization.getIcon()) != null) {
                        ImageDescriptor imageDescriptor2 = ImageDescriptor.createFromImage((Image)image);
                        action.setImageDescriptor(imageDescriptor2);
                        action.setImage(image);
                    } else if (detailItemCustomization.getIconClass() != null) {
                        try {
                            ICustomIconObject customImgObject;
                            Object imgClass = detailItemCustomization.getIconClass().newInstance();
                            if (imgClass instanceof ICustomIconObject && (image = (customImgObject = (ICustomIconObject)imgClass).getIcon(availableCMElementDeclaration, null)) != null) {
                                imageDescriptor = ImageDescriptor.createFromImage((Image)image);
                                action.setImageDescriptor(imageDescriptor);
                                action.setImage(image);
                            }
                        }
                        catch (IllegalAccessException e2) {
                            e2.printStackTrace();
                        }
                        catch (InstantiationException e3) {
                            e3.printStackTrace();
                        }
                    }
                } else if (action.getImage() == null && customization.getIconClass() != null) {
                    try {
                        ICustomIconObject customImgObject;
                        Image image;
                        Object imgClass = customization.getIconClass().newInstance();
                        if (imgClass instanceof ICustomIconObject && (image = (customImgObject = (ICustomIconObject)imgClass).getIcon(availableCMElementDeclaration, null)) != null) {
                            imageDescriptor = ImageDescriptor.createFromImage((Image)image);
                            action.setImageDescriptor(imageDescriptor);
                            action.setImage(image);
                        }
                    }
                    catch (IllegalAccessException e4) {
                        e4.printStackTrace();
                    }
                    catch (InstantiationException e5) {
                        e5.printStackTrace();
                    }
                }
                if (label == null && (detectSchemaLabel || globalDetectSchemaLabel) && cmElementDeclaration != null && (label = ModelUtil.getLabel((CMNode)availableCMElementDeclaration)) != null) {
                    action.setText(label);
                }
            }
            actions.add(action);
        }
        return actions;
    }

    public static Action getDeletionAction(Element element, DDEViewer ddeViewer, CustomizationManager.Customization customization, IEditorPart editorPart) {
        Node parentNode;
        DeleteElementAction deleteElementAction = new DeleteElementAction(element, ddeViewer, editorPart);
        DetailItemCustomization detailItemCustomization = null;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(element);
        if (customization != null) {
            detailItemCustomization = customization.getItemCustomization(ModelUtil.getNodeNamespace(element), ModelUtil.getElementFullPath(element));
            if (detailItemCustomization == null) {
                detailItemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, ModelUtil.getElementFullPath(element));
            }
            if (detailItemCustomization != null) {
                Class canDeleteClass;
                boolean canDelete;
                Class deletionClass = detailItemCustomization.getDeletionClass();
                if (deletionClass != null) {
                    deleteElementAction.setDeletionClass(deletionClass);
                }
                if (!(canDelete = detailItemCustomization.isCanDelete())) {
                    deleteElementAction.setEnabled(false);
                }
                if ((canDeleteClass = detailItemCustomization.getCanDeleteClass()) != null) {
                    try {
                        ICustomCanDeleteObject customCanDeleteObject;
                        Object object = canDeleteClass.newInstance();
                        if (object instanceof ICustomCanDeleteObject && !(customCanDeleteObject = (ICustomCanDeleteObject)object).canDelete(element, editorPart)) {
                            deleteElementAction.setEnabled(false);
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ((parentNode = element.getParentNode()).getNodeType() == 9) {
            deleteElementAction.setEnabled(false);
        }
        deleteElementAction.setImageDescriptor(DDEPlugin.getDefault().getImageDescriptor("icons/remove.gif"));
        return deleteElementAction;
    }

    public static String formatHeaderOrFooterText(String text) {
        return text.replace("\\n", "\n").replace("\\t", "\t");
    }

    public static boolean canDeleteElement(Element element, CustomizationManager.Customization customization, IEditorPart editorPart) {
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(element);
        if (customization != null) {
            DetailItemCustomization detailItemCustomization = customization.getItemCustomization(ModelUtil.getNodeNamespace(element), ModelUtil.getElementFullPath(element));
            if (detailItemCustomization == null) {
                detailItemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, ModelUtil.getElementFullPath(element));
            }
            if (detailItemCustomization != null) {
                if (!detailItemCustomization.isCanDelete()) {
                    return false;
                }
                Class canDeleteClass = detailItemCustomization.getCanDeleteClass();
                if (canDeleteClass != null) {
                    try {
                        ICustomCanDeleteObject customCanDeleteObject;
                        Object object = canDeleteClass.newInstance();
                        if (object instanceof ICustomCanDeleteObject && !(customCanDeleteObject = (ICustomCanDeleteObject)object).canDelete(element, editorPart)) {
                            return false;
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return !ModelUtil.isRootElement(element);
    }

    public static NodeList runXPathAgainstDocument(Document document, String path, String namespaceData) {
        if (document != null) {
            try {
                XPath xpath = XPathFactory.newInstance().newXPath();
                if (namespaceData != null && !"".equals(namespaceData)) {
                    final HashMap<String, String> namespaces = new HashMap<String, String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(namespaceData, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String token = stringTokenizer.nextToken();
                        int index = token.indexOf(61);
                        if (index == -1) continue;
                        String key = token.substring(0, index).trim();
                        String value = token.substring(index + 1).trim();
                        namespaces.put(key, value);
                    }
                    NamespaceContext namespaceContext = new NamespaceContext(){

                        @Override
                        public String getNamespaceURI(String prefix) {
                            return (String)namespaces.get(prefix);
                        }

                        @Override
                        public String getPrefix(String namespace) {
                            return null;
                        }

                        public Iterator getPrefixes(String namespace) {
                            return null;
                        }
                    };
                    xpath.setNamespaceContext(namespaceContext);
                }
                XPathExpression expr = xpath.compile(path);
                return (NodeList)expr.evaluate(document, XPathConstants.NODESET);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void assignDefaultValues(Element element, CustomizationManager.Customization customization, IEditorPart editorPart) {
        if (customization != null) {
            Stack<Element> elements = new Stack<Element>();
            DetailsContentProvider detailsContentProvider = new DetailsContentProvider(customization);
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
            elements.push(element);
            while (!elements.isEmpty()) {
                CMElementDeclaration parentCMElementDeclaration;
                Element currentElement = (Element)elements.pop();
                CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(currentElement);
                NodeList childNodes = currentElement.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Element childElement;
                    CMElementDeclaration childCMElementDeclaration;
                    Node item = childNodes.item(i);
                    if (item.getNodeType() != 1 || !ModelUtil.elementMustAppearInTree(customization, currentElement, cmElementDeclaration, childCMElementDeclaration = modelQuery.getCMElementDeclaration(childElement = (Element)item))) continue;
                    elements.push(childElement);
                }
                Element parentElement = (Element)currentElement.getParentNode();
                if (!ModelUtil.elementMustAppearInTree(customization, parentElement, parentCMElementDeclaration = modelQuery.getCMElementDeclaration(parentElement), cmElementDeclaration)) continue;
                Stack<DetailItem> detailItems = new Stack<DetailItem>();
                DetailItem[] items = detailsContentProvider.getItems(currentElement);
                detailItems.addAll(Arrays.asList(items));
                while (!detailItems.isEmpty()) {
                    AtomicDetailItem atomicDetailItem;
                    DetailItem detailItem = (DetailItem)detailItems.pop();
                    if (detailItem instanceof SimpleDetailItem) {
                        SimpleDetailItem simpleDetailItem = (SimpleDetailItem)detailItem;
                        DetailItem[] atomicDetailItems = simpleDetailItem.getAtomicDetailItems();
                        detailItems.addAll(Arrays.asList(atomicDetailItems));
                        continue;
                    }
                    DetailItemCustomization detailItemCustomization = detailItem.getDetailItemCustomization();
                    if (detailItemCustomization == null) continue;
                    String defaultValue = detailItemCustomization.getDefaultValue();
                    Class defaultValueClass = detailItemCustomization.getDefaultValueClass();
                    boolean isRequired = detailItemCustomization.isRequired();
                    if (defaultValueClass != null) {
                        try {
                            Object object = defaultValueClass.newInstance();
                            if (object instanceof ICustomDefaultValueObject) {
                                ICustomDefaultValueObject customDefaultValueObject = (ICustomDefaultValueObject)object;
                                Element ancestor = element;
                                defaultValue = customDefaultValueObject.getDefaultValue(ancestor, editorPart);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (defaultValue != null) {
                        if (detailItem instanceof AtomicDetailItem) {
                            atomicDetailItem = (AtomicDetailItem)detailItem;
                            atomicDetailItem.setValue(defaultValue);
                            continue;
                        }
                        if (!(detailItem instanceof RepeatableAtomicDetailItemSet)) continue;
                        RepeatableAtomicDetailItemSet repeatableAtomicDetailItemSet = (RepeatableAtomicDetailItemSet)detailItem;
                        StringTokenizer stringTokenizer = new StringTokenizer(defaultValue, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String token = stringTokenizer.nextToken();
                            repeatableAtomicDetailItemSet.addItem(token);
                        }
                        continue;
                    }
                    if (!isRequired || detailItem.isRequired() || !(detailItem instanceof AtomicDetailItem)) continue;
                    atomicDetailItem = (AtomicDetailItem)detailItem;
                    atomicDetailItem.setValue("");
                }
            }
        }
    }

    public static String getDefaultValueForDetailItem(DetailItem detailItem, CustomizationManager.Customization customization, IEditorPart editorPart) {
        String defaultValue = null;
        DetailItemCustomization detailItemCustomization = detailItem.getDetailItemCustomization();
        if (detailItemCustomization != null) {
            Class defaultValueClass = detailItemCustomization.getDefaultValueClass();
            if (defaultValueClass != null) {
                try {
                    Object object = defaultValueClass.newInstance();
                    if (object instanceof ICustomDefaultValueObject) {
                        ICustomDefaultValueObject customDefaultValueObject = (ICustomDefaultValueObject)object;
                        Element ancestor = null;
                        if (detailItem instanceof AtomicDetailItem) {
                            AtomicDetailItem atomicDetailItem = (AtomicDetailItem)detailItem;
                            ancestor = atomicDetailItem.getClosestAncestor();
                        } else if (detailItem instanceof RepeatableAtomicDetailItemSet) {
                            RepeatableAtomicDetailItemSet repeatableAtomicDetailItemSet = (RepeatableAtomicDetailItemSet)detailItem;
                            ancestor = repeatableAtomicDetailItemSet.getClosestAncestor();
                        }
                        defaultValue = customDefaultValueObject.getDefaultValue(ancestor, editorPart);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                defaultValue = detailItemCustomization.getDefaultValue();
            }
        }
        return defaultValue;
    }

    public static List getTreeChildElements(Element element, CustomizationManager.Customization customization) {
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        ArrayList<Element> elements = new ArrayList<Element>();
        CMElementDeclaration parentCMElementDeclaration = modelQuery.getCMElementDeclaration(element);
        if (parentCMElementDeclaration != null) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element childElement;
                CMElementDeclaration childCMElementDeclaration;
                if (node.getNodeType() != 1 || (childCMElementDeclaration = modelQuery.getCMElementDeclaration(childElement = (Element)node)) == null || !ModelUtil.elementMustAppearInTree(customization, element, parentCMElementDeclaration, childCMElementDeclaration)) continue;
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static boolean isDesignViewPageActiveAndInFocus() {
        DDEMultiPageEditorPart ddeMultiPageEditorPart;
        IWorkbenchPart activePart;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        return workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activePart = activePage.getActivePart()) != null && activePart instanceof DDEMultiPageEditorPart && (ddeMultiPageEditorPart = (DDEMultiPageEditorPart)activePart).getEditorActivePage() == DDEMultiPageEditorPart.DESIGN_VIEW_PAGE;
    }

    public static boolean isSourceViewPageActiveAndInFocus() {
        DDEMultiPageEditorPart ddeMultiPageEditorPart;
        IWorkbenchPart activePart;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        return workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activePart = activePage.getActivePart()) instanceof DDEMultiPageEditorPart && (ddeMultiPageEditorPart = (DDEMultiPageEditorPart)activePart).getEditorActivePage() == DDEMultiPageEditorPart.SOURCE_VIEW_PAGE;
    }

    public static String getDetailItemLocalPath(SimpleDetailItem containingSimpleDetailItem, DetailItem detailItem) {
        String detailItemLocalPath = "";
        if (containingSimpleDetailItem != null) {
            detailItemLocalPath = detailItemLocalPath + containingSimpleDetailItem.getName() + '/';
        }
        if (detailItem instanceof AtomicAttributeDetailItem) {
            detailItemLocalPath = detailItemLocalPath + '@';
        }
        detailItemLocalPath = detailItemLocalPath + detailItem.getName();
        return detailItemLocalPath;
    }

    public static Node[] getInstances(Document document, String path) {
        ArrayList<Document> nodeList = new ArrayList<Document>();
        nodeList.add(document);
        StringTokenizer stringTokenizer = new StringTokenizer(path, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            ArrayList<Node> newNodeList = new ArrayList<Node>();
            Iterator iterator = nodeList.iterator();
            String targetElementName = null;
            String targetAttributeName = null;
            int attributeSeparator = token.indexOf(64);
            if (attributeSeparator != -1) {
                targetElementName = token.substring(0, attributeSeparator);
                targetAttributeName = token.substring(attributeSeparator + 1);
            } else {
                targetElementName = token;
            }
            while (iterator.hasNext()) {
                Node currentNode = (Node)iterator.next();
                for (Node currentNodeChild = currentNode.getFirstChild(); currentNodeChild != null; currentNodeChild = currentNodeChild.getNextSibling()) {
                    Element currentNodeChildElement;
                    if (currentNodeChild.getNodeType() != 1 || !targetElementName.equals((currentNodeChildElement = (Element)currentNodeChild).getLocalName())) continue;
                    if (targetAttributeName != null) {
                        NamedNodeMap attributes = currentNodeChildElement.getAttributes();
                        Node attributeNode = attributes.getNamedItem(targetAttributeName);
                        if (attributeNode == null) continue;
                        newNodeList.add(attributeNode);
                        continue;
                    }
                    newNodeList.add(currentNodeChildElement);
                }
            }
            nodeList = newNodeList;
        }
        return nodeList.toArray(new Node[nodeList.size()]);
    }

    public static Node getDetailItemValueNode(DetailItem detailItem) {
        if (detailItem instanceof AtomicDetailItem) {
            AtomicDetailItem atomicDetailItem = (AtomicDetailItem)detailItem;
            Node node = atomicDetailItem.getNode();
            if (node != null) {
                if (node.getNodeType() == 1 && atomicDetailItem.hasEditableValue()) {
                    boolean isCDATAStorage = false;
                    DetailItemCustomization detailItemCustomization = atomicDetailItem.getDetailItemCustomization();
                    if (detailItemCustomization != null) {
                        isCDATAStorage = detailItemCustomization.isCDATASectionStorage();
                    }
                    for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                        String text;
                        if (!(!isCDATAStorage && childNode.getNodeType() == 3 ? (text = childNode.getNodeValue()) != null && text.trim().length() != 0 : isCDATAStorage && childNode.getNodeType() == 4 && (text = childNode.getNodeValue()) != null && text.trim().length() != 0)) continue;
                        return childNode;
                    }
                }
                return node;
            }
        } else if (detailItem instanceof RepeatableAtomicDetailItemSet) {
            RepeatableAtomicDetailItemSet repeatableAtomicDetailItemSet = (RepeatableAtomicDetailItemSet)detailItem;
            AtomicDetailItem[] items = repeatableAtomicDetailItemSet.getItems();
            if (items.length > 0) {
                return items[0].getNode().getParentNode();
            }
        } else if (detailItem instanceof SimpleDetailItem) {
            // empty if block
        }
        return null;
    }

    public static void removeBlankCreatedRepeatableItems(Element element, CustomizationManager.Customization customization) {
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        Stack<Element> elementStack = new Stack<Element>();
        elementStack.push(element);
        while (!elementStack.isEmpty()) {
            DetailItemCustomization itemCustomization;
            Element currentElement = (Element)elementStack.pop();
            NodeList childNodes = currentElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node currentChildNode = childNodes.item(i);
                if (currentChildNode.getNodeType() != 1) continue;
                Element currentChildElement = (Element)currentChildNode;
                elementStack.push(currentChildElement);
            }
            Element currentParentElement = null;
            CMElementDeclaration currentParentCMElementDeclaration = null;
            CMElementDeclaration currentElementCMElementDeclaration = modelQuery.getCMElementDeclaration(currentElement);
            Node currentParentNode = currentElement.getParentNode();
            if (currentParentNode.getNodeType() == 1) {
                currentParentElement = (Element)currentParentNode;
                currentParentCMElementDeclaration = modelQuery.getCMElementDeclaration(currentParentElement);
            }
            if (currentParentElement == null || currentParentCMElementDeclaration == null || currentElementCMElementDeclaration == null || ModelUtil.elementMustAppearInTree(customization, currentParentElement, currentParentCMElementDeclaration, currentElementCMElementDeclaration) || !ModelUtil.isAtomicCMElementDeclaration(customization, currentParentElement, currentElementCMElementDeclaration)) continue;
            boolean singleOccurrence = false;
            int style = 0;
            String currentElementNamespace = ModelUtil.getNodeNamespace(currentElement);
            String currentElementPath = ModelUtil.getElementFullPath(currentElement);
            DetailItemCustomization detailItemCustomization = itemCustomization = customization != null ? customization.getItemCustomization(currentElementNamespace, currentElementPath) : null;
            if (itemCustomization == null && customization != null) {
                itemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)currentElementCMElementDeclaration, currentElementPath);
            }
            if (itemCustomization != null) {
                singleOccurrence = itemCustomization.isSingleOccurrence();
                style = itemCustomization.getStyle();
            }
            if (!ModelUtil.isCMNodeRepeatable((CMNode)currentElementCMElementDeclaration) || singleOccurrence || style != 0) continue;
            currentParentElement.removeChild(currentElement);
        }
    }

    public static String getTreeNodeLabel(Element domElement, CustomizationManager.Customization customization, IResource resource) {
        boolean detectSchemaLabel = false;
        boolean globalDetectSchemaLabel = false;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)domElement.getOwnerDocument());
        CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(domElement);
        if (customization != null) {
            String schemaLabel;
            Class treeLabelClass;
            globalDetectSchemaLabel = customization.getGlobalDetectSchemaLabel();
            String label = null;
            String path = ModelUtil.getElementFullPath(domElement);
            String elementNamespace = ModelUtil.getNodeNamespace(domElement);
            DetailItemCustomization detailItemCustomization = customization.getItemCustomization(elementNamespace, path);
            if (detailItemCustomization == null) {
                detailItemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, path);
            }
            if (detailItemCustomization != null) {
                treeLabelClass = detailItemCustomization.getTreeLabelClass();
                if (treeLabelClass != null) {
                    try {
                        Object object = treeLabelClass.newInstance();
                        if (object instanceof ICustomLabelObject) {
                            ICustomLabelObject customLabelObject = (ICustomLabelObject)object;
                            return customLabelObject.getLabel(domElement, resource);
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                }
                if ((label = detailItemCustomization.getTreeLabel()) != null) {
                    if (label.indexOf(36) != -1) {
                        label = ModelUtil.processLabelDistinguishers(domElement, label);
                    }
                    return label;
                }
                detectSchemaLabel = detailItemCustomization.getDetectSchemaLabel();
                label = detailItemCustomization.getLabel();
                if (label != null) {
                    return label;
                }
            } else if (customization != null && (treeLabelClass = customization.getTreeLabelClass()) != null) {
                try {
                    Object object = treeLabelClass.newInstance();
                    if (object instanceof ICustomLabelObject) {
                        ICustomLabelObject customLabelObject = (ICustomLabelObject)object;
                        return customLabelObject.getLabel(domElement, resource);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            if (label == null && (detectSchemaLabel || globalDetectSchemaLabel) && cmElementDeclaration != null && (schemaLabel = ModelUtil.getLabel((CMNode)cmElementDeclaration)) != null) {
                return schemaLabel;
            }
        }
        return domElement.getLocalName();
    }

    public static int getRepeatableElementIndex(Element element) {
        int index = 0;
        String elementName = element.getNodeName();
        for (Node node = element.getParentNode().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNodeName().equals(elementName)) continue;
            if (node.equals(element)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public static String getPreferenceKeyForEditor(String siteId, String preferenceKey) {
        return siteId + '.' + preferenceKey;
    }

    public static String getNodeNamespace(Node node) {
        while (node != null) {
            int index;
            Attr attr;
            String value;
            Node attrNode;
            Element element;
            NamedNodeMap attributes;
            String namespaceURI = node.getNamespaceURI();
            if (namespaceURI != null) {
                return namespaceURI;
            }
            if (node.getNodeType() == 1 && (attributes = (element = (Element)node).getAttributes()) != null && (attrNode = attributes.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "type")) != null && attrNode.getNodeType() == 2 && (value = (attr = (Attr)attrNode).getValue()) != null && (index = value.indexOf(58)) != -1) {
                String prefix = value.substring(0, index);
                NamespaceTable namespaceTable = new NamespaceTable(element.getOwnerDocument());
                if (namespaceTable != null) {
                    namespaceTable.addElementLineage(element);
                    String uriForPrefix = namespaceTable.getURIForPrefix(prefix);
                    if (uriForPrefix != null) {
                        return uriForPrefix;
                    }
                }
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static Element[] getElementTreeChildren(CustomizationManager.Customization customization, Element element) {
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        ArrayList<Element> elements = new ArrayList<Element>();
        CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(element);
        if (cmElementDeclaration != null) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                CMElementDeclaration childCMElementDeclaration;
                Element childElement;
                if (node.getNodeType() != 1 || !ModelUtil.elementMustAppearInTree(customization, childElement = (Element)node, cmElementDeclaration, childCMElementDeclaration = modelQuery.getCMElementDeclaration(childElement))) continue;
                elements.add(childElement);
            }
        }
        return elements.toArray(new Element[elements.size()]);
    }

    public static boolean removeCDATASection(Element element) {
        boolean cdataRemoved = false;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            element.removeChild(node);
            cdataRemoved = true;
        }
        return cdataRemoved;
    }

    public static boolean isNodeInDocument(Document document, Node node) {
        if (document != null && node != null && node.getOwnerDocument() == document) {
            for (Node parentNode = node.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
                if (parentNode != document) continue;
                return true;
            }
        }
        return false;
    }

    public static void removePrecedingText(Element element) {
        Text text;
        String nodeValue;
        Node previousSibling;
        Node parentNode;
        if (element != null && (parentNode = element.getParentNode()) != null && (previousSibling = element.getPreviousSibling()) != null && previousSibling.getNodeType() == 3 && (nodeValue = (text = (Text)previousSibling).getNodeValue()) != null && nodeValue.trim().length() == 0) {
            int index = nodeValue.lastIndexOf("\r\n");
            if (index == -1) {
                index = nodeValue.lastIndexOf("\n");
            }
            if (index != -1) {
                if ("".equals(nodeValue = nodeValue.substring(0, index))) {
                    parentNode.removeChild(text);
                } else {
                    text.setNodeValue(nodeValue);
                }
            }
        }
    }

    public static void removeNextText(Element element) {
        Text text;
        String nodeValue;
        Node nextSibling;
        Node parentNode;
        if (element != null && (parentNode = element.getParentNode()) != null && (nextSibling = element.getNextSibling()) != null && nextSibling.getNodeType() == 3 && (nodeValue = (text = (Text)nextSibling).getNodeValue()) != null && nodeValue.trim().length() == 0) {
            int index = nodeValue.lastIndexOf("\r\n");
            if (index == -1) {
                index = nodeValue.lastIndexOf("\n");
            }
            if (index != -1) {
                if ("".equals(nodeValue = nodeValue.substring(0, index))) {
                    parentNode.removeChild(text);
                } else {
                    text.setNodeValue(nodeValue);
                }
            }
        }
    }

    public static void removeText(Node node) {
        Node prevSib;
        Node nextSib = node.getNextSibling();
        for (prevSib = node.getPreviousSibling(); prevSib != null && !(prevSib instanceof Element); prevSib = prevSib.getPreviousSibling()) {
        }
        if (nextSib instanceof Element) {
            Text text;
            String nodeValue;
            if (node != null && node.getNodeType() == 3 && (nodeValue = (text = (Text)node).getNodeValue()) != null && nodeValue.trim().length() == 0) {
                int index = nodeValue.lastIndexOf("\r\n");
                if (index == -1) {
                    index = nodeValue.lastIndexOf("\n");
                }
                if (index != -1) {
                    if ("".equals(nodeValue = nodeValue.substring(0, index))) {
                        node.getParentNode().removeChild(text);
                    } else {
                        text.setNodeValue(nodeValue);
                    }
                }
            }
        } else {
            ModelUtil.removeNextText((Element)prevSib);
        }
    }

    public static Element getFirstChildElement(Node start) {
        Node node;
        for (node = start.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getNextElement(Node start) {
        Node node;
        for (node = start.getNextSibling(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getFirstChildElement(Node start, String name) {
        Node node;
        for (node = start.getFirstChild(); !(node == null || node.getNodeType() == 1 && node.getNodeName().equals(name)); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getNextElement(Node start, String name) {
        Node node;
        for (node = start.getNextSibling(); !(node == null || node.getNodeType() == 1 && node.getNodeName().equals(name)); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getFirstChildElement(Node start, String ns, String name) {
        Node node;
        if (ns == null) {
            return ModelUtil.getFirstChildElement(start, name);
        }
        for (node = start.getFirstChild(); !(node == null || node.getNodeType() == 1 && node.getLocalName().equals(name) && ns.equals(node.getNamespaceURI())); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static Element getNextElement(Node start, String ns, String name) {
        Node node;
        if (ns == null) {
            return ModelUtil.getNextElement(start, name);
        }
        for (node = start.getNextSibling(); !(node == null || node.getNodeType() == 1 && node.getLocalName().equals(name) && ns.equals(node.getNamespaceURI())); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static String getAttributeValue(Element element, String name) {
        Attr attr = element.getAttributeNode(name);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public static String getTextContent(Node parent) {
        Node textNode = ModelUtil.getTextNode(parent);
        if (textNode != null) {
            return textNode.getNodeValue();
        }
        return null;
    }

    public static Node getTextNode(Node parent) {
        Node node;
        for (node = parent.getFirstChild(); node != null && node.getNodeType() != 3; node = node.getNextSibling()) {
        }
        return node;
    }

    public static String getLabel(CMNode node) {
        return ModelUtil.getLabelFromSchema(node, EXT_XSD, "label");
    }

    static String getLabelFromSchema(CMNode node, String ns, String tag) {
        XSDAttributeUse use;
        XSDAttributeDeclaration attr;
        Notifier target;
        XSDImpl.XSDElementDeclarationAdapter adapter;
        String APPINFO = "appinfo";
        String label = null;
        XSDAnnotation annotation = null;
        if (node instanceof XSDImpl.XSDElementDeclarationAdapter) {
            XSDElementDeclaration edecl;
            adapter = (XSDImpl.XSDElementDeclarationAdapter)node;
            target = adapter.getTarget();
            if (target instanceof XSDElementDeclaration && (annotation = (edecl = (XSDElementDeclaration)target).getAnnotation()) == null) {
                XSDTypeDefinition type = edecl.getTypeDefinition();
                annotation = type.getAnnotation();
                while (annotation == null && type.getBaseType() != null && !type.isCircular()) {
                    type = type.getBaseType();
                    annotation = type.getAnnotation();
                }
            }
        } else if (node instanceof XSDImpl.XSDAttributeUseAdapter && (target = (adapter = (XSDImpl.XSDAttributeUseAdapter)node).getTarget()) instanceof XSDAttributeUse && (annotation = (attr = (use = (XSDAttributeUse)target).getAttributeDeclaration()).getAnnotation()) == null) {
            XSDSimpleTypeDefinition type = attr.getTypeDefinition();
            annotation = type.getAnnotation();
            while (annotation == null && type.getBaseType() != null && !type.isCircular()) {
                type = type.getBaseType();
                annotation = type.getAnnotation();
            }
        }
        if (annotation != null) {
            Element e = annotation.getElement();
            Element e2 = ModelUtil.getFirstChildElement(e, SCHEMA_XSD, "appinfo");
            while (e2 != null) {
                Element e3 = ModelUtil.getFirstChildElement(e2, ns, tag);
                while (e3 != null) {
                    String s = ModelUtil.getTextContent(e3);
                    if (s != null) {
                        return s.trim();
                    }
                    e3 = ModelUtil.getNextElement(e3, ns, tag);
                }
                e2 = ModelUtil.getNextElement(e2, SCHEMA_XSD, "appinfo");
            }
        }
        return label;
    }

    public static XSDTypeDefinition getTypeDefinitionFromSchema(CMNode node) {
        XSDTypeDefinition type = null;
        if (node instanceof XSDImpl.XSDElementDeclarationAdapter) {
            XSDImpl.XSDElementDeclarationAdapter adapter = (XSDImpl.XSDElementDeclarationAdapter)node;
            Notifier target = adapter.getTarget();
            if (target instanceof XSDElementDeclaration) {
                XSDElementDeclaration edecl = (XSDElementDeclaration)target;
                type = edecl.getTypeDefinition();
            }
        } else if (node instanceof XSDImpl.XSDAttributeUseAdapter) {
            XSDImpl.XSDAttributeUseAdapter adapter = (XSDImpl.XSDAttributeUseAdapter)node;
            Notifier target = adapter.getTarget();
            if (target instanceof XSDAttributeUse) {
                XSDAttributeUse use = (XSDAttributeUse)target;
                XSDAttributeDeclaration attr = use.getAttributeDeclaration();
                type = attr.getTypeDefinition();
            }
            if (target instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration attr = (XSDAttributeDeclaration)target;
                type = attr.getTypeDefinition();
            }
        }
        return type;
    }

    public static String getTypeFromSchema(CMNode node) {
        String typeName = null;
        XSDTypeDefinition type = ModelUtil.getTypeDefinitionFromSchema(node);
        if (type != null) {
            typeName = ModelUtil.getTypeName(type.getTargetNamespace(), type.getName());
        }
        return typeName;
    }

    public static List<XSDSimpleTypeDefinition> getMemberTypesFromUnion(CMNode node) {
        XSDSimpleTypeDefinition st;
        ArrayList<XSDSimpleTypeDefinition> types = new ArrayList<XSDSimpleTypeDefinition>();
        XSDTypeDefinition type = ModelUtil.getTypeDefinitionFromSchema(node);
        if (type instanceof XSDSimpleTypeDefinition && type.getName() == null && (st = (XSDSimpleTypeDefinition)type).getVariety().equals((Object)XSDVariety.UNION_LITERAL)) {
            EList memberTypeDefinitions = st.getMemberTypeDefinitions();
            StringBuffer s = new StringBuffer();
            for (XSDSimpleTypeDefinition std : memberTypeDefinitions) {
                String name = std.getName();
                String ns = std.getTargetNamespace();
                if (name == null || name.length() <= 0) continue;
                types.add(std);
            }
        }
        return types;
    }

    public static HashMap<String, Element> getGroupDeclFromType(XSDTypeDefinition typeDef) {
        HashMap<String, Element> map = new HashMap<String, Element>();
        ModelUtil.getGroupDeclFromType(typeDef, map);
        return map;
    }

    private static void getGroupDeclFromType(XSDTypeDefinition typeDef, HashMap<String, Element> map) {
        Element element;
        NodeList childNodes;
        EList elements;
        XSDAnnotation ann;
        XSDTypeDefinition baseType = typeDef.getBaseType();
        XSDTypeDefinition rootType = typeDef.getRootType();
        if (rootType != typeDef) {
            ModelUtil.getGroupDeclFromType(baseType, map);
        }
        if ((ann = typeDef.getAnnotation()) != null && (elements = ann.getApplicationInformation()).size() > 0 && (childNodes = (element = (Element)elements.get(0)).getChildNodes()) != null && childNodes.getLength() > 0) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getLocalName() == null || !node.getLocalName().equals("groupDecl")) continue;
                String groupID = ((Element)node).getAttribute("id");
                map.put(groupID, (Element)node);
            }
        }
    }

    public static String getGroupIDFromSchema(CMNode node) {
        Element e;
        NodeList childNodes;
        EList elements;
        Notifier target;
        XSDImpl.XSDElementDeclarationAdapter adapter;
        XSDAnnotation annotation = null;
        if (node instanceof XSDImpl.XSDElementDeclarationAdapter) {
            adapter = (XSDImpl.XSDElementDeclarationAdapter)node;
            target = adapter.getTarget();
            if (target instanceof XSDElementDeclaration) {
                XSDElementDeclaration edecl = (XSDElementDeclaration)target;
                annotation = edecl.getAnnotation();
            }
        } else if (node instanceof XSDImpl.XSDAttributeUseAdapter && (target = (adapter = (XSDImpl.XSDAttributeUseAdapter)node).getTarget()) instanceof XSDAttributeUse) {
            XSDAttributeUse use = (XSDAttributeUse)target;
            XSDAttributeDeclaration attr = use.getAttributeDeclaration();
            annotation = attr.getAnnotation();
        }
        if (annotation != null && (elements = annotation.getApplicationInformation()).size() > 0 && (childNodes = (e = (Element)elements.get(0)).getChildNodes()) != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node n = childNodes.item(i);
                if (n.getLocalName() == null || !n.getLocalName().equals("group")) continue;
                return ((Element)n).getAttribute("id");
            }
        }
        return null;
    }

    private static String getTypeName(String namespace, String name) {
        if (namespace == null || namespace.isEmpty()) {
            return name;
        }
        return namespace + ":" + name;
    }

    private static class IsSimpleCMElementDeclarationVisitor
    extends CMVisitor {
        public boolean result = true;
        private List visitedGroups;
        private CustomizationManager.Customization customization;
        private Element grandParentElement;
        private CMElementDeclaration parentCMElementDeclaration;

        public IsSimpleCMElementDeclarationVisitor(CustomizationManager.Customization customization, Element parentElement, CMElementDeclaration cmElementDeclaration) {
            this.customization = customization;
            this.grandParentElement = parentElement;
            this.parentCMElementDeclaration = cmElementDeclaration;
            this.visitedGroups = new ArrayList();
        }

        public void visitCMGroup(CMGroup group) {
            if (this.result) {
                if (group.getOperator() == 2 || group.getMaxOccur() == -1 || group.getMaxOccur() > 1) {
                    this.result = false;
                } else if (this.visitedGroups.indexOf(group) == -1) {
                    super.visitCMGroup(group);
                    this.visitedGroups.add(group);
                }
            }
        }

        public void visitCMElementDeclaration(CMElementDeclaration cmElementDeclaration) {
            if (this.result) {
                this.result = ModelUtil.isAtomicCMElementDeclaration(this.customization, this.grandParentElement, this.parentCMElementDeclaration, cmElementDeclaration);
                this.visitCMNode((CMNode)cmElementDeclaration.getContent());
            }
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

