/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.util;

import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.viewers.DetailsContentProvider;
import com.ibm.xwt.dde.internal.viewers.DetailsViewer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DetailsViewerAdapter {
    protected DetailsViewer detailsViewer = null;
    protected Element element = null;
    private final String NO_NAMESPACE_LOCATION = "xsi:noNamespaceSchemaLocation";
    private final String SCHEMA_LOCATION = "xsi:schemaLocation";

    public DetailsViewerAdapter() {
    }

    public DetailsViewerAdapter(Composite parent, CustomizationManager.Customization customization) {
        this.init(parent, customization);
    }

    public void init(Composite parent, CustomizationManager.Customization customization) {
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        widgetFactory.setBackground(null);
        this.detailsViewer = new DetailsViewer(parent, widgetFactory, null, customization, null, null);
        this.detailsViewer.setContentProvider(new DetailsContentProvider(customization));
    }

    public void createElement(String schemaPath, String elementName) {
        this.createElement(schemaPath, null, elementName, null);
    }

    public void createElement(String schemaPath, String schemaNameSpace, String elementName) {
        this.createElement(schemaPath, schemaNameSpace, elementName, null);
    }

    public void createElement(String schemaPath, String elementName, Map<String, String> properties) {
        this.createElement(schemaPath, null, elementName, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createElement(String schemaPath, String schemaNameSpace, String elementName, Map<String, String> properties) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        IStructuredModel sm = null;
        try {
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element new_el = null;
            if (schemaNameSpace != null) {
                elementName = "tns:" + elementName;
                new_el = doc.createElement(elementName);
                new_el.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                new_el.setAttribute("xmlns:tns", schemaNameSpace);
                new_el.setAttribute("xsi:schemaLocation", schemaNameSpace + " " + schemaPath);
            } else {
                new_el = doc.createElement(elementName);
                new_el.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                new_el.setAttribute("xsi:noNamespaceSchemaLocation", schemaPath);
            }
            if (properties != null && properties.size() > 0) {
                Set<String> keys = properties.keySet();
                for (String key : keys) {
                    new_el.setAttribute(key, properties.get(key));
                }
            }
            doc.appendChild(new_el);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            sm = StructuredModelManager.getModelManager().getModelForRead(ContentTypeIdForXML.ContentTypeID_XML, (InputStream)inputStream, null);
            doc = ((IDOMModel)sm).getDocument();
            sm.reload((InputStream)inputStream);
            Element el = null;
            NodeList nodeList = doc.getElementsByTagName(elementName);
            if (nodeList != null && nodeList.getLength() > 0) {
                this.element = el = (Element)nodeList.item(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (sm != null) {
                sm.releaseFromRead();
            }
        }
    }

    public void loadContents() {
        if (this.detailsViewer != null) {
            this.detailsViewer.setInput(this.element);
        }
    }

    public void setElement(Element el) {
        this.element = el;
    }

    public Control getControl() {
        if (this.detailsViewer != null) {
            return this.detailsViewer.getControl();
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }

    private boolean isSchemaAttr(Attr attr) {
        String attrKey = attr.getName();
        if (attrKey.equals("xsi:noNamespaceSchemaLocation") || attrKey.equals("xsi:schemaLocation")) {
            return true;
        }
        return attrKey.equals("xmlns:xsi") || attrKey.equals("xmlns:tns");
    }

    public Map<String, String> getElementProperties() {
        NamedNodeMap nodeMap = this.element.getAttributes();
        LinkedHashMap<String, String> prop = new LinkedHashMap<String, String>();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Attr attr = (Attr)nodeMap.item(i);
            if (this.isSchemaAttr(attr)) continue;
            prop.put(attr.getLocalName(), attr.getValue());
        }
        return prop;
    }
}

