/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.data;

import com.ibm.xwt.dde.internal.data.AtomicDetailItem;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocumentation;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AtomicElementDetailItem
extends AtomicDetailItem {
    private Element grandParentElement;
    private CMElementDeclaration parentCMElementDeclaration;
    private Element parentElement;
    private Element element;
    private CMElementDeclaration elementDeclaration;

    public AtomicElementDetailItem(Element element) {
        ModelQuery modelQuery;
        this.element = element;
        Node parentNode = element.getParentNode();
        if (parentNode.getNodeType() == 1) {
            this.parentElement = (Element)parentNode;
        }
        if ((modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument())) != null) {
            CMElementDeclaration parentCMElementDeclaration;
            CMElementDeclaration elementDeclaration = modelQuery.getCMElementDeclaration(element);
            if (elementDeclaration != null) {
                this.elementDeclaration = elementDeclaration;
            }
            if ((parentCMElementDeclaration = modelQuery.getCMElementDeclaration(this.parentElement)) != null) {
                this.parentCMElementDeclaration = parentCMElementDeclaration;
            }
        }
    }

    public AtomicElementDetailItem(Element parentElement, CMElementDeclaration cmElementDeclaration) {
        this.parentElement = parentElement;
        this.elementDeclaration = cmElementDeclaration;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)parentElement.getOwnerDocument());
        CMElementDeclaration parentCMElementDeclaration = modelQuery.getCMElementDeclaration(parentElement);
        if (parentCMElementDeclaration != null) {
            this.parentCMElementDeclaration = parentCMElementDeclaration;
        }
    }

    public AtomicElementDetailItem(Element grandParentElement, CMElementDeclaration parentCMElementDeclaration, CMElementDeclaration cmElementDeclaration) {
        this.grandParentElement = grandParentElement;
        this.parentCMElementDeclaration = parentCMElementDeclaration;
        this.elementDeclaration = cmElementDeclaration;
    }

    @Override
    public Node getNode() {
        return this.element;
    }

    @Override
    public Map getPossibleValues() {
        ModelQuery modelQuery;
        String[] values = null;
        if (this.element != null) {
            modelQuery = ModelQueryUtil.getModelQuery((Document)this.element.getOwnerDocument());
            values = modelQuery.getPossibleDataTypeValues(this.element, (CMNode)this.elementDeclaration);
        } else if (this.parentElement != null) {
            modelQuery = ModelQueryUtil.getModelQuery((Document)this.parentElement.getOwnerDocument());
            values = modelQuery.getPossibleDataTypeValues(this.parentElement, (CMNode)this.elementDeclaration);
        } else if (this.grandParentElement != null) {
            modelQuery = ModelQueryUtil.getModelQuery((Document)this.grandParentElement.getOwnerDocument());
            values = modelQuery.getPossibleDataTypeValues(this.grandParentElement, (CMNode)this.elementDeclaration);
        }
        if (values.length > 1) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < values.length; ++i) {
                map.put(values[i], values[i]);
            }
            return map;
        }
        return null;
    }

    @Override
    public String getValue() {
        boolean isCDATAStorage = this.isCDATASectionStorage();
        if (this.element != null) {
            for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
                String text;
                if (!(!isCDATAStorage && node.getNodeType() == 3 ? (text = node.getNodeValue()) != null && text.trim().length() != 0 : isCDATAStorage && node.getNodeType() == 4 && (text = node.getNodeValue()) != null && text.trim().length() != 0)) continue;
                return text.trim();
            }
        }
        return "";
    }

    @Override
    public boolean hasEditableValue() {
        int contentType = this.elementDeclaration.getContentType();
        return contentType == 3 || contentType == 4;
    }

    @Override
    public void setValue(String newValue) {
        boolean isCDATASectionStorage = this.isCDATASectionStorage();
        if (this.element == null) {
            if (this.parentElement == null) {
                this.parentElement = ModelUtil.obtainOrCreateElement(this.grandParentElement, this.parentCMElementDeclaration, this.detailItemCustomization != null ? this.detailItemCustomization.getCustomization() : null);
            }
            this.element = ModelUtil.obtainOrCreateElement(this.parentElement, this.elementDeclaration, this.detailItemCustomization != null ? this.detailItemCustomization.getCustomization() : null);
        }
        Node textNode = null;
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String text;
            if (!isCDATASectionStorage && node.getNodeType() == 3) {
                text = node.getNodeValue();
                if (text == null || text.trim().length() == 0) continue;
                textNode = node;
                break;
            }
            if (!isCDATASectionStorage || node.getNodeType() != 4 || (text = node.getNodeValue()) == null || text.trim().length() == 0) continue;
            textNode = node;
            break;
        }
        if (newValue != null) {
            if (textNode == null) {
                if (isCDATASectionStorage) {
                    ModelUtil.removeCDATASection(this.element);
                    textNode = this.element.getOwnerDocument().createCDATASection(newValue);
                    this.element.appendChild(textNode);
                } else if (!"".equals(newValue)) {
                    textNode = this.element.getOwnerDocument().createTextNode(newValue);
                    this.element.appendChild(textNode);
                }
                ModelUtil.formatXMLNode(this.element);
            } else if (!"".equals(newValue)) {
                textNode.setNodeValue(newValue);
            } else if (this.detailItemCustomization != null && this.parentElement != null && !ModelUtil.elementMustAppearInTree(this.detailItemCustomization.getCustomization(), this.parentElement, this.parentCMElementDeclaration, this.elementDeclaration)) {
                this.element.removeChild(textNode);
                this.element = ModelUtil.compressEmptyElementTag(this.element);
                ModelUtil.formatXMLNode(this.element);
            } else {
                textNode.setNodeValue("");
            }
        }
    }

    @Override
    public String getName() {
        return this.elementDeclaration.getElementName();
    }

    @Override
    public boolean isRequired() {
        return this.elementDeclaration.getMinOccur() == 1;
    }

    @Override
    public boolean isOptionalWithinContext() {
        int condition = 12;
        return (ModelUtil.getGroupTypesInBetween(this.parentCMElementDeclaration, this.elementDeclaration) & condition) == condition;
    }

    @Override
    public boolean exists() {
        return this.element != null;
    }

    @Override
    public void delete() {
        if (this.element != null) {
            ModelUtil.removePrecedingText(this.element);
            this.parentElement.removeChild(this.element);
            this.element = null;
        }
    }

    @Override
    public String getDocumentation() {
        Object object = this.elementDeclaration.getProperty("documentation");
        if (object instanceof CMNodeList) {
            CMNodeList cmNodeList = (CMNodeList)object;
            int n = cmNodeList.getLength();
            String documentation = "";
            for (int i = 0; i < n; ++i) {
                CMNode cmNode = cmNodeList.item(i);
                if (cmNode.getNodeType() != 9) continue;
                CMDocumentation cmDocumentation = (CMDocumentation)cmNode;
                documentation = documentation + cmDocumentation.getValue();
            }
            return documentation;
        }
        return null;
    }

    @Override
    public Element getClosestAncestor() {
        if (this.parentElement != null) {
            return this.parentElement;
        }
        return this.grandParentElement;
    }

    @Override
    public CMNode getCMNode() {
        return this.elementDeclaration;
    }

    private boolean isCDATASectionStorage() {
        if (this.detailItemCustomization != null) {
            return this.detailItemCustomization.isCDATASectionStorage();
        }
        return false;
    }
}

