/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.actions;

import com.ibm.xwt.dde.DDEPlugin;
import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.viewers.DDEViewer;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MoveAction
extends Action {
    private DDEViewer ddeViewer;
    private boolean direction;

    public MoveAction(DDEViewer ddeViewer, boolean direction) {
        this.ddeViewer = ddeViewer;
        this.direction = direction;
        boolean enabled = false;
        TreeItem[] treeItems = ddeViewer.getTreeViewer().getTree().getSelection();
        if (treeItems.length == 1) {
            TreeItem treeItem = treeItems[0];
            TreeItem parentTreeItem = treeItem.getParentItem();
            if (ddeViewer.getTreeViewer().getSorter() == null && parentTreeItem != null) {
                TreeItem[] childItems = parentTreeItem.getItems();
                if (direction && !childItems[0].equals(treeItem)) {
                    enabled = true;
                }
                if (!direction && !childItems[childItems.length - 1].equals(treeItem)) {
                    enabled = true;
                }
            }
        }
        this.setEnabled(enabled);
        if (direction) {
            this.setImageDescriptor(DDEPlugin.getDefault().getImageDescriptor("icons/move_up.gif"));
            this.setText(Messages.LABEL_MOVE_UP_WITH_MNEMONIC);
        } else {
            this.setImageDescriptor(DDEPlugin.getDefault().getImageDescriptor("icons/move_down.gif"));
            this.setText(Messages.LABEL_MOVE_DOWN_WITH_MNEMONIC);
        }
    }

    public void run() {
        if (((DDEMultiPageEditorPart)this.ddeViewer.getEditorPart()).validateEditorInput()) {
            String nodeValue;
            int i;
            IStructuredTextUndoManager undoManager = this.ddeViewer.getUndoManager();
            TreeViewer treeViewer = this.ddeViewer.getTreeViewer();
            TreeItem treeItem = treeViewer.getTree().getSelection()[0];
            TreeItem parentTreeItem = treeItem.getParentItem();
            TreeItem[] childItems = parentTreeItem.getItems();
            Element source = (Element)treeItem.getData();
            Element parentElement = (Element)source.getParentNode();
            IDOMModel model = ((IDOMNode)source).getModel();
            Node sibling = null;
            if (this.direction) {
                for (i = 1; !childItems[i].equals(treeItem) && i < childItems.length; ++i) {
                }
                Element target = (Element)childItems[i - 1].getData();
                MessageFormat messageFormat = new MessageFormat(Messages.MOVE_UP);
                undoManager.beginRecording((Object)this, messageFormat.format(new String[]{treeItem.getText()}));
                model.aboutToChangeModel();
                parentElement.replaceChild(target, source);
                parentElement.insertBefore(source, target);
                sibling = source.getPreviousSibling();
            } else {
                for (i = childItems.length - 1; !childItems[i].equals(treeItem) && i > 0; --i) {
                }
                Element target = (Element)childItems[i + 1].getData();
                MessageFormat messageFormat = new MessageFormat(Messages.MOVE_DOWN);
                undoManager.beginRecording((Object)this, messageFormat.format(new String[]{treeItem.getText()}));
                model.aboutToChangeModel();
                parentElement.replaceChild(source, target);
                parentElement.insertBefore(target, source);
                sibling = target.getPreviousSibling();
            }
            if (sibling != null && sibling.getNodeType() == 3 && (nodeValue = sibling.getNodeValue()) != null && nodeValue.trim().length() == 0) {
                parentElement.removeChild(sibling);
            }
            ModelUtil.formatXMLNode(source);
            model.changedModel();
            undoManager.endRecording((Object)this);
            StructuredSelection selection = new StructuredSelection((Object)source);
            treeViewer.refresh();
            treeViewer.setSelection((ISelection)selection);
        }
    }
}

