/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.actions;

import com.ibm.xwt.dde.customization.ICustomDeletionObject;
import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.validation.ValidationManager;
import com.ibm.xwt.dde.internal.viewers.DDEViewer;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeleteElementAction
extends Action {
    private Element element;
    private DDEViewer ddeViewer;
    private IEditorPart editorPart;
    private Class deletionClass;

    public DeleteElementAction(Element element, DDEViewer viewer, IEditorPart editorPart) {
        super(Messages.REMOVE_WITH_MNEMONIC);
        this.element = element;
        this.ddeViewer = viewer;
        this.editorPart = editorPart;
    }

    public void run() {
        if (((DDEMultiPageEditorPart)this.editorPart).validateEditorInput()) {
            ModelQuery modelQuery;
            String namespace = ModelUtil.getNodeNamespace(this.element);
            String path = ModelUtil.getElementFullPath(this.element);
            CustomizationManager.Customization customization = this.ddeViewer.getCustomization();
            DetailItemCustomization itemCustomization = null;
            if (customization != null && (itemCustomization = customization.getItemCustomization(namespace, path)) == null && (modelQuery = ModelQueryUtil.getModelQuery((Document)this.element.getOwnerDocument())) != null) {
                CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(this.element);
                itemCustomization = customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, path);
            }
            String itemLabel = null;
            if (itemCustomization != null) {
                itemLabel = itemCustomization.getLabel();
            }
            if (itemLabel == null) {
                itemLabel = this.element.getNodeName();
            }
            MessageFormat messageFormat = new MessageFormat(Messages.REMOVE);
            this.ddeViewer.getUndoManager().beginRecording((Object)this, messageFormat.format(new String[]{itemLabel}));
            Element documentElement = this.element.getOwnerDocument().getDocumentElement();
            boolean refresh = false;
            Node parentNode = this.element.getParentNode();
            if (this.deletionClass != null) {
                try {
                    Object object = this.deletionClass.newInstance();
                    if (object instanceof ICustomDeletionObject) {
                        ICustomDeletionObject customDeletionObject = (ICustomDeletionObject)object;
                        IDOMModel model = ((IDOMNode)this.element).getModel();
                        model.aboutToChangeModel();
                        refresh = customDeletionObject.delete(this.element, this.editorPart);
                        model.changedModel();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                IDOMModel model = ((IDOMNode)this.element).getModel();
                model.aboutToChangeModel();
                ModelUtil.removePrecedingText(this.element);
                parentNode.removeChild(this.element);
                model.changedModel();
                refresh = true;
            }
            if (refresh) {
                ValidationManager validationManager = this.ddeViewer.getValidationManager();
                if (parentNode != null && parentNode.getNodeType() == 1 && parentNode.getParentNode() != null) {
                    Element parentElement = (Element)parentNode;
                    validationManager.getMessageManager().removeTreeNode(parentElement, this.element);
                    validationManager.validateTreeNode(parentElement, false, false, false);
                    this.ddeViewer.updateValidationInformation();
                    this.ddeViewer.setSelection((ISelection)new StructuredSelection((Object)parentNode), true);
                } else {
                    validationManager.validateTreeNode(documentElement, true, false, false);
                    this.ddeViewer.updateValidationInformation();
                    this.ddeViewer.setSelection((ISelection)new StructuredSelection((Object)documentElement), true);
                }
            }
            this.ddeViewer.getUndoManager().endRecording((Object)this);
        }
    }

    public void setDeletionClass(Class deletionClass) {
        this.deletionClass = deletionClass;
    }
}

