/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.common.core.internal.Trace;
import com.ibm.ws.st.common.ui.ext.internal.servertype.ServerTypeUIExtension;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class WebSphereServerWizardCommonFragment
extends WizardFragment {
    public static final String SERVER_TYPE_DATA = "com.ibm.ws.st.ui.serverTypeData";
    public static final String SERVICE_INFO = "com.ibm.ws.st.ui.serviceInfo";

    protected boolean runtimeHasServers() {
        WebSphereRuntime wrt;
        boolean hasServers = true;
        IRuntime rt = (IRuntime)this.getTaskModel().getObject("runtime");
        if (rt != null && (wrt = (WebSphereRuntime)rt.loadAdapter(WebSphereRuntime.class, null)) != null) {
            hasServers = wrt.hasServers();
        }
        return hasServers;
    }

    protected boolean directoryHasServer(IPath userDir) {
        File[] folders = userDir.toFile().listFiles();
        if (folders != null) {
            for (File f : folders) {
                File serverFile;
                if (!f.isDirectory() || !(serverFile = new File(f, "server.xml")).exists()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isLocalhost() {
        return WebSphereServerWizardCommonFragment.isLocalhost(this.getTaskModel());
    }

    public static boolean isLocalhost(TaskModel taskModel) {
        if (taskModel == null) {
            return true;
        }
        IServerWorkingCopy swc = (IServerWorkingCopy)taskModel.getObject("server");
        String host = swc.getHost();
        if (host != null) {
            return SocketUtil.isLocalhost((String)host);
        }
        Trace.logError((String)"The value for host in the server task model is null", (Throwable)new Exception("Host value is null"));
        return true;
    }

    protected List<ServerTypeUIExtension> getServerTypeExtensions() {
        ArrayList<ServerTypeUIExtension> exts = new ArrayList<ServerTypeUIExtension>();
        for (ServerTypeUIExtension ext : ServerTypeUIExtension.getServerTypeUIExtensions()) {
            exts.add(ext);
        }
        return exts;
    }

    protected List<ServerTypeUIExtension> getActiveServerTypeExtensions() {
        TaskModel taskModel = this.getTaskModel();
        ArrayList<ServerTypeUIExtension> exts = new ArrayList<ServerTypeUIExtension>();
        for (ServerTypeUIExtension ext : ServerTypeUIExtension.getServerTypeUIExtensions()) {
            if (!ext.isActive(taskModel)) continue;
            exts.add(ext);
        }
        return exts;
    }
}

