/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.common.core.internal.Trace;
import com.ibm.ws.st.common.ui.ext.internal.servertype.ServerTypeUIExtension;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.wizard.AbstractWebSphereServerComposite;
import com.ibm.ws.st.ui.internal.wizard.IServerWizardComposite;
import com.ibm.ws.st.ui.internal.wizard.WebSphereDefaultServerComposite;
import com.ibm.ws.st.ui.internal.wizard.WebSphereRemoteServerComposite;
import com.ibm.ws.st.ui.internal.wizard.WebSphereServerComposite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class WebSphereServerParentComposite
extends AbstractWebSphereServerComposite {
    protected Label description;
    protected boolean updating;
    protected IWizardHandle wHandle;
    protected Composite parent;
    protected List<ServerTypeUIExtension> activeServerTypeExtensions = new ArrayList<ServerTypeUIExtension>();
    protected TaskModel taskModel;
    protected IServerWizardComposite comp = null;
    protected static final String STAND_ALONE_LIBERTY = Messages.wizServerTypeLibertyServer;
    private final HashMap<String, IServerWizardComposite> compCache = new HashMap();
    protected Map<String, WebSphereServerInfo> serverInfoMap;
    protected Point initialSize = null;

    public WebSphereServerParentComposite(Composite parent, IWizardHandle wizard, List<ServerTypeUIExtension> activeServerTypeExtensions, TaskModel taskModel) {
        super(parent, wizard);
        this.wHandle = wizard;
        this.activeServerTypeExtensions = activeServerTypeExtensions;
        this.taskModel = taskModel;
        if (taskModel != null) {
            taskModel.putObject("com.ibm.ws.st.ui.serverTypeData", (Object)"libertyServer");
        }
        wizard.setTitle(Messages.wizServerTitle);
        wizard.setDescription(Messages.wizServerDescription);
        wizard.setImageDescriptor(Activator.getImageDescriptor("wizServer"));
        this.createControl();
    }

    @Override
    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "com.ibm.ws.st.ui.twnr0000");
        if (this.activeServerTypeExtensions != null && !this.activeServerTypeExtensions.isEmpty()) {
            this.addServerTypeWidget();
        } else {
            this.comp = (IServerWizardComposite)this.getLibertyServerComposite();
            this.setupComposite(this.comp, false);
        }
    }

    @Override
    protected void init() {
        if (this.server == null) {
            return;
        }
        this.updating = true;
        this.server.setDefaults((IProgressMonitor)new NullProgressMonitor());
        this.updating = false;
    }

    @Override
    public void validate() {
        if (this.comp != null) {
            this.comp.validate();
        }
    }

    @Override
    public boolean isComplete() {
        if (this.comp != null) {
            return this.comp.isComplete();
        }
        return false;
    }

    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (this.comp != null) {
            this.comp.performFinish(monitor);
        }
    }

    protected boolean runtimeHasServers() {
        WebSphereRuntime wrt;
        boolean hasServers = true;
        IRuntime rt = (IRuntime)this.taskModel.getObject("runtime");
        if (rt != null && (wrt = (WebSphereRuntime)rt.loadAdapter(WebSphereRuntime.class, null)) != null) {
            wrt.updateServerCache(true);
            hasServers = wrt.hasServers();
        }
        return hasServers;
    }

    private void addServerTypeWidget() {
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.serverType);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Button libertyButton = new Button((Composite)this, 16);
        libertyButton.setText(Messages.wizServerTypeLibertyServer);
        GridData data = new GridData(4, 1, false, false);
        data.horizontalSpan = 2;
        libertyButton.setLayoutData((Object)data);
        libertyButton.setData("com.ibm.ws.st.ui.serverTypeData", (Object)"libertyServer");
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    WebSphereServerParentComposite.this.setServerType((String)button.getData("com.ibm.ws.st.ui.serverTypeData"));
                    if (WebSphereServerParentComposite.this.comp != null) {
                        GridData data = (GridData)WebSphereServerParentComposite.this.comp.getComposite().getLayoutData();
                        if (!data.exclude) {
                            data.exclude = true;
                            WebSphereServerParentComposite.this.comp.getComposite().setVisible(!data.exclude);
                            WebSphereServerParentComposite.this.comp.getComposite().setLayoutData((Object)data);
                        }
                    }
                    String buttonText = ((Button)e.getSource()).getText();
                    WebSphereServerParentComposite.this.comp = WebSphereServerParentComposite.this.getComposite(buttonText);
                    WebSphereServerParentComposite.this.taskModel.putObject("compositeType", (Object)buttonText);
                    WebSphereServerParentComposite.this.updateCompLayout();
                }
                WebSphereServerParentComposite.this.setFocus();
            }
        };
        libertyButton.addSelectionListener((SelectionListener)listener);
        for (ServerTypeUIExtension ext : this.activeServerTypeExtensions) {
            Button button = new Button((Composite)this, 16);
            button.setText(ext.getLabel());
            data = new GridData(4, 1, false, false);
            data.horizontalIndent = label.computeSize((int)-1, (int)-1).x + 7;
            data.horizontalSpan = 3;
            button.setLayoutData((Object)data);
            button.addSelectionListener((SelectionListener)listener);
            button.setData("com.ibm.ws.st.ui.serverTypeData", (Object)ext.getTypeId());
        }
        libertyButton.setSelection(true);
        libertyButton.notifyListeners(13, new Event());
    }

    protected Composite getLibertyServerComposite() {
        if (this.isLocalhost()) {
            if (this.runtimeHasServers()) {
                return new WebSphereServerComposite(this, this.wHandle);
            }
            return new WebSphereDefaultServerComposite(this, this.wHandle, this.taskModel);
        }
        return new WebSphereRemoteServerComposite(this, this.wHandle);
    }

    protected void setupComposite(IServerWizardComposite comp, boolean isIndentationRequired) {
        if (comp != null) {
            comp.setup(this.taskModel);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.verticalAlignment = 4;
            data.widthHint = 400;
            data.grabExcessVerticalSpace = true;
            data.horizontalSpan = 3;
            data.verticalIndent = 7;
            if (isIndentationRequired) {
                data.horizontalIndent = SWTUtil.convertWidthInCharsToPixels(this, 4);
            }
            comp.getComposite().setLayoutData((Object)data);
        }
    }

    protected IServerWizardComposite getComposite(String serverType) {
        IServerWizardComposite comp = this.compCache.get(serverType);
        if (comp == null) {
            comp = this.createComposite(serverType);
            this.compCache.put(serverType, comp);
        }
        return comp;
    }

    protected IServerWizardComposite createComposite(String serverType) {
        if (!serverType.equals(STAND_ALONE_LIBERTY) && this.activeServerTypeExtensions != null) {
            for (ServerTypeUIExtension ext : this.activeServerTypeExtensions) {
                if (!serverType.equals(ext.getLabel())) continue;
                return (IServerWizardComposite)ext.getComposite((Composite)this, this.wHandle, this.taskModel);
            }
        } else {
            return (IServerWizardComposite)this.getLibertyServerComposite();
        }
        return null;
    }

    protected boolean isLocalhost() {
        IServerWorkingCopy swc = (IServerWorkingCopy)this.taskModel.getObject("server");
        String host = swc.getHost();
        if (host != null) {
            return SocketUtil.isLocalhost((String)host);
        }
        Trace.logError((String)"The value for host in the server task model is null", (Throwable)new Exception("Host value is null"));
        return true;
    }

    protected void setServerType(String serverType) {
        WebSphereServer wsServer;
        this.taskModel.putObject("com.ibm.ws.st.ui.serverTypeData", (Object)serverType);
        IServerWorkingCopy swc = (IServerWorkingCopy)this.taskModel.getObject("server");
        if (swc != null && (wsServer = (WebSphereServer)swc.getAdapter(WebSphereServer.class)) != null) {
            wsServer.setServerType(serverType);
        }
    }

    protected void updateChildren(boolean hasServers) {
        if (this.comp != null) {
            GridData data = (GridData)this.comp.getComposite().getLayoutData();
            if (!data.exclude) {
                data.exclude = true;
                this.comp.getComposite().setVisible(!data.exclude);
                this.comp.getComposite().setLayoutData((Object)data);
            }
        }
        for (IServerWizardComposite child : this.compCache.values()) {
            ((Widget)child).dispose();
        }
        this.compCache.clear();
        this.setServerType((String)this.taskModel.getObject("com.ibm.ws.st.ui.serverTypeData"));
        String compositeType = (String)this.taskModel.getObject("compositeType");
        this.comp = compositeType != null ? this.getComposite(compositeType) : this.getComposite(STAND_ALONE_LIBERTY);
        this.updateCompLayout();
        this.setFocus();
    }

    protected void updateCompLayout() {
        this.setupComposite(this.comp, true);
        GridData data = (GridData)this.comp.getComposite().getLayoutData();
        data.exclude = false;
        this.comp.getComposite().setVisible(!data.exclude);
        this.validate();
        this.redraw();
        this.layout(true, true);
        Shell shell = this.getShell();
        shell.layout(true, true);
        if (this.initialSize == null) {
            Boolean preventResize = (Boolean)this.taskModel.getObject("preventResize");
            if (preventResize != null && preventResize.booleanValue()) {
                this.taskModel.putObject("preventResize", (Object)false);
                return;
            }
            this.initialSize = shell.getSize();
        }
        Point newSize = shell.computeSize(this.initialSize.x, -1, true);
        shell.setSize(newSize);
        this.wHandle.update();
    }
}

