/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.wizard.AbstractWebSphereServerComposite;
import com.ibm.ws.st.ui.internal.wizard.NewServerNameWizardFragment;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.w3c.dom.Document;

public class WebSphereServerComposite
extends AbstractWebSphereServerComposite {
    protected Combo serverName;
    protected Label description;
    protected boolean updating;
    protected Map<String, WebSphereServerInfo> serverInfoMap;
    protected IPath lastRuntimeLocation = null;

    protected WebSphereServerComposite(Composite parent, IWizardHandle wizard) {
        super(parent, wizard);
        wizard.setImageDescriptor(Activator.getImageDescriptor("wizServer"));
        this.createControl();
    }

    @Override
    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "com.ibm.ws.st.ui.twnr0000");
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.server);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.serverName = new Combo((Composite)this, 8);
        this.serverName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serverName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebSphereServerInfo serverInfo;
                if (WebSphereServerComposite.this.updating) {
                    return;
                }
                if (WebSphereServerComposite.this.server != null && (serverInfo = WebSphereServerComposite.this.serverInfoMap.get(WebSphereServerComposite.this.serverName.getText())) != null) {
                    WebSphereServerComposite.this.server.setServerName(serverInfo.getServerName());
                    WebSphereServerComposite.this.server.setUserDir(serverInfo.getUserDirectory());
                }
                WebSphereServerComposite.this.setTreeInput();
                WebSphereServerComposite.this.validate();
            }
        });
        Button createNew = SWTUtil.createButton(this, Messages.create);
        createNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebSphereRuntime runtime;
                TaskModel taskModel = new TaskModel();
                taskModel.putObject("runtime", (Object)WebSphereServerComposite.this.serverWC.getRuntime());
                taskModel.putObject("userDirectory", (Object)WebSphereServerComposite.this.userDirectory);
                TaskWizard wizard = new TaskWizard(Messages.wizServerNameTitle, (WizardFragment)new NewServerNameWizardFragment(), taskModel);
                String newServerName = null;
                String newServerNameWithUsrDir = null;
                WizardDialog dialog = new WizardDialog(WebSphereServerComposite.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    newServerName = (String)taskModel.getObject("serverName");
                    UserDirectory userDir = (UserDirectory)taskModel.getObject("userDirectory");
                    WebSphereServerComposite.this.server.setServerName(newServerName);
                    WebSphereServerComposite.this.server.setUserDir(userDir);
                    newServerNameWithUsrDir = NLS.bind((String)Messages.wizServerNameFormat, (Object[])new String[]{newServerName, userDir.getUniqueId()});
                }
                if ((runtime = WebSphereServerComposite.this.server.getWebSphereRuntime()) != null) {
                    WebSphereServerComposite.this.updating = true;
                    String[] serverNames = WebSphereServerComposite.this.getServerNames();
                    WebSphereServerComposite.this.serverName.setItems(serverNames);
                    WebSphereServerComposite.this.serverName.setEnabled(true);
                    WebSphereServerComposite.this.updating = false;
                    if (newServerName != null && WebSphereServerComposite.this.serverInfoMap.get(newServerName) != null) {
                        WebSphereServerComposite.this.serverName.setText(newServerName);
                    } else if (newServerNameWithUsrDir != null && WebSphereServerComposite.this.serverInfoMap.get(newServerNameWithUsrDir) != null) {
                        WebSphereServerComposite.this.serverName.setText(newServerNameWithUsrDir);
                    } else {
                        WebSphereServerComposite.this.initServerName();
                    }
                }
                WebSphereServerComposite.this.monitoredSetTreeInput();
                WebSphereServerComposite.this.validate();
            }
        });
        label = new Label((Composite)this, 0);
        label.setText(Messages.wizServerDescriptionLabel);
        GridData data = new GridData(1, 1, false, false);
        data.verticalIndent = 3;
        label.setLayoutData((Object)data);
        this.description = new Label((Composite)this, 64);
        this.description.setText("");
        data = new GridData(4, 4, true, false);
        data.verticalIndent = 3;
        data.horizontalSpan = 2;
        data.verticalSpan = 2;
        this.description.setLayoutData((Object)data);
        label = new Label((Composite)this, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.createConfigControl(this);
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.serverName.forceFocus();
    }

    protected void setTreeInput() {
        if (this.serverWC == null) {
            return;
        }
        try {
            ConfigurationFile configFile = this.server.getConfiguration();
            String desc = configFile == null ? "" : configFile.getServerDescription();
            Document document = configFile == null ? null : configFile.getDomDocument();
            this.setTreeInput(desc, document);
        }
        catch (Throwable t) {
            Trace.logError("Error loading config tree", t);
        }
    }

    protected void setTreeInput(String desc, Document document) {
        try {
            if (document == null) {
                this.description.setText(desc);
                this.treeViewer.setInput((Object)Messages.configNone);
                return;
            }
            WebSphereRuntime wrt = this.server == null ? null : this.server.getWebSphereRuntime();
            boolean metadataDirExistsBefore = wrt == null ? false : wrt.metadataDirectoryExists();
            this.description.setText(desc);
            this.treeViewer.setInput((Object)document.getDocumentElement());
            if (!metadataDirExistsBefore && wrt != null && wrt.metadataDirectoryExists()) {
                this.addMetaDataRuntimeId(wrt.getRuntime());
            }
        }
        catch (Throwable t) {
            Trace.logError("Error loading config tree", t);
        }
    }

    protected void monitoredSetTreeInput() {
        if (this.serverWC == null) {
            return;
        }
        try {
            this.wizard.run(true, true, new IRunnableWithProgress(){
                protected static final int WAIT = 20;
                protected boolean complete = false;

                protected synchronized void finished() {
                    this.complete = true;
                    this.notifyAll();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block18: {
                        monitor.beginTask(Messages.wizServerRefreshing, 10);
                        try {
                            Document document;
                            String desc;
                            monitor.worked(1);
                            ConfigurationFile configFile = WebSphereServerComposite.this.server.getConfiguration();
                            if (monitor.isCanceled()) {
                                throw new CoreException(Status.CANCEL_STATUS);
                            }
                            monitor.worked(2);
                            String string = desc = configFile == null ? "" : configFile.getServerDescription();
                            if (monitor.isCanceled()) {
                                throw new CoreException(Status.CANCEL_STATUS);
                            }
                            monitor.worked(1);
                            Document document2 = document = configFile == null ? null : configFile.getDomDocument();
                            if (monitor.isCanceled()) {
                                throw new CoreException(Status.CANCEL_STATUS);
                            }
                            monitor.worked(3);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    WebSphereServerComposite.this.setTreeInput(desc, document);
                                    this.finished();
                                }
                            });
                            int count = 0;
                            do {
                                3 var6_7 = this;
                                synchronized (var6_7) {
                                    try {
                                        this.wait(1000L);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (this.complete) {
                                        monitor.worked(3);
                                        break block18;
                                    }
                                }
                                if (!monitor.isCanceled()) continue;
                                throw new CoreException(Status.CANCEL_STATUS);
                            } while (++count <= 20);
                            Trace.logError("Async exec for refreshing the server configuration in the new server wizard timed out for server: " + WebSphereServerComposite.this.server.getServerName(), null);
                        }
                        catch (Exception e) {
                            if (monitor.isCanceled()) {
                                if (Trace.ENABLED) {
                                    Trace.trace((byte)0, "Monitor for refreshing the configuration in the new server wizard was cancelled for server: " + WebSphereServerComposite.this.server.getServerName());
                                }
                            } else {
                                Trace.logError("Error refreshing the configuration in the new server wizard for server: " + WebSphereServerComposite.this.server.getServerName(), e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            Trace.logError("Error refreshing the configuration in the new server wizard for server: " + this.server.getServerName(), e);
        }
    }

    @Override
    protected void init() {
        this.wizard.setTitle(Messages.wizServerTitle);
        this.wizard.setDescription(Messages.wizServerDescription);
        if (this.serverName == null || this.server == null) {
            return;
        }
        this.updating = true;
        this.server.setDefaults((IProgressMonitor)new NullProgressMonitor());
        this.updating = false;
        WebSphereRuntime runtime = this.server.getWebSphereRuntime();
        if (runtime != null) {
            String[] serverNames = this.getServerNames();
            if (serverNames == null || serverNames.length == 0) {
                this.serverName.setEnabled(false);
                this.serverName.removeAll();
            } else {
                this.serverName.setEnabled(true);
                this.serverName.setItems(serverNames);
                this.initServerName();
            }
        } else {
            this.serverName.setItems(new String[]{"error"});
        }
        this.setTreeInput();
    }

    protected String[] getServerNames() {
        WebSphereRuntime runtime = this.server.getWebSphereRuntime();
        if (runtime == null) {
            return new String[0];
        }
        runtime.updateServerCache(true);
        List serverInfos = runtime.getWebSphereServerInfos();
        if (serverInfos == null || serverInfos.size() == 0) {
            return new String[0];
        }
        this.serverInfoMap = new HashMap<String, WebSphereServerInfo>(serverInfos.size());
        for (WebSphereServerInfo serverInfo : serverInfos) {
            String name = serverInfo.getServerName();
            for (WebSphereServerInfo info : serverInfos) {
                if (info.equals(serverInfo) || !info.getServerName().equals(name)) continue;
                name = NLS.bind((String)Messages.wizServerNameFormat, (Object[])new String[]{name, serverInfo.getUserDirectory().getUniqueId()});
                break;
            }
            this.serverInfoMap.put(name, serverInfo);
        }
        Set<String> serverNames = this.serverInfoMap.keySet();
        String[] names = serverNames.toArray(new String[serverNames.size()]);
        Arrays.sort(names, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        return names;
    }

    protected void initServerName() {
        String[] serverNames;
        for (String name : serverNames = this.getServerNames()) {
            if (name == null || this.isServerInUse(name).booleanValue()) continue;
            this.serverName.setText(name);
            return;
        }
    }

    @Override
    public void validate() {
        IStatus status = WebSphereServerComposite.validate(this.server);
        if (status == null || status.isOK()) {
            this.wizard.setMessage(null, 0);
        } else if (status.getSeverity() == 2) {
            this.wizard.setMessage(status.getMessage(), 2);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
        this.wizard.update();
    }

    protected static IStatus validate(WebSphereServer server) {
        if (server == null) {
            return new Status(4, "com.ibm.ws.st.ui", "");
        }
        if (server.getServerName() == null) {
            return new Status(4, "com.ibm.ws.st.ui", Messages.errorNoServers);
        }
        IStatus status = server.validate();
        if (status == null || status.isOK()) {
            String serverName = server.getServerName();
            UserDirectory userDir = server.getUserDirectory();
            if (serverName != null && serverName.trim().length() > 0) {
                WebSphereServer[] servers;
                for (WebSphereServer serv : servers = WebSphereUtil.getWebSphereServers()) {
                    UserDirectory dir = serv.getUserDirectory();
                    if (!serverName.equals(serv.getServerName()) || (userDir != null || dir != null) && (userDir == null || !userDir.equals((Object)dir)) || !server.getServer().getRuntime().equals(serv.getServer().getRuntime())) continue;
                    return new Status(4, "com.ibm.ws.st.ui", NLS.bind((String)Messages.warningServerAlreadyDefined, (Object)serverName, (Object)serv.getServer().getName()));
                }
            }
        }
        return status;
    }

    private Boolean isServerInUse(String serverName) {
        WebSphereServerInfo server = this.serverInfoMap.get(serverName);
        UserDirectory userDir = server.getUserDirectory();
        if (serverName != null && serverName.trim().length() > 0) {
            WebSphereServer[] servers;
            for (WebSphereServer serv : servers = WebSphereUtil.getWebSphereServers()) {
                UserDirectory dir = serv.getUserDirectory();
                if (!server.getServerName().equals(serv.getServerName()) || (userDir != null || dir != null) && (userDir == null || !userDir.equals((Object)dir)) || !server.getWebSphereRuntime().getRuntime().equals(serv.getServer().getRuntime())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        this.removeGeneratedMetaData(this.server.getWebSphereRuntime().getRuntime());
    }

    @Override
    public boolean isComplete() {
        if (this.server.getServer() == null) {
            return false;
        }
        WebSphereServer wsServer = this.server;
        if (wsServer == null) {
            return false;
        }
        WebSphereRuntime wr = wsServer.getWebSphereRuntime();
        if (wr != null) {
            if (this.lastRuntimeLocation == null) {
                this.lastRuntimeLocation = wr.getRuntimeLocation();
            } else if (wr.getRuntimeLocation() != null && !this.lastRuntimeLocation.equals((Object)wr.getRuntimeLocation())) {
                wr.resetRuntimeServerInfo();
                this.lastRuntimeLocation = wr.getRuntimeLocation();
            }
        }
        wsServer.setDefaults(null);
        IStatus status = WebSphereServerComposite.validate(wsServer);
        return status == null || status.isOK();
    }
}

