/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.ContentAssistCombo;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.download.IRuntimeHandler;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import com.ibm.ws.st.ui.internal.download.ValidationResult;
import com.ibm.ws.st.ui.internal.wizard.RuntimeAdvancedDialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WebSphereRuntimeComposite
extends Composite {
    protected IMessageHandler messageHandler;
    protected Mode mode;
    protected ContentAssistCombo installDir;
    protected Text name;
    protected Combo combo;
    protected Button jreUseSpecific;
    protected Button jreUseDefault;
    protected List<IVMInstall> installedJREs;
    protected String[] jreNames;
    protected boolean updating;
    protected String runtimeTypeId;
    protected Link advancedLink;
    protected Button installUseNew;
    protected Button installUseExisting;
    protected IRuntimeHandler runtimeHandler;
    protected IDownloadRequestHandler requestHandler;
    protected boolean isDownloading;

    public WebSphereRuntimeComposite(Composite parent, IMessageHandler handler, Mode mode, IDownloadRequestHandler reqHandler) {
        super(parent, 0);
        this.messageHandler = handler;
        this.requestHandler = reqHandler;
        this.mode = mode;
        this.createControl();
    }

    public void setRuntimeHandler(IRuntimeHandler runtimeHandler) {
        this.runtimeHandler = runtimeHandler;
        this.init();
        this.validate();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "com.ibm.ws.st.ui.twnr0000");
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.name);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.name = new Text((Composite)this, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (WebSphereRuntimeComposite.this.updating) {
                    return;
                }
                WebSphereRuntimeComposite.this.runtimeHandler.setRuntimeName(WebSphereRuntimeComposite.this.name.getText());
                WebSphereRuntimeComposite.this.validate();
            }
        });
        label = new Label((Composite)this, 258);
        label.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        label.setVisible(false);
        label = new Label((Composite)this, 0);
        label.setText(Messages.runtimeCreateOptionLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        Composite installGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        installGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        installGroup.setLayoutData((Object)data);
        this.installUseExisting = new Button(installGroup, 16);
        this.installUseExisting.setText(Messages.runtimeExistingDirLabel);
        this.installUseExisting.setLayoutData((Object)new GridData(4, 1, true, true, 3, 1));
        this.installUseExisting.setSelection(true);
        Label pathLabel = new Label(installGroup, 0);
        pathLabel.setText(Messages.runtimeInstallPath);
        data = new GridData(4, 0x1000000, false, false);
        data.horizontalIndent = 20;
        pathLabel.setLayoutData((Object)data);
        this.installDir = new ContentAssistCombo(installGroup, new RuntimeLocationContentProvider());
        this.installDir.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.installDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (WebSphereRuntimeComposite.this.updating) {
                    return;
                }
                WebSphereRuntimeComposite.this.runtimeHandler.setLocation((IPath)new Path(WebSphereRuntimeComposite.this.installDir.getText()));
                WebSphereRuntimeComposite.this.validate();
            }
        });
        final Button browse = SWTUtil.createButton(installGroup, Messages.browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(WebSphereRuntimeComposite.this.getShell());
                dialog.setMessage(Messages.runtimeInstallMessage);
                dialog.setFilterPath(WebSphereRuntimeComposite.this.installDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    WebSphereRuntimeComposite.this.installDir.setTextAndSuggest(selectedDirectory);
                }
            }
        });
        this.installUseNew = new Button(installGroup, 16);
        if (SiteHelper.downloadAndInstallSupported()) {
            this.installUseNew.setText(Messages.runtimeNewDirLabel);
        } else {
            this.installUseNew.setText(Messages.runtimeArchiveInstallLabel);
        }
        this.installUseNew.setLayoutData((Object)new GridData(4, 1, true, true, 3, 1));
        if (this.mode == Mode.ARCHIVE) {
            this.installUseExisting.setSelection(false);
            this.installUseNew.setSelection(true);
            this.installUseExisting.setEnabled(false);
        } else {
            this.installUseExisting.setSelection(true);
            this.installUseNew.setSelection(false);
            if (this.mode == Mode.EXISTING_FOLDER) {
                this.installUseNew.setEnabled(false);
            }
        }
        this.installUseExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WebSphereRuntimeComposite.this.installUseExisting.getSelection()) {
                    WebSphereRuntimeComposite.this.isDownloading = false;
                    WebSphereRuntimeComposite.this.requestHandler.downloadRequested(false);
                } else {
                    WebSphereRuntimeComposite.this.isDownloading = true;
                    WebSphereRuntimeComposite.this.requestHandler.downloadRequested(true);
                }
                WebSphereRuntimeComposite.this.installDir.setEnabled(!WebSphereRuntimeComposite.this.isDownloading);
                browse.setEnabled(!WebSphereRuntimeComposite.this.isDownloading);
                WebSphereRuntimeComposite.this.validate();
            }
        });
        if (this.mode == Mode.EXISTING_FOLDER || this.mode == Mode.ARCHIVE) {
            this.installDir.setEnabled(false);
            browse.setEnabled(false);
        }
        label = new Label((Composite)this, 258);
        label.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        label.setVisible(false);
        this.updateJREs();
        Group jreGroup = new Group((Composite)this, 0);
        jreGroup.setText(Messages.runtimeJREGroup);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        jreGroup.setLayout((Layout)layout);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        jreGroup.setLayoutData((Object)data);
        this.jreUseSpecific = new Button((Composite)jreGroup, 16);
        this.jreUseSpecific.setText(Messages.runtimeJRESpecific);
        this.jreUseSpecific.setLayoutData((Object)new GridData(256));
        this.combo = new Combo((Composite)jreGroup, 12);
        this.combo.setItems(this.jreNames);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = 50;
        this.combo.setLayoutData((Object)data);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WebSphereRuntimeComposite.this.updating) {
                    return;
                }
                int sel = WebSphereRuntimeComposite.this.combo.getSelectionIndex();
                IVMInstall vmInstall = null;
                if (sel >= 0) {
                    vmInstall = WebSphereRuntimeComposite.this.installedJREs.get(sel);
                }
                WebSphereRuntimeComposite.this.runtimeHandler.getRuntime().setVMInstall(vmInstall);
                WebSphereRuntimeComposite.this.validate();
            }
        });
        this.jreUseDefault = new Button((Composite)jreGroup, 16);
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        this.jreUseDefault.setText(NLS.bind((String)Messages.runtimeJREDefault, (Object)vmInstall.getName()));
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        this.jreUseDefault.setLayoutData((Object)data);
        this.jreUseDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WebSphereRuntimeComposite.this.jreUseDefault.getSelection()) {
                    WebSphereRuntimeComposite.this.combo.setEnabled(false);
                    WebSphereRuntimeComposite.this.runtimeHandler.getRuntime().setVMInstall(null);
                } else {
                    WebSphereRuntimeComposite.this.combo.setEnabled(true);
                    int sel = WebSphereRuntimeComposite.this.combo.getSelectionIndex();
                    IVMInstall vmInstall = null;
                    if (sel >= 0) {
                        vmInstall = WebSphereRuntimeComposite.this.installedJREs.get(sel);
                    }
                    WebSphereRuntimeComposite.this.runtimeHandler.getRuntime().setVMInstall(vmInstall);
                }
                WebSphereRuntimeComposite.this.validate();
            }
        });
        Link link = new Link((Composite)jreGroup, 0);
        link.setText("<a>" + Messages.runtimeJREConfigure + "</a>");
        link.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = WebSphereRuntimeComposite.this.combo.getText();
                if (WebSphereRuntimeComposite.this.showPreferencePage()) {
                    WebSphereRuntimeComposite.this.updateJREs();
                    WebSphereRuntimeComposite.this.combo.setItems(WebSphereRuntimeComposite.this.jreNames);
                    WebSphereRuntimeComposite.this.combo.setText(currentVM);
                    if (WebSphereRuntimeComposite.this.combo.getSelectionIndex() == -1) {
                        WebSphereRuntimeComposite.this.combo.select(0);
                    }
                    IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
                    WebSphereRuntimeComposite.this.jreUseDefault.setText(NLS.bind((String)Messages.runtimeJREDefault, (Object)vmInstall.getName()));
                    WebSphereRuntimeComposite.this.validate();
                }
            }
        });
        this.advancedLink = new Link((Composite)this, 0);
        this.advancedLink.setText("<a>" + Messages.runtimeAdvancedLink + "</a>");
        data = new GridData(131072, 0x1000000, false, false);
        data.horizontalSpan = 2;
        this.advancedLink.setLayoutData((Object)data);
        this.advancedLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeAdvancedDialog dialog = new RuntimeAdvancedDialog(WebSphereRuntimeComposite.this.getShell(), WebSphereRuntimeComposite.this.runtimeHandler.getRuntime());
                dialog.open();
            }
        });
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void updateJREs() {
        int i;
        this.installedJREs = new ArrayList<IVMInstall>();
        IVMInstallType[] vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int size = vmInstallTypes.length;
        for (i = 0; i < size; ++i) {
            IVMInstall[] vmInstalls = vmInstallTypes[i].getVMInstalls();
            int size2 = vmInstalls.length;
            for (int j = 0; j < size2; ++j) {
                this.installedJREs.add(vmInstalls[j]);
            }
        }
        size = this.installedJREs.size();
        this.jreNames = new String[size];
        for (i = 0; i < size; ++i) {
            IVMInstall vmInstall = this.installedJREs.get(i);
            this.jreNames[i] = vmInstall.getName();
        }
    }

    protected boolean showPreferencePage() {
        String id = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage").findSubNode(id);
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager2);
        dialog.create();
        return dialog.open() == 0;
    }

    private void init() {
        if (this.name == null || this.runtimeHandler == null || this.runtimeHandler.getRuntime() == null) {
            return;
        }
        this.updating = true;
        if (this.runtimeHandler.getRuntimeName() != null) {
            this.name.setText(this.runtimeHandler.getRuntimeName());
        } else {
            this.name.setText("");
        }
        this.runtimeTypeId = this.runtimeHandler.getRuntimeTypeId();
        if (this.runtimeHandler.getLocation() != null && !this.runtimeHandler.getLocation().isEmpty()) {
            this.installDir.setText(this.runtimeHandler.getLocation().toOSString());
        } else {
            this.installDir.setText("");
        }
        if (this.runtimeHandler.getRuntime().isUsingDefaultJRE()) {
            this.combo.setEnabled(false);
            this.jreUseDefault.setSelection(true);
            this.combo.select(0);
        } else {
            this.combo.setEnabled(true);
            this.jreUseSpecific.setSelection(true);
            boolean found = false;
            int size = this.installedJREs.size();
            for (int i = 0; i < size; ++i) {
                IVMInstall vmInstall = this.installedJREs.get(i);
                if (!vmInstall.equals(this.runtimeHandler.getRuntime().getVMInstall())) continue;
                this.combo.select(i);
                found = true;
            }
            if (!found) {
                this.combo.select(0);
            }
        }
        this.updating = false;
    }

    protected void validate() {
        if (this.runtimeHandler != null) {
            ValidationResult result = this.runtimeHandler.validateRuntime(this.mode == Mode.ARCHIVE || this.isDownloading);
            this.processValidationResult(result.getMessage(), result.getLevel());
        } else {
            this.processValidationResult(null, 3);
        }
    }

    private void processValidationResult(String message, int level) {
        this.messageHandler.setMessage(message, level);
        this.advancedLink.setEnabled(level == 0);
    }

    public static interface IMessageHandler {
        public void setMessage(String var1, int var2);
    }

    public static interface IDownloadRequestHandler {
        public void downloadRequested(boolean var1);
    }

    public static enum Mode {
        NEW_FOLDER,
        EXISTING_FOLDER,
        ARCHIVE,
        EDIT;

    }

    protected class RuntimeLocationContentProvider
    extends ContentAssistCombo.ContentProvider {
        protected RuntimeLocationContentProvider() {
        }

        @Override
        public String[] getSuggestions(String hint, boolean showAll) {
            List<String> previousLocations = Activator.getPreferenceList(WebSphereRuntimeComposite.this.runtimeTypeId + ".folder");
            if (hint == null || hint.isEmpty()) {
                return previousLocations.toArray(new String[previousLocations.size()]);
            }
            ArrayList<String> suggestions = new ArrayList<String>();
            List suggestedPaths = WebSphereRuntime.findValidLocations((IPath)new Path(hint));
            if (suggestedPaths != null) {
                for (IPath path : suggestedPaths) {
                    try {
                        suggestions.add(path.toFile().getCanonicalPath());
                    }
                    catch (IOException e) {
                        suggestions.add(path.toOSString());
                    }
                }
            }
            for (String previousLocation : previousLocations) {
                Path previousPath = new Path(previousLocation);
                if (suggestedPaths != null && this.matchPathsByFile((IPath)previousPath, suggestedPaths) || !showAll && !WebSphereRuntimeComposite.this.installDir.matches(previousPath.toPortableString())) continue;
                suggestions.add(previousPath.toOSString());
            }
            return suggestions.toArray(new String[suggestions.size()]);
        }

        private boolean matchPathsByFile(IPath thePath, List<IPath> pathList) {
            for (IPath item : pathList) {
                if (!item.toFile().equals(thePath.toFile())) continue;
                return true;
            }
            return false;
        }
    }
}

