/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.remote.RemoteUtils;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.wizard.AbstractRemoteServerComposite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.w3c.dom.Document;

public class WebSphereRemoteServerComposite
extends AbstractRemoteServerComposite {
    Group connectionInfo;
    Text userText;
    Text passwordText;
    Text portText;
    Button connectButton;
    Label remoteServerOutputPath;
    String userName;
    String pass;
    String portNum;
    boolean isComplete = false;

    protected WebSphereRemoteServerComposite(Composite parent, IWizardHandle wizard) {
        super(parent, wizard);
        wizard.setTitle(Messages.wizRemoteServerTitle);
        wizard.setImageDescriptor(Activator.getImageDescriptor("wizServer"));
        this.createControl();
    }

    @Override
    protected void setServer(IServerWorkingCopy newServer, UserDirectory userDir) {
        super.setServer(newServer, userDir);
        this.wizard.setDescription(NLS.bind((String)Messages.wizRemoteServerDescription, (Object)this.server.getServer().getHost()));
        this.connectionInfo.pack(true);
        this.connectionInfo.redraw();
        this.layout(true);
    }

    @Override
    protected void createControl() {
        this.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.setLayoutData(layoutData);
        this.connectionInfo = new Group((Composite)this, 0);
        this.connectionInfo.setText(Messages.wizRemoteConnectionGroup);
        int numCols = 3;
        GridLayout layout = new GridLayout(numCols, false);
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        this.connectionInfo.setLayout((Layout)layout);
        layoutData = new GridData(768);
        this.connectionInfo.setLayoutData((Object)layoutData);
        Label label = new Label((Composite)this.connectionInfo, 0);
        label.setText(Messages.wizRemoteUserLabel);
        this.userText = new Text((Composite)this.connectionInfo, 2048);
        this.userText.setText("");
        this.userText.forceFocus();
        layoutData = new GridData(4, 0x1000000, true, false);
        this.userText.setLayoutData((Object)layoutData);
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WebSphereRemoteServerComposite.this.isComplete = false;
                WebSphereRemoteServerComposite.this.validate();
            }
        });
        label = new Label((Composite)this.connectionInfo, 0);
        label = new Label((Composite)this.connectionInfo, 0);
        label.setText(Messages.wizRemotePasswordLabel);
        this.passwordText = new Text((Composite)this.connectionInfo, 0x400800);
        this.passwordText.setText("");
        layoutData = new GridData(4, 0x1000000, true, false);
        this.passwordText.setLayoutData((Object)layoutData);
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WebSphereRemoteServerComposite.this.isComplete = false;
                WebSphereRemoteServerComposite.this.validate();
            }
        });
        label = new Label((Composite)this.connectionInfo, 0);
        label = new Label((Composite)this.connectionInfo, 0);
        label.setText(Messages.wizRemotePortLabel);
        this.portText = new Text((Composite)this.connectionInfo, 2048);
        this.portText.setText("");
        layoutData = new GridData(4, 0x1000000, true, false);
        this.portText.setLayoutData((Object)layoutData);
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WebSphereRemoteServerComposite.this.isComplete = false;
                WebSphereRemoteServerComposite.this.validate();
            }
        });
        this.connectButton = new Button((Composite)this.connectionInfo, 0);
        this.connectButton.setText(Messages.wizRemoteConnect);
        this.connectButton.setToolTipText(Messages.wizRemoteConnectTooltip);
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebSphereRemoteServerComposite.this.validate();
                if (WebSphereRemoteServerComposite.this.wizard.getMessage() != null) {
                    return;
                }
                MultiStatus multiStatus = WebSphereRemoteServerComposite.this.remoteConfigSetup(null);
                if (WebSphereRemoteServerComposite.this.serverConfigDir != null) {
                    WebSphereRemoteServerComposite.this.remoteServerOutputPath.setText(WebSphereRemoteServerComposite.this.serverConfigDir);
                } else {
                    WebSphereRemoteServerComposite.this.remoteServerOutputPath.setText("");
                }
                WebSphereRemoteServerComposite.this.remoteServerOutputPath.getParent().layout();
                if (multiStatus.isOK()) {
                    WebSphereRemoteServerComposite.this.isComplete = true;
                    WebSphereRemoteServerComposite.this.userName = WebSphereRemoteServerComposite.this.userText.getText();
                    WebSphereRemoteServerComposite.this.pass = WebSphereRemoteServerComposite.this.passwordText.getText();
                    WebSphereRemoteServerComposite.this.portNum = WebSphereRemoteServerComposite.this.portText.getText();
                    WebSphereRemoteServerComposite.this.setTreeInput();
                } else {
                    WebSphereRemoteServerComposite.this.isComplete = false;
                    for (IStatus status : multiStatus.getChildren()) {
                        if (status == null || status.isOK()) continue;
                        WebSphereRemoteServerComposite.this.wizard.setMessage(status.getMessage(), 3);
                        break;
                    }
                    WebSphereRemoteServerComposite.this.setTreeInput(null);
                }
                WebSphereRemoteServerComposite.this.wizard.update();
            }
        });
        this.createConfigControl(this);
        label = new Label((Composite)this, 0);
        label.setText(Messages.wizRemoteDirectoryLabel);
        this.remoteServerOutputPath = new Label((Composite)this, 0);
        this.remoteServerOutputPath.setText("");
        label = new Label((Composite)this, 0);
        Composite fileSyncComposite = new Composite((Composite)this, 0);
        layout = new GridLayout(numCols, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        fileSyncComposite.setLayout((Layout)layout);
        layoutData = new GridData(768);
        fileSyncComposite.setLayoutData((Object)layoutData);
        label = new Label(fileSyncComposite, 64);
        label.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
        layoutData = new GridData(1, 1, false, false);
        label.setLayoutData((Object)layoutData);
        Text text = new Text(fileSyncComposite, 72);
        text.setBackground(fileSyncComposite.getBackground());
        text.setForeground(fileSyncComposite.getForeground());
        text.setText(Messages.infoOnlyServerConfigSynchronized);
        layoutData = new GridData(4, 1, true, false);
        layoutData.widthHint = 500;
        text.setLayoutData((Object)layoutData);
    }

    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        this.createUserDir(RemoteUtils.generateRemoteUsrDirName((WebSphereRuntime)this.server.getWebSphereRuntime()), monitor);
        this.saveCredentials();
    }

    @Override
    protected String getHost() {
        return this.server.getServer().getHost();
    }

    @Override
    protected String getUserId() {
        return this.userText.getText();
    }

    @Override
    protected String getUserPassword() {
        return this.passwordText.getText();
    }

    @Override
    protected String getPort() {
        return this.portText.getText();
    }

    @Override
    protected void performCancel() {
        this.discardTemporaryFiles();
    }

    private void saveCredentials() {
        this.server.setLooseConfigEnabled(false);
        this.server.setServerPassword(this.pass);
        this.server.setServerUserName(this.userName);
        this.server.setServerSecurePort(this.portNum);
    }

    @Override
    protected void init() {
        if (this.server == null) {
            return;
        }
        this.server.setDefaults((IProgressMonitor)new NullProgressMonitor());
        this.server.setLooseConfigEnabled(false);
        this.server.setStopTimeout(60);
    }

    @Override
    public void validate() {
        String user = this.userText.getText();
        if (user == null || user.length() < 1) {
            this.wizard.setMessage(Messages.wizRemoteUserNotSet, 3);
            this.wizard.update();
            return;
        }
        String password = this.passwordText.getText();
        if (password == null || password.length() < 1) {
            this.wizard.setMessage(Messages.wizRemotePasswordNotSet, 3);
            this.wizard.update();
            return;
        }
        String port = this.portText.getText();
        try {
            if (port == null || port.length() < 1 || Integer.parseInt(this.portText.getText()) < 1) {
                this.wizard.setMessage(Messages.wizRemotePortNotSet, 3);
                this.wizard.update();
                return;
            }
        }
        catch (Throwable t) {
            this.wizard.setMessage(Messages.wizRemotePortNotSet, 3);
            this.wizard.update();
            return;
        }
        this.wizard.setMessage(null, 0);
        this.wizard.update();
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    protected void setTreeInput() {
        if (this.serverWC == null) {
            return;
        }
        Document document = this.getServerConfigDocument();
        this.setTreeInput(document);
    }

    protected void setTreeInput(Document document) {
        try {
            if (document == null) {
                this.treeViewer.setInput((Object)Messages.configNone);
                return;
            }
            WebSphereRuntime wrt = this.server == null ? null : this.server.getWebSphereRuntime();
            boolean metadataDirExistsBefore = wrt == null ? false : wrt.metadataDirectoryExists();
            this.treeViewer.setInput((Object)document.getDocumentElement());
            if (!metadataDirExistsBefore && wrt != null && wrt.metadataDirectoryExists()) {
                this.addMetaDataRuntimeId(wrt.getRuntime());
            }
        }
        catch (Throwable t) {
            Trace.logError((String)"Error loading config tree", (Throwable)t);
        }
    }
}

