/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.wizard.NewUserDirProjectWizard;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UserDirWizardPage
extends WizardPage {
    protected boolean projectOptionSelected = true;
    protected Table projectTable;
    protected IProject selectedProject;
    protected IPath selectedPath;

    public UserDirWizardPage() {
        super("userDir", Messages.wizUserDirTitle, null);
        this.setDescription(Messages.wizUserDirDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        comp.setLayout((Layout)layout);
        Label message = new Label(comp, 64);
        message.setText(Messages.wizUserDirMessage);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        message.setLayoutData((Object)data);
        Point p = message.computeSize(200, -1);
        message.setSize(p);
        final Button projectOption = new Button(comp, 16);
        projectOption.setText(Messages.wizUserDirProject);
        data = new GridData(1, 1, true, false);
        data.horizontalSpan = 2;
        projectOption.setLayoutData((Object)data);
        this.projectTable = new Table(comp, 67588);
        data = new GridData(4, 4, true, true);
        data.horizontalIndent = 15;
        this.projectTable.setLayoutData((Object)data);
        this.projectTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] ti = UserDirWizardPage.this.projectTable.getSelection();
                if (ti == null || ti.length != 1) {
                    return;
                }
                UserDirWizardPage.this.selectedProject = (IProject)ti[0].getData();
                UserDirWizardPage.this.setPageComplete(UserDirWizardPage.this.validate());
            }
        });
        this.updateUserDirProjects();
        final Button newProject = SWTUtil.createButton(comp, Messages.create);
        newProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                NewUserDirProjectWizard wizard = new NewUserDirProjectWizard();
                WizardDialog dialog = new WizardDialog(UserDirWizardPage.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 1) {
                    return;
                }
                UserDirWizardPage.this.updateUserDirProjects();
                for (TableItem ti : items = UserDirWizardPage.this.projectTable.getItems()) {
                    IProject p = (IProject)ti.getData();
                    if (!wizard.getProject().equals(p)) continue;
                    UserDirWizardPage.this.projectTable.setSelection(ti);
                    UserDirWizardPage.this.selectedProject = (IProject)ti.getData();
                    UserDirWizardPage.this.setPageComplete(UserDirWizardPage.this.validate());
                    return;
                }
            }
        });
        Button externalOption = new Button(comp, 16);
        externalOption.setText(Messages.wizUserDirExternal);
        data = new GridData(1, 1, true, false);
        data.horizontalSpan = 2;
        externalOption.setLayoutData((Object)data);
        final Text folder = new Text(comp, 2048);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 15;
        folder.setLayoutData((Object)data);
        folder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserDirWizardPage.this.selectedPath = new Path(folder.getText());
                UserDirWizardPage.this.setPageComplete(UserDirWizardPage.this.validate());
            }
        });
        final Button browse = SWTUtil.createButton(comp, Messages.browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(UserDirWizardPage.this.getShell());
                dialog.setMessage(Messages.wizUserDirExternalBrowse);
                dialog.setFilterPath(folder.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    folder.setText(selectedDirectory);
                }
            }
        });
        final Label externalWarning = new Label(comp, 64);
        externalWarning.setText(Messages.wizUserDirExternalMessage);
        data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        data.horizontalIndent = 15;
        externalWarning.setLayoutData((Object)data);
        p = externalWarning.computeSize(200, -1);
        externalWarning.setSize(p);
        projectOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserDirWizardPage.this.projectOptionSelected = projectOption.getSelection();
                UserDirWizardPage.this.projectTable.setEnabled(UserDirWizardPage.this.projectOptionSelected);
                newProject.setEnabled(UserDirWizardPage.this.projectOptionSelected);
                folder.setEnabled(!UserDirWizardPage.this.projectOptionSelected);
                browse.setEnabled(!UserDirWizardPage.this.projectOptionSelected);
                externalWarning.setEnabled(!UserDirWizardPage.this.projectOptionSelected);
                UserDirWizardPage.this.setPageComplete(UserDirWizardPage.this.validate());
            }
        });
        Dialog.applyDialogFont((Control)comp);
        projectOption.setSelection(true);
        this.projectTable.setEnabled(true);
        newProject.setEnabled(true);
        folder.setEnabled(false);
        browse.setEnabled(false);
        externalWarning.setEnabled(false);
        this.setControl((Control)comp);
        this.setPageComplete(this.validate());
    }

    protected void updateUserDirProjects() {
        IProject[] projects;
        this.projectTable.removeAll();
        for (IProject p : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (!p.getFolder("servers").exists() || !p.getFolder("shared").exists()) continue;
            TableItem item = new TableItem(this.projectTable, 0);
            item.setData((Object)p);
            item.setImage(Activator.getImage("userProject"));
            item.setText(p.getName());
        }
    }

    protected boolean validate() {
        if (this.projectOptionSelected) {
            if (this.selectedProject == null) {
                this.setMessage(null, 0);
                return false;
            }
        } else {
            if (this.selectedPath == null || this.selectedPath.toFile() == null) {
                this.setMessage(null, 0);
                return false;
            }
            File f = this.selectedPath.toFile();
            if (!f.exists()) {
                this.setMessage(Messages.wizUserDirExternalInvalid, 3);
                return false;
            }
        }
        this.setMessage(null, 0);
        return true;
    }

    public IPath getPath() {
        return this.selectedPath;
    }

    public IProject getProject() {
        return this.selectedProject;
    }
}

