/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.wizard.UserDirWizard;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;

public class RuntimeAdvancedDialog
extends TitleAreaDialog {
    protected WebSphereRuntime runtime;
    protected Table userDirTable;
    protected Button clearCacheButton;
    protected Image projectErrorImage;
    protected Image folderErrorImage;

    public RuntimeAdvancedDialog(Shell parentShell, WebSphereRuntime runtime) {
        super(parentShell);
        this.runtime = runtime;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.title);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(Activator.getImage("wizRuntime"));
        this.setTitle(Messages.runtimeAdvancedTitle);
        this.setMessage(Messages.runtimeAdvancedDescription);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Group userDirGroup = new Group(composite, 0);
        userDirGroup.setText(Messages.runtimeUserDirGroup);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        userDirGroup.setLayout((Layout)layout);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        userDirGroup.setLayoutData((Object)data);
        this.userDirTable = new Table((Composite)userDirGroup, 67588);
        data = new GridData(4, 4, true, false);
        data.heightHint = 60;
        data.verticalSpan = 2;
        this.userDirTable.setLayoutData((Object)data);
        Button userDirNew = SWTUtil.createButton((Composite)userDirGroup, Messages.create);
        userDirNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserDirWizard wizard = new UserDirWizard();
                WizardDialog dialog = new WizardDialog(RuntimeAdvancedDialog.this.getShell(), (IWizard)wizard);
                dialog.setPageSize(425, 275);
                if (dialog.open() == 1) {
                    return;
                }
                IProject project = wizard.getProject();
                if (project != null) {
                    RuntimeAdvancedDialog.this.runtime.addUserDirectory(project);
                } else {
                    RuntimeAdvancedDialog.this.runtime.addUserDirectory(wizard.getPath());
                }
                RuntimeAdvancedDialog.this.updateUserDirs();
            }
        });
        final Button userDirRemove = SWTUtil.createButton((Composite)userDirGroup, Messages.remove);
        userDirRemove.setEnabled(false);
        userDirRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] ti = RuntimeAdvancedDialog.this.userDirTable.getSelection();
                if (ti == null || ti.length != 1) {
                    return;
                }
                UserDirectory ud = (UserDirectory)ti[0].getData();
                RuntimeAdvancedDialog.this.runtime.removeUserDirectory(ud);
                RuntimeAdvancedDialog.this.updateUserDirs();
                userDirRemove.setEnabled(false);
            }
        });
        this.userDirTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] ti = RuntimeAdvancedDialog.this.userDirTable.getSelection();
                UserDirectory ud = null;
                boolean enabled = false;
                if (ti != null && ti.length == 1) {
                    ud = (UserDirectory)ti[0].getData();
                    IPath runtimeLocation = RuntimeAdvancedDialog.this.runtime.getRuntime().getLocation();
                    if (runtimeLocation == null || !ud.getPath().equals((Object)runtimeLocation.append("usr"))) {
                        enabled = true;
                    }
                }
                RuntimeAdvancedDialog.this.setMessage(Messages.runtimeAdvancedDescription, 0);
                if (ud != null) {
                    if (ud.getProject() != null) {
                        if (!ud.getProject().exists()) {
                            RuntimeAdvancedDialog.this.setMessage(Messages.runtimeUserDirNotFound, 3);
                        }
                    } else if (!ud.getPath().toFile().exists()) {
                        RuntimeAdvancedDialog.this.setMessage(Messages.runtimeUserDirNotFound, 3);
                    }
                }
                userDirRemove.setEnabled(enabled);
            }
        });
        Image img = Activator.getImage("userProject");
        this.projectErrorImage = new Image(img.getDevice(), img.getBounds());
        GC gc = new GC((Drawable)this.projectErrorImage);
        gc.drawImage(img, 0, 0);
        gc.drawImage(Activator.getImage("errorOverlay"), 0, 0);
        gc.dispose();
        img = Activator.getImage("userFolder");
        this.folderErrorImage = new Image(img.getDevice(), img.getBounds());
        gc = new GC((Drawable)this.folderErrorImage);
        gc.drawImage(img, 0, 0);
        gc.drawImage(Activator.getImage("errorOverlay"), 0, 0);
        gc.dispose();
        this.userDirTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                RuntimeAdvancedDialog.this.projectErrorImage.dispose();
                RuntimeAdvancedDialog.this.folderErrorImage.dispose();
            }
        });
        final Label label = new Label(composite, 64);
        IRuntime rt = this.runtime.getRuntime();
        boolean enable = !rt.isWorkingCopy() || ((IRuntimeWorkingCopy)rt).getOriginal() != null;
        label.setText(this.timestampString(enable));
        data = new GridData(4, 1, true, false);
        data.widthHint = 250;
        label.setLayoutData((Object)data);
        this.clearCacheButton = SWTUtil.createButton(composite, Messages.runtimeCacheRefresh);
        ((GridData)this.clearCacheButton.getLayoutData()).horizontalAlignment = 1;
        this.clearCacheButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeAdvancedDialog.this.refreshRuntime(label);
            }
        });
        this.clearCacheButton.setEnabled(enable);
        this.init();
        return composite;
    }

    void refreshRuntime(final Label label) {
        this.runtime.generateMetadata((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                try {
                    if (event.getResult().isOK()) {
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    String s = RuntimeAdvancedDialog.this.timestampString(true);
                                    if (Trace.ENABLED) {
                                        Trace.trace((byte)0, "Metadata regeneration complete at " + s);
                                    }
                                    label.setText(s);
                                    RuntimeAdvancedDialog.this.runtime.fireMetadataRefreshEvent();
                                }
                                catch (SWTException sWTException) {
                                    // empty catch block
                                }
                            }
                        };
                        Display.getDefault().asyncExec(r);
                    }
                }
                finally {
                    event.getJob().removeJobChangeListener((IJobChangeListener)this);
                }
            }
        }, true, 15);
    }

    String timestampString(boolean enabled) {
        String s;
        block9: {
            s = "";
            if (enabled) {
                URL url = this.runtime.getConfigurationSchemaURL();
                URL fallbackSchemaURL = WebSphereRuntime.getFallbackSchema();
                if (url != null && !url.sameFile(fallbackSchemaURL)) {
                    File file = null;
                    try {
                        file = new File(url.toURI());
                        if (file.exists()) {
                            long timestamp = file.lastModified();
                            DateFormat df = DateFormat.getDateTimeInstance();
                            s = df.format(timestamp);
                        } else if (Trace.ENABLED) {
                            Trace.trace((byte)1, "Timestamp of last runtime update unavailable because schema does not exist");
                        }
                        break block9;
                    }
                    catch (URISyntaxException e) {
                        if (Trace.ENABLED) {
                            Trace.trace((byte)1, "Timestamp of last runtime update unavailable because of bad URL for schema", e);
                        }
                        break block9;
                    }
                }
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Timestamp of last runtime update unavailable because configuration schema URL is null");
                }
            }
        }
        return NLS.bind((String)Messages.runtimeCacheDescription, (Object)s);
    }

    protected void updateUserDirs() {
        this.userDirTable.removeAll();
        List userDirs = null;
        if (this.runtime != null) {
            userDirs = this.runtime.getUserDirectories();
        }
        if (userDirs != null) {
            for (UserDirectory ud : userDirs) {
                TableItem item = new TableItem(this.userDirTable, 0);
                item.setData((Object)ud);
                if (ud.getProject() != null) {
                    item.setText(ud.getProject().getName());
                    if (ud.getProject().exists()) {
                        item.setImage(Activator.getImage("userProject"));
                        continue;
                    }
                    item.setImage(this.projectErrorImage);
                    continue;
                }
                item.setText(ud.getPath().toOSString());
                if (ud.getPath().toFile().exists()) {
                    item.setImage(Activator.getImage("userFolder"));
                    continue;
                }
                item.setImage(this.folderErrorImage);
            }
        }
    }

    protected void init() {
        if (this.userDirTable == null || this.runtime == null) {
            return;
        }
        this.updateUserDirs();
        this.userDirTable.select(0);
    }
}

