/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.actions.NewConfigDropinAction;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewConfigDropinWizardPage
extends WizardPage {
    protected IPath dropinsPath;
    protected NewConfigDropinAction.DropinType type;
    protected String fileName;

    public NewConfigDropinWizardPage(IPath dropinsPath, NewConfigDropinAction.DropinType type) {
        super("configDropins", type.getTitle(), null);
        this.dropinsPath = dropinsPath;
        this.type = type;
        this.setDescription(type.getDesc());
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(Messages.newConfigDropinWizardFileNameLabel);
        GridData data = new GridData(4, 4, false, false);
        label.setLayoutData((Object)data);
        final Text text = new Text(comp, 2048);
        data = new GridData(4, 4, true, false);
        text.setLayoutData((Object)data);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigDropinWizardPage.this.fileName = text.getText();
                NewConfigDropinWizardPage.this.setPageComplete(NewConfigDropinWizardPage.this.validate());
            }
        });
        text.setFocus();
        this.setControl((Control)comp);
        this.setPageComplete(this.validate());
    }

    protected boolean validate() {
        if (this.fileName == null || this.fileName.isEmpty()) {
            this.setMessage(null, 0);
            return false;
        }
        if (!this.fileName.endsWith(".xml")) {
            this.setMessage(Messages.newConfigDropinWizardXMLExtError, 3);
            return false;
        }
        IPath path = this.dropinsPath.append(this.fileName);
        if (path.toFile().exists()) {
            this.setMessage(Messages.newConfigDropinWizardExistsError, 3);
            return false;
        }
        this.setMessage(null, 0);
        return true;
    }

    public String getFileName() {
        return this.fileName;
    }
}

