/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.generation.MetaDataRemover;
import com.ibm.ws.st.ui.internal.DDETreeContentProvider;
import com.ibm.ws.st.ui.internal.DDETreeLabelProvider;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.wizard.IServerWizardComposite;
import java.util.HashSet;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public abstract class AbstractWebSphereServerComposite
extends Composite
implements IServerWizardComposite {
    protected IServerWorkingCopy serverWC;
    protected WebSphereServer server;
    protected IWizardHandle wizard;
    protected TreeViewer treeViewer;
    protected DDETreeContentProvider contentProvider;
    protected final HashSet<String> runtimeIds = new HashSet();
    protected UserDirectory userDirectory;
    private Label label;
    private Tree tree;

    protected AbstractWebSphereServerComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
    }

    protected abstract void createControl();

    protected abstract void init();

    @Override
    public void reInitialize() {
        this.init();
    }

    protected void createConfigControl(Composite comp) {
        this.label = new Label(comp, 0);
        this.label.setText(Messages.wizServerConfiguration);
        GridData data = new GridData(1, 1, false, false);
        data.horizontalSpan = 3;
        data.verticalIndent = 3;
        this.label.setLayoutData((Object)data);
        this.tree = new Tree(comp, 68356);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        data.minimumHeight = 80;
        this.tree.setLayoutData((Object)data);
        this.tree.setFont(this.getFont());
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setAutoExpandLevel(3);
        this.contentProvider = new DDETreeContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DDETreeLabelProvider()));
    }

    protected void setConfigControlVisible(boolean b) {
        this.label.setVisible(b);
        this.tree.setVisible(b);
    }

    protected String getEmptyConfigMsg() {
        return Messages.configNone;
    }

    @Override
    public void setup(TaskModel taskModel) {
        IServerWorkingCopy wc = (IServerWorkingCopy)taskModel.getObject("server");
        UserDirectory userDir = (UserDirectory)taskModel.getObject("userDirectory");
        this.setServer(wc, userDir);
    }

    protected void setServer(IServerWorkingCopy newServer, UserDirectory userDir) {
        if (newServer == null) {
            this.serverWC = null;
            this.server = null;
            this.userDirectory = null;
        } else {
            this.serverWC = newServer;
            this.server = (WebSphereServer)newServer.loadAdapter(WebSphereServer.class, null);
            this.userDirectory = userDir;
        }
        this.init();
        this.validate();
    }

    protected void performCancel() {
        this.removeGeneratedMetaData(null);
    }

    protected void addMetaDataRuntimeId(IRuntime runtime) {
        if (runtime != null && runtime.isWorkingCopy() && ((IRuntimeWorkingCopy)runtime).getOriginal() == null) {
            this.runtimeIds.add(runtime.getId());
        }
    }

    protected void removeGeneratedMetaData(IRuntime runtimeToExclude) {
        if (runtimeToExclude != null) {
            this.runtimeIds.remove(runtimeToExclude.getId());
        }
        if (!this.runtimeIds.isEmpty()) {
            MetaDataRemover.removeCancelledMetaData(this.runtimeIds);
        }
    }

    @Override
    public Composite getComposite() {
        return this;
    }
}

