/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.utility;

import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.utility.UtilityWizardPage;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PluginConfigWizardPage
extends UtilityWizardPage {
    public PluginConfigWizardPage(WebSphereServerInfo server) {
        super(server);
        this.setTitle(Messages.wizPluginConfigTitle);
        this.setDescription(Messages.wizPluginConfigDescription);
    }

    @Override
    public void createUtilityControl(Composite comp) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!PluginConfigWizardPage.this.server.getConfigRoot().hasFeature("localConnector-1.0") || !PluginConfigWizardPage.this.server.getWebSphereRuntime().isServerStarted(PluginConfigWizardPage.this.server, null)) {
                        PluginConfigWizardPage.this.setMessage(Messages.wizPluginConfigError, 3);
                        PluginConfigWizardPage.this.setPageComplete(false);
                    }
                }
                catch (CoreException ce) {
                    Trace.logError("Error checking state for server: " + PluginConfigWizardPage.this.server.getServerName(), ce);
                }
            }
        });
    }

    @Override
    protected String getUserMessage() {
        IPath pluginConfigPath = this.server.getServerOutputPath().append("plugin-cfg.xml");
        try {
            if (!this.server.getWebSphereRuntime().isServerStarted(this.server, null)) {
                return NLS.bind((String)Messages.wizPluginConfigMessage, (Object)pluginConfigPath.toString()).concat(Messages.wizPluginConfigStoppedMessage);
            }
        }
        catch (CoreException ce) {
            Trace.logError("Error checking state for server: " + this.server.getServerName(), ce);
        }
        return NLS.bind((String)Messages.wizPluginConfigMessage, (Object)pluginConfigPath.toString());
    }

    public void showPluginConfigFile(final WebSphereServerInfo server) {
        Job job = new Job(Messages.wizRefreshServerFolderJob){

            protected IStatus run(IProgressMonitor monitor) {
                block3: {
                    IFolder serverFolder = server.getServerFolder();
                    if (serverFolder != null && serverFolder.exists()) {
                        try {
                            serverFolder.refreshLocal(2, monitor);
                        }
                        catch (CoreException ce) {
                            if (!Trace.ENABLED) break block3;
                            Trace.trace((byte)1, "Couldn't refresh server folder: " + serverFolder.getName(), ce);
                        }
                    }
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IFile[] files;
                        IPath serverOutputPath = server.getServerOutputPath();
                        File pluginConfigFile = serverOutputPath.append("plugin-cfg.xml").toFile();
                        if (pluginConfigFile != null && pluginConfigFile.exists() && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(server.getServerOutputPath().append("plugin-cfg.xml").toFile().toURI())).length > 0) {
                            IFile file = files[0];
                            Activator.showResource((IResource)file);
                        }
                    }
                });
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "com.ibm.ws.st.core.job.family".equals(family);
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    @Override
    public void finish(IProgressMonitor monitor) throws Exception {
        try {
            this.server.generatePluginConfig();
            this.showPluginConfigFile(this.server);
        }
        catch (Exception e) {
            Trace.logError("Generating web server plug-in configuration failed.", e);
            throw new Exception(Messages.wizPluginConfigFailed, e);
        }
    }
}

