/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.utility;

import com.ibm.ws.st.ui.internal.Trace;
import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

public class PathUtil {
    public static IFile getBestIFileMatchForURI(URI uri) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile[] files = workspace.getRoot().findFilesForLocationURI(uri);
        int bestMatchCount = 0;
        IFile bestMatchFile = null;
        for (int i = 0; i < files.length; ++i) {
            int segmentsMatched = PathUtil.segmentsMatched(uri.getPath().split("/"), files[i].getFullPath().segments());
            if (bestMatchCount != 0 && segmentsMatched <= bestMatchCount) continue;
            bestMatchCount = segmentsMatched;
            bestMatchFile = files[i];
        }
        return bestMatchFile;
    }

    private static int segmentsMatched(String[] uriSegments, String[] iFileSegments) {
        int matches = 0;
        int uriSegmentCount = uriSegments.length;
        for (int iFileSegmentCount = iFileSegments.length; uriSegmentCount > 0 && iFileSegmentCount > 0; --uriSegmentCount, --iFileSegmentCount) {
            if (!uriSegments[uriSegmentCount - 1].equals(iFileSegments[iFileSegmentCount - 1])) continue;
            ++matches;
        }
        return matches;
    }

    public static URI getURIForFilePath(String filePath) {
        try {
            return new File(filePath).toURI();
        }
        catch (Exception exception) {
            Trace.logError("Could not create URI for file path " + filePath, exception);
            return null;
        }
    }
}

