/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.security;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.security.LibertyX509CertPathValidatorControl;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class LibertyX509CertPathValidatorDialog
extends MessageDialog {
    private final Certificate[] certificates_;
    private final int index_;
    private final String causeMessage_;
    private final Throwable causeThrowable_;
    public static boolean isOpen = false;
    private static final String[] BUTTONS = new String[]{Messages.X509_DIALOG_BUTTON_VALID_FOR_SESSION, Messages.X509_DIALOG_BUTTON_VALID_FOR_WORKSPACE, Messages.X509_DIALOG_BUTTON_REJECTED};

    public LibertyX509CertPathValidatorDialog(Shell shell, CertPath certPath, int index, String causeMessage, Throwable causeThrowable) {
        super(shell, Messages.X509_DIALOG_TITLE, null, Messages.X509_DIALOG_MESSAGE, 4, BUTTONS, 2);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.certificates_ = certPath != null ? certPath.getCertificates().toArray(new Certificate[0]) : null;
        this.index_ = index;
        this.causeMessage_ = causeMessage;
        this.causeThrowable_ = causeThrowable;
    }

    protected Control createCustomArea(Composite parent) {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)("parent=[" + parent + "]"));
        }
        return new LibertyX509CertPathValidatorControl(parent, 0, this.certificates_, this.index_, this.causes());
    }

    private String[] causes() {
        LinkedList<String> causes = new LinkedList<String>();
        if (this.causeMessage_ != null) {
            causes.add(this.causeMessage_);
        }
        Throwable causeExc = this.causeThrowable_;
        for (int limit = 20; causeExc != null && limit > 0; causeExc = causeExc.getCause(), --limit) {
            causes.add(causeExc.getLocalizedMessage());
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)("causes=[" + causes + "]"));
        }
        return causes.toArray(new String[0]);
    }

    public int open() {
        isOpen = true;
        return super.open();
    }

    public boolean close() {
        isOpen = false;
        return super.close();
    }
}

