/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.security;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.security.LibertyX509CertData;
import com.ibm.ws.st.ui.internal.Messages;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class LibertyX509CertPathValidatorDetailsControl
extends Composite {
    private Cert[] certs_;

    public LibertyX509CertPathValidatorDetailsControl(Composite parent, int style, Certificate[] certificates, int index) {
        super(parent, style);
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)("parent=[" + parent + "] style=[" + style + "] certificates=[" + Arrays.toString(certificates) + "] index=" + index + "]"));
        }
        this.loadCerts(certificates);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayoutData(new GridData(4, 4, true, true));
        if (certificates.length > 0 && certificates[certificates.length - 1] instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificates[certificates.length - 1];
            X500Principal issuerPrincipal = x509Certificate.getIssuerX500Principal();
            String issuerCN = issuerPrincipal.getName();
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)("issuerCN=[" + issuerCN + "]"));
            }
            Label messageLabel = new Label(parent, 64);
            messageLabel.setText(NLS.bind((String)Messages.X509_CONTROL_ISSUER, (Object)issuerCN));
            messageLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        Composite certListComposite = new Composite(parent, 0);
        certListComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout certListTableColumnLayout = new TableColumnLayout();
        certListComposite.setLayout((Layout)certListTableColumnLayout);
        final TableViewer certListTableViewer = new TableViewer(certListComposite, 67584);
        Table certListTable = certListTableViewer.getTable();
        certListTable.setHeaderVisible(true);
        certListTable.setLinesVisible(true);
        TableViewerColumn certListTableViewerColumn = new TableViewerColumn(certListTableViewer, 0);
        TableColumn certListTableColumn = certListTableViewerColumn.getColumn();
        certListTableColumnLayout.setColumnData((Widget)certListTableColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        certListTableColumn.setResizable(true);
        certListTableColumn.setText(Messages.X509_CONTROL_COLUMN_TITLE_CERTIFICATE);
        certListTableViewer.setLabelProvider((IBaseLabelProvider)new CertListLabelProvider());
        certListTableViewer.setContentProvider((IContentProvider)new CertListContentProvider());
        certListTableViewer.setInput((Object)this.certs_);
        certListTable.select(index >= 0 && index < this.certs_.length ? index : this.certs_.length - 1);
        Label certDetailsLabel = new Label(parent, 64);
        certDetailsLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        certDetailsLabel.setText(Messages.X509_CONTROL_CERTIFICATE_DETAILS_LABEL);
        Composite certDetailsComposite = new Composite(parent, 0);
        certDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout certDetailsTableColumnLayout = new TableColumnLayout();
        certDetailsComposite.setLayout((Layout)certDetailsTableColumnLayout);
        final TableViewer certDetailsTableViewer = new TableViewer(certDetailsComposite, 67584);
        Table certDetailsTable = certDetailsTableViewer.getTable();
        certDetailsTable.setHeaderVisible(true);
        certDetailsTable.setLinesVisible(true);
        TableViewerColumn certDetailsTableViewerColumn1 = new TableViewerColumn(certDetailsTableViewer, 0);
        TableColumn certDetailsTableColumn1 = certDetailsTableViewerColumn1.getColumn();
        certDetailsTableColumnLayout.setColumnData((Widget)certDetailsTableColumn1, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        certDetailsTableColumn1.setResizable(true);
        certDetailsTableColumn1.setText(Messages.X509_CONTROL_COLUMN_TITLE_ATTRIBUTE);
        TableViewerColumn certDetailsTableViewerColumn2 = new TableViewerColumn(certDetailsTableViewer, 0);
        TableColumn certDetailsTableColumn2 = certDetailsTableViewerColumn2.getColumn();
        certDetailsTableColumnLayout.setColumnData((Widget)certDetailsTableColumn2, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        certDetailsTableColumn2.setResizable(true);
        certDetailsTableColumn2.setText(Messages.X509_CONTROL_COLUMN_TITLE_VALUE);
        certDetailsTableViewer.setLabelProvider((IBaseLabelProvider)new CertLabelProvider());
        certDetailsTableViewer.setContentProvider((IContentProvider)new CertContentProvider());
        int selectionIndex = certListTable.getSelectionIndex();
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)("selectionIndex=[" + selectionIndex + "]"));
        }
        if (selectionIndex > -1 && selectionIndex < this.certs_.length) {
            certDetailsTableViewer.setInput((Object)this.certs_[selectionIndex]);
        }
        certListTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)certListTableViewer.getSelection();
                Object object = selection.getFirstElement();
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, (String)("selected object=[" + object + "]"));
                }
                if (object != null && !object.equals(certDetailsTableViewer.getInput())) {
                    certDetailsTableViewer.setInput(object);
                }
            }
        });
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)"return");
        }
    }

    private void loadCerts(Certificate[] certificates) {
        if (certificates != null) {
            this.certs_ = new Cert[certificates.length];
            for (int i = 0; i < certificates.length; ++i) {
                this.certs_[i] = new Cert(i, null, certificates[i]);
            }
        } else {
            this.certs_ = new Cert[0];
        }
    }

    private static class CertListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)("element=[" + element + "] columnIndex=[" + columnIndex + "]"));
            }
            if (element instanceof Cert) {
                return ((Cert)element).getName();
            }
            return null;
        }

        public void dispose() {
            super.dispose();
        }
    }

    private static class CertListContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)("inputElement=[" + inputElement + "]"));
            }
            if (inputElement instanceof Cert[]) {
                return (Cert[])inputElement;
            }
            return null;
        }
    }

    private static class Cert {
        private final int index_;
        private String name_;
        private final Certificate certificate_;
        private LibertyX509CertData certData_;

        public Cert(int index, String name, Certificate certificate) {
            this.index_ = index;
            this.name_ = name;
            this.certificate_ = certificate;
        }

        public String getName() {
            if (this.name_ == null && this.certificate_ instanceof X509Certificate) {
                this.name_ = ((X509Certificate)this.certificate_).getSubjectX500Principal().getName();
            }
            return this.name_ == null ? Integer.toString(this.index_ + 1) : this.name_;
        }

        public LibertyX509CertData getCertData() {
            if (this.certData_ == null && this.certificate_ != null) {
                this.certData_ = new LibertyX509CertData(this.certificate_);
            }
            return this.certData_;
        }

        public String toString() {
            return "{" + this.index_ + "," + this.name_ + "," + this.certificate_ + "," + this.certData_ + "}";
        }
    }

    private static class CertLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public void dispose() {
            super.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)("element=[" + element + "] columnIndex=[" + columnIndex + "]"));
            }
            if (element instanceof LibertyX509CertData.Entry) {
                LibertyX509CertData.Entry entry = (LibertyX509CertData.Entry)element;
                return columnIndex == 0 ? entry.getKey() : entry.getVal();
            }
            return null;
        }
    }

    private static class CertContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)("inputElement=[" + inputElement + "]"));
            }
            if (inputElement instanceof Cert) {
                Cert cert = (Cert)inputElement;
                return cert.getCertData().entries();
            }
            return null;
        }
    }
}

