/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.preferences;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LibertyServerPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Composite preferencesComposite;
    protected Button enableAutomaticFeatureDetectionCheckbox;
    protected Label defaultClassScanningLabel;
    protected Combo defaultClassScanningCombo;

    protected Control createContents(Composite parent) {
        this.preferencesComposite = new Composite(parent, 0);
        this.preferencesComposite.setLayout((Layout)new GridLayout(2, false));
        this.enableAutomaticFeatureDetectionCheckbox = new Button(this.preferencesComposite, 32);
        this.enableAutomaticFeatureDetectionCheckbox.setText(Messages.enableAutomaticFeatureDetection);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.enableAutomaticFeatureDetectionCheckbox.setLayoutData((Object)gridData);
        this.enableAutomaticFeatureDetectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LibertyServerPreferencesPage.this.updateWidgetEnablement();
            }
        });
        this.defaultClassScanningLabel = new Label(this.preferencesComposite, 0);
        this.defaultClassScanningLabel.setText(Messages.requiredFeatureDefaultAction);
        gridData = new GridData();
        gridData.horizontalIndent = 18;
        this.defaultClassScanningLabel.setLayoutData((Object)gridData);
        this.defaultClassScanningCombo = new Combo(this.preferencesComposite, 8);
        String[] comboItems = new String[]{Messages.propertyPageFeatureAlways, Messages.propertyPageFeaturePrompt, Messages.propertyPageFeatureNever};
        this.defaultClassScanningCombo.setItems(comboItems);
        this.initializeValues();
        this.updateWidgetEnablement();
        return this.preferencesComposite;
    }

    protected void initializeValues() {
        this.enableAutomaticFeatureDetectionCheckbox.setSelection(Activator.isAutomaticFeatureDetectionEnabled());
        switch (Activator.getDefaultClassScanning()) {
            case 1: {
                this.defaultClassScanningCombo.select(0);
                break;
            }
            case 0: {
                this.defaultClassScanningCombo.select(1);
                break;
            }
            case 2: {
                this.defaultClassScanningCombo.select(2);
            }
        }
    }

    protected void updateWidgetEnablement() {
        boolean enablement = this.enableAutomaticFeatureDetectionCheckbox.getSelection();
        this.defaultClassScanningLabel.setEnabled(enablement);
        this.defaultClassScanningCombo.setEnabled(enablement);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.enableAutomaticFeatureDetectionCheckbox.setSelection(Activator.getAutomaticFeatureDetectionEnabledDefault());
        this.updateWidgetEnablement();
        switch (Activator.getDefaultClassScanningDefaultValue()) {
            case 1: {
                this.defaultClassScanningCombo.select(0);
                break;
            }
            case 0: {
                this.defaultClassScanningCombo.select(1);
                break;
            }
            case 2: {
                this.defaultClassScanningCombo.select(2);
            }
        }
    }

    public boolean performOk() {
        Activator.setAutomaticFeatureDetection((boolean)this.enableAutomaticFeatureDetectionCheckbox.getSelection());
        switch (this.defaultClassScanningCombo.getSelectionIndex()) {
            case 0: {
                Activator.setDefaultClassScanning((int)1);
                break;
            }
            case 1: {
                Activator.setDefaultClassScanning((int)0);
                break;
            }
            case 2: {
                Activator.setDefaultClassScanning((int)2);
            }
        }
        return true;
    }
}

