/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.validation.ValidationFramework;

public class QuickFixUpdateSecurePort
extends AbstractMarkerResolution {
    public String getLabel() {
        return Messages.updateSecurePortQuickFix;
    }

    public void run(IMarker marker) {
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        WebSphereServerInfo wsInfo = configFile.getWebSphereServer();
        if (wsInfo == null) {
            return;
        }
        WebSphereServer webSphereServer = WebSphereUtil.getWebSphereServer((WebSphereServerInfo)wsInfo);
        if (webSphereServer == null) {
            return;
        }
        IServer server = webSphereServer.getServer();
        IServerWorkingCopy workingCopy = server.createWorkingCopy();
        int httpsPort = configFile.getHTTPSPort();
        WebSphereServer adapter = (WebSphereServer)workingCopy.loadAdapter(WebSphereServer.class, null);
        adapter.setServerSecurePort(Integer.toString(httpsPort));
        try {
            workingCopy.save(true, null);
            ValidationFramework validationFramework = ValidationFramework.getDefault();
            validationFramework.validate(configFile.getIFile(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Update secure port failed.", coreException);
            }
            this.showErrorMessage();
        }
    }

    @Override
    protected String getErrorMessage() {
        return Messages.updateSecurePortFailedMsg;
    }
}

