/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;

public class QuickFixRemoveWhitespace
extends AbstractMarkerResolution {
    public String getLabel() {
        return Messages.whitespaceQuickFix;
    }

    public void run(IMarker marker) {
        int start = marker.getAttribute("charStart", 0);
        int end = marker.getAttribute("charEnd", 0);
        IFile file = this.getResource(marker);
        if (file == null) {
            return;
        }
        try {
            InputStreamReader in = new InputStreamReader(file.getContents(), file.getCharset());
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[256];
            int n = in.read(buf);
            while (n >= 0) {
                sb.append(buf, 0, n);
                n = in.read(buf);
            }
            in.close();
            sb.delete(start, end);
            file.setContents((InputStream)new ByteArrayInputStream(sb.toString().getBytes(file.getCharset())), true, true, null);
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix for removing whitespace failed", e);
            }
            this.showErrorMessage();
        }
    }

    @Override
    protected String getErrorMessage() {
        return Messages.whitespaceQuickFixFailed;
    }
}

