/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.validation.ConfigurationQuickFix;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;

public class QuickFixBestMatchVariable
extends AbstractMarkerResolution
implements ConfigurationQuickFix {
    private final String variableName;
    private final String bestMatch;

    public QuickFixBestMatchVariable(String variableName, String bestMatch) {
        this.variableName = variableName;
        this.bestMatch = bestMatch;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.replaceReferenceQuickFix, (Object[])new String[]{this.variableName, this.bestMatch});
    }

    public void run(IMarker marker) {
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        String xpath = marker.getAttribute("xpathAttr", "");
        String reference = marker.getAttribute("referenceName", "");
        int referenceOffset = marker.getAttribute("referenceOffset", 0);
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        if (configFile.replaceVariableReference(xpath, reference, referenceOffset, this.bestMatch)) {
            try {
                configFile.save(null);
            }
            catch (IOException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)6, "Quick fix for unknown variable failed. Error trying to save configuration file: " + configFile.getURI(), e);
                }
                this.showErrorMessage();
            }
        } else {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix for unknown variable failed. Error trying replace variable reference'" + xpath + "' in configuration: " + configFile.getURI(), null);
            }
            this.showErrorMessage();
        }
    }

    public ConfigurationQuickFix.ResolutionType getResolutionType() {
        return ConfigurationQuickFix.ResolutionType.BEST_MATCH_VARIABLE;
    }

    @Override
    protected String getErrorMessage() {
        return Messages.replaceReferenceFailedMessage;
    }
}

