/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class QuickFixAddSecurePortElement
extends AbstractMarkerResolution {
    public String getLabel() {
        return Messages.addSecurePortQuickFix;
    }

    public void run(IMarker marker) {
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        WebSphereServerInfo wsInfo = configFile.getWebSphereServer();
        if (wsInfo == null) {
            return;
        }
        WebSphereServer webSphereServer = WebSphereUtil.getWebSphereServer((WebSphereServerInfo)wsInfo);
        if (webSphereServer == null) {
            return;
        }
        Element httpEndpointElement = configFile.getDocument().createElement("httpEndpoint");
        httpEndpointElement.setAttribute("httpsPort", webSphereServer.getServerSecurePort());
        configFile.getDocument().getDocumentElement().appendChild(httpEndpointElement);
        Text textNode = configFile.getDocument().createTextNode("\n");
        configFile.getDocument().getDocumentElement().appendChild(textNode);
        try {
            configFile.save(null);
        }
        catch (IOException ioException) {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Add secure port quick fix failed. Error trying to update configuration: " + configFile.getURI(), ioException);
            }
            this.showErrorMessage();
        }
    }

    @Override
    protected String getErrorMessage() {
        return Messages.addSecurePortFailedMsg;
    }
}

