/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;

public class QuickFixAddFeature
extends AbstractMarkerResolution {
    private final String feature;

    public QuickFixAddFeature(String feature) {
        this.feature = feature;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.addFeatureQuickFix, (Object)this.feature);
    }

    public void run(IMarker marker) {
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        try {
            configFile.addFeature(this.feature);
            configFile.save(null);
        }
        catch (IOException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix to add feature failed trying to save configuration: " + configFile.getURI(), e);
            }
            this.showErrorMessage();
        }
    }

    @Override
    protected String getErrorMessage() {
        return Messages.addFeatureFailedMessage;
    }
}

