/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.config.validation.AbstractConfigurationValidator;
import com.ibm.ws.st.ui.internal.marker.QuickFixAddApplicationElement;
import com.ibm.ws.st.ui.internal.marker.QuickFixAddFeature;
import com.ibm.ws.st.ui.internal.marker.QuickFixAddSecurePortElement;
import com.ibm.ws.st.ui.internal.marker.QuickFixAddSecurityElements;
import com.ibm.ws.st.ui.internal.marker.QuickFixBestMatchElement;
import com.ibm.ws.st.ui.internal.marker.QuickFixBestMatchFactoryRef;
import com.ibm.ws.st.ui.internal.marker.QuickFixBestMatchFeature;
import com.ibm.ws.st.ui.internal.marker.QuickFixBestMatchProperty;
import com.ibm.ws.st.ui.internal.marker.QuickFixBestMatchVariable;
import com.ibm.ws.st.ui.internal.marker.QuickFixCreateVariable;
import com.ibm.ws.st.ui.internal.marker.QuickFixDuplicateFactoryRef;
import com.ibm.ws.st.ui.internal.marker.QuickFixFeatureConflict;
import com.ibm.ws.st.ui.internal.marker.QuickFixIgnoreAllProperties;
import com.ibm.ws.st.ui.internal.marker.QuickFixIgnoreProperty;
import com.ibm.ws.st.ui.internal.marker.QuickFixPlainTextPassword;
import com.ibm.ws.st.ui.internal.marker.QuickFixRemoveServerApplication;
import com.ibm.ws.st.ui.internal.marker.QuickFixRemoveWhitespace;
import com.ibm.ws.st.ui.internal.marker.QuickFixSupersedeFeature;
import com.ibm.ws.st.ui.internal.marker.QuickFixUpdateSecurePort;
import com.ibm.ws.st.ui.internal.marker.QuickFixUpdateSharedLibRef;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        int fixType = marker.getAttribute("quickFixTypeAttr", AbstractConfigurationValidator.QuickFixType.NONE.ordinal());
        switch (AbstractConfigurationValidator.QuickFixType.values()[fixType]) {
            case PLAIN_TEXT_PASSWORD: {
                return new IMarkerResolution[]{new QuickFixPlainTextPassword()};
            }
            case UNRECOGNIZED_PROPERTY: {
                return this.getPropertyResolutions(marker);
            }
            case UNRECOGNIZED_ELEMENT: {
                return this.getElementBestMatchResolutions(marker);
            }
            case UNAVAILABLE_ELEMENT: {
                return this.getElementFeatureResolutions(marker);
            }
            case UNDEFINED_VARIABLE: {
                return this.getUndefinedVariableResolutions(marker);
            }
            case UNRECOGNIZED_FEATURE: {
                return this.getFeatureResolutions(marker);
            }
            case OUT_OF_SYNC_APP: {
                return this.getOutOfSyncAppResolutions(marker);
            }
            case OUT_OF_SYNC_SHARED_LIB_REF_MISMATCH: {
                return this.getOutOfSyncMissingSharedLibRefResolutions(marker);
            }
            case FACTORY_ID_NOT_FOUND: {
                return this.getFactoryIdResolutions(marker);
            }
            case DUPLICATE_FACTORY_ID: {
                return new IMarkerResolution[]{new QuickFixDuplicateFactoryRef(marker.getAttribute("referenceName", ""), marker.getAttribute("referenceOffset", -1))};
            }
            case INVALID_WHITESPACE: {
                return new IMarkerResolution[]{new QuickFixRemoveWhitespace()};
            }
            case SUPERSEDED_FEATURE: {
                return new IMarkerResolution[]{new QuickFixSupersedeFeature(marker.getAttribute("bestMatch", ""))};
            }
            case FEATURE_CONFLICT: {
                return new IMarkerResolution[]{new QuickFixFeatureConflict(marker.getAttribute("bestMatch", ""))};
            }
            case SSL_NO_KEYSTORE: {
                return new IMarkerResolution[]{new QuickFixAddSecurityElements()};
            }
            case REMOTE_SERVER_SECURE_PORT_MISMATCH: {
                return new IMarkerResolution[]{new QuickFixAddSecurePortElement(), new QuickFixUpdateSecurePort()};
            }
        }
        return null;
    }

    private IMarkerResolution[] getElementBestMatchResolutions(IMarker marker) {
        String bestMatch = marker.getAttribute("bestMatch", "");
        String[] matches = bestMatch.split(",");
        int len = matches.length;
        IMarkerResolution[] resolutions = new IMarkerResolution[len];
        for (int i = 0; i < len; ++i) {
            resolutions[i] = new QuickFixBestMatchElement(matches[i]);
        }
        return resolutions;
    }

    private IMarkerResolution[] getElementFeatureResolutions(IMarker marker) {
        String bestMatch = marker.getAttribute("bestMatch", "");
        String[] matches = bestMatch.split(",");
        int len = matches.length;
        IMarkerResolution[] resolutions = new IMarkerResolution[len];
        for (int i = 0; i < len; ++i) {
            resolutions[i] = new QuickFixAddFeature(matches[i]);
        }
        return resolutions;
    }

    private IMarkerResolution[] getPropertyResolutions(IMarker marker) {
        String bestMatch = marker.getAttribute("bestMatch", "");
        String elemName = marker.getAttribute("elementNodeName", "");
        String attrName = marker.getAttribute("attributeNodeName", "");
        if (bestMatch.length() == 0) {
            return new IMarkerResolution[]{new QuickFixIgnoreProperty(elemName, attrName), new QuickFixIgnoreAllProperties(elemName), new QuickFixIgnoreAllProperties()};
        }
        String[] matches = bestMatch.split(",");
        int len = matches.length;
        IMarkerResolution[] resolutions = new IMarkerResolution[len + 3];
        int index = 0;
        for (String match : matches) {
            resolutions[index++] = new QuickFixBestMatchProperty(match);
        }
        resolutions[len] = new QuickFixIgnoreProperty(elemName, attrName);
        resolutions[len + 1] = new QuickFixIgnoreAllProperties(elemName);
        resolutions[len + 2] = new QuickFixIgnoreAllProperties();
        return resolutions;
    }

    private IMarkerResolution[] getUndefinedVariableResolutions(IMarker marker) {
        String name = marker.getAttribute("referenceName", "");
        String bestMatch = marker.getAttribute("bestMatch", "");
        int referenceOffset = marker.getAttribute("referenceOffset", 0);
        if (bestMatch.length() == 0 || referenceOffset <= 0) {
            return new IMarkerResolution[]{new QuickFixCreateVariable(name)};
        }
        String[] matches = bestMatch.split(",");
        IMarkerResolution[] resolutions = new IMarkerResolution[matches.length + 1];
        int index = 1;
        resolutions[0] = new QuickFixCreateVariable(name);
        for (String match : matches) {
            resolutions[index++] = new QuickFixBestMatchVariable(name, match);
        }
        return resolutions;
    }

    private IMarkerResolution[] getFeatureResolutions(IMarker marker) {
        String bestMatch = marker.getAttribute("bestMatch", "");
        String[] matches = bestMatch.split(",");
        int len = matches.length;
        IMarkerResolution[] resolutions = new IMarkerResolution[len];
        int index = 0;
        for (String match : matches) {
            resolutions[index++] = new QuickFixBestMatchFeature(match);
        }
        return resolutions;
    }

    private IMarkerResolution[] getOutOfSyncAppResolutions(IMarker marker) {
        String appName = marker.getAttribute("applicationName", "");
        return new IMarkerResolution[]{new QuickFixAddApplicationElement(appName), new QuickFixRemoveServerApplication(appName)};
    }

    private IMarkerResolution[] getOutOfSyncMissingSharedLibRefResolutions(IMarker marker) {
        String appName = marker.getAttribute("applicationName", "");
        return new IMarkerResolution[]{new QuickFixUpdateSharedLibRef(appName)};
    }

    private IMarkerResolution[] getFactoryIdResolutions(IMarker marker) {
        String bestMatch = marker.getAttribute("bestMatch", "");
        String[] matches = bestMatch.split(",");
        int len = matches.length;
        IMarkerResolution[] resolutions = new IMarkerResolution[len];
        int index = 0;
        for (String match : matches) {
            resolutions[index++] = new QuickFixBestMatchFactoryRef(match, marker.getAttribute("referenceName", ""), marker.getAttribute("referenceOffset", -1));
        }
        return resolutions;
    }

    public boolean hasResolutions(IMarker marker) {
        int fixType = marker.getAttribute("quickFixTypeAttr", AbstractConfigurationValidator.QuickFixType.NONE.ordinal());
        if (fixType == AbstractConfigurationValidator.QuickFixType.UNDEFINED_VARIABLE.ordinal()) {
            String name = marker.getAttribute("referenceName", "");
            return name.length() > 0;
        }
        if (fixType == AbstractConfigurationValidator.QuickFixType.UNRECOGNIZED_ELEMENT.ordinal()) {
            String bestMatch = marker.getAttribute("bestMatch", "");
            return bestMatch.length() > 0;
        }
        return fixType != AbstractConfigurationValidator.QuickFixType.NONE.ordinal();
    }
}

