/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RepositoryInfoDialog
extends TitleAreaDialog {
    private Text nameText;
    private Label urlLabel;
    private Text urlText;
    private Label userLabel;
    private Text userText;
    private Label passwordLabel;
    private Text passwordText;
    private Label locationLabel;
    Text locationText;
    private Button remoteButton;
    private Button localButton;
    Button browseButton;
    protected final SiteHelper.SiteDelegate site;
    private final ModifyListener listener;
    private final SelectionAdapter enablementListener;
    private String siteName;
    private String user;
    private String password;
    URL url;
    private final List<SiteHelper.SiteDelegate> allSites;
    private final Map<String, Object> map;
    Control[] remoteControls;
    Control[] localControls;

    protected Point getInitialSize() {
        return new Point(800, 500);
    }

    public RepositoryInfoDialog(Shell parentShell, SiteHelper.SiteDelegate site, List<SiteHelper.SiteDelegate> allSites, Map<String, Object> map) {
        super(parentShell);
        this.site = site;
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryInfoDialog.this.enableOKButton(RepositoryInfoDialog.this.validate());
            }
        };
        this.enablementListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RepositoryInfoDialog.this.handleEnablement();
                RepositoryInfoDialog.this.enableOKButton(RepositoryInfoDialog.this.validate());
            }
        };
        this.allSites = allSites;
        this.map = map;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.site == null ? Messages.repositoryInfoDialogNewTitle : Messages.repositoryInfoDialogEditTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(Activator.getImage("wizRuntime"));
        this.setTitle(this.site == null ? Messages.repositoryInfoDialogNewTitle : Messages.repositoryInfoDialogEditTitle);
        this.setMessage(this.site == null ? Messages.repositoryInfoDialogNewDescription : Messages.repositoryInfoDialogEditDescription);
        FieldDecoration reqFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED");
        Composite comp = new Composite(parent, 2048);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(comp, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(comp, 4);
        comp.setLayout((Layout)layout);
        Composite nameGroup = new Composite(comp, 0);
        nameGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(comp, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(comp, 4);
        layout.numColumns = 3;
        nameGroup.setLayout((Layout)layout);
        Label label = new Label(nameGroup, 0);
        label.setText(Messages.name);
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        this.nameText = new Text(nameGroup, 2048);
        this.nameText.setLayoutData((Object)this.getFieldGridData(2));
        ControlDecoration dec = new ControlDecoration((Control)this.nameText, 16512);
        dec.setImage(reqFieldIndicator.getImage());
        Composite radioGroup = new Composite(comp, 0);
        radioGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(comp, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(comp, 4);
        layout.numColumns = 1;
        radioGroup.setLayout((Layout)layout);
        this.remoteButton = new Button(radioGroup, 16);
        this.remoteButton.setText(Messages.repositoryInfoDialogRemoteGroupLabel);
        Composite remoteGroup = new Composite(radioGroup, 0);
        layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(comp, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(comp, 4);
        layout.numColumns = 3;
        remoteGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalIndent = 15;
        remoteGroup.setLayoutData((Object)data);
        label = new Label(remoteGroup, 0);
        label.setText(Messages.url);
        GridData gd = new GridData(1, 2, false, false);
        gd.widthHint = 70;
        label.setLayoutData((Object)gd);
        this.urlLabel = label;
        this.urlText = new Text(remoteGroup, 2048);
        this.urlText.setLayoutData((Object)this.getFieldGridData(2));
        dec = new ControlDecoration((Control)this.urlText, 16512);
        dec.setImage(reqFieldIndicator.getImage());
        label = new Label(remoteGroup, 0);
        label.setText(Messages.user);
        gd = new GridData(1, 2, false, false);
        gd.widthHint = 70;
        label.setLayoutData((Object)gd);
        this.userLabel = label;
        this.userText = new Text(remoteGroup, 2048);
        this.userText.setLayoutData((Object)this.getFieldGridData(2));
        dec = new ControlDecoration((Control)this.userText, 16512);
        dec.setImage(reqFieldIndicator.getImage());
        dec.setShowOnlyOnFocus(true);
        label = new Label(remoteGroup, 0);
        label.setText(Messages.password);
        gd = new GridData(1, 2, false, false);
        gd.widthHint = 70;
        label.setLayoutData((Object)gd);
        this.passwordLabel = label;
        this.passwordText = new Text(remoteGroup, 2048);
        this.passwordText.setLayoutData((Object)this.getFieldGridData(2));
        this.passwordText.setEchoChar('*');
        dec = new ControlDecoration((Control)this.passwordText, 16512);
        dec.setImage(reqFieldIndicator.getImage());
        dec.setShowOnlyOnFocus(true);
        this.localButton = new Button(radioGroup, 16);
        this.localButton.setText(Messages.repositoryInfoDialogLocalGroupLabel);
        Composite localGroup = new Composite(radioGroup, 0);
        layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(comp, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(comp, 4);
        layout.numColumns = 3;
        localGroup.setLayout((Layout)layout);
        data = new GridData(4, 2, true, false);
        data.horizontalIndent = 15;
        localGroup.setLayoutData((Object)data);
        label = new Label(localGroup, 0);
        label.setText(Messages.repositoryInfoDialogLocationLabel);
        gd = new GridData(1, 2, false, false);
        gd.widthHint = 70;
        label.setLayoutData((Object)gd);
        this.locationLabel = label;
        this.locationText = new Text(localGroup, 2048);
        this.locationText.setLayoutData((Object)this.getFieldGridData(1));
        dec = new ControlDecoration((Control)this.urlText, 16512);
        dec.setImage(reqFieldIndicator.getImage());
        IRuntimeInfo runtimeInfo = (IRuntimeInfo)this.map.get("core");
        if (SiteHelper.isZipRepoSupported(runtimeInfo)) {
            this.browseButton = new Button(localGroup, 0x4000008);
            this.browseButton.setText(Messages.browseButtonAcc4);
            this.browseButton.setImage(Activator.getImage("menuDown"));
            data = new GridData(1, 1, false, false);
            this.browseButton.setLayoutData((Object)data);
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Menu menu = new Menu((Decorations)RepositoryInfoDialog.this.getShell(), 64);
                    MenuItem directory = new MenuItem(menu, 0);
                    directory.setText(Messages.repositoryInfoDialogDirectoryRepoButton);
                    directory.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent arg0) {
                            DirectoryDialog dialog = new DirectoryDialog(RepositoryInfoDialog.this.getShell());
                            String file = dialog.open();
                            if (file != null) {
                                RepositoryInfoDialog.this.locationText.setText(file);
                            }
                        }
                    });
                    MenuItem zip = new MenuItem(menu, 0);
                    zip.setText(Messages.repositoryInfoDialogZipRepoButton);
                    zip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent arg0) {
                            FileDialog dialog = new FileDialog(RepositoryInfoDialog.this.getShell());
                            dialog.setFilterExtensions(new String[]{"*.zip"});
                            String file = dialog.open();
                            if (file != null) {
                                RepositoryInfoDialog.this.locationText.setText(file);
                            }
                        }
                    });
                    RepositoryInfoDialog.this.displayDropdownMenu((Control)RepositoryInfoDialog.this.browseButton, menu, true);
                    menu.dispose();
                }
            });
        } else {
            this.browseButton = new Button(localGroup, 0);
            this.browseButton.setText(Messages.browseButtonAcc);
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    DirectoryDialog dialog = new DirectoryDialog(RepositoryInfoDialog.this.getShell());
                    String file = dialog.open();
                    if (file != null) {
                        RepositoryInfoDialog.this.locationText.setText(file);
                    }
                }
            });
        }
        this.remoteControls = new Control[]{this.urlLabel, this.urlText, this.userLabel, this.userText, this.passwordLabel, this.passwordText};
        this.localControls = new Control[]{this.locationLabel, this.locationText, this.browseButton};
        this.init();
        return comp;
    }

    private void init() {
        URL url;
        if (this.site != null && (url = this.site.getURL()) != null) {
            this.nameText.setText(this.site.getName());
            if (url.toString().startsWith("file:/")) {
                String path;
                block8: {
                    try {
                        File file = new File(url.toURI());
                        path = file.getPath();
                    }
                    catch (URISyntaxException e) {
                        Trace.logError("Could not create a file from the URL: " + url, e);
                        path = url.getFile();
                        if (!System.getProperty("os.name").toLowerCase().contains("windows") || !path.startsWith("/")) break block8;
                        path = path.substring(1);
                    }
                }
                this.locationText.setText(path);
                this.localButton.setSelection(true);
            } else {
                this.urlText.setText(this.site.getURL().toString());
                if (this.site.getUser() != null) {
                    this.userText.setText(this.site.getUser());
                }
                if (this.site.getPassword() != null) {
                    this.passwordText.setText(this.site.getPassword());
                }
                this.remoteButton.setSelection(true);
            }
        } else {
            this.urlText.setText("http://");
            this.remoteButton.setSelection(true);
            this.locationText.setText("");
        }
        this.nameText.setFocus();
        this.nameText.addModifyListener(this.listener);
        this.urlText.addModifyListener(this.listener);
        this.userText.addModifyListener(this.listener);
        this.passwordText.addModifyListener(this.listener);
        this.locationText.addModifyListener(this.listener);
        this.localButton.addSelectionListener((SelectionListener)this.enablementListener);
        this.remoteButton.addSelectionListener((SelectionListener)this.enablementListener);
        this.handleEnablement();
        this.setErrorMessage(null);
    }

    protected GridData getFieldGridData(int horizontalSpan) {
        int margin = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        GridData data = new GridData(4, 2, true, false);
        data.widthHint = 200 + margin;
        data.horizontalIndent = margin;
        data.horizontalSpan = horizontalSpan;
        return data;
    }

    protected boolean validate() {
        block23: {
            this.siteName = this.nameText.getText().trim();
            if (this.siteName.isEmpty()) {
                this.setErrorMessage(Messages.errorRepositoryEmptyName);
                return false;
            }
            if (this.site == null || !this.siteName.equalsIgnoreCase(this.site.getName())) {
                for (SiteHelper.SiteDelegate s : this.allSites) {
                    if (!this.siteName.equalsIgnoreCase(s.getName())) continue;
                    this.setErrorMessage(Messages.errorRepositoryAlreadyExists);
                    return false;
                }
            }
            if (this.localButton.getSelection()) {
                String location = this.locationText.getText();
                if (location.isEmpty()) {
                    this.setErrorMessage(null);
                    return false;
                }
                try {
                    FilenameFilter filter = new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.equalsIgnoreCase("repository.config");
                        }
                    };
                    File file = new File(location);
                    IRuntimeInfo runtimeInfo = (IRuntimeInfo)this.map.get("core");
                    if (!file.exists()) {
                        this.setErrorMessage(Messages.errorRepositoryInvalidLocation);
                        return false;
                    }
                    if (file.isDirectory()) {
                        if (file.listFiles(filter).length != 1) {
                            this.setErrorMessage(Messages.errorRepositoryInvalidLocation);
                            return false;
                        }
                    } else if (!SiteHelper.isZipRepoSupported(runtimeInfo) || !SiteHelper.isValidOnPremZipRepository(file)) {
                        this.setErrorMessage(Messages.errorRepositoryInvalidArchive);
                        return false;
                    }
                    try {
                        this.url = file.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        this.setErrorMessage(Messages.errorRepositoryInvalidLocation);
                        return false;
                    }
                    if (this.url == null) {
                        this.setErrorMessage(Messages.errorRepositoryInvalidLocation);
                        return false;
                    }
                    break block23;
                }
                catch (Throwable t) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Failed to verify local repository directory", t);
                    }
                    this.setErrorMessage(Messages.errorRepositoryInvalidLocation);
                    return false;
                }
            }
            if ("http://".equalsIgnoreCase(this.urlText.getText())) {
                this.setErrorMessage(Messages.errorRepositoryInvalidURL);
                return false;
            }
            try {
                this.url = new URL(this.urlText.getText());
            }
            catch (MalformedURLException e) {
                this.setErrorMessage(Messages.errorRepositoryInvalidURL);
                return false;
            }
            if (this.userText.getText().isEmpty()) {
                if (!this.passwordText.getText().isEmpty()) {
                    this.setErrorMessage(Messages.errorRepositoryUserNotSet);
                    return false;
                }
            } else if (this.passwordText.getText().isEmpty()) {
                this.setErrorMessage(Messages.errorRepositoryPasswordNotSet);
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(this.site == null ? Messages.repositoryInfoDialogNewDescription : Messages.repositoryInfoDialogEditDescription);
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOKButton(this.validate());
        this.setErrorMessage(null);
        return control;
    }

    protected void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    protected void okPressed() {
        if (this.remoteButton.getSelection()) {
            this.user = this.userText.getText().trim();
            this.password = this.passwordText.getText().trim();
        } else {
            this.user = null;
            this.password = null;
        }
        super.okPressed();
    }

    protected String getSiteName() {
        return this.siteName;
    }

    protected URL getSiteURL() {
        return this.url;
    }

    protected String getSiteUser() {
        return this.user;
    }

    protected String getSitePassword() {
        return this.password;
    }

    void handleEnablement() {
        for (Control c : this.remoteControls) {
            c.setEnabled(this.remoteButton.getSelection());
        }
        for (Control c : this.localControls) {
            c.setEnabled(!this.remoteButton.getSelection());
        }
    }

    protected void displayDropdownMenu(Control anchor, Menu menu, boolean subtractWidth) {
        Point size = anchor.getSize();
        Point point = anchor.toDisplay(0, size.y);
        menu.setLocation(point.x - (subtractWidth ? size.x : 0), point.y);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            Display display = menu.getShell().getDisplay();
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

