/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.download.RepositoryInfoDialog;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RepositoriesConfigurationDialog
extends TitleAreaDialog {
    protected Table table;
    protected Button newButton;
    protected Button editButton;
    protected Button removeButton;
    protected Button upButton;
    protected Button downButton;
    protected CheckboxTableViewer tableViewer;
    protected SiteHelper.SiteDelegate currentSite;
    protected List<SiteHelper.SiteDelegate> activeSiteList = new ArrayList<SiteHelper.SiteDelegate>();
    private boolean isRefreshRequired = false;
    protected final Map<String, Object> map;

    public RepositoriesConfigurationDialog(Shell parentShell, Map<String, Object> map) {
        super(parentShell);
        SiteHelper.SiteDelegate[] sites;
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
        for (SiteHelper.SiteDelegate site : sites = SiteHelper.getConfigurableSites()) {
            this.activeSiteList.add(site);
        }
        this.map = map;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.configureRepoDialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(Activator.getImage("wizRuntime"));
        this.setTitle(Messages.configureRepoDialogTitle);
        this.setMessage(Messages.repoPrefencePageDescriptionLabel1);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(composite, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(composite, 4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label.setVisible(false);
        label = new Label(composite, 64);
        label.setText(Messages.repoPrefencePageDescriptionLabel2);
        data = new GridData(4, 0x1000000, false, false);
        data.horizontalSpan = 2;
        data.widthHint = 275;
        label.setLayoutData((Object)data);
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label.setVisible(false);
        label = new Label(composite, 0);
        label.setText(Messages.repoPrefencePageDescriptionLabel3);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.table = new Table(composite, 68388);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableLayout tableLayout = new TableLayout();
        new TableColumn(this.table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.table.setLayout((Layout)tableLayout);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new RepoContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new RepoTableLabelProvider());
        this.tableViewer.setInput((Object)"init");
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                Object[] obj = RepositoriesConfigurationDialog.this.tableViewer.getCheckedElements();
                if (obj.length == 0) {
                    RepositoriesConfigurationDialog.this.tableViewer.setChecked(e.getElement(), true);
                }
            }
        });
        Object[] selectedSites = SiteHelper.getSelectedSites();
        if (selectedSites.length > 0) {
            this.tableViewer.setCheckedElements(selectedSites);
        } else {
            Object obj = this.tableViewer.getElementAt(0);
            if (obj != null) {
                this.tableViewer.setChecked(obj, true);
            }
        }
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)RepositoriesConfigurationDialog.this.tableViewer.getSelection();
                if (sel.size() == 0 || sel.size() > 1) {
                    return;
                }
                Object firstElem = sel.getFirstElement();
                if (firstElem != null) {
                    RepositoriesConfigurationDialog.this.currentSite = (SiteHelper.SiteDelegate)firstElem;
                    RepositoriesConfigurationDialog.this.editButton.setEnabled(RepositoriesConfigurationDialog.this.currentSite != SiteHelper.getDefaultSiteDelegate());
                    RepositoriesConfigurationDialog.this.removeButton.setEnabled(RepositoriesConfigurationDialog.this.currentSite != SiteHelper.getDefaultSiteDelegate());
                    RepositoriesConfigurationDialog.this.upButton.setEnabled(RepositoriesConfigurationDialog.this.activeSiteList.size() > 1 && RepositoriesConfigurationDialog.this.currentSite != SiteHelper.getDefaultSiteDelegate() && RepositoriesConfigurationDialog.this.activeSiteList.indexOf(RepositoriesConfigurationDialog.this.currentSite) > 0);
                    RepositoriesConfigurationDialog.this.downButton.setEnabled(RepositoriesConfigurationDialog.this.activeSiteList.size() > 1 && RepositoriesConfigurationDialog.this.activeSiteList.indexOf(RepositoriesConfigurationDialog.this.currentSite) < RepositoriesConfigurationDialog.this.activeSiteList.size() - 2);
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)RepositoriesConfigurationDialog.this.tableViewer.getSelection();
                if (sel.size() == 0 || sel.size() > 1) {
                    return;
                }
                Object firstElem = sel.getFirstElement();
                if (firstElem != null) {
                    RepositoriesConfigurationDialog.this.currentSite = (SiteHelper.SiteDelegate)firstElem;
                    if (RepositoriesConfigurationDialog.this.currentSite == SiteHelper.getDefaultSiteDelegate()) {
                        return;
                    }
                    RepositoryInfoDialog d = new RepositoryInfoDialog(RepositoriesConfigurationDialog.this.getShell(), RepositoriesConfigurationDialog.this.currentSite, RepositoriesConfigurationDialog.this.activeSiteList, RepositoriesConfigurationDialog.this.map);
                    if (d.open() == 0 && RepositoriesConfigurationDialog.this.isSiteInfoChanged(RepositoriesConfigurationDialog.this.currentSite, d)) {
                        if (RepositoriesConfigurationDialog.this.currentSite.getState() != SiteHelper.SiteDelegate.State.COPY) {
                            int index1 = RepositoriesConfigurationDialog.this.activeSiteList.indexOf(RepositoriesConfigurationDialog.this.currentSite);
                            RepositoriesConfigurationDialog.this.currentSite = new SiteHelper.SiteDelegate(RepositoriesConfigurationDialog.this.currentSite);
                            RepositoriesConfigurationDialog.this.activeSiteList.set(index1, RepositoriesConfigurationDialog.this.currentSite);
                        }
                        RepositoriesConfigurationDialog.this.currentSite.setName(d.getSiteName());
                        RepositoriesConfigurationDialog.this.currentSite.setURL(d.getSiteURL());
                        RepositoriesConfigurationDialog.this.currentSite.setUser(d.getSiteUser());
                        RepositoriesConfigurationDialog.this.currentSite.setPassword(d.getSitePassword());
                        RepositoriesConfigurationDialog.this.tableViewer.refresh();
                    }
                }
            }
        });
        Composite buttonComp = new Composite(composite, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComp.setLayout((Layout)layout);
        data = new GridData(272);
        buttonComp.setLayoutData((Object)data);
        this.newButton = SWTUtil.createButton(buttonComp, Messages.addButtonAcc);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RepositoryInfoDialog d = new RepositoryInfoDialog(RepositoriesConfigurationDialog.this.getShell(), null, RepositoriesConfigurationDialog.this.activeSiteList, RepositoriesConfigurationDialog.this.map);
                if (d.open() == 0) {
                    SiteHelper.SiteDelegate site = new SiteHelper.SiteDelegate(d.getSiteName());
                    site.setURL(d.getSiteURL());
                    site.setUser(d.getSiteUser());
                    site.setPassword(d.getSitePassword());
                    site.setState(SiteHelper.SiteDelegate.State.NEW);
                    RepositoriesConfigurationDialog.this.activeSiteList.add(site);
                    RepositoriesConfigurationDialog.this.moveSite(site, -1);
                    RepositoriesConfigurationDialog.this.tableViewer.refresh();
                    RepositoriesConfigurationDialog.this.tableViewer.setChecked((Object)site, true);
                    IStructuredSelection sel = (IStructuredSelection)RepositoriesConfigurationDialog.this.tableViewer.getSelection();
                    if (sel.size() == 1 && RepositoriesConfigurationDialog.this.currentSite != null) {
                        RepositoriesConfigurationDialog.this.upButton.setEnabled(RepositoriesConfigurationDialog.this.activeSiteList.size() > 1 && RepositoriesConfigurationDialog.this.activeSiteList.indexOf(RepositoriesConfigurationDialog.this.currentSite) > 0);
                        RepositoriesConfigurationDialog.this.downButton.setEnabled(RepositoriesConfigurationDialog.this.activeSiteList.size() > 1 && RepositoriesConfigurationDialog.this.activeSiteList.indexOf(RepositoriesConfigurationDialog.this.currentSite) < RepositoriesConfigurationDialog.this.activeSiteList.size() - 2);
                    }
                }
            }
        });
        this.editButton = SWTUtil.createButton(buttonComp, Messages.editButtonAcc);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RepositoryInfoDialog d = new RepositoryInfoDialog(RepositoriesConfigurationDialog.this.getShell(), RepositoriesConfigurationDialog.this.currentSite, RepositoriesConfigurationDialog.this.activeSiteList, RepositoriesConfigurationDialog.this.map);
                if (d.open() == 0 && RepositoriesConfigurationDialog.this.isSiteInfoChanged(RepositoriesConfigurationDialog.this.currentSite, d)) {
                    boolean isChecked = RepositoriesConfigurationDialog.this.tableViewer.getChecked((Object)RepositoriesConfigurationDialog.this.currentSite);
                    if (RepositoriesConfigurationDialog.this.currentSite.getState() != SiteHelper.SiteDelegate.State.COPY) {
                        int index1 = RepositoriesConfigurationDialog.this.activeSiteList.indexOf(RepositoriesConfigurationDialog.this.currentSite);
                        RepositoriesConfigurationDialog.this.currentSite = new SiteHelper.SiteDelegate(RepositoriesConfigurationDialog.this.currentSite);
                        RepositoriesConfigurationDialog.this.activeSiteList.set(index1, RepositoriesConfigurationDialog.this.currentSite);
                    }
                    RepositoriesConfigurationDialog.this.currentSite.setName(d.getSiteName());
                    RepositoriesConfigurationDialog.this.currentSite.setURL(d.getSiteURL());
                    RepositoriesConfigurationDialog.this.currentSite.setUser(d.getSiteUser());
                    RepositoriesConfigurationDialog.this.currentSite.setPassword(d.getSitePassword());
                    RepositoriesConfigurationDialog.this.tableViewer.refresh();
                    RepositoriesConfigurationDialog.this.tableViewer.setChecked((Object)RepositoriesConfigurationDialog.this.currentSite, isChecked);
                    RepositoriesConfigurationDialog.this.editButton.setEnabled(false);
                    RepositoriesConfigurationDialog.this.removeButton.setEnabled(false);
                    RepositoriesConfigurationDialog.this.upButton.setEnabled(false);
                    RepositoriesConfigurationDialog.this.downButton.setEnabled(false);
                }
            }
        });
        this.removeButton = SWTUtil.createButton(buttonComp, Messages.removeButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object obj;
                RepositoriesConfigurationDialog.this.activeSiteList.remove(RepositoriesConfigurationDialog.this.currentSite);
                RepositoriesConfigurationDialog.this.currentSite = null;
                RepositoriesConfigurationDialog.this.tableViewer.refresh();
                RepositoriesConfigurationDialog.this.editButton.setEnabled(false);
                RepositoriesConfigurationDialog.this.removeButton.setEnabled(false);
                RepositoriesConfigurationDialog.this.upButton.setEnabled(false);
                RepositoriesConfigurationDialog.this.downButton.setEnabled(false);
                Object[] checkedElements = RepositoriesConfigurationDialog.this.tableViewer.getCheckedElements();
                if ((checkedElements == null || checkedElements.length == 0) && (obj = RepositoriesConfigurationDialog.this.tableViewer.getElementAt(0)) != null) {
                    RepositoriesConfigurationDialog.this.tableViewer.setChecked(obj, true);
                }
            }
        });
        this.upButton = SWTUtil.createButton(buttonComp, Messages.upButton);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RepositoriesConfigurationDialog.this.moveSite(RepositoriesConfigurationDialog.this.currentSite, -1);
                RepositoriesConfigurationDialog.this.tableViewer.refresh();
                RepositoriesConfigurationDialog.this.upButton.setEnabled(RepositoriesConfigurationDialog.this.activeSiteList.size() > 1 && RepositoriesConfigurationDialog.this.activeSiteList.indexOf(RepositoriesConfigurationDialog.this.currentSite) > 0);
                RepositoriesConfigurationDialog.this.downButton.setEnabled(RepositoriesConfigurationDialog.this.activeSiteList.size() > 1 && RepositoriesConfigurationDialog.this.activeSiteList.indexOf(RepositoriesConfigurationDialog.this.currentSite) < RepositoriesConfigurationDialog.this.activeSiteList.size() - 2);
            }
        });
        this.downButton = SWTUtil.createButton(buttonComp, Messages.downButton);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RepositoriesConfigurationDialog.this.moveSite(RepositoriesConfigurationDialog.this.currentSite, 1);
                RepositoriesConfigurationDialog.this.tableViewer.refresh();
                RepositoriesConfigurationDialog.this.upButton.setEnabled(RepositoriesConfigurationDialog.this.activeSiteList.size() > 1 && RepositoriesConfigurationDialog.this.activeSiteList.indexOf(RepositoriesConfigurationDialog.this.currentSite) > 0);
                RepositoriesConfigurationDialog.this.downButton.setEnabled(RepositoriesConfigurationDialog.this.activeSiteList.size() > 1 && RepositoriesConfigurationDialog.this.activeSiteList.indexOf(RepositoriesConfigurationDialog.this.currentSite) < RepositoriesConfigurationDialog.this.activeSiteList.size() - 2);
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        return composite;
    }

    protected void okPressed() {
        ArrayList<SiteHelper.SiteDelegate> selectedSiteList = new ArrayList<SiteHelper.SiteDelegate>(this.activeSiteList.size());
        for (SiteHelper.SiteDelegate site : this.activeSiteList) {
            if (!this.tableViewer.getChecked((Object)site)) continue;
            selectedSiteList.add(site);
        }
        this.isRefreshRequired = SiteHelper.applyConfigSiteChanges(this.activeSiteList, selectedSiteList);
        super.okPressed();
    }

    protected void moveSite(SiteHelper.SiteDelegate site, int direction) {
        int index = this.activeSiteList.indexOf(site);
        if (index == -1) {
            return;
        }
        int newIndex = index + direction;
        SiteHelper.SiteDelegate moveSite = this.activeSiteList.get(newIndex);
        this.activeSiteList.set(newIndex, site);
        this.activeSiteList.set(index, moveSite);
    }

    protected void replaceSite(SiteHelper.SiteDelegate oldSite, SiteHelper.SiteDelegate newSite, List<SiteHelper.SiteDelegate> sites) {
        int index = sites.indexOf(oldSite);
        if (index == -1) {
            return;
        }
        sites.set(index, newSite);
    }

    protected boolean isSiteInfoChanged(SiteHelper.SiteDelegate site, RepositoryInfoDialog d) {
        if (!d.getSiteName().equals(this.nullToEmptyString(site.getName()))) {
            return true;
        }
        if (!d.getSiteURL().equals(site.getURL())) {
            return true;
        }
        if (!this.nullToEmptyString(d.getSiteUser()).equals(this.nullToEmptyString(site.getUser()))) {
            return true;
        }
        return !this.nullToEmptyString(d.getSitePassword()).equals(this.nullToEmptyString(site.getPassword()));
    }

    protected boolean isRefreshRequired() {
        return this.isRefreshRequired;
    }

    private String nullToEmptyString(String value) {
        return value == null ? "" : value;
    }

    class RepoContentProvider
    implements IStructuredContentProvider {
        RepoContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            SiteHelper.SiteDelegate[] sites = new SiteHelper.SiteDelegate[RepositoriesConfigurationDialog.this.activeSiteList.size()];
            return RepositoriesConfigurationDialog.this.activeSiteList.toArray(sites);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class RepoTableLabelProvider
    implements ITableLabelProvider {
        RepoTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SiteHelper.SiteDelegate site = (SiteHelper.SiteDelegate)element;
            return site.getName();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }
}

