/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.ui.internal.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

class ProductMatcher {
    private static final Pattern validNumericVersionOrRange = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)\\+?$");

    ProductMatcher() {
    }

    static List<ProductInfo> processApplicableProducts(String appliesTo) {
        if (appliesTo == null || appliesTo.isEmpty()) {
            return Collections.emptyList();
        }
        ProductInfo info = new ProductInfo();
        ArrayList<ProductInfo> list = new ArrayList<ProductInfo>();
        boolean quoted = false;
        int index = 0;
        for (int i = 0; i < appliesTo.length(); ++i) {
            char c = appliesTo.charAt(i);
            if (c == '\"') {
                boolean bl = quoted = !quoted;
            }
            if (quoted) continue;
            if (c == ',') {
                ProductMatcher.add(info, appliesTo.substring(index, i).trim());
                index = i + 1;
                list.add(info);
                info = new ProductInfo();
                continue;
            }
            if (c != ';') continue;
            ProductMatcher.add(info, appliesTo.substring(index, i).trim());
            index = i + 1;
        }
        ProductMatcher.add(info, appliesTo.substring(index).trim());
        list.add(info);
        return list;
    }

    private static void add(ProductInfo productInfo, String trimmedString) {
        if (trimmedString.isEmpty()) {
            return;
        }
        if (productInfo.id == null) {
            productInfo.id = trimmedString;
        } else if (trimmedString.startsWith("productVersion")) {
            productInfo.version = ProductMatcher.getValue(trimmedString);
        } else if (trimmedString.startsWith("productEdition")) {
            String editionStr = ProductMatcher.getValue(trimmedString);
            int startIndex = 0;
            int endIndex = editionStr.indexOf(44);
            while (true) {
                productInfo.editions.add(editionStr.substring(startIndex, endIndex == -1 ? editionStr.length() : endIndex));
                if (endIndex != -1) {
                    startIndex = endIndex;
                    endIndex = editionStr.indexOf(44, ++startIndex);
                    continue;
                }
                break;
            }
        } else if (trimmedString.startsWith("productInstallType")) {
            productInfo.installType = ProductMatcher.getValue(trimmedString);
        }
    }

    private static String getValue(String substring) {
        int index = substring.indexOf(61);
        String substring1 = substring.substring(index + 1).trim();
        if (substring1.charAt(0) == '\"') {
            return substring1.substring(1, substring1.length() - 1);
        }
        return substring1;
    }

    static IStatus match(IProduct product, IRuntimeInfo runtime) {
        List<ProductInfo> appliesToList = ProductMatcher.processApplicableProducts(product.getAttribute("appliesTo"));
        if (appliesToList == null || appliesToList.isEmpty()) {
            return new Status(4, "com.ibm.ws.st.ui", Messages.errorAddonInvalid, null);
        }
        Status status = new Status(4, "com.ibm.ws.st.ui", Messages.errorRuntimeNoProductInfo, null);
        List runtimeProducts = runtime.getProducts();
        if (runtimeProducts != null) {
            for (IRuntimeInfo.IProduct runtimeProduct : runtimeProducts) {
                for (ProductInfo appliesTo : appliesToList) {
                    status = ProductMatcher.matches(appliesTo, runtimeProduct);
                    if (status != Status.OK_STATUS) continue;
                    return status;
                }
            }
        }
        return status;
    }

    private static IStatus matches(ProductInfo appliesTo, IRuntimeInfo.IProduct runtimeProduct) {
        if (appliesTo.id == null) {
            return new Status(4, "com.ibm.ws.st.ui", Messages.errorAddonNoProductId, null);
        }
        if (!appliesTo.id.equals(runtimeProduct.getProductId())) {
            String message = runtimeProduct.getProductId() == null || runtimeProduct.getProductId().isEmpty() ? Messages.errorRuntimeNoProductId : NLS.bind((String)Messages.errorAddonProdcutIdMismatch, (Object[])new String[]{runtimeProduct.getProductId(), appliesTo.id});
            return new Status(4, "com.ibm.ws.st.ui", message, null);
        }
        String productVersion = runtimeProduct.getProductVersion();
        if (appliesTo.version != null) {
            int[] targetProductVersion;
            int[] minAppliesToVersion;
            Matcher appliesToMatcher = validNumericVersionOrRange.matcher(appliesTo.version);
            boolean appliesToIsRange = appliesTo.version.endsWith("+");
            Matcher productVersionMatcher = validNumericVersionOrRange.matcher(productVersion);
            if (appliesToMatcher.matches() && appliesToIsRange && productVersionMatcher.matches() ? !ProductMatcher.versionSatisfiesMinimum(minAppliesToVersion = ProductMatcher.allMatcherGroupsToIntArray(appliesToMatcher), targetProductVersion = ProductMatcher.allMatcherGroupsToIntArray(productVersionMatcher)) : !appliesTo.version.equals(productVersion)) {
                return new Status(4, "com.ibm.ws.st.ui", NLS.bind((String)Messages.errorAddonVersionMismatch, (Object[])new String[]{productVersion, appliesTo.version}), null);
            }
        } else if (productVersion != null && productVersion.startsWith("8.5.0")) {
            return new Status(4, "com.ibm.ws.st.ui", NLS.bind((String)Messages.errorAddonNotSupported, (Object)productVersion), null);
        }
        if (!appliesTo.editions.isEmpty() && !appliesTo.editions.contains(runtimeProduct.getProductEdition())) {
            return new Status(4, "com.ibm.ws.st.ui", NLS.bind((String)Messages.errorAddonEditionMismatch, (Object[])new String[]{runtimeProduct.getProductEdition(), appliesTo.editions.toString()}), null);
        }
        if (appliesTo.installType != null && !appliesTo.installType.equals(runtimeProduct.getProductInstallType())) {
            return new Status(4, "com.ibm.ws.st.ui", NLS.bind((String)Messages.errorAddonInstallTypeMismatch, (Object[])new String[]{runtimeProduct.getProductInstallType(), appliesTo.installType}), null);
        }
        return Status.OK_STATUS;
    }

    private static int[] allMatcherGroupsToIntArray(Matcher matcher) {
        int numGroups = matcher.groupCount();
        int[] digits = new int[numGroups];
        for (int i = 0; i < numGroups; ++i) {
            digits[i] = Integer.parseInt(matcher.group(i + 1));
        }
        return digits;
    }

    private static boolean versionSatisfiesMinimum(int[] minimumVersion, int[] queryVersion) {
        if (minimumVersion.length == queryVersion.length) {
            for (int i = 0; i < minimumVersion.length; ++i) {
                if (queryVersion[i] < minimumVersion[i]) {
                    return false;
                }
                if (queryVersion[i] == minimumVersion[i] || queryVersion[i] <= minimumVersion[i]) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private static class ProductInfo {
        String id;
        String version;
        String installType;
        List<String> editions = new ArrayList<String>();
    }
}

