/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.download.ProductMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProductHelper {
    private static final String LIBERTY_PRODUCT_ID = "com.ibm.websphere.appserver";

    public static IStatus isApplicableTo(IProduct product, IRuntimeInfo runtime) {
        if (runtime == null) {
            return new Status(4, "com.ibm.ws.st.ui", Messages.errorRuntimeRequired, null);
        }
        if (product.getType() == IProduct.Type.IFIX) {
            return new Status(4, "com.ibm.ws.st.ui", Messages.errorAddonNotSupported, null);
        }
        return ProductMatcher.match(product, runtime);
    }

    static List<String> processProvideFeature(String provideFeature) {
        if (provideFeature == null) {
            return Collections.emptyList();
        }
        String[] features = provideFeature.split(",");
        ArrayList<String> list = new ArrayList<String>(features.length);
        for (String f : features) {
            list.add(f.replaceAll("\\s", ""));
        }
        return list;
    }

    static boolean isCore(IProduct product) {
        if (product == null) {
            return false;
        }
        return IProduct.Type.INSTALL == product.getType() && LIBERTY_PRODUCT_ID.equals(product.getRuntimeInfo().getPrimaryProductId());
    }
}

