/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.ContentAssistCombo;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.download.FeatureHandler;
import com.ibm.ws.st.ui.internal.download.LocalProduct;
import com.ibm.ws.st.ui.internal.download.ProductHelper;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NewAddonDialog
extends TitleAreaDialog {
    protected static final String PREF_ADDONS = "addons";
    protected Map<String, Object> map;
    protected ContentAssistCombo archive;
    protected String archiveName;
    protected final FeatureHandler featureHandler;

    public NewAddonDialog(Shell parentShell, FeatureHandler featureHandler, Map<String, Object> map) {
        super(parentShell);
        this.map = map;
        this.featureHandler = featureHandler;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.wizInstallAddonTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(Activator.getImage("addOnWizard"));
        this.setTitle(Messages.wizInstallAddonTitle);
        this.setMessage(Messages.wizInstallAddonDescription);
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(Messages.wizInstallAddonArchiveMessage);
        label.setLayoutData((Object)new GridData(1, 2, true, false, 3, 1));
        label = new Label(comp, 0);
        label.setText(Messages.wizInstallAddonArchive);
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        ExtendsContentProvider extContentProvider = new ExtendsContentProvider();
        this.archive = new ContentAssistCombo(comp, extContentProvider);
        String[] exts = extContentProvider.getSuggestions("", true);
        if (exts != null) {
            for (String s : exts) {
                if (!new File(s).exists()) continue;
                this.archiveName = s;
                this.archive.setText(s);
                break;
            }
        }
        this.archive.setLayoutData(new GridData(4, 2, true, false));
        this.archive.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewAddonDialog.this.archiveName = NewAddonDialog.this.archive.getText().trim();
                NewAddonDialog.this.enableOKButton(NewAddonDialog.this.validate());
            }
        });
        Button browse = SWTUtil.createButton(comp, Messages.browse);
        ((GridData)browse.getLayoutData()).verticalAlignment = 2;
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dialog = new FileDialog(NewAddonDialog.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.jar;*.zip;*.esa"});
                dialog.setFileName(NewAddonDialog.this.archive.getText());
                String file = dialog.open();
                if (file != null) {
                    NewAddonDialog.this.archive.setText(file);
                }
            }
        });
        label = new Label(comp, 0);
        GridData data = new GridData(4, 4, true, true, 3, 1);
        data.verticalSpan = 5;
        label.setLayoutData((Object)data);
        return comp;
    }

    protected boolean validate() {
        if (this.archiveName == null || this.archiveName.isEmpty()) {
            this.setMessage(Messages.wizInstallAddonDescription, 0);
            return false;
        }
        File file = new File(this.archiveName);
        if (!file.exists()) {
            this.setMessage(Messages.errorInvalidArchive, 3);
            return false;
        }
        String error = NewAddonDialog.validateArchive(this.archiveName, this.featureHandler, this.map);
        if (error != null) {
            this.setMessage(error, 3);
            return false;
        }
        this.setMessage(Messages.wizInstallAddonDescription, 0);
        return true;
    }

    protected static String validateArchive(String archiveName, FeatureHandler featureHandler, Map<String, Object> map) {
        LocalProduct product = LocalProduct.create(archiveName);
        if (product == null || product.getType() == IProduct.Type.INSTALL) {
            return Messages.errorWizNotAddonJar;
        }
        IRuntimeInfo newCore = (IRuntimeInfo)map.get("core");
        IStatus status = ProductHelper.isApplicableTo(product, newCore);
        if (status != Status.OK_STATUS) {
            if (SiteHelper.isZipRepoSupported(newCore) && SiteHelper.isValidOnPremZipRepository(new File(archiveName))) {
                return Messages.errorAddonIsRepo;
            }
            return status.getMessage();
        }
        if (featureHandler != null && featureHandler.containsFeatures(product.getProvideFeature())) {
            return Messages.errorAddonAlreadyInstalled;
        }
        List localArchives = (List)map.get("archives");
        if (localArchives != null && !localArchives.isEmpty()) {
            int size = localArchives.size();
            for (int i = 0; i < size; ++i) {
                File file = new File(((String)localArchives.get(i)).trim());
                if (!product.getName().equals(file.getName())) continue;
                return NLS.bind((String)Messages.errorWizAddonJarDup, (Object)archiveName);
            }
        }
        return null;
    }

    public String getArchive() {
        return this.archiveName;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOKButton(this.validate());
        return control;
    }

    protected void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    protected class ExtendsContentProvider
    extends ContentAssistCombo.ContentProvider {
        protected ExtendsContentProvider() {
        }

        @Override
        public String[] getSuggestions(String hint, boolean showAll) {
            ArrayList<String> items = new ArrayList<String>();
            items.addAll(Activator.getPreferenceList(NewAddonDialog.PREF_ADDONS));
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String s : items) {
                boolean found = false;
                for (String t : suggestions) {
                    if (!t.equalsIgnoreCase(s)) continue;
                    found = true;
                }
                if (found || !showAll && !NewAddonDialog.this.archive.matches(s)) continue;
                suggestions.add(s);
            }
            return suggestions.toArray(new String[suggestions.size()]);
        }
    }
}

