/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.download.AbstractDownloadComposite;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InstallContentComposite
extends AbstractDownloadComposite {
    protected Text installDir;
    protected Label contentLabel;
    protected Label sizeLabel;

    public InstallContentComposite(Composite parent, Map<String, Object> map, AbstractDownloadComposite.IContainer container, AbstractDownloadComposite.IMessageHandler handler) {
        super(parent, map, container, handler);
        container.setTitle(Messages.wizInstallContentTitle);
        container.setDescription(Messages.wizInstallContentDescription);
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        Group installGroup = new Group((Composite)this, 0);
        installGroup.setText(Messages.wizInstallFolder);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        installGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        installGroup.setLayoutData((Object)data);
        this.installDir = new Text((Composite)installGroup, 0);
        this.installDir.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.installDir.setText((String)this.map.get("folder"));
        this.installDir.setEnabled(false);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.wizInstallArchiveSize);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sizeLabel = new Label((Composite)this, 0);
        this.sizeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)this, 0);
        label.setText(Messages.wizInstallFileName);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.contentLabel = new Label((Composite)this, 64);
        this.contentLabel.setLayoutData((Object)new GridData(4, 128, true, true));
        Dialog.applyDialogFont((Control)this);
    }

    private void updateInfo() {
        long size = 0L;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        List productList = (List)this.map.get("selectedDownloaders");
        for (IProduct p : productList) {
            size += p.getSize();
            if (!first) {
                sb.append(",\n");
            } else {
                first = false;
            }
            sb.append(p.getName());
        }
        this.sizeLabel.setText(DownloadHelper.getSize(size));
        this.contentLabel.setText(sb.toString());
        this.layout();
    }

    @Override
    public void enter() {
        this.updateInfo();
        this.installDir.setFocus();
    }

    @Override
    public void performCancel(IProgressMonitor monitor) throws CoreException {
    }
}

