/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final MessageDigest messagedigestMD5;
    static final MessageDigest messagedigestSHA256;

    public static String getMD5String(String str) {
        return HashUtils.getHashString(str, messagedigestMD5);
    }

    public static String getFileMD5String(File file) throws IOException {
        return HashUtils.getFileHashString(file, messagedigestMD5);
    }

    public static String getSHA256String(String str) {
        return HashUtils.getHashString(str, messagedigestSHA256);
    }

    public static String getFileSHA256String(File file) throws IOException {
        return HashUtils.getFileHashString(file, messagedigestSHA256);
    }

    private static String getHashString(String str, MessageDigest messagedigest) {
        messagedigest.update(str.getBytes());
        return HashUtils.byteArrayToHexString(messagedigest.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileHashString(File file, MessageDigest messagedigest) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int numRead = 0;
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                messagedigest.update(buffer, 0, numRead);
            }
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (Exception exception) {}
            }
        }
        return HashUtils.byteArrayToHexString(messagedigest.digest());
    }

    private static String byteArrayToHexString(byte[] byteArray) {
        StringBuffer stringbuffer = new StringBuffer(2 * byteArray.length);
        for (int i = 0; i < byteArray.length; ++i) {
            char upper = hexDigits[(byteArray[i] & 0xF0) >> 4];
            char lower = hexDigits[byteArray[i] & 0xF];
            stringbuffer.append(upper);
            stringbuffer.append(lower);
        }
        return stringbuffer.toString();
    }

    static {
        try {
            messagedigestMD5 = MessageDigest.getInstance("MD5");
            messagedigestSHA256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

