/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IProduct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

class FeatureResolver {
    FeatureResolver() {
    }

    protected static List<String> getAllRequireFeature(IProduct product, List<IProduct> availableProducts) {
        List requireList = product.getRequireFeature();
        if (requireList.isEmpty()) {
            return Collections.emptyList();
        }
        Stack<String> requireStack = new Stack<String>();
        requireStack.addAll(requireList);
        ArrayList<String> finalRequireList = new ArrayList<String>();
        while (!requireStack.isEmpty()) {
            String feature = (String)requireStack.pop();
            if (finalRequireList.contains(feature)) continue;
            finalRequireList.add(feature);
            List<String> reqList = FeatureResolver.getRequireFeature(feature, product, availableProducts);
            if (reqList.isEmpty()) continue;
            requireStack.addAll(reqList);
        }
        return finalRequireList;
    }

    private static List<String> getRequireFeature(String feature, IProduct originalProduct, List<IProduct> availableProducts) {
        ArrayList<String> list = new ArrayList<String>();
        for (IProduct p : availableProducts) {
            if (p == originalProduct || p.getType() != IProduct.Type.FEATURE || !feature.equals(p.getProvideFeature().get(0))) continue;
            list.addAll(p.getRequireFeature());
        }
        return list;
    }
}

