/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.AbstractInstaller;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import com.ibm.ws.st.ui.internal.download.HashUtils;
import com.ibm.ws.st.ui.internal.download.LocalProduct;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ExtractorInstaller
extends AbstractInstaller {
    private static String EXT_JAR = ".jar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus install(IProduct product, PasswordAuthentication pa, Map<String, Object> settings, IProgressMonitor monitor2) {
        IPath installPath = (IPath)settings.get("runtimeLocation");
        if (installPath == null) {
            return new Status(4, "com.ibm.ws.st.ui", 0, Messages.errorRuntimeLocationMissing, (Throwable)new IOException(Messages.errorRuntimeLocationMissing));
        }
        File temp = null;
        IProgressMonitor monitor = monitor2;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.beginTask(Messages.jobInstallingRuntime, 100);
        try {
            if (product instanceof LocalProduct) {
                File archiveFile = new File(product.getSource().getLocation());
                if (archiveFile.isFile()) {
                    DownloadHelper.unzip(archiveFile, installPath, archiveFile.length(), (IProgressMonitor)new SubProgressMonitor(monitor, 100), product.getName());
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            temp = File.createTempFile("download", EXT_JAR);
            DownloadHelper.download(product, temp, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            String checksum = product.getHashSHA256();
            if (!this.verifyDownload(temp, checksum)) {
                throw new Exception(NLS.bind((String)Messages.errorVerificationFailed, (Object)product.getName()));
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            DownloadHelper.unzip(temp, installPath, temp.length(), (IProgressMonitor)new SubProgressMonitor(monitor, 20), product.getName());
        }
        catch (Exception e) {
            Status status = new Status(4, "com.ibm.ws.st.ui", 0, e.getLocalizedMessage(), (Throwable)e);
            return status;
        }
        finally {
            if (temp != null && temp.exists() && !temp.delete() && Trace.ENABLED) {
                Trace.trace((byte)1, "Could not delete file: " + temp.getName());
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private boolean verifyDownload(File temp, String checksum) {
        if (checksum == null) {
            return true;
        }
        try {
            String fileHash = HashUtils.getFileSHA256String(temp);
            return fileHash.equals(checksum);
        }
        catch (IOException e) {
            Trace.logError("Failed to generate hash for file " + temp, e);
            return false;
        }
    }
}

