/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.core.internal.repository.ISite;
import com.ibm.ws.st.core.internal.repository.License;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.download.AbstractDownloadComposite;
import com.ibm.ws.st.ui.internal.download.AddonUtil;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import com.ibm.ws.st.ui.internal.download.FeatureHandler;
import com.ibm.ws.st.ui.internal.download.FeatureResolver;
import com.ibm.ws.st.ui.internal.download.LocalProduct;
import com.ibm.ws.st.ui.internal.download.NewAddonDialog;
import com.ibm.ws.st.ui.internal.download.PasswordDialog;
import com.ibm.ws.st.ui.internal.download.RepositoriesConfigurationDialog;
import com.ibm.ws.st.ui.internal.download.SiteHelper;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AddonsComposite
extends AbstractDownloadComposite {
    protected static final String PAGE_NAME = "add-ons";
    protected Link configRepoLink;
    protected ScrolledComposite scrollComp;
    protected Button addArchive;
    protected Label summaryLabel;
    protected Text summaryValueLabel;
    protected Label downloadsTotalLabel;
    protected Text downloadsValueLabel;
    protected Text filterText;
    protected String filter;
    protected Font boldFont;
    protected Color selEdgeColor;
    protected Color selFillColor;
    protected List<IProduct> allApplicableAddOnList = new ArrayList<IProduct>();
    protected IRuntimeInfo core = null;
    protected FeatureHandler featureHandler = new FeatureHandler();
    protected List<IProduct.Type> typeFilterList = new ArrayList<IProduct.Type>();
    protected List<IProduct.Type> typeFilterMenuList = new ArrayList<IProduct.Type>();
    protected boolean isShowSelectedOnly = false;
    protected boolean isHideConflictingProducts = false;
    protected boolean isHideInstalledProducts = true;
    protected boolean updating = false;
    protected ISite selectedSite = null;
    protected HashMap<ISite, PasswordAuthentication> siteAuthentication;
    protected Map<IProduct, PasswordAuthentication> productAuthentication = new HashMap<IProduct, PasswordAuthentication>();
    protected Label barLabel;
    protected ProgressBar bar;
    protected final AtomicInteger licenseJobCounter = new AtomicInteger();
    protected final Map<IProduct, Boolean> licenseStatusMap = new ConcurrentHashMap<IProduct, Boolean>();
    protected final List<IProduct> licenseRemoveList = new ArrayList<IProduct>();
    private LicenseThread licenseThread;
    protected Listener scrollCompositeListener;
    Set<IProduct> implicitProducts = new HashSet<IProduct>();
    private Thread timerThread = null;

    public AddonsComposite(Composite parent, Map<String, Object> map, AbstractDownloadComposite.IContainer container, AbstractDownloadComposite.IMessageHandler handler) {
        super(parent, map, container, handler);
        container.setTitle(Messages.wizInstallAddonTitle);
        container.setDescription(Messages.wizInstallAddonDescription);
        this.init();
        this.createControl();
    }

    @Override
    public void performCancel(IProgressMonitor monitor) throws CoreException {
        if (this.licenseThread != null) {
            this.licenseThread.done();
            this.licenseThread = null;
        }
    }

    @Override
    public void enter() {
        this.updateAddons();
        this.updateSummary();
        this.licenseThread = new LicenseThread();
        this.licenseThread.setDaemon(true);
        this.licenseThread.start();
        this.validate();
    }

    @Override
    public void exit() {
        List selectedAddOn;
        ArrayList<IProduct> selectedList = (ArrayList<IProduct>)this.map.get("selectedDownloaders");
        ArrayList<PasswordAuthentication> authList = (ArrayList<PasswordAuthentication>)this.map.get("productAuthentication");
        if (selectedList == null) {
            selectedList = new ArrayList<IProduct>();
            this.map.put("selectedDownloaders", selectedList);
        } else {
            selectedList.clear();
        }
        if (authList == null) {
            authList = new ArrayList<PasswordAuthentication>();
            this.map.put("productAuthentication", authList);
        } else {
            authList.clear();
        }
        IProduct coreManager = (IProduct)this.map.get("coreManager");
        if (coreManager != null) {
            selectedList.add(coreManager);
            authList.add(this.productAuthentication.get(coreManager));
        }
        if (!(selectedAddOn = (List)this.map.get("selectedAddOns")).isEmpty()) {
            this.sortAddonList(selectedAddOn);
            selectedList.addAll(selectedAddOn);
            for (IProduct p : selectedAddOn) {
                authList.add(this.productAuthentication.get(p));
            }
        }
        if (!this.licenseRemoveList.isEmpty()) {
            Map<IProduct, License> licenseMap = this.getLicenseMap(false);
            for (IProduct p : this.licenseRemoveList) {
                if (licenseMap != null && licenseMap.containsKey(p)) {
                    licenseMap.remove(p);
                }
                if (!this.licenseStatusMap.containsKey(p)) continue;
                this.licenseStatusMap.remove(p);
            }
            this.licenseRemoveList.clear();
        }
        if (this.licenseThread != null) {
            this.licenseThread.done();
            this.licenseThread = null;
        }
    }

    private void init() {
        this.siteAuthentication = (HashMap)this.map.get("siteAuthentication");
        if (this.siteAuthentication == null) {
            this.siteAuthentication = new HashMap();
            this.map.put("siteAuthentication", this.siteAuthentication);
        }
        this.initializeTypeFilterList();
        this.scrollCompositeListener = new Listener(){

            public void handleEvent(Event event) {
                if (AddonsComposite.this.scrollComp == null || AddonsComposite.this.scrollComp.isDisposed()) {
                    return;
                }
                if (event.type == 3) {
                    Button b = AddonsComposite.this.getInstallButton(event);
                    if (b != null) {
                        b.setFocus();
                    } else {
                        AddonsComposite.this.scrollComp.setFocus();
                    }
                } else if (event.type == 1 && (event.keyCode == 0x1000006 || event.keyCode == 0x1000005)) {
                    int selection;
                    ScrollBar vBar = AddonsComposite.this.scrollComp.getVerticalBar();
                    Rectangle r = AddonsComposite.this.scrollComp.getClientArea();
                    int n = selection = event.keyCode == 0x1000006 ? vBar.getSelection() + r.height : vBar.getSelection() - r.height;
                    if (selection < vBar.getMaximum() && selection >= 0) {
                        vBar.setSelection(selection);
                        Composite comp = (Composite)AddonsComposite.this.scrollComp.getContent();
                        Point location = comp.getLocation();
                        comp.setLocation(location.x, -vBar.getSelection());
                    }
                }
            }
        };
    }

    protected void initializeTypeFilterList() {
        Object presetTypes = this.map.get("typeFilterPreset");
        if (presetTypes == null) {
            for (IProduct.Type type : IProduct.Type.values()) {
                if (type == IProduct.Type.INSTALL || type == IProduct.Type.IFIX || type == IProduct.Type.CONFIG_SNIPPET || type == IProduct.Type.UNKNOWN) continue;
                this.typeFilterList.add(type);
                this.typeFilterMenuList.add(type);
            }
        } else {
            List types = (List)presetTypes;
            for (IProduct.Type type : IProduct.Type.values()) {
                if (!types.contains(type)) continue;
                this.typeFilterList.add(type);
                this.typeFilterMenuList.add(type);
            }
        }
    }

    protected void createControl() {
        final Shell shell = this.getShell();
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        Composite filterComp = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        filterComp.setLayout((Layout)layout);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalSpan = 3;
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        filterComp.setLayoutData((Object)data);
        final Button filterButton = new Button(filterComp, 0x4000008);
        filterButton.setText(Messages.wizSearchFilterLabel);
        filterButton.setImage(Activator.getImage("menuDown"));
        data = new GridData(1, 1, false, false);
        filterButton.setLayoutData((Object)data);
        this.filterText = new Text(filterComp, 128);
        this.filterText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.filterText.setText(Messages.wizDefaultFilterText);
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Decorations)shell, 8);
                AddonsComposite.this.fillFilterMenu(menu);
                AddonsComposite.this.displayDropdownMenu((Control)filterButton, menu, true);
                menu.dispose();
            }
        });
        this.configRepoLink = new Link((Composite)this, 0);
        this.configRepoLink.setText("<a>" + Messages.wizConfigRepoLabel + "</a>");
        this.configRepoLink.setLayoutData((Object)new GridData(3, 2, true, false, 3, 1));
        this.configRepoLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoriesConfigurationDialog d = new RepositoriesConfigurationDialog(AddonsComposite.this.getShell(), AddonsComposite.this.map);
                if (d.open() == 0 && d.isRefreshRequired()) {
                    AddonsComposite.this.refreshAddonTable();
                    AddonsComposite.this.updateSummary();
                    AddonsComposite.this.validate();
                }
            }
        });
        this.scrollComp = new ScrolledComposite((Composite)this, 2560);
        data = new GridData(4, 4, true, true, 3, 1);
        data.heightHint = 350;
        this.scrollComp.setLayoutData((Object)data);
        this.scrollComp.setAlwaysShowScrollBars(true);
        this.scrollComp.setBackground(this.scrollComp.getDisplay().getSystemColor(25));
        int lineHeight = this.filterText.computeSize((int)-1, (int)-1).y;
        this.scrollComp.getVerticalBar().setPageIncrement(lineHeight * 3);
        this.scrollComp.getVerticalBar().setIncrement(lineHeight);
        DropTarget target = new DropTarget((Control)this.scrollComp, 19);
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        target.setTransfer(new Transfer[]{fileTransfer});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                if (!fileTransfer.isSupportedType(event.currentDataType)) {
                    return;
                }
                AddonsComposite.this.handleDrop((String[])event.data, AddonsComposite.this.filterText);
            }
        });
        this.scrollComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                Control c = AddonsComposite.this.scrollComp.getContent();
                if (c == null) {
                    return;
                }
                Rectangle r = AddonsComposite.this.scrollComp.getClientArea();
                r.height = c.computeSize((int)r.width, (int)-1).y;
                c.setBounds(r);
            }
        });
        Font font = this.getFont();
        if (this.boldFont == null) {
            Display display = this.getShell().getDisplay();
            FontData[] fontData = font.getFontData();
            fontData[0].setStyle(1);
            fontData[0].setHeight(fontData[0].getHeight());
            this.boldFont = new Font((Device)display, fontData);
            Color c1 = display.getSystemColor(26);
            Color c2 = display.getSystemColor(25);
            this.selEdgeColor = new Color((Device)display, (c1.getRed() + c2.getRed() * 3) / 4, (c1.getGreen() + c2.getGreen() * 3) / 4, (c1.getBlue() + c2.getBlue() * 3) / 4);
            this.selFillColor = new Color((Device)display, (c1.getRed() + c2.getRed() * 8) / 9, (c1.getGreen() + c2.getGreen() * 8) / 9, (c1.getBlue() + c2.getBlue() * 8) / 9);
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (AddonsComposite.this.boldFont != null) {
                    AddonsComposite.this.boldFont.dispose();
                }
                if (AddonsComposite.this.selEdgeColor != null) {
                    AddonsComposite.this.selEdgeColor.dispose();
                }
                if (AddonsComposite.this.selFillColor != null) {
                    AddonsComposite.this.selFillColor.dispose();
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (AddonsComposite.this.updating) {
                    return;
                }
                String text = AddonsComposite.this.filterText.getText();
                AddonsComposite.this.filter = Messages.wizDefaultFilterText.equals(text) ? null : AddonsComposite.this.filterText.getText();
                AddonsComposite.this.filterUpdate();
            }
        });
        this.filterText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (AddonsComposite.this.filterText.getText().isEmpty()) {
                    AddonsComposite.this.updating = true;
                    AddonsComposite.this.filterText.setText(Messages.wizDefaultFilterText);
                    AddonsComposite.this.updating = false;
                }
            }

            public void focusGained(FocusEvent e) {
                if (Messages.wizDefaultFilterText.equals(AddonsComposite.this.filterText.getText())) {
                    AddonsComposite.this.updating = true;
                    AddonsComposite.this.filterText.setText("");
                    AddonsComposite.this.updating = false;
                }
            }
        });
        this.addArchive = new Button((Composite)this, 0);
        this.addArchive.setText(Messages.wizInstallAddonAddArchive);
        this.addArchive.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.addArchive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String archiveName;
                NewAddonDialog dialog = new NewAddonDialog(AddonsComposite.this.getShell(), AddonsComposite.this.featureHandler, AddonsComposite.this.map);
                if (dialog.open() == 0 && (archiveName = dialog.getArchive()) != null) {
                    AddonsComposite.this.addArchiveAddOn(archiveName, AddonsComposite.this.filterText);
                }
            }
        });
        Composite summaryComp = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        summaryComp.setLayout((Layout)layout);
        data = new GridData(3, 4, true, true, 1, 1);
        summaryComp.setLayoutData((Object)data);
        this.summaryLabel = new Label(summaryComp, 0);
        this.summaryLabel.setLayoutData((Object)new GridData(3, 2, true, false, 1, 1));
        this.summaryLabel.setText(Messages.wizInstallAddonSummary);
        this.summaryValueLabel = new Text(summaryComp, 8);
        this.summaryValueLabel.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        this.summaryValueLabel.setForeground(summaryComp.getForeground());
        this.summaryValueLabel.setBackground(summaryComp.getBackground());
        this.downloadsTotalLabel = new Label(summaryComp, 0);
        this.downloadsTotalLabel.setLayoutData((Object)new GridData(3, 2, true, false, 1, 1));
        this.downloadsTotalLabel.setText(Messages.wizInstallDownloadSummary);
        this.downloadsValueLabel = new Text(summaryComp, 8);
        this.downloadsValueLabel.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        this.downloadsValueLabel.setForeground(summaryComp.getForeground());
        this.downloadsValueLabel.setBackground(summaryComp.getBackground());
        this.barLabel = new Label((Composite)this, 0);
        this.barLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.barLabel.setText(Messages.taskDownloadLicense);
        this.bar = new ProgressBar((Composite)this, 65536);
        this.bar.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.bar.setMaximum(200);
        Dialog.applyDialogFont((Control)this);
        this.filterText.setFocus();
        this.updateSummary();
    }

    protected void filterUpdate() {
        boolean updateRunning;
        boolean bl = updateRunning = this.timerThread != null && this.timerThread.isAlive();
        if (!updateRunning) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Starting timer thread");
            }
            this.startTimerThread();
        } else {
            this.timerThread.interrupt();
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Interrupted and restarted timer thread");
            }
            this.startTimerThread();
        }
    }

    private void startTimerThread() {
        this.timerThread = new Thread(){

            @Override
            public void run() {
                block4: {
                    try {
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "Addon timer started for 500ms");
                        }
                        10.sleep(500L);
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "Updating addon table");
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                AddonsComposite.this.updateAddonTable();
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        if (!Trace.ENABLED) break block4;
                        Trace.trace((byte)0, "Addon timer thread was interrupted");
                    }
                }
            }
        };
        this.timerThread.start();
    }

    protected void handleDrop(String[] files, Text filterText) {
        if (files == null) {
            return;
        }
        for (String archiveName : files) {
            String error = NewAddonDialog.validateArchive(archiveName, this.featureHandler, this.map);
            if (error != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.title, (String)error);
                continue;
            }
            this.addArchiveAddOn(archiveName, filterText);
        }
    }

    protected void displayDropdownMenu(Control anchor, Menu menu, boolean subtractWidth) {
        Point size = anchor.getSize();
        Point point = anchor.toDisplay(0, size.y);
        menu.setLocation(point.x - (subtractWidth ? size.x : 0), point.y);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            Display display = menu.getShell().getDisplay();
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void fillFilterMenu(Menu menu) {
        MenuItem item;
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MenuItem item = (MenuItem)event.getSource();
                if (item.getSelection()) {
                    AddonsComposite.this.typeFilterList.add((IProduct.Type)item.getData());
                } else {
                    AddonsComposite.this.typeFilterList.remove(item.getData());
                }
                AddonsComposite.this.updateAddonTable();
            }
        };
        for (IProduct.Type type : this.typeFilterMenuList) {
            item = new MenuItem(menu, 32);
            item.setText(type.toString());
            item.setData((Object)type);
            item.setSelection(this.typeFilterList.contains(type));
            item.addSelectionListener((SelectionListener)listener);
        }
        item = new MenuItem(menu, 2);
        final MenuItem selectedItem = new MenuItem(menu, 32);
        selectedItem.setText(Messages.wizSelectedFilterLabel);
        selectedItem.setSelection(this.isShowSelectedOnly);
        selectedItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AddonsComposite.this.isShowSelectedOnly = selectedItem.getSelection();
                AddonsComposite.this.updateAddonTable();
            }
        });
        final MenuItem hideDuplicatesItem = new MenuItem(menu, 32);
        hideDuplicatesItem.setText(Messages.wizConflictFilterLabel);
        hideDuplicatesItem.setSelection(this.isHideConflictingProducts);
        hideDuplicatesItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AddonsComposite.this.isHideConflictingProducts = hideDuplicatesItem.getSelection();
                AddonsComposite.this.updateAddonTable();
            }
        });
        final MenuItem hideInstalledItem = new MenuItem(menu, 32);
        hideInstalledItem.setText(Messages.wizInstalledFilterLabel);
        hideInstalledItem.setSelection(this.isHideInstalledProducts);
        hideInstalledItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AddonsComposite.this.isHideInstalledProducts = hideInstalledItem.getSelection();
                AddonsComposite.this.updateAddonTable();
            }
        });
    }

    protected void addArchiveAddOn(String archiveName, Text filterText) {
        ArrayList<String> archives = (ArrayList<String>)this.map.get("archives");
        if (archives == null) {
            archives = new ArrayList<String>();
            this.map.put("archives", archives);
        }
        archives.add(archiveName);
        List addOnList = (List)this.map.get("selectedAddOns");
        LocalProduct product = LocalProduct.create(archiveName);
        addOnList.add(product);
        this.allApplicableAddOnList.add(product);
        this.downloadLicense(product);
        this.featureHandler.addFeatures(product.getProvideFeature());
        if (product.getType() == IProduct.Type.FEATURE) {
            this.featureHandler.addFeatures(FeatureResolver.getAllRequireFeature(product, this.allApplicableAddOnList));
        }
        filterText.setText("");
        this.updateAddonTable();
        this.updateSummary();
        this.validate();
        Rectangle r = this.scrollComp.getClientArea();
        int h = this.scrollComp.getContent().computeSize((int)this.scrollComp.getClientArea().width, (int)-1).y;
        if (h > r.height) {
            this.scrollComp.setOrigin(0, h - r.height);
        }
    }

    protected boolean isCoreRuntimeExpected() {
        return true;
    }

    protected void sortAddonList(List<IProduct> addonList) {
        Collections.sort(addonList, new Comparator<IProduct>(){

            @Override
            public int compare(IProduct p1, IProduct p2) {
                int t2;
                int t1 = AddonsComposite.this.getDisplayType(p1).ordinal();
                if (t1 == (t2 = AddonsComposite.this.getDisplayType(p2).ordinal())) {
                    return 0;
                }
                return t1 < t2 ? -1 : 1;
            }
        });
    }

    protected void validate() {
        List addOnList = (List)this.map.get("selectedAddOns");
        if (addOnList == null || addOnList.isEmpty()) {
            this.setMessage(null, this.isCoreRuntimeExpected() && this.map.get("coreManager") != null ? 0 : 3);
            return;
        }
        if (this.licenseJobCounter.get() > 0) {
            this.setMessage(null, 3);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (IProduct p : addOnList) {
            if (Boolean.TRUE.equals(this.licenseStatusMap.get(p))) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(p.getName());
        }
        if (sb.length() > 0) {
            this.setMessage(NLS.bind((String)Messages.wizLicenseError, (Object)sb.toString()), 3);
            return;
        }
        this.setMessage(null, 0);
    }

    protected boolean isAuthenticationRequired(IProduct product) {
        return false;
    }

    protected PasswordAuthentication getAuthentication(IProduct product) {
        PasswordAuthentication authentication = this.productAuthentication.get(product);
        if (authentication == null) {
            authentication = this.getAuthentication(this.getSite(product));
            this.productAuthentication.put(product, authentication);
        }
        return authentication;
    }

    protected PasswordAuthentication getAuthentication(ISite site) {
        PasswordAuthentication authentication = this.siteAuthentication.get(site);
        if (authentication == null || authentication.getUserName().isEmpty() || authentication.getPassword().length == 0) {
            PasswordDialog dialog = new PasswordDialog(this.getShell(), NLS.bind((String)Messages.loginPasswordDialogMessage, (Object)site.getName()), authentication);
            if (dialog.open() == 1) {
                return null;
            }
            authentication = new PasswordAuthentication(dialog.getUser(), dialog.getPassword().toCharArray());
            this.siteAuthentication.put(site, authentication);
        }
        return authentication;
    }

    private ISite getSite(IProduct p) {
        return this.selectedSite;
    }

    protected void updateAddons() {
        IRuntimeInfo newCore = (IRuntimeInfo)this.map.get("core");
        ArrayList<IProduct> selectedAddOns = (ArrayList<IProduct>)this.map.get("selectedAddOns");
        if (selectedAddOns == null) {
            selectedAddOns = new ArrayList<IProduct>(4);
            this.map.put("selectedAddOns", selectedAddOns);
        }
        this.selectedSite = SiteHelper.getDefaultAddOnSite();
        if (this.core == newCore) {
            this.updateAddonTable();
            return;
        }
        if (!selectedAddOns.isEmpty()) {
            this.removeSelectedAddOns(selectedAddOns);
        }
        this.core = newCore;
        this.licenseStatusMap.clear();
        this.productAuthentication.clear();
        this.featureHandler.reset();
        IProduct coreManager = (IProduct)this.map.get("coreManager");
        if (coreManager != null) {
            this.featureHandler.addFeatures(coreManager.getProvideFeature());
        }
        this.refreshAddonTable();
    }

    protected void refreshAddonTable() {
        ISite[] iSiteArray;
        this.configRepoLink.setEnabled(false);
        this.configRepoLink.setVisible(this.core.isOnPremiseSupported());
        this.filterText.setEnabled(false);
        Control content = this.scrollComp.getContent();
        if (content != null) {
            content.dispose();
        }
        Composite labelComp = new Composite((Composite)this.scrollComp, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 12;
        labelComp.setLayout((Layout)layout);
        labelComp.setBackground(this.scrollComp.getBackground());
        Label descriptionLabel = new Label(labelComp, 0);
        descriptionLabel.setLayoutData((Object)new GridData(4, 1, false, false));
        descriptionLabel.setBackground(this.scrollComp.getBackground());
        descriptionLabel.setText(Messages.wizDownloadConnecting);
        this.scrollComp.setContent((Control)labelComp);
        labelComp.setSize(labelComp.computeSize(-1, -1));
        if (this.core.isOnPremiseSupported()) {
            iSiteArray = SiteHelper.getAvailableSites();
        } else {
            ISite[] iSiteArray2 = new ISite[1];
            iSiteArray = iSiteArray2;
            iSiteArray2[0] = SiteHelper.getDefaultAddOnSite();
        }
        final ISite[] availableSites = iSiteArray;
        this.allApplicableAddOnList.clear();
        final ArrayList<SiteThread> siteThreads = new ArrayList<SiteThread>(availableSites.length);
        final ConcurrentHashMap<ISite, List<IProduct>> siteProductMap = new ConcurrentHashMap<ISite, List<IProduct>>();
        for (int i = 0; i < availableSites.length; ++i) {
            if (!this.isSiteSupported(availableSites[i], this.core)) continue;
            SiteThread siteThread = new SiteThread(availableSites[i], siteProductMap);
            siteThread.setDaemon(true);
            siteThread.start();
            siteThreads.add(siteThread);
        }
        Thread finalizeThread = new Thread("Checking available repositories"){

            @Override
            public void run() {
                try {
                    for (SiteThread thread : siteThreads) {
                        thread.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (availableSites.length > 0) {
                    List productList = (List)siteProductMap.get(availableSites[0]);
                    if (productList != null) {
                        AddonsComposite.this.allApplicableAddOnList.addAll(productList);
                    }
                    for (int i = 1; i < availableSites.length; ++i) {
                        productList = (List)siteProductMap.get(availableSites[i]);
                        if (productList == null) continue;
                        for (IProduct p : productList) {
                            if (AddonsComposite.this.allApplicableAddOnList.contains(p)) continue;
                            AddonsComposite.this.allApplicableAddOnList.add(p);
                        }
                    }
                }
                Collections.sort(AddonsComposite.this.allApplicableAddOnList, new Comparator<IProduct>(){

                    @Override
                    public int compare(IProduct p1, IProduct p2) {
                        int t2;
                        int t1 = AddonsComposite.this.getDisplayType(p1).ordinal();
                        if (t1 == (t2 = AddonsComposite.this.getDisplayType(p2).ordinal())) {
                            return Collator.getInstance().compare(p1.getName(), p2.getName());
                        }
                        return t1 < t2 ? -1 : 1;
                    }
                });
                List selectedList = (List)AddonsComposite.this.map.get("selectedAddOns");
                if (selectedList != null) {
                    ArrayList<IProduct> removeList = new ArrayList<IProduct>(selectedList.size());
                    for (int i = 0; i < selectedList.size(); ++i) {
                        IProduct p;
                        p = (IProduct)selectedList.get(i);
                        if (p instanceof LocalProduct) {
                            AddonsComposite.this.allApplicableAddOnList.add(p);
                            continue;
                        }
                        int index = AddonsComposite.this.allApplicableAddOnList.indexOf(p);
                        if (index == -1) {
                            removeList.add(p);
                            continue;
                        }
                        selectedList.set(i, AddonsComposite.this.allApplicableAddOnList.get(index));
                        Map<IProduct, License> licenseMap = AddonsComposite.this.getLicenseMap(false);
                        if (licenseMap != null) {
                            licenseMap.remove(p);
                        }
                        AddonsComposite.this.licenseStatusMap.put(p, Boolean.FALSE);
                        AddonsComposite.this.downloadLicense((IProduct)selectedList.get(i));
                    }
                    for (IProduct p : removeList) {
                        if (!AddonsComposite.this.licenseRemoveList.contains(p)) {
                            AddonsComposite.this.licenseRemoveList.add(p);
                        }
                        selectedList.remove(p);
                        AddonsComposite.this.featureHandler.removeFeatures(p.getProvideFeature());
                        if (p.getType() != IProduct.Type.FEATURE) continue;
                        AddonsComposite.this.featureHandler.removeFeatures(FeatureResolver.getAllRequireFeature(p, AddonsComposite.this.allApplicableAddOnList));
                    }
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AddonsComposite.this.scrollComp.isDisposed()) {
                            return;
                        }
                        AddonsComposite.this.updateAddonTable();
                        AddonsComposite.this.updateSummary();
                        if (!AddonsComposite.this.configRepoLink.isDisposed()) {
                            AddonsComposite.this.configRepoLink.setVisible(AddonsComposite.this.core.isOnPremiseSupported());
                            AddonsComposite.this.configRepoLink.setEnabled(true);
                        }
                        AddonsComposite.this.filterText.setEnabled(true);
                    }
                });
            }
        };
        finalizeThread.setDaemon(true);
        finalizeThread.start();
    }

    private boolean isSiteSupported(ISite site, IRuntimeInfo core) {
        return SiteHelper.isRepoSupported(site, core);
    }

    protected void updateAddonTable() {
        Control content = this.scrollComp.getContent();
        if (content != null) {
            content.dispose();
        }
        this.implicitProducts.clear();
        if (this.allApplicableAddOnList.isEmpty()) {
            Composite labelComp = new Composite((Composite)this.scrollComp, 0);
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 8;
            layout.verticalSpacing = 12;
            labelComp.setLayout((Layout)layout);
            labelComp.setBackground(this.scrollComp.getBackground());
            Label descriptionLabel = new Label(labelComp, 0);
            descriptionLabel.setLayoutData((Object)new GridData(4, 1, false, false));
            descriptionLabel.setBackground(this.scrollComp.getBackground());
            descriptionLabel.setText(Messages.wizNoApplicableAddonMessage);
            this.scrollComp.setContent((Control)labelComp);
            labelComp.setSize(labelComp.computeSize(-1, -1));
            return;
        }
        ScrollBar vBar = this.scrollComp.getVerticalBar();
        ScrollBar hBar = this.scrollComp.getHorizontalBar();
        if (vBar != null) {
            vBar.setEnabled(false);
        }
        if (hBar != null) {
            hBar.setEnabled(false);
        }
        final Composite comp = new Composite((Composite)this.scrollComp, 0);
        comp.setBackground(this.scrollComp.getBackground());
        comp.setLayout((Layout)new AddOnLayout());
        comp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Control[] c = comp.getChildren();
                List selected = (List)AddonsComposite.this.map.get("selectedAddOns");
                for (int i = 0; i < c.length; i += 5) {
                    Object data = c[i].getData();
                    if (!selected.contains(data)) continue;
                    Rectangle r = ((AddOnLayout)comp.getLayout()).getSelection(c[i]);
                    if (r == null) {
                        return;
                    }
                    event.gc.setBackground(AddonsComposite.this.selFillColor);
                    event.gc.fillRoundRectangle(r.x, r.y, r.width, r.height, 7, 7);
                    event.gc.setForeground(AddonsComposite.this.selEdgeColor);
                    event.gc.drawRoundRectangle(r.x, r.y, r.width, r.height, 7, 7);
                }
            }
        });
        comp.addListener(3, this.scrollCompositeListener);
        final List selected = (List)this.map.get("selectedAddOns");
        Color gray = comp.getShell().getDisplay().getSystemColor(15);
        Color darkGray = comp.getShell().getDisplay().getSystemColor(16);
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Applicable Addons length: " + this.allApplicableAddOnList.size());
        }
        for (IProduct product : this.allApplicableAddOnList) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Addon: " + product.getName());
            }
            Color c = null;
            boolean isConflicting = false;
            boolean isInstalled = false;
            if (this.isFilteredOut(product)) continue;
            if (selected.contains(product)) {
                c = this.selFillColor;
            } else {
                if (this.isShowSelectedOnly) continue;
                if (this.isInstalled(product)) {
                    if (this.isHideInstalledProducts) continue;
                    isInstalled = true;
                } else if (this.isConflicting(product)) {
                    if (this.isHideConflictingProducts) continue;
                    isConflicting = true;
                }
                c = comp.getBackground();
            }
            if (this.filter != null && !this.filter.isEmpty() && !this.matches(product, this.filter)) continue;
            Label imgLabel = new Label(comp, 0);
            imgLabel.setBackground(c);
            imgLabel.setImage(this.getImageFor(product));
            imgLabel.setData((Object)product);
            imgLabel.addListener(3, this.scrollCompositeListener);
            final Label nameLabel = new Label(comp, 64);
            nameLabel.setFont(this.boldFont);
            nameLabel.setBackground(c);
            nameLabel.setText(product.getName());
            nameLabel.addListener(3, this.scrollCompositeListener);
            final Label descLabel = new Label(comp, 64);
            descLabel.setBackground(c);
            String desc = product.getDescription();
            if (desc == null) {
                desc = "";
            }
            descLabel.setText(desc);
            descLabel.addListener(3, this.scrollCompositeListener);
            Label sizeLabel = new Label(comp, 0);
            sizeLabel.setBackground(c);
            sizeLabel.setText("");
            final Button install = new Button(comp, 0x800008);
            install.setBackground(c);
            if (isInstalled) {
                install.setText(Messages.wizInstallAddonInstalled);
            } else if (this.isSelected(product)) {
                install.setText(Messages.wizInstallAddonRemove);
            } else {
                install.setText(Messages.wizInstallAddonInstall);
            }
            install.addListener(1, this.scrollCompositeListener);
            install.setData((Object)product);
            if (isConflicting) {
                this.implicitProducts.add(product);
                nameLabel.setForeground(gray);
                descLabel.setForeground(gray);
                sizeLabel.setForeground(gray);
                install.setEnabled(false);
                nameLabel.setToolTipText(Messages.wizConflictToolTipMessage);
                descLabel.setToolTipText(Messages.wizConflictToolTipMessage);
            } else if (isInstalled) {
                nameLabel.setForeground(darkGray);
                descLabel.setForeground(darkGray);
                sizeLabel.setForeground(darkGray);
                install.setEnabled(false);
                nameLabel.setToolTipText(Messages.wizInstalledToolTipMessage);
                descLabel.setToolTipText(Messages.wizInstalledToolTipMessage);
            }
            final IProduct item2 = product;
            install.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    Rectangle r = AddonsComposite.this.scrollComp.getClientArea();
                    Point p = AddonsComposite.this.scrollComp.getOrigin();
                    Rectangle rc1 = AddonsComposite.this.getSelectionRectangle(item2);
                    Rectangle rc2 = install.getBounds();
                    if (rc1 != null && rc2 != null && (rc2.y < p.y || rc2.y > p.y + r.height)) {
                        AddonsComposite.this.scrollComp.setOrigin(0, rc1.y);
                    }
                }
            });
            install.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = nameLabel.getText() + " " + descLabel.getText() + " " + install.getText();
                }
            });
            install.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Button currentInstallButton;
                    if (selected.contains(item2)) {
                        if (!AddonsComposite.this.licenseRemoveList.contains(item2)) {
                            AddonsComposite.this.licenseRemoveList.add(item2);
                        }
                        selected.remove(item2);
                        AddonsComposite.this.featureHandler.removeFeatures(item2.getProvideFeature());
                        if (item2.getType() == IProduct.Type.FEATURE) {
                            AddonsComposite.this.featureHandler.removeFeatures(FeatureResolver.getAllRequireFeature(item2, AddonsComposite.this.allApplicableAddOnList));
                        }
                    } else if (!AddonsComposite.this.isAuthenticationRequired(item2) || AddonsComposite.this.getAuthentication(item2) != null) {
                        selected.add(item2);
                        AddonsComposite.this.downloadLicense(item2);
                        AddonsComposite.this.featureHandler.addFeatures(item2.getProvideFeature());
                        if (item2.getType() == IProduct.Type.FEATURE) {
                            AddonsComposite.this.featureHandler.addFeatures(FeatureResolver.getAllRequireFeature(item2, AddonsComposite.this.allApplicableAddOnList));
                        }
                        if ((item2.getType() == IProduct.Type.EXTENDED || item2.getType() == IProduct.Type.FEATURE) && selected.size() > 1) {
                            ArrayList<IProduct> dupList = new ArrayList<IProduct>(selected.size() - 1);
                            for (IProduct p : selected) {
                                List featureList;
                                if (p.getType() != IProduct.Type.FEATURE || !AddonsComposite.this.featureHandler.isMultipleSelection((String)(featureList = p.getProvideFeature()).get(0))) continue;
                                AddonsComposite.this.featureHandler.removeFeatures(featureList);
                                AddonsComposite.this.featureHandler.removeFeatures(FeatureResolver.getAllRequireFeature(p, AddonsComposite.this.allApplicableAddOnList));
                                dupList.add(p);
                            }
                            for (IProduct p : dupList) {
                                Map licenseMap = (Map)AddonsComposite.this.map.get("license");
                                if (licenseMap != null) {
                                    licenseMap.remove(p);
                                }
                                selected.remove(p);
                                if (AddonsComposite.this.licenseRemoveList.contains(p)) continue;
                                AddonsComposite.this.licenseRemoveList.add(p);
                            }
                        }
                    }
                    Point p = AddonsComposite.this.scrollComp.getOrigin();
                    Rectangle rc1 = AddonsComposite.this.getSelectionRectangle(item2);
                    AddonsComposite.this.updateAddonTable();
                    AddonsComposite.this.updateSummary();
                    AddonsComposite.this.validate();
                    AddonsComposite.this.map.remove("accept");
                    Rectangle rc2 = AddonsComposite.this.getSelectionRectangle(item2);
                    if (rc2 != null && rc1 != null) {
                        if (rc1.y == rc2.y) {
                            AddonsComposite.this.scrollComp.setOrigin(p);
                        } else {
                            int h = rc2.y + p.y - rc1.y;
                            if (h > 0) {
                                AddonsComposite.this.scrollComp.setOrigin(0, h);
                            }
                        }
                    }
                    if ((currentInstallButton = AddonsComposite.this.getInstallButton(item2)) != null) {
                        currentInstallButton.setFocus();
                    }
                }
            });
        }
        Rectangle r = this.scrollComp.getClientArea();
        r.height = comp.computeSize((int)r.width, (int)-1).y;
        comp.setBounds(r);
        this.scrollComp.setContent((Control)comp);
        if (vBar != null) {
            vBar.setEnabled(true);
        }
        if (hBar != null) {
            hBar.setEnabled(true);
        }
    }

    private boolean isFilteredOut(IProduct product) {
        if (this.typeFilterList.isEmpty()) {
            return false;
        }
        IProduct.Type type = this.getDisplayType(product);
        return !this.typeFilterList.contains(type);
    }

    private Image getImageFor(IProduct product) {
        block6: {
            try {
                IProduct.Type type = this.getDisplayType(product);
                if (type == IProduct.Type.SAMPLE) {
                    return Activator.getImage("addOnSample");
                }
                if (type == IProduct.Type.FEATURE) {
                    return Activator.getImage("addOnFeature");
                }
                if (type == IProduct.Type.CONFIG_SNIPPET) {
                    return Activator.getImage("addOnConfigSnippet");
                }
                if (type == IProduct.Type.OPEN_SOURCE) {
                    return Activator.getImage("addOnOpenSource");
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block6;
                Trace.trace((byte)1, "Failed to get image for product " + product.getName());
            }
        }
        return Activator.getImage("addOn");
    }

    protected boolean matches(IProduct item, String filter) {
        List features = item.getProvideFeature();
        boolean featureIDMatch = features != null && !features.isEmpty() && ((String)features.get(0)).toLowerCase().contains(filter.toLowerCase());
        return featureIDMatch || item.getName().toLowerCase().contains(filter.toLowerCase()) || item.getDescription().toLowerCase().contains(filter.toLowerCase());
    }

    protected Rectangle getSelectionRectangle(IProduct item) {
        Control[] cos;
        Composite comp = (Composite)this.scrollComp.getContent();
        for (Control co : cos = comp.getChildren()) {
            if (co.getData() != item) continue;
            return ((AddOnLayout)comp.getLayout()).getSelection(co);
        }
        return null;
    }

    protected Button getInstallButton(IProduct item) {
        Control[] cos;
        Composite comp = (Composite)this.scrollComp.getContent();
        for (Control co : cos = comp.getChildren()) {
            if (co.getData() != item || !(co instanceof Button)) continue;
            return (Button)co;
        }
        return null;
    }

    protected Button getInstallButton(Event event) {
        Widget w = event.widget;
        if (w == null) {
            return null;
        }
        if (w instanceof Composite) {
            return this.getInstallButton(event.y);
        }
        Composite comp = (Composite)this.scrollComp.getContent();
        Control[] cos = comp.getChildren();
        for (int i = 0; i < cos.length; ++i) {
            if (cos[i] != w) continue;
            for (int j = i + 1; j < cos.length; ++j) {
                if (!(cos[j] instanceof Button)) continue;
                return (Button)cos[j];
            }
        }
        return null;
    }

    private Button getInstallButton(int y) {
        Control[] cos;
        Composite comp = (Composite)this.scrollComp.getContent();
        for (Control co : cos = comp.getChildren()) {
            if (!(co instanceof Button)) continue;
            Rectangle c = this.getSelectionRectangle((IProduct)co.getData());
            if (y < c.y || y > c.y + c.height) continue;
            return (Button)co;
        }
        return null;
    }

    protected void updateSummary() {
        int size = 0;
        List addOnList = (List)this.map.get("selectedAddOns");
        if (addOnList != null) {
            size = addOnList.size();
        }
        String oldText = this.summaryValueLabel.getText();
        String newText = size + "";
        this.summaryValueLabel.setText(newText);
        if (!oldText.isEmpty() && newText.length() != oldText.length()) {
            this.summaryValueLabel.getParent().getParent().layout(true);
        }
        long downloadSize = 0L;
        String oldDownloadTotal = this.downloadsValueLabel.getText();
        String newDownloadTotal = "0 KB";
        if (size == 0) {
            this.downloadsValueLabel.setText(newDownloadTotal);
        } else {
            downloadSize = this.getTotalDownloadSize();
            newDownloadTotal = DownloadHelper.getSize(downloadSize, NumberFormat.getIntegerInstance());
            this.downloadsValueLabel.setText(newDownloadTotal);
        }
        if (!oldDownloadTotal.isEmpty() && !newDownloadTotal.equals(oldDownloadTotal)) {
            this.downloadsValueLabel.getParent().getParent().layout(true);
        }
    }

    private long getTotalDownloadSize() {
        List selected = (List)this.map.get("selectedAddOns");
        if (selected == null) {
            return 0L;
        }
        long downloadTotal = 0L;
        for (IProduct p : selected) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Selected product: " + p.getName() + " Size: " + p.getSize());
            }
            downloadTotal += p.getSize();
        }
        for (IProduct p : this.implicitProducts) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Implicitly selected product: " + p.getName() + " Size: " + p.getSize());
            }
            downloadTotal += p.getSize();
        }
        return downloadTotal;
    }

    protected boolean isSelected(IProduct manager) {
        if (manager == null) {
            return false;
        }
        List selected = (List)this.map.get("selectedAddOns");
        if (selected == null) {
            return false;
        }
        return selected.contains(manager);
    }

    private void removeSelectedAddOns(List<IProduct> addOnList) {
        List archives = (List)this.map.get("archives");
        for (IProduct addOn : addOnList) {
            if (!(addOn instanceof LocalProduct)) continue;
            archives.remove(addOn.getSource().getLocation());
        }
        addOnList.clear();
        this.featureHandler.reset();
    }

    protected List<IProduct> getApplicableAddOns(ISite site) {
        return site.getApplicableProducts(this.core, (IProgressMonitor)new NullProgressMonitor());
    }

    private boolean isConflicting(IProduct p) {
        return this.featureHandler.containsFeatures(p.getProvideFeature());
    }

    protected boolean isInstalled(IProduct p) {
        if (p.isInstallOnlyFeature()) {
            return this.featureHandler.isInstalled(this.core, p.getRequireFeature());
        }
        return this.featureHandler.isInstalled(this.core, p.getProvideFeature());
    }

    protected void downloadLicense(final IProduct p) {
        if (this.licenseRemoveList.contains(p)) {
            this.licenseRemoveList.remove(p);
        }
        if (this.isLicenseExist(p)) {
            this.licenseStatusMap.put(p, Boolean.TRUE);
            return;
        }
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                try {
                    AddonsComposite.this.licenseJobCounter.decrementAndGet();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AddonsComposite.this.validate();
                        }
                    });
                }
                finally {
                    event.getJob().removeJobChangeListener((IJobChangeListener)this);
                }
            }
        };
        Job job = new Job(Messages.taskDownloadLicense){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    License license = p.getLicense(monitor);
                    if (license != null) {
                        Map<IProduct, License> licenseMap = AddonsComposite.this.getLicenseMap(true);
                        licenseMap.put(p, license);
                    }
                    AddonsComposite.this.licenseStatusMap.put(p, Boolean.TRUE);
                }
                catch (IOException e) {
                    Trace.logError("Error getting license for " + p.getName(), e);
                }
                return Status.OK_STATUS;
            }
        };
        this.licenseStatusMap.put(p, Boolean.FALSE);
        this.licenseJobCounter.incrementAndGet();
        job.addJobChangeListener((IJobChangeListener)listener);
        job.setPriority(20);
        job.schedule();
    }

    private boolean isLicenseExist(IProduct p) {
        Map<IProduct, License> licenseMap = this.getLicenseMap(false);
        return licenseMap == null ? false : licenseMap.containsKey(p);
    }

    protected Map<IProduct, License> getLicenseMap(boolean toCreate) {
        Map<IProduct, License> licenseMap = (Map<IProduct, License>)this.map.get("license");
        if (licenseMap == null && toCreate) {
            licenseMap = AddonUtil.createLicenseMap();
            this.map.put("license", licenseMap);
        }
        return licenseMap;
    }

    IProduct.Type getDisplayType(IProduct product) {
        IProduct.Type type = product.getType();
        try {
            if (product.getAttribute("displayType") != null) {
                type = IProduct.Type.valueOf((String)product.getAttribute("displayType"));
            }
        }
        catch (Exception e) {
            Trace.logError("Error getting product type", e);
        }
        return type;
    }

    private class LicenseThread
    extends Thread {
        private volatile boolean done = false;

        @Override
        public void run() {
            boolean isResetRequired = false;
            final int[] i = new int[1];
            while (!this.done) {
                if (!isResetRequired) {
                    isResetRequired = true;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!AddonsComposite.this.bar.isDisposed()) {
                                AddonsComposite.this.barLabel.setVisible(false);
                                AddonsComposite.this.bar.setVisible(false);
                            }
                        }
                    });
                }
                while (AddonsComposite.this.licenseJobCounter.get() > 0) {
                    if (isResetRequired) {
                        isResetRequired = false;
                        i[0] = 0;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!AddonsComposite.this.bar.isDisposed()) {
                                    AddonsComposite.this.barLabel.setVisible(true);
                                    AddonsComposite.this.bar.setVisible(true);
                                }
                            }
                        });
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (AddonsComposite.this.bar.isDisposed()) {
                                return;
                            }
                            i[0] = i[0] + 1;
                            if (i[0] < AddonsComposite.this.bar.getMaximum()) {
                                AddonsComposite.this.bar.setSelection(i[0]);
                            }
                        }
                    });
                }
            }
        }

        public void done() {
            this.done = true;
        }
    }

    private class SiteThread
    extends Thread {
        private final ISite site;
        private final Map<ISite, List<IProduct>> siteProductMap;

        SiteThread(ISite site, Map<ISite, List<IProduct>> siteProductMap) {
            this.site = site;
            this.siteProductMap = siteProductMap;
        }

        @Override
        public void run() {
            this.siteProductMap.put(this.site, AddonsComposite.this.getApplicableAddOns(this.site));
        }
    }

    static class AddOnLayout
    extends Layout {
        private static final int BORDER = 5;
        private static final int IMG = 48;
        private static final int GAP = 3;
        private static final int V_SPACE = 3;
        protected int colWidth = -1;
        protected Map<Control, Rectangle> map = new HashMap<Control, Rectangle>();

        AddOnLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return new Point(composite.getClientArea().width, this.layoutImpl(composite, wHint, flushCache, false));
        }

        protected void layout(Composite composite, boolean flushCache) {
            this.layoutImpl(composite, 0, flushCache, true);
        }

        protected Rectangle getSelection(Control c) {
            return this.map.get(c);
        }

        protected int layoutImpl(Composite composite, int wHint, boolean flushCache, boolean apply) {
            Control[] children;
            Rectangle r = composite.getClientArea();
            int areaW = r.width > 0 ? r.width : wHint;
            int i = 0;
            int x = r.x + 5;
            int y = r.y + 5;
            int w = 0;
            w = areaW == 0 ? composite.getParent().getBounds().width - composite.getParent().getBorderWidth() * 2 : areaW - 10;
            w = Math.max(100, w);
            if (apply) {
                this.map.clear();
            }
            if ((children = composite.getChildren()).length > 4 && this.colWidth < 0) {
                Button b = (Button)children[4];
                String s = b.getText();
                b.setText(Messages.wizInstallAddonRemove);
                int ww = b.computeSize((int)-1, (int)-1, (boolean)flushCache).x;
                b.setText(Messages.wizInstallAddonInstall);
                ww = Math.max(ww, b.computeSize((int)-1, (int)-1, (boolean)flushCache).x);
                b.setText(s);
                this.colWidth = ww + 8;
            }
            int colWid = Math.max(50, this.colWidth);
            while (i < children.length) {
                if (i > 0) {
                    y += 3;
                }
                Rectangle br = new Rectangle(x, y, w, 5);
                if (apply) {
                    children[i].setBounds(x, y, 48, 48);
                }
                Point p = children[i + 1].computeSize(w - 48 - 3, -1, flushCache);
                if (apply) {
                    children[i + 1].setBounds(x + 48 + 3, y, w - 48 - 3, p.y);
                }
                int yy = y += p.y + 3;
                p = children[i + 4].computeSize(colWid, -1, flushCache);
                if (apply) {
                    children[i + 4].setBounds(x + w - colWid, y, colWid, p.y);
                }
                yy += p.y + 3;
                p = children[i + 2].computeSize(w - 48 - 6 - colWid, -1, flushCache);
                if (apply) {
                    children[i + 2].setBounds(x + 48 + 3, y, w - 48 - 6 - colWid, p.y);
                }
                y = Math.max(y + p.y, yy);
                if (apply) {
                    br.x -= 3;
                    br.y -= 3;
                    br.width += 6;
                    br.height = y - br.y + 4;
                    this.map.put(children[i], br);
                }
                y += 5;
                i += 5;
            }
            return y - r.y;
        }
    }
}

