/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.custom;

import com.ibm.ws.st.ui.internal.custom.ICustomServerConfig;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IServer;

public class CustomServerConfigManager {
    private static final String EXTENSION_ID = "com.ibm.ws.st.ui.customServerConfig";
    private static final String HANDLER_ELEMENT = "handler";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final CustomServerConfigManager customServerConfigurationManager = new CustomServerConfigManager();
    private final List<ICustomServerConfig> handlers = new ArrayList<ICustomServerConfig>();

    private CustomServerConfigManager() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement configurationElement = extensions[i];
            if (!HANDLER_ELEMENT.equals(configurationElement.getName())) continue;
            try {
                Object object = configurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
                if (!(object instanceof ICustomServerConfig)) continue;
                this.handlers.add((ICustomServerConfig)object);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static CustomServerConfigManager getInstance() {
        return customServerConfigurationManager;
    }

    public List<Object> getCustomServerElements(IServer server) {
        ArrayList<Object> customServerElements = new ArrayList<Object>();
        for (ICustomServerConfig customServerConfig : this.handlers) {
            List<Object> currentCustomServerElements = customServerConfig.getCustomServerElements(server);
            if (currentCustomServerElements == null) continue;
            customServerElements.addAll(currentCustomServerElements);
        }
        return customServerElements;
    }
}

