/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.ui.internal.config.BaseCustomObject;
import com.ibm.ws.st.ui.internal.config.CComboModifiers;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.ws.st.ui.internal.config.ConfigVarComputer;
import com.ibm.ws.st.ui.internal.config.TextModifiers;
import java.util.EventListener;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class VariableTextCustomObject
extends BaseCustomObject {
    private static final int MAX_CCOMBO_SIZE = 5;

    public void createCustomControl(final Element input, final String itemName, Composite composite, IEditorPart editorPart, EventListener listener) {
        ConfigVarComputer configVarComputer = this.getConfigVarComputer(input, itemName, editorPart);
        boolean isSchemaProperties = input.getUserData("schema.properties.editor.part") != null;
        String defaultValue = null;
        XSDSimpleTypeDefinition baseType = null;
        String baseTypeName = null;
        CMAttributeDeclaration attrDecl = this.getAttrDecl(input, itemName);
        if (attrDecl != null) {
            CMDataType attrType = attrDecl.getAttrType();
            defaultValue = attrDecl.getDefaultValue();
            baseType = ConfigUtils.getBaseType((CMNode)attrDecl);
            baseTypeName = ConfigUtils.getBaseTypeName((XSDSimpleTypeDefinition)baseType);
            if (baseTypeName == null && attrType != null) {
                baseTypeName = attrType.getDataTypeName();
            }
        }
        Map<String, XSDEnumerationFacet> enumMap = baseType != null ? ConfigUIUtils.getEnumerationMap(baseType) : null;
        Attr attr = input.getAttributeNode(itemName);
        String value = defaultValue;
        if (attr != null) {
            value = attr.getNodeValue();
        }
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.setLabelVerticalAlign(composite, 2);
        if (enumMap != null && enumMap.size() > 0) {
            final CCombo comboControl = widgetFactory.createCCombo(composite, 0x800000);
            String[] enumValues = enumMap.keySet().toArray(new String[enumMap.size()]);
            comboControl.setItems(enumValues);
            comboControl.setVisibleItemCount(Math.min(enumValues.length, 5));
            if (value != null && !value.isEmpty()) {
                comboControl.setText(value);
                comboControl.setToolTipText(value);
            }
            CComboModifiers.addContentProposalProvider(comboControl, attrDecl, enumMap, configVarComputer, baseTypeName);
            if (!isSchemaProperties) {
                CComboModifiers.addVariableHyperlink(comboControl, configVarComputer);
            }
            GridData data = new GridData(768);
            data.grabExcessHorizontalSpace = true;
            data.horizontalIndent = 2;
            data.horizontalSpan = 2;
            comboControl.setLayoutData((Object)data);
            comboControl.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    String text = comboControl.getText();
                    Attr attr = input.getAttributeNode(itemName);
                    if (text == null || text.isEmpty()) {
                        if (attr != null) {
                            input.removeAttributeNode(attr);
                        }
                    } else {
                        input.setAttribute(itemName, text);
                    }
                    comboControl.setToolTipText(text);
                }
            });
            comboControl.setEnabled(!this.getReadOnly());
        } else {
            final Text textControl = widgetFactory.createText(composite, "");
            if (value != null && !value.isEmpty()) {
                textControl.setText(value);
                textControl.setToolTipText(value);
            }
            TextModifiers.addVariableContentProposalProvider(textControl, configVarComputer, baseTypeName);
            if (!isSchemaProperties) {
                TextModifiers.addVariableHyperlink(textControl, configVarComputer);
            }
            GridData data = new GridData(768);
            data.grabExcessHorizontalSpace = true;
            data.horizontalIndent = 2;
            data.horizontalSpan = 2;
            textControl.setLayoutData((Object)data);
            textControl.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    String text = textControl.getText();
                    Attr attr = input.getAttributeNode(itemName);
                    if (text == null || text.isEmpty()) {
                        if (attr != null) {
                            input.removeAttributeNode(attr);
                        }
                    } else {
                        input.setAttribute(itemName, text);
                    }
                    textControl.setToolTipText(text);
                }
            });
            textControl.setEnabled(!this.getReadOnly());
        }
    }
}

