/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.ui.internal.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VariableDialog
extends Dialog {
    protected boolean isOK = false;
    protected String name = "";
    protected String value = "";
    protected boolean nameDisabled = false;

    public VariableDialog(Shell parent) {
        super(parent);
    }

    public VariableDialog(Shell parent, String name) {
        super(parent);
        this.name = name;
        this.nameDisabled = name.length() > 0;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.variableDialogTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 0) {
            this.isOK = true;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.minimumWidth = 250;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(Messages.nameDialogEnter);
        data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        final Text nameText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        nameText.setLayoutData((Object)data);
        if (this.nameDisabled) {
            nameText.setText(this.name);
            nameText.setEditable(false);
        }
        label = new Label(composite, 0);
        label.setText(Messages.valueDialogEnter);
        data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        final Text valueText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        valueText.setLayoutData((Object)data);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String nameStr = nameText.getText();
                String valueStr = valueText.getText();
                if (valueStr.length() > 0 && nameStr.length() > 0) {
                    VariableDialog.this.name = nameStr;
                    VariableDialog.this.value = valueStr;
                    VariableDialog.this.enableOKButton(true);
                } else {
                    VariableDialog.this.enableOKButton(false);
                }
            }
        };
        nameText.addModifyListener(listener);
        valueText.addModifyListener(listener);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOKButton(false);
        return control;
    }

    protected void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String getName() {
        if (this.isOK) {
            return this.name;
        }
        return null;
    }

    public String getValue() {
        if (this.isOK) {
            return this.value;
        }
        return null;
    }
}

