/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.BaseCustomObject;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.ws.st.ui.internal.config.SchemaPropertiesWizard;
import com.ibm.xwt.dde.internal.util.DetailsViewerAdapter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaPropertiesCustomObject
extends BaseCustomObject {
    public static final String PARENT_ELEM_DATA = "schema.properties.parent.elem";
    public static final String EDITOR_PART_DATA = "schema.properties.editor.part";
    protected Element propertiesElem = null;
    protected Text text = null;
    protected Button setButton = null;
    protected Button editButton = null;
    protected Button clearButton = null;

    public void createCustomControl(final Element input, final String itemName, Composite parent, final IEditorPart editorPart, EventListener listener) {
        String schemaPath = this.getSchemaPath(input, itemName, null);
        if (schemaPath != null) {
            HashMap<String, CMElementDeclaration> cmElemMap = this.getValidElements(schemaPath, input, itemName, null);
            for (String name : cmElemMap.keySet()) {
                NodeList nodeList = input.getElementsByTagName(name);
                if (nodeList == null || nodeList.getLength() <= 0) continue;
                this.propertiesElem = (Element)nodeList.item(0);
                break;
            }
        }
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        final Shell shell = parent.getShell();
        this.setLabelVerticalAlign(parent, 1);
        this.text = widgetFactory.createText(parent, "", 778);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = this.text.getLineHeight() * 3;
        data.verticalIndent = 2;
        this.text.setLayoutData((Object)data);
        Composite buttonComposite = widgetFactory.createComposite(parent, 0x800000);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(4, 1, false, false);
        data.horizontalSpan = 1;
        buttonComposite.setLayoutData((Object)data);
        this.setButton = widgetFactory.createButton(buttonComposite, Messages.setButton, 8);
        data = new GridData(4, 1, true, false);
        this.setButton.setLayoutData((Object)data);
        this.editButton = widgetFactory.createButton(buttonComposite, Messages.editButton, 8);
        data = new GridData(4, 1, true, false);
        this.editButton.setLayoutData((Object)data);
        this.clearButton = widgetFactory.createButton(buttonComposite, Messages.clearButton, 8);
        data = new GridData(4, 1, true, false);
        this.clearButton.setLayoutData((Object)data);
        Listener scrollBarListener = new Listener(){

            public void handleEvent(Event event) {
                Rectangle r1 = SchemaPropertiesCustomObject.this.text.getClientArea();
                Rectangle r2 = SchemaPropertiesCustomObject.this.text.computeTrim(r1.x, r1.y, r1.width, r1.height);
                Point p = SchemaPropertiesCustomObject.this.text.computeSize(-1, -1, true);
                SchemaPropertiesCustomObject.this.text.getHorizontalBar().setVisible(r2.width <= p.x);
                SchemaPropertiesCustomObject.this.text.getVerticalBar().setVisible(r2.height <= p.y);
                if (event.type == 24) {
                    SchemaPropertiesCustomObject.this.text.getParent().layout(true);
                    SchemaPropertiesCustomObject.this.text.showSelection();
                }
            }
        };
        this.text.addListener(11, scrollBarListener);
        this.text.addListener(24, scrollBarListener);
        this.setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block6: {
                    String schemaPath = SchemaPropertiesCustomObject.this.getSchemaPath(input, itemName, shell);
                    if (schemaPath == null) {
                        return;
                    }
                    HashMap<String, CMElementDeclaration> cmElemMap = SchemaPropertiesCustomObject.this.getValidElements(schemaPath, input, itemName, shell);
                    if (cmElemMap.isEmpty()) {
                        return;
                    }
                    URL schemaURL = SchemaPropertiesCustomObject.this.getURL(schemaPath);
                    SchemaPropertiesData propertiesData = new SchemaPropertiesData(schemaURL, cmElemMap, null, null, input, editorPart);
                    SchemaPropertiesWizard wizard = new SchemaPropertiesWizard(propertiesData);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.setPageSize(425, 275);
                    if (dialog.open() == 1) {
                        return;
                    }
                    if (SchemaPropertiesCustomObject.this.propertiesElem != null) {
                        ConfigUIUtils.removeNode(SchemaPropertiesCustomObject.this.propertiesElem);
                    }
                    SchemaPropertiesCustomObject.this.propertiesElem = SchemaPropertiesCustomObject.this.updatePropertiesElem(input, null, propertiesData);
                    SchemaPropertiesCustomObject.this.editButton.setEnabled(true);
                    SchemaPropertiesCustomObject.this.clearButton.setEnabled(true);
                    try {
                        String xml = SchemaPropertiesCustomObject.this.getXMLString(SchemaPropertiesCustomObject.this.propertiesElem);
                        SchemaPropertiesCustomObject.this.text.setText(xml);
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) break block6;
                        Trace.trace((byte)1, "Failed to build document fragment for properties.", e);
                    }
                }
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block5: {
                    String schemaPath = SchemaPropertiesCustomObject.this.getSchemaPath(input, itemName, shell);
                    if (schemaPath == null) {
                        return;
                    }
                    HashMap<String, CMElementDeclaration> cmElemMap = SchemaPropertiesCustomObject.this.getValidElements(schemaPath, input, itemName, shell);
                    if (cmElemMap.isEmpty()) {
                        return;
                    }
                    URL schemaURL = SchemaPropertiesCustomObject.this.getURL(schemaPath);
                    SchemaPropertiesData propertiesData = new SchemaPropertiesData(schemaURL, cmElemMap, SchemaPropertiesCustomObject.this.propertiesElem.getLocalName(), SchemaPropertiesCustomObject.this.getProperties(SchemaPropertiesCustomObject.this.propertiesElem), input, editorPart);
                    SchemaPropertiesWizard wizard = new SchemaPropertiesWizard(propertiesData);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.setPageSize(425, 275);
                    if (dialog.open() == 1) {
                        return;
                    }
                    SchemaPropertiesCustomObject.this.propertiesElem = SchemaPropertiesCustomObject.this.updatePropertiesElem(input, SchemaPropertiesCustomObject.this.propertiesElem, propertiesData);
                    try {
                        String xml = SchemaPropertiesCustomObject.this.getXMLString(SchemaPropertiesCustomObject.this.propertiesElem);
                        SchemaPropertiesCustomObject.this.text.setText(xml);
                    }
                    catch (Exception e) {
                        if (!Trace.ENABLED) break block5;
                        Trace.trace((byte)1, "Failed to build document fragment for properties.", e);
                    }
                }
            }
        });
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SchemaPropertiesCustomObject.this.removePropertiesElem(SchemaPropertiesCustomObject.this.propertiesElem);
                SchemaPropertiesCustomObject.this.propertiesElem = null;
                SchemaPropertiesCustomObject.this.text.setText("");
                SchemaPropertiesCustomObject.this.editButton.setEnabled(false);
                SchemaPropertiesCustomObject.this.clearButton.setEnabled(false);
            }
        });
        this.text.setEnabled(!this.getReadOnly());
        this.setButton.setEnabled(!this.getReadOnly());
        this.editButton.setEnabled(!this.getReadOnly());
        this.clearButton.setEnabled(!this.getReadOnly());
    }

    @Override
    public void postLayoutProcessing() {
        block3: {
            if (this.propertiesElem != null) {
                try {
                    this.text.setText(this.getXMLString(this.propertiesElem));
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block3;
                    Trace.trace((byte)1, "Failed to serialize the existing properties node: " + this.propertiesElem.getLocalName(), e);
                }
            }
        }
        this.editButton.setEnabled(this.propertiesElem != null);
        this.clearButton.setEnabled(this.propertiesElem != null);
    }

    protected HashMap<String, CMElementDeclaration> getValidElements(String schemaPath, Element input, String itemName, Shell shell) {
        HashMap<String, CMElementDeclaration> elemMap = new HashMap<String, CMElementDeclaration>();
        String propertiesId = this.getPropertiesId(input, itemName, shell);
        CMDocument doc = this.getSchema(schemaPath);
        if (propertiesId != null && doc != null) {
            CMNamedNodeMap elements = doc.getElements();
            String elemName = input.getLocalName();
            for (int i = 0; i < elements.getLength(); ++i) {
                String parentVal;
                CMElementDeclaration element = (CMElementDeclaration)elements.item(i);
                String propertiesIdVal = SchemaUtil.getExtInfo((CMNode)element, (String)"propertiesId");
                if (!propertiesId.equals(propertiesIdVal) || !elemName.equals(parentVal = SchemaUtil.getExtInfo((CMNode)element, (String)"parent"))) continue;
                elemMap.put(element.getElementName(), element);
            }
        }
        if (elemMap.isEmpty()) {
            Trace.logError("No valid schema elements for parent: " + input.getLocalName() + ", and properties id: " + propertiesId, null);
        }
        return elemMap;
    }

    protected String getSchemaPath(Element input, String itemName, Shell shell) {
        CMAttributeDeclaration attrDecl = this.getAttrDecl(input, itemName);
        String attrName = SchemaUtil.getExtInfo((CMNode)attrDecl, (String)"schemaAttr");
        if (attrName == null) {
            Trace.logError("Have a schema properties type but can't get schema attribute.", null);
            return null;
        }
        String schemaGenInfo = input.getAttribute(attrName);
        if ((schemaGenInfo == null || schemaGenInfo.isEmpty()) && shell != null) {
            MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.schemaPropsRequiredAttrNoValue, (Object)attrName));
            return null;
        }
        String schemaPath = "C:/home/eclipse431/workspace_oltx/SchemaTest/properties.xsd";
        return schemaPath;
    }

    protected URL getURL(String path) {
        try {
            File file = new File(path);
            return file.toURI().toURL();
        }
        catch (Exception e) {
            Trace.logError("Invalid schema path, cannot convert to URI: " + path, e);
            return null;
        }
    }

    protected CMDocument getSchema(String schemaPath) {
        File file = new File(schemaPath);
        CMDocument cmDocument = null;
        if (file.exists()) {
            cmDocument = ContentModelManager.getInstance().createCMDocument(file.toURI().toString(), null);
        }
        if (cmDocument == null) {
            Trace.logError("Could not load the schema: " + schemaPath, null);
        }
        return cmDocument;
    }

    protected String getPropertiesId(Element input, String itemName, Shell shell) {
        CMAttributeDeclaration attrDecl = this.getAttrDecl(input, itemName);
        String attrName = SchemaUtil.getExtInfo((CMNode)attrDecl, (String)"propertiesId");
        if (attrName == null) {
            Trace.logError("Have a schema properties type but can't get schema attribute.", null);
            return null;
        }
        String id = input.getAttribute(attrName);
        if ((id == null || id.isEmpty()) && shell != null) {
            MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.schemaPropsRequiredAttrNoValue, (Object)attrName));
            return null;
        }
        return id;
    }

    protected Element updatePropertiesElem(Element parent, Element currentElem, SchemaPropertiesData data) {
        String elemName = data.getChosenElem();
        Map<String, String> properties = data.getUpdatedProperties();
        if (currentElem != null && currentElem.getLocalName().equals(elemName)) {
            Set<Map.Entry<String, String>> entries = properties.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (value == null || value.isEmpty()) {
                    if (!currentElem.hasAttribute(name)) continue;
                    currentElem.removeAttribute(name);
                    continue;
                }
                currentElem.setAttribute(name, value);
            }
            return currentElem;
        }
        if (currentElem != null) {
            ConfigUIUtils.removeNode(currentElem);
        }
        Element newElem = ConfigUIUtils.addNode(elemName, parent);
        Set<Map.Entry<String, String>> entries = properties.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            newElem.setAttribute(entry.getKey(), entry.getValue());
        }
        return newElem;
    }

    protected void removePropertiesElem(Element currentElem) {
        if (currentElem != null) {
            ConfigUIUtils.removeNode(currentElem);
        }
    }

    protected String getXMLString(Node node) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(os);
        DOMSource source = new DOMSource(node);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(source, result);
        return os.toString();
    }

    protected Map<String, String> getProperties(Element elem) {
        HashMap<String, String> properties = new HashMap<String, String>();
        NamedNodeMap attrs = elem.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            properties.put(attr.getLocalName(), attr.getValue());
        }
        return properties;
    }

    public static class SchemaPropertiesData {
        URL schemaURL;
        Map<String, CMElementDeclaration> elemMap;
        String chosenElem;
        Map<String, String> properties;
        Element parentElem;
        IEditorPart editorPart;
        DetailsViewerAdapter dvAdapter;

        public SchemaPropertiesData(URL schemaURL, Map<String, CMElementDeclaration> elemMap, String chosenElem, Map<String, String> properties, Element parentElem, IEditorPart editorPart) {
            this.schemaURL = schemaURL;
            this.elemMap = elemMap;
            this.chosenElem = chosenElem;
            this.properties = properties;
            if (this.chosenElem == null && elemMap.size() == 1) {
                this.chosenElem = elemMap.keySet().iterator().next();
            }
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.parentElem = parentElem;
            this.editorPart = editorPart;
            this.dvAdapter = new DetailsViewerAdapter();
        }

        public URL getSchemaURL() {
            return this.schemaURL;
        }

        public String[] getElems() {
            return this.elemMap.keySet().toArray(new String[this.elemMap.size()]);
        }

        public String getChosenElem() {
            return this.chosenElem;
        }

        public void setChosenElem(String chosenElem) {
            this.chosenElem = chosenElem;
        }

        public CMElementDeclaration getElementDecl() {
            return this.elemMap.get(this.chosenElem);
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Element getParentElem() {
            return this.parentElem;
        }

        public IEditorPart getEditorPart() {
            return this.editorPart;
        }

        public DetailsViewerAdapter getDVAdapter() {
            return this.dvAdapter;
        }

        public Map<String, String> getUpdatedProperties() {
            return this.dvAdapter.getElementProperties();
        }
    }
}

