/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.core.internal.config.URILocation;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.ws.st.ui.internal.config.ConfigVarComputer;
import com.ibm.ws.st.ui.internal.config.ReferenceBaseCustomObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceSingleCustomObject
extends ReferenceBaseCustomObject {
    public void createCustomControl(final Element input, final String itemName, Composite composite, final IEditorPart editorPart, EventListener listener) {
        final Shell shell = composite.getShell();
        CMAttributeDeclaration attrDecl = this.getAttrDecl(input, itemName);
        final String[] references = this.getReferences(attrDecl);
        if (references == null || references.length == 0) {
            Trace.logError("Have a reference type but could not get the reference name.", null);
            return;
        }
        final boolean multipleRefs = references.length > 1;
        final String nestedReference = multipleRefs ? null : this.fixReferenceForNested(input, itemName, references[0]);
        final Document doc = input.getOwnerDocument();
        final URI docURI = ConfigUIUtils.getURI(editorPart.getEditorInput(), doc);
        WebSphereServerInfo serverInfo = ConfigUtils.getServerInfo((URI)docURI);
        UserDirectory userDir = serverInfo != null ? serverInfo.getUserDirectory() : ConfigUtils.getUserDirectory((URI)docURI);
        String refValue = DOMUtils.getAttributeValue((Element)input, (String)itemName);
        ConfigVarComputer configVarComputer = this.getGlobalConfigVarComputer(input, editorPart);
        Map<String, URILocation> idMap = ConfigUIUtils.getIdMap(doc, docURI, serverInfo, userDir, references);
        ArrayList<String> ids = new ArrayList<String>(idMap.keySet());
        Collections.sort(ids);
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.setLabelVerticalAlign(composite, 2);
        final CCombo refCombo = widgetFactory.createCCombo(composite);
        refCombo.setEditable(true);
        ArrayList<String> itemList = new ArrayList<String>(ids);
        List vars = configVarComputer.getConfigVars().getSortedVars(ConfigVars.STRING_TYPES, false);
        for (String var : vars) {
            itemList.add(ConfigVarsUtils.getVarRef((String)var));
        }
        refCombo.setItems(itemList.toArray(new String[itemList.size()]));
        if (refValue != null && !refValue.isEmpty()) {
            refCombo.setText(refValue);
        }
        this.addFactoryIdHyperlink(refCombo, idMap, configVarComputer.getConfigVars());
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 1;
        data.verticalIndent = 1;
        refCombo.setLayoutData((Object)data);
        refCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = refCombo.getText();
                ReferenceSingleCustomObject.this.updateAttr(input, itemName, text);
            }
        });
        if (nestedReference != null || multipleRefs) {
            Button addButton;
            Composite addButtonComposite = widgetFactory.createComposite(composite);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            layout.numColumns = 2;
            addButtonComposite.setLayout((Layout)layout);
            data = new GridData(768);
            data.grabExcessHorizontalSpace = false;
            addButtonComposite.setLayoutData((Object)data);
            Button menuButton = null;
            if (multipleRefs) {
                addButton = widgetFactory.createButton(addButtonComposite, Messages.addButton2, 0x4000008);
                addButton.setImage(Activator.getImage("menuDown"));
                data = new GridData(768);
                addButton.setLayoutData((Object)data);
            } else {
                addButton = widgetFactory.createButton(addButtonComposite, Messages.addButton2, 8);
                data = new GridData(768);
                addButton.setLayoutData((Object)data);
                addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Element elem = ReferenceSingleCustomObject.this.addNested(input, nestedReference);
                        ReferenceSingleCustomObject.this.openElement(editorPart, elem);
                    }
                });
                menuButton = widgetFactory.createButton(addButtonComposite, "", 8);
                this.setDropdownData((Control)addButton, menuButton);
            }
            final Button mainButton = addButton;
            final Button dropdownButton = menuButton == null ? mainButton : menuButton;
            dropdownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Menu menu = new Menu((Decorations)shell, 8);
                    if (nestedReference != null) {
                        MenuItem item = new MenuItem(menu, 8);
                        item.setText(Messages.referenceNestedButton);
                        item.addListener(13, new Listener(){

                            public void handleEvent(Event e) {
                                Element elem = ReferenceSingleCustomObject.this.addNested(input, nestedReference);
                                ReferenceSingleCustomObject.this.openElement(editorPart, elem);
                            }
                        });
                        menu.setDefaultItem(item);
                    }
                    String[] stringArray = references;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String reference;
                        final String ref = reference = stringArray[i];
                        String label = SchemaUtil.getLabel((Document)doc, (String[])new String[]{"server", ref}, (URI)docURI);
                        final String typeLabel = (label == null ? ref : label) + "...";
                        MenuItem item = new MenuItem(menu, 8);
                        item.setText(multipleRefs ? typeLabel : Messages.referenceTopLevelButton);
                        item.addListener(13, new Listener(){

                            public void handleEvent(Event e) {
                                ReferenceBaseCustomObject.IDDialog dialog = new ReferenceBaseCustomObject.IDDialog(shell, typeLabel);
                                if (dialog.open() == 0) {
                                    String id = dialog.getId();
                                    refCombo.setText(id);
                                    ReferenceSingleCustomObject.this.updateAttr(input, itemName, id);
                                    Element elem = ReferenceSingleCustomObject.this.addTopLevel(doc, ref, id, input);
                                    ReferenceSingleCustomObject.this.openElement(editorPart, elem);
                                }
                            }
                        });
                    }
                    ReferenceSingleCustomObject.this.displayDropdownMenu((Control)mainButton, menu, mainButton == dropdownButton);
                    menu.dispose();
                }
            });
            addButton.setEnabled(!this.getReadOnly());
            dropdownButton.setEnabled(!this.getReadOnly());
        } else {
            final String reference = references[0];
            String label = SchemaUtil.getLabel((Document)doc, (String[])new String[]{"server", reference}, (URI)docURI);
            final String typeLabel = label == null ? reference : label;
            Button addButton = widgetFactory.createButton(composite, Messages.addButton2, 8);
            data = new GridData(768);
            data.grabExcessHorizontalSpace = false;
            addButton.setLayoutData((Object)data);
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReferenceBaseCustomObject.IDDialog dialog = new ReferenceBaseCustomObject.IDDialog(shell, typeLabel);
                    if (dialog.open() == 0) {
                        String id = dialog.getId();
                        refCombo.setText(id);
                        ReferenceSingleCustomObject.this.updateAttr(input, itemName, id);
                        Element elem = ReferenceSingleCustomObject.this.addTopLevel(doc, reference, id, input);
                        ReferenceSingleCustomObject.this.openElement(editorPart, elem);
                    }
                }
            });
            addButton.setEnabled(!this.getReadOnly());
        }
        refCombo.setEnabled(!this.getReadOnly());
    }

    protected void updateAttr(Element elem, String attrName, String ref) {
        if (ref == null || ref.isEmpty()) {
            elem.removeAttribute(attrName);
            return;
        }
        elem.setAttribute(attrName, ref);
    }

    protected void addFactoryIdHyperlink(final CCombo combolControl, final Map<String, URILocation> idMap, final ConfigVars configVars) {
        combolControl.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x100000C) {
                    String idName = combolControl.getText();
                    String varName = idName == null ? null : ConfigVarsUtils.getVariableName((String)idName);
                    DocumentLocation location = null;
                    if (varName != null && !varName.isEmpty()) {
                        location = configVars.getDocumentLocation(varName);
                    } else if (idName != null && !idName.isEmpty() && idMap.containsKey(idName)) {
                        location = (URILocation)idMap.get(idName);
                    }
                    if (location != null && location.getURI() != null) {
                        Activator.open((URILocation)location);
                    }
                }
            }
        });
    }
}

