/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.core.internal.config.URILocation;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.ws.st.ui.internal.config.ConfigVarComputer;
import com.ibm.ws.st.ui.internal.config.HoverHelper;
import com.ibm.ws.st.ui.internal.config.ReferenceBaseCustomObject;
import com.ibm.ws.st.ui.internal.config.ReferenceSelectionDialog;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReferenceListCustomObject
extends ReferenceBaseCustomObject {
    public void createCustomControl(final Element input, final String itemName, Composite parent, final IEditorPart editorPart, EventListener listener) {
        Document doc;
        final Shell shell = parent.getShell();
        CMAttributeDeclaration attrDecl = this.getAttrDecl(input, itemName);
        final String[] references = this.getReferences(attrDecl);
        if (references == null || references.length == 0) {
            Trace.logError("Have a reference type but could not get the reference name.", null);
            return;
        }
        final boolean multipleRefs = references.length > 1;
        final String[] nestedReferences = new String[references.length];
        for (int i = 0; i < references.length; ++i) {
            nestedReferences[i] = this.fixReferenceForNested(input, itemName, references[i]);
        }
        IEditorInput editorInput = editorPart.getEditorInput();
        final URI docURI = ConfigUIUtils.getURI(editorInput, doc = input.getOwnerDocument());
        WebSphereServerInfo serverInfo = ConfigUtils.getServerInfo((URI)docURI);
        UserDirectory userDir = serverInfo != null ? serverInfo.getUserDirectory() : ConfigUtils.getUserDirectory((URI)docURI);
        final HashSet<String> referenceSet = new HashSet<String>();
        String value = DOMUtils.getAttributeValue((Element)input, (String)itemName);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ", ");
            while (tokenizer.hasMoreTokens()) {
                referenceSet.add(tokenizer.nextToken());
            }
        }
        final ConfigVarComputer configVarComputer = this.getGlobalConfigVarComputer(input, editorPart);
        final Map<String, URILocation> idMap = ConfigUIUtils.getIdMap(doc, docURI, serverInfo, userDir, references);
        int count = 0;
        boolean showNestedCount = false;
        for (String ref : nestedReferences) {
            if (ref == null) continue;
            NodeList nestedList = input.getElementsByTagName(ref);
            count += nestedList.getLength();
            showNestedCount = true;
        }
        int nestedCount = count;
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.setLabelVerticalAlign(parent, 1);
        Composite composite = widgetFactory.createComposite(parent, 0x800000);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        final Table refTable = widgetFactory.createTable(composite, 2);
        data = new GridData(4, 4, true, false);
        data.heightHint = 80;
        data.horizontalIndent = 2;
        data.verticalSpan = 3;
        refTable.setLayoutData((Object)data);
        this.createItems(refTable, referenceSet, configVarComputer.getConfigVars());
        HoverHelper.addHoverHelp(refTable);
        Button browseButton = widgetFactory.createButton(composite, Messages.browseButton, 8);
        data = new GridData(4, 1, false, false);
        browseButton.setLayoutData((Object)data);
        if (nestedReferences[0] != null || multipleRefs) {
            Button addButton;
            Composite buttonComposite = widgetFactory.createComposite(composite);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            layout.numColumns = 2;
            buttonComposite.setLayout((Layout)layout);
            data = new GridData(4, 1, false, false);
            buttonComposite.setLayoutData((Object)data);
            Button menuButton = null;
            if (multipleRefs) {
                addButton = widgetFactory.createButton(buttonComposite, Messages.addButton2, 0x4000008);
                addButton.setImage(Activator.getImage("menuDown"));
                data = new GridData(768);
                data.grabExcessHorizontalSpace = true;
                addButton.setLayoutData((Object)data);
            } else {
                addButton = widgetFactory.createButton(buttonComposite, Messages.addButton2, 8);
                data = new GridData(768);
                data.grabExcessHorizontalSpace = true;
                addButton.setLayoutData((Object)data);
                addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Element elem = ReferenceListCustomObject.this.addNested(input, nestedReferences[0]);
                        ReferenceListCustomObject.this.openElement(editorPart, elem);
                    }
                });
                menuButton = widgetFactory.createButton(buttonComposite, "", 8);
                this.setDropdownData((Control)addButton, menuButton);
            }
            final Button mainButton = addButton;
            final Button dropdownButton = menuButton == null ? mainButton : menuButton;
            dropdownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Menu menu = new Menu((Decorations)shell, 8);
                    if (!multipleRefs) {
                        MenuItem item = new MenuItem(menu, 8);
                        item.setText(Messages.referenceNestedButton);
                        item.addListener(13, new Listener(){

                            public void handleEvent(Event e) {
                                Element elem = ReferenceListCustomObject.this.addNested(input, nestedReferences[0]);
                                ReferenceListCustomObject.this.openElement(editorPart, elem);
                            }
                        });
                        menu.setDefaultItem(item);
                    }
                    String[] stringArray = references;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String reference;
                        final String ref = reference = stringArray[i];
                        String label = SchemaUtil.getLabel((Document)doc, (String[])new String[]{"server", ref}, (URI)docURI);
                        final String typeLabel = (label == null ? ref : label) + "...";
                        MenuItem item = new MenuItem(menu, 8);
                        item.setText(multipleRefs ? typeLabel : Messages.referenceTopLevelButton);
                        item.addListener(13, new Listener(){

                            public void handleEvent(Event e) {
                                ReferenceBaseCustomObject.IDDialog dialog = new ReferenceBaseCustomObject.IDDialog(shell, typeLabel);
                                if (dialog.open() == 0) {
                                    String id = dialog.getId();
                                    referenceSet.add(id);
                                    ReferenceListCustomObject.this.updateAttr(input, itemName, referenceSet);
                                    Element elem = ReferenceListCustomObject.this.addTopLevel(doc, ref, id, input);
                                    ReferenceListCustomObject.this.openElement(editorPart, elem);
                                }
                            }
                        });
                    }
                    ReferenceListCustomObject.this.displayDropdownMenu((Control)mainButton, menu, mainButton == dropdownButton);
                    menu.dispose();
                }
            });
            addButton.setEnabled(!this.getReadOnly());
            dropdownButton.setEnabled(!this.getReadOnly());
        } else {
            final String reference = references[0];
            String label = SchemaUtil.getLabel((Document)doc, (String[])new String[]{"server", reference}, (URI)docURI);
            final String typeLabel = label == null ? reference : label;
            Button addButton = widgetFactory.createButton(composite, Messages.addButton2, 8);
            data = new GridData(4, 1, false, false);
            addButton.setLayoutData((Object)data);
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReferenceBaseCustomObject.IDDialog dialog = new ReferenceBaseCustomObject.IDDialog(shell, typeLabel);
                    if (dialog.open() == 0) {
                        String id = dialog.getId();
                        referenceSet.add(id);
                        ReferenceListCustomObject.this.updateAttr(input, itemName, referenceSet);
                        Element elem = ReferenceListCustomObject.this.addTopLevel(doc, reference, id, input);
                        ReferenceListCustomObject.this.openElement(editorPart, elem);
                    }
                }
            });
            addButton.setEnabled(!this.getReadOnly());
        }
        final Button removeButton = widgetFactory.createButton(composite, Messages.removeButton, 8);
        data = new GridData(4, 1, false, false);
        removeButton.setLayoutData((Object)data);
        if (showNestedCount) {
            Label nestedLabel = widgetFactory.createLabel(composite, NLS.bind((String)Messages.referenceNestedCount, (Object)String.valueOf(nestedCount)));
            data = new GridData(4, 1, true, false);
            data.horizontalIndent = 2;
            data.horizontalSpan = 2;
            nestedLabel.setLayoutData((Object)data);
        }
        refTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceListCustomObject.this.updateRemoveButton(removeButton, refTable);
            }
        });
        refTable.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selections;
                if (event.keyCode == 0x100000C && (selections = refTable.getSelection()).length == 1) {
                    String name = selections[0].getText();
                    String varName = ConfigVarsUtils.getVariableName((String)name);
                    DocumentLocation location = null;
                    if (varName != null && !varName.isEmpty()) {
                        location = configVarComputer.getConfigVars().getDocumentLocation(varName);
                    } else if (idMap.containsKey(name)) {
                        location = (URILocation)idMap.get(name);
                    }
                    if (location != null && location.getURI() != null) {
                        Activator.open((URILocation)location);
                    }
                }
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashSet<String> ids = new HashSet<String>(idMap.keySet());
                ids.removeAll(referenceSet);
                HashSet<String> vars = new HashSet<String>(configVarComputer.getConfigVars().getVars(ConfigVars.STRING_TYPES, false));
                for (String ref : referenceSet) {
                    String varName = ConfigVarsUtils.getVariableName((String)ref);
                    if (varName == null || varName.isEmpty()) continue;
                    vars.remove(varName);
                }
                ReferenceSelectionDialog dialog = new ReferenceSelectionDialog(shell, ids, vars, configVarComputer.getConfigVars(), true);
                if (dialog.open() == 0) {
                    Set<String> newRefs = dialog.getRefs();
                    referenceSet.addAll(newRefs);
                    ReferenceListCustomObject.this.updateAttr(input, itemName, referenceSet);
                    ReferenceListCustomObject.this.createItems(refTable, referenceSet, configVarComputer.getConfigVars());
                    ReferenceListCustomObject.this.updateRemoveButton(removeButton, refTable);
                }
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                for (TableItem item : items = refTable.getSelection()) {
                    referenceSet.remove(item.getText());
                }
                ReferenceListCustomObject.this.updateAttr(input, itemName, referenceSet);
                ReferenceListCustomObject.this.createItems(refTable, referenceSet, configVarComputer.getConfigVars());
                ReferenceListCustomObject.this.updateRemoveButton(removeButton, refTable);
            }
        });
        browseButton.setEnabled(!this.getReadOnly());
        removeButton.setEnabled(false);
    }

    protected void createItems(Table table, Set<String> refs, ConfigVars vars) {
        ArrayList<String> refList = new ArrayList<String>(refs);
        Collections.sort(refList);
        table.removeAll();
        for (String ref : refList) {
            TableItem item = new TableItem(table, 0);
            item.setText(ref);
            String varName = ConfigVarsUtils.getVariableName((String)ref);
            if (varName != null) {
                item.setImage(Activator.getImage("variableRef"));
                String value = vars.getValue(varName);
                if (value == null || value.isEmpty()) continue;
                item.setData("hoverData", (Object)NLS.bind((String)Messages.variableValue, (Object[])new String[]{varName, "\"" + value + "\""}));
                continue;
            }
            item.setImage(Activator.getImage("factoryRef"));
        }
    }

    protected void updateRemoveButton(Button removeButton, Table refTable) {
        removeButton.setEnabled(!this.getReadOnly() && refTable.getSelectionCount() > 0);
    }

    protected void updateAttr(Element elem, String attrName, Set<String> refs) {
        if (refs.isEmpty()) {
            elem.removeAttribute(attrName);
            return;
        }
        ArrayList<String> refList = new ArrayList<String>();
        refList.addAll(refs);
        Collections.sort(refList);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String ref : refList) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(ref);
        }
        elem.setAttribute(attrName, builder.toString());
    }
}

