/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.core.internal.crypto.CustomPasswordEncryptionInfo;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.BaseCustomObject;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.ws.st.ui.internal.config.EnableCustomEncryptionDialog;
import com.ibm.ws.st.ui.internal.provisional.dialogs.PasswordDialog;
import java.net.URI;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PasswordTextCustomObject
extends BaseCustomObject {
    public void createCustomControl(final Element input, final String itemName, Composite parent, final IEditorPart editorPart, EventListener listener) {
        final Shell shell = parent.getShell();
        String password = DOMUtils.getAttributeValue((Element)input, (String)itemName);
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        final Text passwordText = widgetFactory.createText(parent, password == null ? "" : password, 0);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 1;
        data.verticalIndent = 1;
        passwordText.setLayoutData((Object)data);
        Button setButton = widgetFactory.createButton(parent, Messages.setButton, 8);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        setButton.setLayoutData((Object)data);
        passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = passwordText.getText();
                PasswordTextCustomObject.this.updateAttr(input, itemName, text);
            }
        });
        setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String password;
                Map customEncryptionMap;
                PasswordDialog dialog;
                String type;
                CMAttributeDeclaration attribDeclaration;
                WebSphereRuntime wsRuntime = ConfigUIUtils.getRuntime(editorPart);
                if (wsRuntime == null) {
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)Messages.passwordDialogNoRuntime);
                    return;
                }
                boolean isSupportHash = false;
                CMElementDeclaration elementDeclaration = SchemaUtil.getElement((Element)input);
                if (elementDeclaration != null && (attribDeclaration = SchemaUtil.getAttr((CMElementDeclaration)elementDeclaration, (String)itemName)) != null && "passwordHash".equals(type = ConfigUtils.getTypeName((CMNode)attribDeclaration))) {
                    isSupportHash = true;
                }
                if ((dialog = new PasswordDialog(shell, isSupportHash, wsRuntime, customEncryptionMap = wsRuntime.listCustomEncryption())).open() == 0 && (password = dialog.getEncodedPassword()) != null) {
                    passwordText.setText(password);
                    String encodingMethod = dialog.getPasswordEncoding();
                    if (customEncryptionMap.containsKey(encodingMethod)) {
                        PasswordTextCustomObject.this.checkFeatureEnabled(shell, wsRuntime, itemName, input, editorPart, ((CustomPasswordEncryptionInfo)customEncryptionMap.get(encodingMethod)).getFeatureName());
                    }
                }
            }
        });
        passwordText.setEnabled(!this.getReadOnly());
        setButton.setEnabled(!this.getReadOnly());
    }

    protected boolean checkFeatureEnabled(Shell shell, WebSphereRuntime wsRuntime, String itemName, Element element, IEditorPart editorPart, String featureName) {
        boolean result = false;
        Document doc = element.getOwnerDocument();
        List<String> currentFeatures = ConfigUIUtils.getFeatures(editorPart.getEditorInput(), doc);
        if (currentFeatures != null) {
            if (this.isListed(currentFeatures, featureName)) {
                result = true;
            } else {
                URI uri = ConfigUIUtils.getURI(editorPart.getEditorInput());
                ArrayList<String> featureList = new ArrayList<String>();
                featureList.add(featureName);
                EnableCustomEncryptionDialog enableDialog = new EnableCustomEncryptionDialog(shell, wsRuntime, itemName, featureList);
                if (enableDialog.open() == 0) {
                    List<String> features = enableDialog.getSelectedFeatures();
                    for (String feature : features) {
                        CMElementDeclaration elemDecl;
                        Element featureElem = null;
                        Element featureManager = DOMUtils.getFirstChildElement((Node)doc.getDocumentElement(), (String)"featureManager");
                        if (featureManager == null && (elemDecl = SchemaUtil.getElement((Document)doc, (String[])new String[]{"server", "featureManager"}, (URI)uri)) != null) {
                            featureManager = ConfigUtils.addElement((Element)doc.getDocumentElement(), (CMElementDeclaration)elemDecl);
                        }
                        if (featureManager != null && (elemDecl = SchemaUtil.getElement((Document)doc, (String[])new String[]{"server", "featureManager", "feature"}, (URI)uri)) != null) {
                            featureElem = ConfigUtils.addElement((Element)featureManager, (CMElementDeclaration)elemDecl, (String)feature);
                        }
                        if (featureElem != null) {
                            result = true;
                            continue;
                        }
                        Trace.logError("Failed to add feature: " + feature, null);
                    }
                }
            }
        } else {
            Trace.logError("Failed to acquire the current features.", null);
        }
        return result;
    }

    protected void updateAttr(Element elem, String attrName, String password) {
        if (password == null || password.isEmpty()) {
            elem.removeAttribute(attrName);
            return;
        }
        elem.setAttribute(attrName, password);
    }

    private boolean isListed(List<String> currentFeatures, String featureName) {
        boolean result = false;
        if (currentFeatures != null && featureName != null) {
            for (String currentFeature : currentFeatures) {
                if (!currentFeature.equalsIgnoreCase(featureName)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

