/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.crypto.CustomPasswordEncryptionInfo;
import com.ibm.ws.st.ui.internal.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PasswordComponent {
    private static final char PASSWORD_CHAR = '\u25cf';
    protected static String ENCODING_XOR = "xor";
    protected static String ENCODING_AES = "aes";
    protected static String ENCODING_HASH = "hash";
    protected List<String> encodingMethodList = new ArrayList<String>();
    protected Map<String, CustomPasswordEncryptionInfo> customEncryptionMap = null;
    protected boolean supportsHash = false;
    protected WebSphereRuntime wsRuntime;
    protected String password = "";
    protected String encodingMethod;
    protected String key = "";
    protected Text passwordText;
    protected ModifyListener listener;

    public PasswordComponent(Composite composite, WebSphereRuntime wsRuntime, boolean supportsHash) {
        this(composite, null, 2, wsRuntime, supportsHash, null);
    }

    public PasswordComponent(Composite composite, WebSphereRuntime wsRuntime, boolean supportsHash, Map<String, CustomPasswordEncryptionInfo> customEncryptionMap) {
        this(composite, null, 2, wsRuntime, supportsHash, customEncryptionMap);
    }

    public PasswordComponent(Composite composite, String passwordLabel, int numColumns, WebSphereRuntime wsRuntime, boolean supportsHash) {
        this(composite, passwordLabel, numColumns, wsRuntime, supportsHash, null);
    }

    public PasswordComponent(Composite composite, String passwordLabel, int numColumns, WebSphereRuntime wsRuntime, boolean supportsHash, Map<String, CustomPasswordEncryptionInfo> customEncryptionMap) {
        this.wsRuntime = wsRuntime;
        this.supportsHash = supportsHash;
        this.customEncryptionMap = customEncryptionMap;
        if (numColumns < 2) {
            throw new IllegalArgumentException("Invalid number of columns");
        }
        this.initializeEncodingMethodArray(customEncryptionMap);
        this.createControl(composite, passwordLabel, numColumns);
    }

    private void initializeEncodingMethodArray(Map<String, CustomPasswordEncryptionInfo> customEncryptionMap) {
        this.encodingMethodList.add(ENCODING_XOR);
        if (this.wsRuntime == null || !this.wsRuntime.getRuntimeVersion().startsWith("8.5.0")) {
            this.encodingMethodList.add(ENCODING_AES);
        }
        if (this.supportsHash) {
            this.encodingMethodList.add(ENCODING_HASH);
        }
        if (customEncryptionMap != null) {
            this.encodingMethodList.addAll(customEncryptionMap.keySet());
        }
    }

    private void createControl(Composite composite, String passwordLabel, int numColumns) {
        Label label = new Label(composite, 0);
        if (passwordLabel == null) {
            label.setText(Messages.password);
        } else {
            label.setText(passwordLabel);
        }
        GridData data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        Composite comp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, false, numColumns - 1, 1));
        this.passwordText = new Text(comp, 2048);
        data = new GridData(4, 2, true, false);
        this.passwordText.setLayoutData((Object)data);
        this.passwordText.setEchoChar('\u25cf');
        final Button showPassword = new Button(comp, 32);
        showPassword.setText(Messages.passwordShow);
        data = new GridData(3, 2, false, false);
        showPassword.setLayoutData((Object)data);
        showPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (showPassword.getSelection()) {
                    PasswordComponent.this.passwordText.setEchoChar('\u0000');
                } else {
                    PasswordComponent.this.passwordText.setEchoChar('\u25cf');
                }
            }
        });
        Label encodingLabel = new Label(composite, 0);
        encodingLabel.setText(Messages.passwordEncoding);
        data = new GridData(1, 2, false, false);
        encodingLabel.setLayoutData((Object)data);
        final Combo encodingCombo = new Combo(composite, 8);
        List<String> methods = this.createEncodingSelectionList();
        encodingCombo.setItems(methods.toArray(new String[methods.size()]));
        data = new GridData(4, 2, true, false, numColumns - 1, 1);
        encodingCombo.setLayoutData((Object)data);
        final Label keyLabel = new Label(composite, 0);
        keyLabel.setText(Messages.passwordKey);
        data = new GridData(1, 1, false, false);
        keyLabel.setLayoutData((Object)data);
        final Text keyText = new Text(composite, 0x400800);
        keyText.setLayoutData((Object)new GridData(4, 1, true, false, numColumns - 1, 1));
        keyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PasswordComponent.this.key = keyText.getText();
            }
        });
        encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sel = encodingCombo.getSelectionIndex();
                PasswordComponent.this.encodingMethod = PasswordComponent.this.encodingMethodList.get(sel);
                boolean isAES = ENCODING_AES.equals(PasswordComponent.this.encodingMethod);
                keyLabel.setEnabled(isAES);
                if (isAES) {
                    keyText.setEnabled(true);
                } else {
                    keyText.setEnabled(false);
                }
            }
        });
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PasswordComponent.this.password = PasswordComponent.this.passwordText.getText();
                if (PasswordComponent.this.listener != null) {
                    PasswordComponent.this.listener.modifyText(event);
                }
            }
        });
        encodingCombo.select(0);
        this.encodingMethod = ENCODING_XOR;
        if (this.wsRuntime != null && this.wsRuntime.getRuntimeVersion().startsWith("8.5.0")) {
            encodingLabel.setEnabled(false);
            encodingCombo.setEnabled(false);
        }
        keyLabel.setEnabled(false);
        keyText.setEnabled(false);
    }

    private List<String> createEncodingSelectionList() {
        ArrayList<String> methodsList = new ArrayList<String>();
        for (String method : this.encodingMethodList) {
            if (ENCODING_XOR.equals(method)) {
                methodsList.add(Messages.passwordXOR);
                continue;
            }
            if (ENCODING_AES.equals(method)) {
                methodsList.add(Messages.passwordAES);
                continue;
            }
            if (ENCODING_HASH.equals(method)) {
                methodsList.add(Messages.passwordHash);
                continue;
            }
            StringBuffer sb = new StringBuffer(method);
            String description = this.getCustomEncryptionDescription(method);
            if (description != null && description.length() > 0) {
                sb.append(" ").append(NLS.bind((String)Messages.passwordExplanation, (Object)this.getCustomEncryptionDescription(method)));
            }
            methodsList.add(sb.toString());
        }
        return methodsList;
    }

    private String getCustomEncryptionDescription(String method) {
        CustomPasswordEncryptionInfo info;
        String output = null;
        if (this.customEncryptionMap != null && (info = this.customEncryptionMap.get(method)) != null) {
            output = info.getDescription();
        }
        return output;
    }

    public void addModifyListener(ModifyListener listener) {
        this.listener = listener;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordEncoding() {
        return this.encodingMethod;
    }

    public String getPasswordKey() {
        return this.key;
    }

    public IStatus validate() {
        if (this.password != null && !this.password.isEmpty()) {
            return Status.OK_STATUS;
        }
        return new Status(4, "com.ibm.ws.st.ui", null);
    }

    public String getEncodedPassword(IProgressMonitor monitor) throws CoreException {
        if (this.encodingMethod != null) {
            if (ENCODING_XOR.equals(this.encodingMethod)) {
                return this.wsRuntime.encodePassword(this.password, monitor);
            }
            if (ENCODING_AES.equals(this.encodingMethod)) {
                return this.wsRuntime.encryptPassword("aes", this.key, this.password, monitor);
            }
            return this.wsRuntime.encryptPassword(this.encodingMethod, null, this.password, monitor);
        }
        return null;
    }

    public boolean setFocus() {
        return this.passwordText.setFocus();
    }
}

